/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.layout.Layout;
import oracle.ide.layout.SimpleLayout;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.ModelUtil;

public final class IdeLayout
extends Layout
implements Folder {
    private static final String LAYOUT = "Layout.";
    private static final String COUNT_PROP = "Layout.count";
    private static final String ACTIVE_PROP = "Layout.active";
    private HashMap _layoutMap = new HashMap();
    private Layout _activeLayout;
    private SimpleLayout _defaults;
    private transient String _shortLabel;
    private transient Icon _icon;
    private transient ArrayResourceBundle _iconBundle;
    private transient int _iconBundleKey;
    private transient String _displayName;

    public IdeLayout(URL fileURL, String shortLabel, Icon icon) {
        this(fileURL, shortLabel, null, -1);
        this._icon = icon;
    }

    public IdeLayout(URL fileURL, String shortLabel, ArrayResourceBundle iconBundle, int iconKey) {
        super(fileURL);
        this._shortLabel = shortLabel;
        this._iconBundle = iconBundle;
        this._iconBundleKey = iconKey;
    }

    public IdeLayout(URL fileURL, String shortLabel, String displayName, ArrayResourceBundle iconBundle, int iconKey) {
        this(fileURL, shortLabel, iconBundle, iconKey);
        this._displayName = displayName;
    }

    protected IdeLayout() {
        super(null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        this.ensureOpen();
        return this._activeLayout.getProperty(key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        this.ensureOpen();
        this.markDirty(true);
        if (value != null) {
            return this._activeLayout.setProperty(key, value);
        }
        return this._activeLayout.removeProperty(key);
    }

    @Override
    public Object removeProperty(String key) {
        this.ensureOpen();
        return this._activeLayout.removeProperty(key);
    }

    public Layout getActiveLayout() {
        this.ensureOpen();
        return this._activeLayout;
    }

    public Layout findLayout(URL url) {
        this.ensureOpen();
        if (url.equals(this.getDefaults().getURL())) {
            return this.getDefaults();
        }
        return IdeLayout.findLayout(url, this);
    }

    private static Layout findLayout(URL url, Element layout) {
        Iterator<Element> iter = layout.getChildren();
        if (iter != null) {
            while (iter.hasNext()) {
                Layout child = (Layout)iter.next();
                if (URLFileSystem.equals((URL)child.getURL(), (URL)url)) {
                    return child;
                }
                if ((child = IdeLayout.findLayout(url, child)) == null) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openImpl() throws IOException {
        this._defaults = new SimpleLayout(this.getURL());
        this._defaults.setOwner(this);
        this.setActiveLayout(this._defaults);
        Integer count = Integer.valueOf(this._defaults.getProperty(COUNT_PROP, "0"));
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory("oracle.ide");
        String baseDir = url.getPath();
        for (int i = 0; i < count; ++i) {
            String filename;
            URL fileURL;
            String prop = LAYOUT + Integer.toString(i);
            String name = this._defaults.getProperty(prop, "");
            if (name.length() <= 0 || !URLFileSystem.exists((URL)(fileURL = URLFactory.newFileURL((String)(filename = baseDir + name + ".layout"))))) continue;
            SimpleLayout layout = new SimpleLayout(fileURL);
            this.add(layout);
        }
        String active = this._defaults.getProperty(ACTIVE_PROP, null);
        if (active != null) {
            String filename = baseDir + active + ".layout";
            URL fileURL = URLFactory.newFileURL((String)filename);
            HashMap hashMap = this._layoutMap;
            synchronized (hashMap) {
                Layout layout = (Layout)this._layoutMap.get(fileURL);
                if (layout != null) {
                    this.setActiveLayout(layout);
                }
            }
        }
        this.markDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            this._layoutMap.clear();
            this._layoutMap = null;
        }
        this._activeLayout = null;
        this._defaults = null;
        this._shortLabel = null;
        this._icon = null;
        this._iconBundle = null;
        this._iconBundleKey = -1;
    }

    @Override
    protected void saveImpl() throws IOException {
        this._activeLayout.save();
        Iterator iter = this.getChildren();
        if (iter != null) {
            while (iter.hasNext()) {
                Layout layout = (Layout)iter.next();
                layout.save();
            }
        }
        this.saveDefaults();
    }

    public Layout getDefaults() {
        this.ensureOpen();
        return this._defaults;
    }

    @Override
    public String getShortLabel() {
        return this._shortLabel;
    }

    @Override
    public String getName() {
        return super.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        if (this._icon == null && this._iconBundle != null) {
            this._icon = this._iconBundle.getIconImpl(this._iconBundleKey);
            this._iconBundle = null;
            this._iconBundleKey = -1;
        }
        return this._icon;
    }

    @Override
    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public String getToolTipText() {
        return this.getShortLabel();
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getChildren() {
        this.ensureOpen();
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            return this._layoutMap.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Element element) {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            this._layoutMap.put(((Layout)element).getURL(), element);
        }
        ((Layout)element).setOwner(this);
        this.markDirty(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Element element) {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            this._layoutMap.remove(((Layout)element).getURL());
        }
        this.markDirty(true);
        return true;
    }

    @Override
    public boolean canRemove(Element element) {
        return element != this._activeLayout;
    }

    @Override
    public boolean canAdd(Element element) {
        return element instanceof Layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsChild(Element child) {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            return this._layoutMap.containsValue(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            return this._layoutMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            if (this._layoutMap.size() > 0) {
                this._layoutMap.clear();
                this.markDirty(true);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((IdeLayout)o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected final boolean equalsImpl(IdeLayout other) {
        if (!super.equalsImpl(other)) {
            return false;
        }
        return this._activeLayout.equals(other._activeLayout) && ModelUtil.areEqual((Object)this._layoutMap, (Object)other._layoutMap);
    }

    protected void setActiveLayout(Layout layout) {
        if (this._activeLayout != null) {
            this._activeLayout.setActive(false);
        }
        this._activeLayout = layout;
        this._activeLayout.setActive(true);
        this.markDirty(true);
    }

    protected Map getLayoutMap() {
        return this._layoutMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDefaults() {
        this.cleanupDefaultsLayout();
        int count = 0;
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            count = this._layoutMap.size();
        }
        if (count > 0) {
            if (this._activeLayout != null) {
                this._defaults.setProperty(ACTIVE_PROP, this._activeLayout.getName());
            }
            this._defaults.setProperty(COUNT_PROP, Integer.toString(count));
            Iterator iter = this.getChildren();
            count = 0;
            if (iter != null) {
                while (iter.hasNext()) {
                    Layout layout = (Layout)iter.next();
                    String prop = LAYOUT + Integer.toString(count++);
                    this._defaults.setProperty(prop, layout.getName());
                }
            }
        } else {
            this._defaults.setProperty(COUNT_PROP, Integer.toString(0));
        }
        try {
            this._defaults.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void cleanupDefaultsLayout() {
        int i = 0;
        String prop = LAYOUT + Integer.toString(i++);
        String value = this._defaults.getProperty(prop, null);
        while (value != null) {
            this._defaults.removeProperty(prop);
            prop = LAYOUT + Integer.toString(i++);
            value = this._defaults.getProperty(prop, null);
        }
        this._defaults.setProperty(ACTIVE_PROP, "");
    }

    @Override
    public String getDisplayName() {
        return this._displayName == null ? super.getDisplayName() : this._displayName;
    }
}

