/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.customtab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import oracle.ide.Context;
import oracle.ide.IdeConstants;
import oracle.ide.IdeUIManager;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ControlsBundle;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.log.LogPage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.ideimpl.controls.SwitchablePanel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TranslucentIcon;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;
import sun.swing.UIAction;

public class CustomTab
extends JPanel
implements SwingConstants,
MouseListener,
MouseMotionListener,
ListDataListener {
    public static final double SELECTED_STYLE_FIXED = 0.0;
    public static final double SELECTED_STYLE_CENTER = 0.5;
    public static final double SELECTED_STYLE_MOVE = 1.0;
    private static final String DOTDOTDOT = "...";
    private static final Color COLOR_UNSELECTED = IdeUIManager.getUnselectedTabColor();
    private static final Color COLOR_SELECTED_FOCUSED = IdeUIManager.getSelectedFocusedTabColor();
    private static final Color COLOR_HIGHLIGHTED = IdeUIManager.getHighlightedTabColor();
    private static final Color DISABLED_TEXT_COLOR = IdeUIManager.getDisabledTextColor();
    private static final Color COLOR_LINES = IdeConstants.COLOR_IDE_LINES;
    private static final String CLOSE_SELECTED_COMMAND = "closeSelected";
    private static final String CLOSE_HOVER_COMMAND = "closeHover";
    private int _position = 3;
    private ListModel _model;
    private int _selectedPage = -1;
    private int _hoverPage = -1;
    private final ArrayList _selectionListener = new ArrayList(2);
    private int _tooltipHeight;
    private AbstractButton _selectedCloseButton;
    private AbstractButton _hoverCloseButton;
    private ActionListener _closeAction;
    private boolean _ctrlClickCloseEnabled;
    private boolean _isListeningGlobalMouseMovements;
    private boolean _active;
    private boolean _focused;
    private boolean _compressible;
    private boolean _isGradientHighlight;
    private boolean _fitWidth;
    private boolean _showIcons = true;
    private boolean _showTabUnderline = true;
    private boolean _showSelectedCloseButton;
    private int _minTabWidth;
    private int _minTabHeight;
    private int _maxTabChars = -1;
    private Font[] _cachedFonts;
    private ArrayList _listDataListeners = new ArrayList(3);
    private int _gapBeforeTabs = 0;
    private int _gapBetweenTabs = 0;
    private int _gapAfterTabs = 0;
    private int _gapAboveLabel = 1;
    private int _gapBelowLabel = 1;
    private int _gapLeft = 2;
    private int _gapCenter = 1;
    private int _gapClose = 4;
    private int _gapRight = 2;
    private int _offsetSelected = 2;
    private int _cornerSize = 2;
    private double _selectedStyle = 0.5;
    private static final String THEME_PART_VIEW = "viewtab";
    private static final String THEME_PART_EDITOR = "editortab";
    private String _themeStyle = "editortab";
    private static final Icon CLOSE_BUTTON = OracleIcons.getIcon((String)"extras/close-default.png");
    private static final Icon CLOSE_BUTTON_ACTIVE = OracleIcons.getIcon((String)"extras/close-default-black.png");
    private DropTargetL dropTargetL = new DropTargetL();
    private Timer dragPageOpenTimer = new Timer(250, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int pageNow = CustomTab.this.getPageUnderMouse();
            if (pageNow == CustomTab.this.dragPageOpenIndex && pageNow != -1 && pageNow != CustomTab.this.getSelectedPage()) {
                CustomTab.this.setSelectedPage(pageNow);
            }
        }
    });
    private int dragPageOpenIndex;
    private boolean alwaysShowCloseButton;
    private List<Actions> _parentActions;
    private AccessibleContext _aContext;
    private Component _ownerComponent;
    private Controller _controller;
    private boolean _controllerAdded;
    private AncestorListener _ancestorListener;

    public CustomTab(int position) {
        this(null, position);
    }

    public CustomTab(ListModel model, int position) {
        super(null);
        this.dragPageOpenTimer.setRepeats(false);
        this.dragPageOpenIndex = -1;
        this.alwaysShowCloseButton = true;
        this._parentActions = new ArrayList<Actions>(4);
        this._controller = new MyController();
        this._ancestorListener = new MyAncestorListener();
        this.setPosition(position);
        this.setModel(model);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        DropTarget dropTarget = new DropTarget(this, this.dropTargetL);
        ToolTipManager.sharedInstance().registerComponent(this);
        this._hoverCloseButton = this.createCloseButton(CLOSE_HOVER_COMMAND);
        this.add(this._hoverCloseButton);
        this._selectedCloseButton = this.createCloseButton(CLOSE_SELECTED_COMMAND);
        this.add(this._selectedCloseButton);
        this.setFont(UIManager.getFont("Label.font"));
        if (Themes.isThemed()) {
            if (this.getPosition() == 1) {
                Insets i = Themes.getActiveTheme().getPartProperties(this._themeStyle).getInsets("contentmargin");
                this._gapAboveLabel = i.top;
                this._gapBelowLabel = i.bottom;
                this._gapLeft = i.left;
                this._gapRight = i.right;
            } else {
                this._gapBetweenTabs = Themes.getActiveTheme().getPartProperties(this._themeStyle).getInt("gapbetweentabs");
            }
        }
        this.loadInputMap();
        this.loadActionMap();
        this.addAncestorListener(this._ancestorListener);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._aContext == null) {
            this._aContext = new AccessibleCustomTab();
        }
        return this._aContext;
    }

    private AbstractButton createCloseButton(String actionCommand) {
        SmallSquareButton b = new SmallSquareButton();
        b.setModel(new DefaultButtonModel());
        b.setActionCommand(actionCommand);
        if (this._isThemedBottomTab()) {
            this._configureButtonIcons(b);
            b.setBorder(BorderFactory.createEmptyBorder());
            b.setBorderPainted(false);
        } else {
            b.setIcon(CLOSE_BUTTON_ACTIVE);
        }
        b.addActionListener(new ForwardCloseActionEvent());
        return b;
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        ListModel oldModel = this._model;
        if (this._model != null) {
            this._model.removeListDataListener(this);
            this._selectedPage = -1;
            this._hoverPage = -1;
        }
        this._model = model;
        if (this._model != null) {
            this._model.addListDataListener(this);
        }
        this.whenTabChanged();
        this.firePropertyChange("model", oldModel, model);
    }

    public void setCloseAction(Action closeAction) {
        this._closeAction = closeAction;
        this._selectedCloseButton.setAction(closeAction);
        this._hoverCloseButton.setAction(closeAction);
        this._selectedCloseButton.removeActionListener(closeAction);
        this._hoverCloseButton.removeActionListener(closeAction);
        this._selectedCloseButton.getModel().setActionCommand(CLOSE_SELECTED_COMMAND);
        this._hoverCloseButton.getModel().setActionCommand(CLOSE_HOVER_COMMAND);
        if (closeAction.getValue("SmallIcon") == null) {
            if (this._isThemedBottomTab()) {
                this._configureButtonIcons(this._selectedCloseButton);
                this._configureButtonIcons(this._hoverCloseButton);
            } else {
                this._selectedCloseButton.setIcon(CLOSE_BUTTON_ACTIVE);
                this._hoverCloseButton.setIcon(CLOSE_BUTTON_ACTIVE);
            }
        }
        String close = ControlsBundle.get("CLOSE_ACTION");
        this._selectedCloseButton.setToolTipText(close);
        this._hoverCloseButton.setToolTipText(close);
        this.whenTabChanged();
    }

    private void _configureButtonIcons(AbstractButton b) {
        ThemeProperties properties = Themes.getActiveTheme().getStateProperties("editortab.close", "default");
        b.setIcon(properties.getIcon("icon"));
        properties = Themes.getActiveTheme().getStateProperties("editortab.close", "mouseover");
        Icon icon = properties.getIcon("icon");
        b.setRolloverIcon(icon);
        b.setPressedIcon(icon);
    }

    private boolean isCtrlClickCloseEnabled() {
        return this._ctrlClickCloseEnabled;
    }

    public void setCtrlClickCloseEnabled(boolean ctrlClickCloseEnabled) {
        this._ctrlClickCloseEnabled = ctrlClickCloseEnabled;
    }

    public void addSelectionListener(ListSelectionListener l) {
        this._selectionListener.add(l);
    }

    public void removeSelectionListener(ListSelectionListener l) {
        this._selectionListener.remove(l);
    }

    private void fireSelectionChange() {
        ListSelectionEvent e = new ListSelectionEvent(this, this._selectedPage, this._selectedPage, false);
        for (int i = 0; i < this._selectionListener.size(); ++i) {
            ListSelectionListener listSelectionListener = (ListSelectionListener)this._selectionListener.get(i);
            listSelectionListener.valueChanged(e);
        }
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int position) {
        this._position = position;
        this._themeStyle = position == 1 ? THEME_PART_VIEW : THEME_PART_EDITOR;
    }

    private boolean isCompressible() {
        return this._compressible;
    }

    public void setCompressible(boolean compressible) {
        if (this._compressible != compressible) {
            this._compressible = compressible;
            this.whenTabChanged();
        }
    }

    private int getMaxTabChars() {
        return this._maxTabChars;
    }

    public void setMaxTabChars(int maxTabChars) {
        if (this._maxTabChars != maxTabChars) {
            this._maxTabChars = maxTabChars;
            this.whenTabChanged();
        }
    }

    private int getMinTabWidth() {
        return this._minTabWidth;
    }

    public void setMinTabWidth(int minTabWidth) {
        if (this._minTabWidth != minTabWidth) {
            this._minTabWidth = minTabWidth;
            this.whenTabChanged();
        }
    }

    public int getMinTabHeight() {
        return this._minTabHeight;
    }

    public void setMinTabHeight(int minTabHeight) {
        if (this._minTabHeight != minTabHeight) {
            this._minTabHeight = minTabHeight;
            this.whenTabChanged();
        }
    }

    public static Color getColorLines() {
        return COLOR_LINES;
    }

    public boolean getShowIcons() {
        return this.isShowIcons();
    }

    public boolean isShowIcons() {
        return this._showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        if (this._showIcons != showIcons) {
            this._showIcons = showIcons;
            this.whenTabChanged();
        }
    }

    public boolean isShowTabUnderline() {
        return this._showTabUnderline;
    }

    public void setShowTabUnderline(boolean showTabUnderline) {
        if (this._showTabUnderline != showTabUnderline) {
            this._showTabUnderline = showTabUnderline;
            this.whenTabChanged();
        }
    }

    public boolean isFitWidth() {
        return this._fitWidth;
    }

    public void setFitWidth(boolean fitWidth) {
        if (this._fitWidth != fitWidth) {
            this._fitWidth = fitWidth;
            this.whenTabChanged();
        }
    }

    public boolean isGradientHighlight() {
        return this._isGradientHighlight;
    }

    public void setGradientHighlight(boolean isGradientHighlight) {
        if (this._isGradientHighlight != isGradientHighlight) {
            this._isGradientHighlight = isGradientHighlight;
            this.repaint();
        }
    }

    public boolean isFocused() {
        return this._focused;
    }

    public void setFocused(boolean focused) {
        if (focused != this._focused) {
            this._focused = focused;
            this.whenTabChanged();
        }
    }

    private boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        if (this._active != active) {
            this._active = active;
            this.whenTabChanged();
        }
    }

    public boolean isShowSelectedCloseButton() {
        return this._showSelectedCloseButton;
    }

    public void setShowSelectedCloseButton(boolean showSelectedCloseButton) {
        if (this._showSelectedCloseButton != showSelectedCloseButton) {
            this._showSelectedCloseButton = showSelectedCloseButton;
            this.whenTabChanged();
        }
    }

    public CustomTabPage removePage(int at) {
        DefaultListModel defaultListModel = (DefaultListModel)this._model;
        CustomTabPage ret = (CustomTabPage)defaultListModel.remove(at);
        if (this.getPageCount() == 0) {
            this._selectedPage = -1;
        }
        this._hoverPage = -1;
        return ret;
    }

    public void removePage(CustomTabPage customTabPage) {
        int i = this.searchPage(customTabPage);
        this.removePage(i);
    }

    public void removeAllPages() {
        DefaultListModel defaultListModel = (DefaultListModel)this._model;
        if (defaultListModel != null) {
            defaultListModel.removeAllElements();
        }
        this._selectedPage = -1;
        this._hoverPage = -1;
    }

    public int getPageCount() {
        return this._model == null ? 0 : this._model.getSize();
    }

    public int searchPage(CustomTabPage customTabPage) {
        int pageCount = this.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage page = this.getPage(i);
            if (page != customTabPage) continue;
            return i;
        }
        return -1;
    }

    public CustomTabPage getPage(int at) {
        int pageCount = this._model.getSize();
        if (pageCount == 0) {
            return null;
        }
        if (at < 0) {
            at = 0;
        }
        if (at >= pageCount) {
            at = pageCount - 1;
        }
        return (CustomTabPage)this._model.getElementAt(at);
    }

    public void setSelectedPage(int page) {
        if (this._selectedPage != page) {
            this._setSelectedPage(page);
        }
    }

    private void _setSelectedPage(int page) {
        if (page == -1 || this.getPage(page).isEnabled() && this.getPage(page).isVisible()) {
            this._selectedPage = page;
            if (this._selectedPage != -1 && this.getPage(this._selectedPage).isHighlighted()) {
                this.getPage(this._selectedPage).setHighlighted(false);
            }
            this.fireSelectionChange();
            this.whenTabChanged();
        }
    }

    public int getSelectedPage() {
        return this._selectedPage;
    }

    private void selectPageAt(Point point) {
        int page = this.getPageAt(point);
        if (page != -1) {
            this.setSelectedPage(page);
        }
    }

    public int getPageAt(Point pt) {
        int pageCount = this.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage customTabPage = this.getPage(i);
            if (!customTabPage.isVisible() || !customTabPage.getBounds().contains(pt)) continue;
            return i;
        }
        return -1;
    }

    public int getPageBefore(int xPos) {
        int ret = -1;
        int pageCount = this.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage customTabPage = this.getPage(i);
            if (!customTabPage.isVisible()) continue;
            Rectangle pageBounds = customTabPage.getBounds();
            if (pageBounds.x >= xPos) break;
            ret = i;
        }
        return ret;
    }

    public int getPageAfter(int xPos) {
        int pageCount = this.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage customTabPage = this.getPage(i);
            if (!customTabPage.isVisible()) continue;
            Rectangle pageBounds = customTabPage.getBounds();
            if (pageBounds.x <= xPos) continue;
            return i;
        }
        return -1;
    }

    public void setDirty(int page, boolean dirty) {
        CustomTabPage customTabPage = this.getPage(page);
        if (page != -1) {
            customTabPage.setDirty(dirty);
            this.whenTabChanged();
        }
    }

    public void setHighlighted(int page, boolean highlighted) {
        CustomTabPage customTabPage = this.getPage(page);
        if (page != -1 && page != this._selectedPage) {
            customTabPage.setHighlighted(highlighted);
            this.whenTabChanged();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension preferredSize = this.getPreferredSize();
        int visibleCount = 0;
        int minWidth = 0;
        int i = this.getPageCount();
        while (i-- > 0) {
            CustomTabPage page = this.getPage(i);
            if (!page.isVisible()) continue;
            minWidth += this.getMinimumTabWidth(page, i == this.getSelectedPage());
            ++visibleCount;
        }
        return new Dimension(minWidth += this._gapBeforeTabs + this._gapAfterTabs + this._gapBetweenTabs * (visibleCount - 1), preferredSize.height);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension preferredSize = this.getPreferredSize();
        int maxWidth = this.isFitWidth() ? Integer.MAX_VALUE : preferredSize.width;
        return new Dimension(maxWidth, preferredSize.height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret;
        if (!this.isPreferredSizeSet()) {
            ret = this.getMaxSize();
            this.clearCachedFont();
            this.setPreferredSize(ret);
        } else {
            ret = super.getPreferredSize();
        }
        return ret;
    }

    @Override
    public void doLayout() {
        Rectangle tabBounds = this.getTabBounds();
        this.calculateSizes(tabBounds, true);
        this.updateCloseButtons();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setPreferredSize(null);
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._cachedFonts = new Font[4];
    }

    private Font getCachedFont(int style) {
        Font ret = this._cachedFonts[style];
        if (ret == null) {
            Font font = UIManager.getFont("Oracle.dirtyFont");
            if (font == null || (style & 2) != 2) {
                font = this._cachedFonts[0] == null ? this.getFont() : this._cachedFonts[0];
            }
            this._cachedFonts[style] = ret = style != font.getStyle() ? font.deriveFont(style) : font;
        }
        return ret;
    }

    private void clearCachedFont() {
        for (int i = 0; i < this._cachedFonts.length; ++i) {
            this._cachedFonts[i] = null;
        }
    }

    private Font getAdjustedFont(int index, CustomTabPage customTabPage) {
        boolean selected = this.getSelectedPage() == index;
        boolean isItalic = customTabPage.isDirty();
        boolean isBold = false;
        Font font = this.getCachedFont((isItalic ? 2 : 0) | (isBold ? 1 : 0));
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            String state = this.getThemeState(index);
            font = t.getStateProperties(this._themeStyle, state).getFont(font, "label");
        }
        return font;
    }

    private AbstractButton getCloseButton(boolean selected) {
        return selected && this.isShowSelectedCloseButton() ? this._selectedCloseButton : this._hoverCloseButton;
    }

    private void updateCloseButtons() {
        this.updateSelectedCloseButton();
        this.updateHoverCloseButton();
    }

    private void updateSelectedCloseButton() {
        if (this.isShowSelectedCloseButton()) {
            if (this._selectedPage >= 0 && this._selectedPage < this.getPageCount()) {
                this.showCloseButton(this._selectedCloseButton, this._selectedPage);
            } else {
                this.hideCloseButton(this._selectedCloseButton);
            }
        }
    }

    private void updateHoverCloseButton() {
        if (this._hoverPage >= 0 && this._hoverPage < this.getPageCount()) {
            if (!this.isShowSelectedCloseButton() || this._hoverPage != this._selectedPage) {
                this.showCloseButton(this._hoverCloseButton, this._hoverPage);
            } else {
                this.hideCloseButton(this._hoverCloseButton);
            }
        } else {
            this.hideCloseButton(this._hoverCloseButton);
        }
    }

    private void paintCloseIcon(AbstractButton closeButton, Graphics g, int pagePos) {
        CustomTabPage page = this.getPage(pagePos);
        if (this._closeAction != null && page.isCloseable()) {
            Rectangle pageBounds = page.getBounds();
            Dimension buttonSize = closeButton.getPreferredSize();
            boolean isSelected = pagePos == this.getSelectedPage();
            int x = pageBounds.x + pageBounds.width - (buttonSize.width + this._gapRight + this._cornerSize + 1);
            int y = pageBounds.y + (pageBounds.height - buttonSize.height + (this.isShowTabUnderline() ? 0 : 1) + (isSelected ? 0 : this._offsetSelected)) / 2;
            if (this._isThemedBottomTab()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("editortab.close", "default");
                Icon icon = properties.getIcon("icon");
                icon.paintIcon(this, g, x, y);
            } else {
                CLOSE_BUTTON.paintIcon(this, g, x + 2, y + 2);
            }
        }
    }

    private void showCloseButton(AbstractButton closeButton, int pagePos) {
        CustomTabPage page = this.getPage(pagePos);
        if (this._closeAction != null && page.isCloseable()) {
            closeButton.setVisible(true);
            Rectangle pageBounds = page.getBounds();
            Dimension buttonSize = closeButton.getPreferredSize();
            boolean isSelected = pagePos == this.getSelectedPage();
            int x = pageBounds.x + pageBounds.width - (buttonSize.width + this._gapRight + this._cornerSize + 1);
            int y = pageBounds.y + (pageBounds.height - buttonSize.height + (this.isShowTabUnderline() ? 0 : 1) + (isSelected ? 0 : this._offsetSelected)) / 2;
            closeButton.setBounds(x, y, buttonSize.width, buttonSize.height);
            closeButton.setForeground(this.getPageForeground(pagePos, page));
        }
    }

    private void hideCloseButton(AbstractButton closeButton) {
        if (this._closeAction != null && closeButton != null) {
            closeButton.setVisible(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point point;
        int pagePos;
        boolean canClose;
        boolean bl = canClose = PlatformUtils.isMac() ? e.isAltDown() : e.isControlDown();
        if (this._closeAction != null && this.isCtrlClickCloseEnabled() && (canClose || SwingUtilities.isMiddleMouseButton(e)) && (pagePos = this.getPageAt(point = e.getPoint())) != -1) {
            CustomTabPage page = this.getPage(pagePos);
            ActionEvent eventToSend = new ActionEvent(page, 1001, "", e.getWhen(), e.getModifiers());
            this._closeAction.actionPerformed(eventToSend);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && (!this.isCtrlClickCloseEnabled() || !e.isControlDown() && !SwingUtilities.isMiddleMouseButton(e))) {
            this.selectPageAt(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this._isListeningGlobalMouseMovements && (this._closeAction != null || Themes.isThemed())) {
            final GlobalMouseDispatcher globalMouseDispatcher = GlobalMouseDispatcher.getInstance();
            globalMouseDispatcher.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Component component = e.getComponent();
                    if (!SwingUtilities.isDescendingFrom(component, CustomTab.this)) {
                        globalMouseDispatcher.removeMouseListener(this);
                        CustomTab.this._isListeningGlobalMouseMovements = false;
                        CustomTab.this._hoverPage = -1;
                        CustomTab.this.updateHoverCloseButton();
                    }
                }
            });
            this._isListeningGlobalMouseMovements = true;
        }
        this.updateHoverCloseButton(e.getPoint());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.updateHoverCloseButton(e.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateHoverCloseButton(e.getPoint());
    }

    private void updateHoverCloseButton(Point pt) {
        int oldHover = this._hoverPage;
        this._hoverPage = this.getPageAt(pt);
        if (this._closeAction != null) {
            this.updateHoverCloseButton();
        }
        if (oldHover != -1 && this.getPage(oldHover) != null) {
            this.repaint(this.getPage(oldHover).getBounds());
        }
    }

    public void whenTabChanged() {
        this.revalidate();
    }

    public void addListDataListener(ListDataListener listener) {
        this._listDataListeners.add(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this._listDataListeners.remove(listener);
    }

    private void fireListDataEvent(ListDataEvent e) {
        block5: for (int i = 0; i < this._listDataListeners.size(); ++i) {
            ListDataListener listDataListener = (ListDataListener)this._listDataListeners.get(i);
            switch (e.getType()) {
                case 0: {
                    listDataListener.contentsChanged(e);
                    continue block5;
                }
                case 1: {
                    listDataListener.intervalAdded(e);
                    continue block5;
                }
                case 2: {
                    listDataListener.intervalRemoved(e);
                }
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        if (index0 <= this._selectedPage) {
            this._selectedPage += index1 + 1 - index0;
        }
        this.fireListDataEvent(e);
        this.whenTabChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        int indexFrom = e.getIndex0();
        int indexTo = e.getIndex1();
        if (this._hoverPage >= indexFrom && this._hoverPage <= indexTo) {
            this._hoverPage = -1;
        }
        if (this._selectedPage > indexTo) {
            this._selectedPage -= indexTo + 1 - indexFrom;
        } else if (this._selectedPage >= indexFrom) {
            CustomTabPage page;
            int newIndex;
            for (newIndex = indexFrom - 1; newIndex >= 0 && !(page = this.getPage(newIndex)).isVisible(); --newIndex) {
            }
            for (int betterIndex = newIndex + 1; betterIndex < this._model.getSize(); ++betterIndex) {
                CustomTabPage page2 = this.getPage(betterIndex);
                if (page2.isVisible()) {
                    newIndex = betterIndex;
                    break;
                }
                ++betterIndex;
            }
            if (newIndex >= 0) {
                this._setSelectedPage(newIndex);
            }
        }
        this.fireListDataEvent(e);
        this.whenTabChanged();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.setSelectedPage(-1);
        this.fireListDataEvent(e);
        this.whenTabChanged();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        CustomTabPage tabPage;
        String ret = null;
        int pagePos = this.getPageAt(event.getPoint());
        if (pagePos != -1 && (ret = (tabPage = this.getPage(pagePos)).getTooltip()) == null && (tabPage.isCompressed() || tabPage.isCondensed()) && (ret = tabPage.getLongLabel()) == null) {
            ret = tabPage.getLabel();
        }
        return ret;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        int pagePos;
        Point ret = null;
        if (this.getToolTipText(event) != null && (pagePos = this.getPageAt(event.getPoint())) != -1) {
            CustomTabPage tabPage = this.getPage(pagePos);
            Rectangle bounds = tabPage.getBounds();
            if (this._tooltipHeight == 0) {
                JToolTip toolTip = this.createToolTip();
                toolTip.setTipText("jt");
                this._tooltipHeight = toolTip.getPreferredSize().height;
            }
            ret = new Point(bounds.x, -this._tooltipHeight);
        }
        return ret;
    }

    private String getThemeState(int tabIndex) {
        boolean selected = this.getSelectedPage() == tabIndex;
        CustomTabPage page = this.getPage(tabIndex);
        if (this._isThemedBottomTab() && !page.isEnabled()) {
            return "disabled";
        }
        if (selected && this.isFocused()) {
            return "active";
        }
        if (selected) {
            return "inactive";
        }
        if (page.isHighlighted()) {
            return "highlighted";
        }
        if (this._hoverPage == tabIndex) {
            return "mouseover";
        }
        return "deselected";
    }

    private void drawTabTop(int index, int x, int y, int tabWidth, int tabHeight, CustomTabPage page, Graphics2D g) {
        boolean selected;
        boolean bl = selected = this.getSelectedPage() == index;
        if (Themes.isThemed()) {
            String state = this.getThemeState(index);
            if (state != null) {
                Painter p = Themes.getActiveTheme().getStateProperties(this._themeStyle, state).getPainter("bg");
                p.paint((Graphics)g, x, y, tabWidth, tabHeight);
            }
        } else {
            int selectionOffset = selected ? 0 : this._offsetSelected;
            int[] xPoints = new int[]{x, x, x + this._cornerSize, x + tabWidth - this._cornerSize - 1, x + tabWidth - 1, x + tabWidth - 1};
            int[] yPoints = new int[]{y + tabHeight - 1, y + this._cornerSize + selectionOffset, y + selectionOffset, y + selectionOffset, y + this._cornerSize + selectionOffset, y + tabHeight - 1};
            if (this.isGradientHighlight()) {
                Polygon shape = new Polygon(xPoints, yPoints, xPoints.length);
                if (selected) {
                    Color c2;
                    Color c1;
                    if (this.isFocused()) {
                        c1 = IdeUIManager.getActiveTitleGradientLightColor();
                        c2 = IdeUIManager.getActiveTitleGradientDarkColor();
                    } else {
                        c1 = IdeUIManager.getInactiveTitleGradientLightColor();
                        c2 = IdeUIManager.getInactiveTitleGradientDarkColor();
                    }
                    g.setColor(c2);
                    g.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, tabHeight - 1, c2));
                } else {
                    g.setColor(IdeUIManager.getUnselectedTitleColor());
                }
                g.fill(shape);
                g.drawLine(x + 1, y + tabHeight - 1, x + tabWidth - 2, y + tabHeight - 1);
                Color c = g.getColor();
                c = new Color((int)((double)c.getRed() * 0.95), (int)((double)c.getGreen() * 0.95), (int)((double)c.getBlue() * 0.95));
                g.setColor(c);
                g.drawLine(x + tabWidth - 3, y + this._cornerSize + selectionOffset - 1, x + tabWidth - 3, y + tabHeight - 3);
                c = new Color((int)((double)c.getRed() * 0.95), (int)((double)c.getGreen() * 0.95), (int)((double)c.getBlue() * 0.95));
                g.setColor(c);
                g.drawLine(x + tabWidth - 2, y + this._cornerSize + selectionOffset, x + tabWidth - 2, y + tabHeight - 2);
            } else {
                g.setColor(this.getPageBackground(page, selected));
                g.fillPolygon(xPoints, yPoints, xPoints.length);
                g.drawLine(x + 1, y + tabHeight - 1, x + tabWidth - 2, y + tabHeight - 1);
            }
            g.setColor(COLOR_LINES);
            g.drawPolyline(xPoints, yPoints, xPoints.length);
        }
        Rectangle labelRectangle = new Rectangle();
        labelRectangle.x = x + 1 + this._cornerSize + this._gapLeft;
        labelRectangle.y = y + this._gapAboveLabel + this._offsetSelected / 2;
        labelRectangle.height = tabHeight - this._gapBelowLabel;
        labelRectangle.width = tabWidth - this._cornerSize - this._gapLeft - this._gapRight - this._cornerSize - 1;
        if (this._closeAction != null) {
            AbstractButton closeButton = this.getCloseButton(selected);
            labelRectangle.width -= this._gapClose + closeButton.getPreferredSize().width;
        }
        if (selected) {
            labelRectangle.translate(0, -((int)((double)this._offsetSelected * this._selectedStyle)));
        }
        this.drawIconAndLabel(g, labelRectangle, index, page);
    }

    private void drawTabBottom(int x, int y, int tabWidth, int tabHeight, int index, CustomTabPage page, Graphics2D g) {
        boolean selected;
        boolean bl = selected = index == this.getSelectedPage();
        if (Themes.isThemed()) {
            String state = this.getThemeState(index);
            if (state != null) {
                Painter p = Themes.getActiveTheme().getStateProperties(this._themeStyle, state).getPainter("bg");
                p.paint((Graphics)g, x, y, tabWidth - 2, tabHeight);
                p = Themes.getActiveTheme().getStateProperties(this._themeStyle + ".edge1", state).getPainter("bg");
                p.paint((Graphics)g, x, y, tabWidth - 2, tabHeight);
                p = Themes.getActiveTheme().getStateProperties(this._themeStyle + ".edge2", state).getPainter("bg");
                p.paint((Graphics)g, x, y, tabWidth - 2, tabHeight);
            }
        } else {
            int selectionOffset = selected ? 0 : this._offsetSelected;
            int[] xPoints = new int[]{x, x, x + this._cornerSize, x + tabWidth - this._cornerSize - 1, x + tabWidth - 1, x + tabWidth - 1};
            int[] yPoints = new int[]{y, y + tabHeight - 1 - this._cornerSize - selectionOffset, y + tabHeight - 1 - selectionOffset, y + tabHeight - 1 - selectionOffset, y + tabHeight - 1 - this._cornerSize - selectionOffset, y};
            if (this.isGradientHighlight()) {
                Polygon shape = new Polygon(xPoints, yPoints, xPoints.length);
                if (selected) {
                    Color c2;
                    Color c1;
                    if (this.isFocused()) {
                        c1 = IdeUIManager.getActiveTitleGradientLightColor();
                        c2 = IdeUIManager.getActiveTitleGradientDarkColor();
                    } else {
                        c1 = IdeUIManager.getInactiveTitleGradientLightColor();
                        c2 = IdeUIManager.getInactiveTitleGradientDarkColor();
                    }
                    g.setColor(c2);
                    g.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, tabHeight - 1, c2));
                } else {
                    g.setColor(IdeUIManager.getUnselectedTitleColor());
                }
                g.fill(shape);
                Color c = g.getColor();
                c = new Color((int)((double)c.getRed() * 0.95), (int)((double)c.getGreen() * 0.95), (int)((double)c.getBlue() * 0.95));
                g.setColor(c);
                g.drawLine(x + tabWidth - 2, y, x + tabWidth - 2, y + tabHeight - 1 - this._cornerSize - selectionOffset);
            } else {
                g.setColor(this.getPageBackground(page, selected));
                g.fillPolygon(xPoints, yPoints, xPoints.length);
            }
            g.setColor(COLOR_LINES);
            g.drawPolyline(xPoints, yPoints, xPoints.length);
        }
        Rectangle labelRectangle = new Rectangle();
        labelRectangle.x = x + 1 + this._cornerSize + this._gapLeft;
        labelRectangle.y = y + this._gapAboveLabel;
        labelRectangle.height = tabHeight - this._offsetSelected - this._gapBelowLabel - 1;
        labelRectangle.width = tabWidth - this._cornerSize - this._gapLeft - this._gapRight - this._cornerSize - 1;
        if (this._closeAction != null) {
            AbstractButton closeButton = this.getCloseButton(selected);
            labelRectangle.width -= this._gapClose + closeButton.getPreferredSize().width;
        }
        if (selected) {
            labelRectangle.translate(0, (int)((double)this._offsetSelected * this._selectedStyle));
        }
        this.drawIconAndLabel(g, labelRectangle, index, page);
    }

    public Rectangle calculateLabelRectangle(CustomTabPage page, int viewPos) {
        boolean selected;
        int index = 0;
        for (int i = 0; i < this.getPageCount(); ++i) {
            if (this.getPage(i) != page) continue;
            index = i;
            break;
        }
        Rectangle pageBounds = page.getBounds();
        Rectangle labelRectangle = new Rectangle();
        labelRectangle.x = pageBounds.x + 1 + this._cornerSize + this._gapLeft;
        labelRectangle.y = pageBounds.y + this._gapAboveLabel + this._offsetSelected / 2;
        labelRectangle.height = pageBounds.height - this._gapBelowLabel;
        labelRectangle.width = pageBounds.width - this._cornerSize - this._gapLeft - this._gapRight - this._cornerSize - 1;
        labelRectangle.width -= viewPos - pageBounds.x;
        boolean bl = selected = index == this.getSelectedPage();
        if (this._closeAction != null) {
            AbstractButton closeButton = this.getCloseButton(selected);
            labelRectangle.width -= this._gapClose + closeButton.getPreferredSize().width;
        }
        if (selected) {
            labelRectangle.translate(0, -((int)((double)this._offsetSelected * this._selectedStyle)));
        }
        return labelRectangle;
    }

    private void drawIconAndLabel(Graphics2D g2, Rectangle labelRectangle, int index, CustomTabPage page) {
        String text;
        boolean hasText;
        boolean hasIcon;
        int viewportX = -1;
        boolean leftClipped = false;
        if (this.getParent() != null && this.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            viewportX = viewport.getViewPosition().x;
            if (viewportX > page.getBounds().x && viewportX <= page.getBounds().x + page.getBounds().width) {
                int realWidth;
                leftClipped = true;
                labelRectangle.width = realWidth = labelRectangle.width - (viewportX - labelRectangle.x);
                labelRectangle.x = viewportX;
            }
        }
        Graphics2D g = (Graphics2D)g2.create();
        int paintPos = leftClipped ? 5 : 0;
        Icon icon = this.isShowIcons() ? page.getIcon() : null;
        boolean bl = hasIcon = icon != null;
        if (hasIcon && !leftClipped) {
            int iconWidth;
            if (Themes.isThemed()) {
                TranslucentIcon ti = new TranslucentIcon(icon);
                double d = Themes.getActiveTheme().getStateProperties(this._themeStyle, this.getThemeState(index)).getDouble("iconopacity");
                if (d != 1.0) {
                    ti.setAlpha((float)d);
                    icon = ti;
                }
            }
            if ((iconWidth = icon.getIconWidth()) <= labelRectangle.width) {
                int yMiddle = labelRectangle.y + (labelRectangle.height - icon.getIconHeight()) / 2;
                icon.paintIcon(this, g, labelRectangle.x + paintPos, yMiddle);
                paintPos += iconWidth;
            }
        }
        if (hasText = ModelUtil.hasLength((String)(text = page.isCondensed() ? page.getLabel() : page.getLongLabel()))) {
            Font font = this.getAdjustedFont(index, page);
            g.setFont(font);
            FontRenderContext frc = g.getFontRenderContext();
            Rectangle2D stringBounds = font.getStringBounds(text, frc);
            double textTop = (double)labelRectangle.y + ((double)labelRectangle.height - stringBounds.getHeight()) / 2.0;
            double ascent = -stringBounds.getY();
            float dY = (float)(textTop + ascent);
            g.setColor(this.getPageForeground(index, page));
            int availableWidth = labelRectangle.width - paintPos;
            if (stringBounds.getWidth() <= (double)availableWidth) {
                if (hasIcon) {
                    paintPos += this._gapCenter;
                }
                SwingUtils.drawString((Graphics2D)g, (String)text, (float)(labelRectangle.x + paintPos), (float)dY);
            } else {
                Rectangle2D dddBounds = font.getStringBounds(DOTDOTDOT, frc);
                if (hasIcon) {
                    paintPos += this._gapCenter;
                    availableWidth -= this._gapCenter;
                }
                g.clipRect(labelRectangle.x + paintPos, labelRectangle.y, availableWidth, labelRectangle.height);
                try {
                    double truncatedWidth = (double)availableWidth - dddBounds.getWidth();
                    TextLayout textLayout = new TextLayout(text, g.getFont(), frc);
                    TextHitInfo textHitInfo = textLayout.hitTestChar((float)truncatedWidth, 1.0f);
                    int charIndex = textHitInfo.getCharIndex();
                    if (charIndex > 0) {
                        String subText = text.substring(0, charIndex).trim();
                        if (!leftClipped) {
                            SwingUtils.drawString((Graphics2D)g, (String)subText, (float)(labelRectangle.x + paintPos), (float)dY);
                        } else {
                            SwingUtils.drawString((Graphics2D)g, (String)subText, (float)(viewportX + paintPos), (float)dY);
                        }
                        Rectangle2D subTextBounds = font.getStringBounds(subText, frc);
                        paintPos = (int)((double)paintPos + subTextBounds.getWidth());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                SwingUtils.drawString((Graphics2D)g, (String)DOTDOTDOT, (float)(labelRectangle.x + paintPos), (float)dY);
            }
        }
        g.dispose();
    }

    private Color getPageForeground(int index, CustomTabPage page) {
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            return t.getStateProperties(this._themeStyle, this.getThemeState(index)).getColor("foreground");
        }
        boolean enabled = page.isEnabled();
        if (page.isHighlighted()) {
            return Color.WHITE;
        }
        if (!enabled) {
            return DISABLED_TEXT_COLOR;
        }
        if (this.isGradientHighlight()) {
            return index == this.getSelectedPage() ? (this.isFocused() ? IdeUIManager.getActiveTitleForegroundColor() : IdeUIManager.getInactiveTitleForegroundColor()) : IdeUIManager.getUnselectedTitleForegroundColor();
        }
        return enabled ? this.getForeground() : DISABLED_TEXT_COLOR;
    }

    private Color getPageBackground(CustomTabPage page, boolean selected) {
        if (this.isGradientHighlight()) {
            return selected ? (this.isFocused() ? IdeUIManager.getActiveTitleColor() : IdeUIManager.getInactiveTitleColor()) : IdeUIManager.getUnselectedTitleColor();
        }
        if (selected) {
            return COLOR_SELECTED_FOCUSED;
        }
        if (page.isHighlighted()) {
            return COLOR_HIGHLIGHTED;
        }
        return COLOR_UNSELECTED;
    }

    public int getGapBeforeTabs() {
        return this._gapBeforeTabs;
    }

    public void setGapBeforeTabs(int gapBeforeTabs) {
        this._gapBeforeTabs = gapBeforeTabs;
        this.whenTabChanged();
    }

    public int getGapBetweenTabs() {
        return this._gapBetweenTabs;
    }

    public void setGapBetweenTabs(int gapBetweenTabs) {
        this._gapBetweenTabs = gapBetweenTabs;
        this.whenTabChanged();
    }

    public int getGapAfterTabs() {
        return this._gapAfterTabs;
    }

    public void setGapAfterTabs(int gapAfterTabs) {
        this._gapAfterTabs = gapAfterTabs;
        this.whenTabChanged();
    }

    public int getGapAboveLabel() {
        return this._gapAboveLabel;
    }

    public void setGapAboveLabel(int gapAboveLabel) {
        this._gapAboveLabel = gapAboveLabel;
        this.whenTabChanged();
    }

    public int getGapBelowLabel() {
        return this._gapBelowLabel;
    }

    public void setGapBelowLabel(int gapBelowLabel) {
        this._gapBelowLabel = gapBelowLabel;
        this.whenTabChanged();
    }

    public int getGapLeft() {
        return this._gapLeft;
    }

    public void setGapLeft(int gapLeft) {
        this._gapLeft = gapLeft;
        this.whenTabChanged();
    }

    public int getGapCenter() {
        return this._gapCenter;
    }

    public void setGapCenter(int gapCenter) {
        this._gapCenter = gapCenter;
        this.whenTabChanged();
    }

    public int getGapRight() {
        return this._gapRight;
    }

    public int getGapClose() {
        return this._gapClose;
    }

    public void setGapClose(int gapClose) {
        this._gapClose = gapClose;
        this.whenTabChanged();
    }

    public void setGapRight(int gapRight) {
        this._gapRight = gapRight;
        this.whenTabChanged();
    }

    public int getOffsetSelected() {
        return this._offsetSelected;
    }

    public void setOffsetSelected(int offsetSelected) {
        this._offsetSelected = offsetSelected;
        this.whenTabChanged();
    }

    public int getCornerSize() {
        return this._cornerSize;
    }

    public void setCornerSize(int cornerSize) {
        this._cornerSize = cornerSize;
        this.whenTabChanged();
    }

    public double getSelectedStyle() {
        return this._selectedStyle;
    }

    public void setSelectedStyle(double selectedStyle) {
        this._selectedStyle = selectedStyle;
        this.whenTabChanged();
    }

    private boolean _isThemedBottomTab() {
        return this.getPosition() == 3 && Themes.isThemed();
    }

    private Dimension getMaxSize() {
        Rectangle tabBounds = this.getTabBounds();
        Dimension size = this.calculateSizes(tabBounds, false);
        Insets insets = this.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    private int getPreferredTabHeight(String label, Icon icon, FontMetrics fontMetrics, boolean isSelected) {
        int height;
        Insets insets = this.getInsets();
        boolean hasIcon = icon != null;
        boolean hasLabel = label != null && label.length() != 0;
        AbstractButton closeButton = this.getCloseButton(isSelected);
        int n = height = hasIcon ? icon.getIconHeight() : 0;
        if (hasLabel) {
            int fontHeight = fontMetrics.getHeight();
            height = Math.max(height, fontHeight);
        }
        if (closeButton != null && this._closeAction != null) {
            height = Math.max(height, closeButton.getPreferredSize().height);
        }
        height += insets.top + this._gapAboveLabel + this._gapBelowLabel + insets.bottom;
        if (this.isShowTabUnderline()) {
            ++height;
        }
        return Math.max(height, this.getMinTabHeight());
    }

    private int getPreferredTabWidth(String label, Icon icon, FontMetrics fontMetrics, boolean isSelected) {
        boolean hasIcon = icon != null;
        boolean hasLabel = label != null && label.length() != 0;
        AbstractButton closeButton = this.getCloseButton(isSelected);
        int width = 1 + this._cornerSize + this._gapLeft;
        if (hasIcon) {
            width += icon.getIconWidth();
        }
        if (hasIcon && hasLabel) {
            width += this._gapCenter;
        }
        if (hasLabel) {
            width = this._maxTabChars < 1 ? (width += fontMetrics.stringWidth(label)) : (width += fontMetrics.stringWidth(label.length() < this._maxTabChars ? label : label.substring(0, this._maxTabChars) + DOTDOTDOT));
        }
        if (closeButton != null && this._closeAction != null) {
            width += closeButton.getPreferredSize().width + this._gapClose;
        }
        return Math.max(width += this._gapRight + this._cornerSize + 1, this.getMinTabWidth());
    }

    private int getMinimumTabWidth(CustomTabPage page, boolean isSelected) {
        Icon icon = this.isShowIcons() ? page.getIcon() : null;
        AbstractButton closeButton = this.getCloseButton(isSelected);
        int minWidth = 1 + this._cornerSize + this._gapLeft;
        minWidth = icon != null ? (minWidth += icon.getIconWidth()) : (minWidth += 16);
        if (closeButton != null && this._closeAction != null) {
            minWidth += closeButton.getPreferredSize().width + this._gapClose;
        }
        return Math.max(minWidth += this._gapRight + this._cornerSize + 1, this.getMinTabWidth());
    }

    private int getCompressedTabWidth(String label, Icon icon, Font font, FontMetrics fontMetrics, int available, boolean isSelected) {
        int dddWidth;
        int gapCenter;
        int availableForText;
        int compressedWidth = 1 + this._cornerSize + this._gapLeft;
        compressedWidth += this._gapRight + this._cornerSize + 1;
        boolean hasLabel = label != null && label.length() != 0;
        boolean hasIcon = icon != null;
        AbstractButton closeButton = this.getCloseButton(isSelected);
        if (hasIcon) {
            compressedWidth += icon.getIconWidth();
        }
        if (closeButton != null && this._closeAction != null) {
            compressedWidth += closeButton.getPreferredSize().width + this._gapClose;
        }
        if (hasLabel && (availableForText = available - compressedWidth - (gapCenter = icon != null ? this._gapCenter : 0)) > 0 && (dddWidth = fontMetrics.stringWidth(DOTDOTDOT)) < availableForText) {
            try {
                double truncatedWidth = availableForText - dddWidth;
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                TextLayout textLayout = new TextLayout(label, font, fontRenderContext);
                TextHitInfo textHitInfo = textLayout.hitTestChar((float)truncatedWidth, 1.0f);
                int charIndex = textHitInfo.getCharIndex();
                if (charIndex > 0) {
                    String subText = label.substring(0, charIndex);
                    int subWidth = fontMetrics.stringWidth(subText);
                    compressedWidth += gapCenter + subWidth + dddWidth;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return Math.max(compressedWidth, this.getMinTabWidth());
    }

    private Dimension calculateSizes(Rectangle bounds, boolean allowCompression) {
        int pageCount = this.getPageCount();
        int maxHeight = 0;
        int totalWidth = 0;
        int visibleCount = 0;
        int[] widths = new int[pageCount];
        int[] shortWidths = new int[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage page = this.getPage(i);
            page.setCompressed(false);
            page.setCondensed(false);
            if (!page.isVisible()) continue;
            boolean isSelected = i == this.getSelectedPage();
            Font font = this.getAdjustedFont(i, page);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Icon icon = this.isShowIcons() ? page.getIcon() : null;
            String label = page.getLabel();
            if (ModelUtil.hasLength((String)label)) {
                int shortWidth = this.getPreferredTabWidth(label, icon, fontMetrics, isSelected);
                int shortHeight = this.getPreferredTabHeight(label, icon, fontMetrics, isSelected);
                shortWidths[i] = shortWidth;
                maxHeight = Math.max(shortHeight, maxHeight);
            } else {
                shortWidths[i] = 0;
            }
            String longLabel = page.getLongLabel();
            if (ModelUtil.hasLength((String)longLabel)) {
                int width = this.getPreferredTabWidth(longLabel, icon, fontMetrics, isSelected);
                int height = this.getPreferredTabHeight(longLabel, icon, fontMetrics, isSelected);
                widths[i] = width;
                maxHeight = Math.max(height, maxHeight);
            } else {
                widths[i] = shortWidths[i];
                page.setCondensed(true);
            }
            totalWidth += Math.max(widths[i], shortWidths[i]);
            ++visibleCount;
        }
        maxHeight += 1 + this._offsetSelected;
        int spaceLeft = bounds.width - totalWidth - this._gapBeforeTabs - this._gapAfterTabs - this._gapBetweenTabs * (visibleCount - 1);
        if (allowCompression && spaceLeft < 0) {
            int i = pageCount;
            while (i-- > 0) {
                int shortWidth;
                CustomTabPage page = this.getPage(i);
                if (!page.isVisible() || widths[i] <= (shortWidth = shortWidths[i])) continue;
                if (this.isCompressible()) {
                    int available;
                    Icon icon;
                    boolean isSelected = i == this.getSelectedPage();
                    Font font = this.getAdjustedFont(i, page);
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int dotdotdotWidth = fontMetrics.stringWidth(DOTDOTDOT);
                    String longLabel = page.getLongLabel();
                    int compressedWidth = this.getCompressedTabWidth(longLabel, icon = this.isShowIcons() ? page.getIcon() : null, font, fontMetrics, available = widths[i] + spaceLeft, isSelected);
                    if (compressedWidth - dotdotdotWidth > shortWidth) {
                        int newWidth = this.isFitWidth() ? compressedWidth : Math.max(compressedWidth, available);
                        int takenBack = widths[i] - newWidth;
                        totalWidth -= takenBack;
                        widths[i] = newWidth;
                        page.setCompressed(takenBack > 0);
                        if ((spaceLeft += takenBack) >= 0) break;
                    }
                }
                int available = widths[i] + spaceLeft;
                int newWidth = this.isFitWidth() ? shortWidth : Math.max(shortWidth, available);
                int takenBack = widths[i] - newWidth;
                totalWidth -= takenBack;
                widths[i] = newWidth;
                page.setCondensed(takenBack > 0);
                if ((spaceLeft += takenBack) < 0) continue;
                break;
            }
            if (spaceLeft < 0 && this.isCompressible()) {
                i = pageCount;
                while (i-- > 0) {
                    CustomTabPage page = this.getPage(i);
                    if (!page.isVisible()) continue;
                    boolean isSelected = i == this.getSelectedPage();
                    Font font = this.getAdjustedFont(i, page);
                    String label = page.getLabel();
                    Icon icon = this.isShowIcons() ? page.getIcon() : null;
                    int available = widths[i] + spaceLeft;
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int compressedWidth = this.getCompressedTabWidth(label, icon, font, fontMetrics, available, isSelected);
                    int newWidth = this.isFitWidth() ? compressedWidth : Math.max(compressedWidth, available);
                    int takenBack = widths[i] - newWidth;
                    totalWidth -= takenBack;
                    widths[i] = newWidth;
                    page.setCompressed(takenBack > 0);
                    if ((spaceLeft += takenBack) < 0) continue;
                    break;
                }
            }
        }
        if (allowCompression && this.isFitWidth() && spaceLeft > 0) {
            int i = pageCount;
            while (i-- > 0) {
                CustomTabPage page = this.getPage(i);
                if (visibleCount <= 0 || !page.isVisible()) continue;
                int extra = spaceLeft / visibleCount;
                int n = i;
                widths[n] = widths[n] + extra;
                spaceLeft -= extra;
                --visibleCount;
            }
        }
        int xPos = bounds.x + this._gapBeforeTabs;
        int yPos = bounds.y;
        int height = allowCompression ? bounds.height : maxHeight;
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage page = this.getPage(i);
            if (!page.isVisible()) continue;
            int width = widths[i];
            if (allowCompression) {
                page.setBounds(xPos, yPos, width, height);
            }
            xPos += widths[i];
            xPos += this._gapBetweenTabs;
        }
        if (visibleCount > 0) {
            xPos -= this._gapBetweenTabs;
        }
        if (allowCompression && (xPos != bounds.width || maxHeight != bounds.height)) {
            this.updateCloseButtons();
        }
        return new Dimension(xPos, maxHeight);
    }

    @Override
    protected void paintComponent(Graphics gAWT) {
        Graphics2D g = (Graphics2D)gAWT;
        this.paintTabs(g);
    }

    protected void paintTabs(Graphics2D g) {
        int pageCount;
        Rectangle tabBounds = this.getTabBounds();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if ((pageCount = this.getPageCount()) == 0) {
            return;
        }
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage page = this.getPage(i);
            if (!page.isVisible()) continue;
            Font font = this.getAdjustedFont(i, page);
            g.setFont(font);
            Rectangle pageBounds = page.getBounds();
            if (this._position == 1) {
                this.drawTabTop(i, pageBounds.x, pageBounds.y, pageBounds.width, pageBounds.height, page, g);
                if (Themes.isThemed() && i < pageCount - 1 && this.getSelectedPage() != i + 1 && this.getSelectedPage() != i) {
                    Painter p = Themes.getActiveTheme().getStateProperties("tabseparator", "normal").getPainter("bg");
                    p.paint((Graphics)g, pageBounds.x + pageBounds.width, 4, 1, pageBounds.height - 8);
                }
                if (!this.alwaysShowCloseButton) continue;
                this.paintCloseIcon(this._selectedCloseButton, g, i);
                continue;
            }
            this.drawTabBottom(pageBounds.x, pageBounds.y, pageBounds.width, pageBounds.height, i, page, g);
            if (!this.alwaysShowCloseButton) continue;
            this.paintCloseIcon(this._selectedCloseButton, g, i);
        }
        if (this.isShowTabUnderline()) {
            CustomTabPage selectedPage;
            Color c = COLOR_LINES;
            if (Themes.isThemed()) {
                Theme theme = Themes.getActiveTheme();
                c = this.isFocused() ? theme.getStateProperties("view", "active").getColor("bordercolor") : theme.getStateProperties("view", "inactive").getColor("bordercolor");
            }
            g.setColor(c);
            int leftOfTab = tabBounds.x;
            int rightOfTab = tabBounds.x;
            if (this._selectedPage != -1 && (selectedPage = this.getPage(this._selectedPage)).isVisible()) {
                Rectangle selectedPageBounds = selectedPage.getBounds();
                leftOfTab = selectedPageBounds.x;
                rightOfTab = leftOfTab + selectedPageBounds.width - 1;
            }
            if (this._position == 3) {
                if (leftOfTab > tabBounds.x) {
                    g.drawLine(tabBounds.x, tabBounds.y, leftOfTab, tabBounds.y);
                }
                g.drawLine(rightOfTab, tabBounds.y, tabBounds.x + tabBounds.width - 1, tabBounds.y);
            } else {
                if (leftOfTab > tabBounds.x) {
                    g.drawLine(tabBounds.x, tabBounds.y + tabBounds.height - 1, leftOfTab, tabBounds.y + tabBounds.height - 1);
                }
                g.drawLine(rightOfTab, tabBounds.y + tabBounds.height - 1, tabBounds.x + tabBounds.width - 1, tabBounds.y + tabBounds.height - 1);
            }
        }
        this.clearCachedFont();
    }

    private Rectangle getTabBounds() {
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    public synchronized void setSelectedPageViaMouse() {
        this.dragPageOpenIndex = this.getPageUnderMouse();
        if (this.dragPageOpenIndex == -1) {
            this.dragPageOpenTimer.stop();
        } else {
            this.dragPageOpenTimer.restart();
        }
    }

    private int getPageUnderMouse() {
        PointerInfo pi = MouseInfo.getPointerInfo();
        if (pi != null && pi.getLocation() != null) {
            Point location = pi.getLocation();
            SwingUtilities.convertPointFromScreen(location, this);
            int page = this.getPageAt(location);
            return page;
        }
        return -1;
    }

    private void ensureTabActionsLoaded(ActionMap map) {
        Actions a = new Actions("navigateNext");
        map.put(a.getValue("Name"), a);
        a = new Actions("navigatePrevious");
        map.put(a.getValue("Name"), a);
        a = new Actions("navigateRight");
        map.put(a.getValue("Name"), a);
        a = new Actions("navigateLeft");
        map.put(a.getValue("Name"), a);
        a = new Actions("navigateUp");
        map.put(a.getValue("Name"), a);
        a = new Actions("navigateDown");
        map.put(a.getValue("Name"), a);
        a = new Actions("navigatePageUp");
        map.put(a.getValue("Name"), a);
        this._parentActions.add(a);
        a = new Actions("navigatePageDown");
        map.put(a.getValue("Name"), a);
        this._parentActions.add(a);
        a = new Actions("requestFocus");
        map.put(a.getValue("Name"), a);
        this._parentActions.add(a);
        a = new Actions("requestFocusForVisibleComponent");
        map.put(a.getValue("Name"), a);
        this._parentActions.add(a);
    }

    private void loadActionMap() {
        ActionMapUIResource myActionMap = new ActionMapUIResource();
        this.ensureTabActionsLoaded(myActionMap);
        SwingUtilities.replaceUIActionMap(this, myActionMap);
    }

    private void loadInputMap() {
        Object obj2;
        Object obj = UIManager.get("TabbedPane.ancestorInputMap");
        if (obj != null && obj instanceof InputMap) {
            SwingUtilities.replaceUIInputMap(this, 1, (InputMap)obj);
        }
        if ((obj2 = UIManager.get("TabbedPane.focusInputMap")) != null && obj2 instanceof InputMap) {
            SwingUtilities.replaceUIInputMap(this, 0, (InputMap)obj2);
        }
    }

    public void setTabComponentOwner(JComponent tabOwner) {
        this._ownerComponent = tabOwner;
        InputMap baseInputMap = (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        InputMap imap = tabOwner.getInputMap(1);
        KeyStroke[] allKeys = baseInputMap.allKeys();
        if (allKeys != null) {
            for (KeyStroke keystroke : allKeys) {
                imap.put(keystroke, baseInputMap.get(keystroke));
            }
        }
        ActionMap actionMap = tabOwner.getActionMap();
        for (Actions a : this._parentActions) {
            actionMap.put(a.getName(), a);
        }
    }

    private void addControllerToActions(boolean add) {
        if (add && this._controllerAdded || !add && !this._controllerAdded) {
            return;
        }
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>(3);
        IdeAction ideAction = IdeAction.find(70);
        if (ideAction != null) {
            actions.add(ideAction);
        }
        if ((ideAction = IdeAction.find(71)) != null) {
            actions.add(ideAction);
        }
        for (IdeAction a : actions) {
            if (add) {
                a.addController(this._controller);
                continue;
            }
            a.removeController(this._controller);
        }
        this._controllerAdded = add;
    }

    protected class AccessibleCustomTab
    extends JComponent.AccessibleJComponent
    implements ListSelectionListener {
        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            String cp = (String)CustomTab.this.getClientProperty("AccessibleName");
            if (cp != null) {
                return cp;
            }
            int index = CustomTab.this.getSelectedPage();
            if (index >= 0) {
                CustomTabPage tabPage = CustomTab.this.getPage(index);
                return tabPage != null ? tabPage.getLabel() : null;
            }
            return super.getAccessibleName();
        }

        public AccessibleCustomTab() {
            super(CustomTab.this);
            CustomTab.this.addSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CustomTabPage tabPage;
            Object o = e.getSource();
            int selPage = CustomTab.this.getSelectedPage();
            if (selPage != -1 && (tabPage = CustomTab.this.getPage(selPage)) instanceof DefaultCustomTabPage) {
                Component comp;
                Object obj = ((DefaultCustomTabPage)tabPage).getUserObject();
                Accessible acomp = null;
                if (obj instanceof Accessible) {
                    acomp = (Accessible)obj;
                } else if (obj instanceof LogPage) {
                    LogPage lpage = (LogPage)obj;
                    Component comp2 = lpage.getLogPageView().getGUI();
                    if (comp2 instanceof Accessible) {
                        acomp = (Accessible)((Object)comp2);
                    }
                } else if (obj instanceof View && (comp = ((View)obj).getGUI()) instanceof Accessible) {
                    acomp = (Accessible)((Object)comp);
                }
                if (acomp == null && CustomTab.this._ownerComponent != null) {
                    Component c = null;
                    if (CustomTab.this._ownerComponent instanceof SwitchablePanel) {
                        SwitchablePanel spanel = (SwitchablePanel)CustomTab.this._ownerComponent;
                        c = spanel.getComponentForPage(tabPage);
                    } else {
                        c = CustomTab.this._ownerComponent;
                    }
                    if (c != null && c instanceof Accessible) {
                        acomp = (Accessible)((Object)c);
                    }
                }
                if (acomp != null) {
                    AccessibleContext ac = acomp.getAccessibleContext();
                    ac.firePropertyChange("AccessibleName", "", tabPage.getLabel() + " " + AccessibleRole.PAGE_TAB);
                }
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            int tab = CustomTab.this.getPageAt(p);
            if (tab == -1) {
                tab = CustomTab.this.getSelectedPage();
            }
            return this.getAccessibleChild(tab);
        }
    }

    private static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomTabPage tabPage;
            String key = this.getName();
            if (!(e.getSource() instanceof JComponent)) {
                return;
            }
            CustomTab cTab = this.getCustomTabInstance((JComponent)e.getSource());
            if (cTab == null) {
                return;
            }
            int selPage = cTab.getSelectedPage();
            if (key == NEXT || key == RIGHT || key == DOWN || key == PAGE_DOWN) {
                if (selPage != -1 && selPage < cTab.getPageCount() - 1) {
                    cTab.setSelectedPage(selPage + 1);
                }
                cTab.requestFocus();
            } else if (key == PREVIOUS || key == LEFT || key == UP || key == PAGE_UP) {
                if (selPage != -1 && selPage > 0) {
                    cTab.setSelectedPage(selPage - 1);
                    cTab.requestFocus();
                }
            } else if (key == REQUEST_FOCUS) {
                cTab.requestFocus();
            } else if (key == REQUEST_FOCUS_FOR_VISIBLE && (tabPage = cTab.getPage(selPage)) instanceof DefaultCustomTabPage) {
                Object obj = ((DefaultCustomTabPage)tabPage).getUserObject();
                Component comp = null;
                if (obj instanceof Component) {
                    comp = (Component)obj;
                } else if (obj instanceof LogPage) {
                    LogPage lpage = (LogPage)obj;
                    comp = lpage.getLogPageView().getGUI();
                }
                if (comp != null) {
                    JComponent jComponent = GraphicsUtils.focusComponentOrChild((Component)comp, (boolean)true);
                }
            }
        }

        private CustomTab getCustomTabInstance(JComponent comp) {
            if (comp instanceof CustomTab) {
                return (CustomTab)comp;
            }
            int n = comp.getComponentCount();
            for (int i = 0; i < n; ++i) {
                CustomTab ctab;
                Component child = comp.getComponent(i);
                if (!(child instanceof JComponent) || (ctab = this.getCustomTabInstance((JComponent)child)) == null) continue;
                return ctab;
            }
            return null;
        }
    }

    private class DropTargetL
    implements DropTargetListener {
        private DropTargetL() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            int page = CustomTab.this.getPageAt(dtde.getLocation());
            CustomTab.this.setSelectedPageViaMouse();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
        }
    }

    private final class ForwardCloseActionEvent
    implements ActionListener {
        private ForwardCloseActionEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pagePos;
            ButtonModel model = ((AbstractButton)e.getSource()).getModel();
            String actionCommand = model.getActionCommand();
            if (actionCommand.equals(CustomTab.CLOSE_SELECTED_COMMAND)) {
                pagePos = CustomTab.this._selectedPage;
            } else if (actionCommand.equals(CustomTab.CLOSE_HOVER_COMMAND)) {
                pagePos = CustomTab.this._hoverPage;
            } else {
                return;
            }
            CustomTab.this._hoverPage = -1;
            CustomTabPage page = CustomTab.this.getPage(pagePos);
            ActionEvent eventToSend = new ActionEvent(page, 1001, "", e.getWhen(), e.getModifiers());
            CustomTab.this._closeAction.actionPerformed(eventToSend);
        }
    }

    private class MyAncestorListener
    implements AncestorListener {
        private MyAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            CustomTab.this.addControllerToActions(true);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            CustomTab.this.addControllerToActions(false);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class MyController
    implements Controller {
        private MyController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (!this.isRightContext()) {
                return false;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 70) {
                if (CustomTab.this._selectedPage > 0) {
                    CustomTab.this.setSelectedPage(CustomTab.this._selectedPage - 1);
                }
                return true;
            }
            if (cmdId == 71) {
                if (CustomTab.this._selectedPage < CustomTab.this.getPageCount() - 1) {
                    CustomTab.this.setSelectedPage(CustomTab.this._selectedPage + 1);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (!this.isRightContext()) {
                return false;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 70) {
                if (CustomTab.this._selectedPage > 0) {
                    action.setEnabled(true);
                    return true;
                }
            } else if (cmdId == 71 && CustomTab.this._selectedPage < CustomTab.this.getPageCount() - 1) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }

        private boolean isRightContext() {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focusComp = kfm.getFocusOwner();
            return focusComp == CustomTab.this;
        }
    }
}

