/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import oracle.ide.controls.ButtonKeyController;
import oracle.ide.util.Assert;

public class RadioKeyController
extends ButtonKeyController {
    private RadioKeyController(AbstractButton[] buttons, int direction) {
        super(buttons, direction);
    }

    @Override
    protected int getActivedButton(AbstractButton[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            AbstractButton button = buttons[i];
            if (!button.isSelected()) continue;
            return i;
        }
        return -1;
    }

    public static void attach(ButtonGroup buttonGroup) {
        AbstractButton[] buttons = RadioKeyController.getButtons(buttonGroup);
        Assert.check((buttons != null && buttons.length > 0 ? 1 : 0) != 0, (String)"You must attach() after adding the buttons to the group");
        RadioKeyController upAction = new RadioKeyController(buttons, -1);
        RadioKeyController downAction = new RadioKeyController(buttons, 1);
        RadioKeyController.attach(upAction, downAction, buttons);
    }

    private static AbstractButton[] getButtons(ButtonGroup buttonGroup) {
        int buttonCount = buttonGroup.getButtonCount();
        AbstractButton[] ret = new AbstractButton[buttonCount];
        Enumeration<AbstractButton> elements = buttonGroup.getElements();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = elements.nextElement();
        }
        return ret;
    }

    @Override
    protected void setActiveButton(AbstractButton button) {
        super.setActiveButton(button);
        button.setSelected(true);
    }
}

