/*
 * Decompiled with CFR 0.152.
 */
package odmr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import javax.json.stream.JsonParser;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sql.BFILE;
import oracle.sql.CLOB;
import oracle.sql.RAW;

public class JSONSchemaGenerator {
    String _table = null;
    String _column = null;
    String _sqlExpression = null;
    Integer _numOfDocs = null;
    Integer _numOfValues = null;
    Map<String, RowItem> _rowMap = new HashMap<String, RowItem>();
    ArrayList<RowItem> _rowList = new ArrayList(1000);
    RowItem _parentRow = null;
    int _lastPos = 0;
    public static String JSON_ROOT_ARRAY_SYMBOL = "[*]";

    private JSONSchemaGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parse(Connection conn) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int totalCnt = 0;
        try {
            stmt = conn.createStatement();
            rs = this._table != null ? (this._numOfDocs != null ? stmt.executeQuery("SELECT " + this._column + " FROM " + this._table + " WHERE ROWNUM <= " + this._numOfDocs) : stmt.executeQuery("SELECT " + this._column + " FROM " + this._table)) : (this._numOfDocs != null ? stmt.executeQuery("SELECT " + this._column + " FROM (" + this._sqlExpression + ") WHERE ROWNUM <= " + this._numOfDocs) : stmt.executeQuery("SELECT " + this._column + " FROM (" + this._sqlExpression + ")"));
            Stack<String> path = new Stack<String>();
            StringBuffer fullPath = new StringBuffer();
            int nDoc = 0;
            while (rs.next()) {
                Object obj = rs.getObject(this._column);
                InputStream in = null;
                if (obj instanceof Clob) {
                    Clob data_clob = (Clob)obj;
                    in = data_clob.getAsciiStream();
                } else if (obj instanceof Blob) {
                    Blob data_blob = (Blob)obj;
                    in = data_blob.getBinaryStream();
                } else if (obj instanceof RAW) {
                    RAW data_raw = (RAW)obj;
                    in = data_raw.binaryStreamValue();
                } else if (obj instanceof BFILE) {
                    BFILE data_bfile = (BFILE)obj;
                    in = data_bfile.getBinaryStream();
                } else {
                    String data_str = (String)obj;
                    in = new ByteArrayInputStream(data_str.getBytes());
                }
                ++nDoc;
                int nrow = 1;
                String curName = "";
                path.clear();
                boolean dirtyPath = false;
                boolean startDoc = true;
                JsonParser parser = Json.createParser((InputStream)in);
                int cnt = 0;
                while (parser.hasNext() && (this._numOfValues == null || cnt <= this._numOfValues)) {
                    JsonParser.Event event = parser.next();
                    String completePath = "";
                    if (dirtyPath) {
                        fullPath.setLength(0);
                        fullPath.append("$.");
                        for (String p : path) {
                            if (p.length() == 0) continue;
                            if (fullPath.length() > 2) {
                                fullPath.append('.');
                            }
                            fullPath.append(p.compareTo(JSON_ROOT_ARRAY_SYMBOL) == 0 ? p : "\"" + p + "\"");
                        }
                        dirtyPath = false;
                    }
                    completePath = fullPath.length() > 2 ? fullPath.toString() + '.' + "\"" + curName + "\"" : fullPath.toString() + "\"" + curName + "\"";
                    switch (event) {
                        case START_OBJECT: {
                            if (startDoc) {
                                startDoc = false;
                            }
                            path.push(curName);
                            dirtyPath = true;
                            if (curName.length() > 0) {
                                this.add(new RowItem(nrow++, "OBJECT", completePath, curName, ""));
                            }
                            curName = "";
                            break;
                        }
                        case END_OBJECT: {
                            path.pop();
                            dirtyPath = true;
                            curName = "";
                            break;
                        }
                        case START_ARRAY: {
                            if (startDoc) {
                                path.push(JSON_ROOT_ARRAY_SYMBOL);
                                startDoc = false;
                            } else {
                                path.push(curName);
                            }
                            dirtyPath = true;
                            if (curName.length() > 0) {
                                this.add(new RowItem(nrow++, "ARRAY", completePath, curName, ""));
                            }
                            curName = "";
                            break;
                        }
                        case END_ARRAY: {
                            path.pop();
                            dirtyPath = true;
                            curName = "";
                            break;
                        }
                        case KEY_NAME: {
                            curName = parser.getString();
                            break;
                        }
                        case VALUE_FALSE: {
                            if (curName.length() <= 0) break;
                            this.add(new RowItem(nrow++, "BOOLEAN", completePath, curName, "FALSE"));
                            ++cnt;
                            break;
                        }
                        case VALUE_TRUE: {
                            if (curName.length() <= 0) break;
                            this.add(new RowItem(nrow++, "BOOLEAN", completePath, curName, "TRUE"));
                            ++cnt;
                            break;
                        }
                        case VALUE_NULL: {
                            if (curName.length() <= 0) break;
                            this.add(new RowItem(nrow++, "NULL", completePath, curName, "NULL"));
                            ++cnt;
                            break;
                        }
                        case VALUE_STRING: {
                            if (curName.length() <= 0) break;
                            this.add(new RowItem(nrow++, "STRING", completePath, curName, parser.getString()));
                            ++cnt;
                            break;
                        }
                        case VALUE_NUMBER: {
                            if (curName.length() <= 0) break;
                            this.add(new RowItem(nrow++, "NUMBER", completePath, curName, parser.getString()));
                            ++cnt;
                        }
                    }
                }
                totalCnt += cnt;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
        return totalCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB pretty_json(CLOB jsonDoc, Integer count) {
        Connection conn = null;
        CLOB clob = null;
        try {
            OracleDataSource ods = new OracleDataSource();
            ods.setURL("jdbc:default:connection");
            conn = ods.getConnection();
            clob = CLOB.createTemporary((Connection)conn, (boolean)false, (int)12);
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonWriter jsonWriter = Json.createWriterFactory(config).createWriter((OutputStream)outputStream);
            JsonReader reader = Json.createReader((Reader)jsonDoc.getCharacterStream());
            JsonObject jsonObject = reader.readObject();
            jsonWriter.writeObject(jsonObject);
            jsonWriter.close();
            String formattedOut = outputStream.toString();
            int size = Math.min(formattedOut.length(), count);
            clob.setString(1L, formattedOut.substring(0, size));
            CLOB cLOB = clob;
            return cLOB;
        }
        catch (Exception e) {
            try {
                clob.setString(1L, e.getLocalizedMessage());
            }
            catch (Exception e2) {
                // empty catch block
            }
            CLOB cLOB = clob;
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB pretty_json2(CLOB jsonSqlExpression, Integer count) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        CLOB clob = null;
        try {
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            int totSize = 0;
            StringBuilder totDocs = new StringBuilder();
            OracleDataSource ods = new OracleDataSource();
            ods.setURL("jdbc:default:connection");
            conn = ods.getConnection();
            stmt = conn.createStatement();
            clob = CLOB.createTemporary((Connection)conn, (boolean)false, (int)12);
            rs = stmt.executeQuery(jsonSqlExpression.stringValue());
            while (rs.next()) {
                String line;
                Object text = null;
                text = rs.getObject(1);
                BufferedReader reader = null;
                if (text instanceof Clob) {
                    Clob data_clob = (Clob)text;
                    reader = new BufferedReader(data_clob.getCharacterStream());
                } else if (text instanceof Blob) {
                    Blob data_blob = (Blob)text;
                    reader = new BufferedReader(new InputStreamReader(data_blob.getBinaryStream()));
                } else if (text instanceof RAW) {
                    RAW data_raw = (RAW)text;
                    reader = new BufferedReader(new InputStreamReader(data_raw.binaryStreamValue()));
                } else if (text instanceof BFILE) {
                    BFILE data_bfile = (BFILE)text;
                    reader = new BufferedReader(new InputStreamReader(data_bfile.getBinaryStream()));
                } else {
                    String data_str = (String)text;
                    reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data_str.getBytes())));
                }
                StringBuilder data = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    data.append(line);
                }
                reader.close();
                String WRAPPER_BEGIN = "{";
                String ROOT = "\"R$T\":";
                String WRAPPER_END = "}";
                boolean removeWrappers = false;
                String jsonDoc = data.toString().trim();
                if (jsonDoc.startsWith("[")) {
                    jsonDoc = "{\"R$T\":" + jsonDoc + "}";
                    removeWrappers = true;
                }
                JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(jsonDoc.getBytes()));
                JsonObject jsonObject = jsonReader.readObject();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                JsonWriter jsonWriter = Json.createWriterFactory(config).createWriter((OutputStream)outputStream);
                jsonWriter.writeObject(jsonObject);
                jsonWriter.close();
                String formattedOut = outputStream.toString();
                if (removeWrappers) {
                    int idx = formattedOut.indexOf("\"R$T\":");
                    int len = "\"R$T\":".length();
                    formattedOut = formattedOut.substring(idx + len);
                    idx = formattedOut.lastIndexOf("}");
                    formattedOut = formattedOut.substring(0, idx);
                }
                totDocs.append(formattedOut);
                if ((totSize += formattedOut.length()) <= count) continue;
                break;
            }
            int finalSize = Math.min(totSize, count);
            clob.setString(1L, totDocs.substring(0, finalSize));
            CLOB cLOB = clob;
            return cLOB;
        }
        catch (Exception e) {
            try {
                clob.setString(1L, e.getLocalizedMessage());
            }
            catch (Exception e2) {
                // empty catch block
            }
            CLOB cLOB = clob;
            return cLOB;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public static int parse(String dataGuideTable, String jsontable, String columnName, Integer numOfDocs, Integer numOfValues) throws SQLException {
        Connection conn = null;
        JSONSchemaGenerator jSONSchemaGenerator = new JSONSchemaGenerator();
        jSONSchemaGenerator._table = jsontable;
        jSONSchemaGenerator._column = columnName;
        jSONSchemaGenerator._sqlExpression = null;
        jSONSchemaGenerator._numOfDocs = numOfDocs;
        jSONSchemaGenerator._numOfValues = numOfValues;
        int totalNumOfValues = 0;
        try {
            OracleDataSource ods = new OracleDataSource();
            ods.setURL("jdbc:default:connection");
            conn = ods.getConnection();
            totalNumOfValues = jSONSchemaGenerator.parse(conn);
            jSONSchemaGenerator.generateDataGuide(conn, dataGuideTable);
        }
        catch (SQLException e) {
            totalNumOfValues = -1;
            throw e;
        }
        return totalNumOfValues;
    }

    public static int parse2(String dataGuideTable, String jsonSqlExpression, String columnName, Integer numOfDocs, Integer numOfValues) throws SQLException {
        Connection conn = null;
        JSONSchemaGenerator jSONSchemaGenerator = new JSONSchemaGenerator();
        jSONSchemaGenerator._table = null;
        jSONSchemaGenerator._column = columnName;
        jSONSchemaGenerator._sqlExpression = jsonSqlExpression;
        jSONSchemaGenerator._numOfDocs = numOfDocs;
        jSONSchemaGenerator._numOfValues = numOfValues;
        int totalNumOfValues = 0;
        try {
            OracleDataSource ods = new OracleDataSource();
            ods.setURL("jdbc:default:connection");
            conn = ods.getConnection();
            totalNumOfValues = jSONSchemaGenerator.parse(conn);
            jSONSchemaGenerator.generateDataGuide(conn, dataGuideTable);
        }
        catch (SQLException e) {
            totalNumOfValues = -1;
            throw e;
        }
        return totalNumOfValues;
    }

    private void add(RowItem newRow) {
        RowItem row = this._rowMap.get(newRow.getPath());
        if (row == null) {
            if (this._parentRow != null) {
                if (newRow.getPath().indexOf(this._parentRow.getPath()) < 0) {
                    RowItem row2;
                    int pos;
                    for (pos = this._lastPos + 1; pos < this._rowList.size() && (row2 = this._rowList.get(pos)).getPath().indexOf(this._parentRow.getPath()) >= 0; ++pos) {
                    }
                    this._lastPos = pos;
                    this._rowList.add(this._lastPos, newRow);
                } else {
                    ++this._lastPos;
                    this._rowList.add(this._lastPos, newRow);
                }
            } else {
                boolean insert = false;
                for (int pos = 0; pos < this._rowList.size(); ++pos) {
                    if (newRow.getPath().compareToIgnoreCase(this._rowList.get(pos).getPath()) != -1) continue;
                    this._rowList.add(pos, newRow);
                    this._lastPos = pos;
                    insert = true;
                    break;
                }
                if (!insert) {
                    this._rowList.add(newRow);
                    this._lastPos = this._rowList.size() - 1;
                }
            }
            this._rowMap.put(newRow.getPath(), newRow);
            this._parentRow = newRow;
        } else {
            if (row.getType() != newRow.getType()) {
                if (row.getType().equals("ARRAY") || newRow.getType().equals("ARRAY")) {
                    row.setType("ARRAY");
                } else if (row.getType().equals("OBJECT") || newRow.getType().equals("OBJECT")) {
                    row.setType("OBJECT");
                } else if (row.getType().equals("NULL") && newRow.getType().equals("NUMBER") || row.getType().equals("NUMBER") && newRow.getType().equals("NULL")) {
                    row.setType("NUMBER");
                } else if (row.getType().equals("NULL") && newRow.getType().equals("STRING") || row.getType().equals("STRING") && newRow.getType().equals("NULL")) {
                    row.setType("STRING");
                } else if (row.getType().equals("NULL") && newRow.getType().equals("BOOLEAN") || row.getType().equals("BOOLEAN") && newRow.getType().equals("NULL")) {
                    row.setType("BOOLEAN");
                } else {
                    row.setType("STRING");
                }
            }
            row.addValues(newRow.getValue());
            this._parentRow = row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDataGuide(Connection conn, String dataGuideTable) throws SQLException {
        String query = null;
        Statement stmt = null;
        try {
            try {
                query = "DROP TABLE \"{0}\" PURGE";
                query = MessageFormat.format(query, dataGuideTable);
                stmt = conn.prepareStatement(query);
                stmt.execute(query);
            }
            catch (Exception e) {
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
            }
            try {
                query = "CREATE TABLE \"{0}\" (NAME VARCHAR2(4000), PATH VARCHAR2(4000), TYPE VARCHAR2(30), TLENGTH NUMBER)";
                query = MessageFormat.format(query, dataGuideTable);
                stmt = conn.prepareStatement(query);
                stmt.execute(query);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
            }
            query = "INSERT INTO \"{0}\" (NAME, PATH, TYPE, TLENGTH) VALUES (''{1}'', ''{2}'', ''{3}'', {4})\n";
            ArrayList<String> line = new ArrayList<String>(5);
            line.add(dataGuideTable);
            line.add("");
            line.add("");
            line.add("");
            line.add("");
            String buf = null;
            for (RowItem row : this._rowList) {
                line.set(1, row.getName());
                line.set(2, row.getPath());
                line.set(3, row.getType());
                line.set(4, row.getSize() + "");
                buf = MessageFormat.format(query, line.toArray());
                stmt = conn.prepareStatement(buf);
                stmt.execute(buf);
                stmt.close();
            }
            conn.commit();
        }
        finally {
            conn.rollback();
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RowItem {
        private int level;
        private String type;
        private String path;
        private String name;
        private String value;
        private int size = 0;
        private List<String> values = new ArrayList<String>();

        public RowItem(int level, String type, String path, String name, String value) {
            this.level = level;
            this.type = type;
            this.path = path;
            this.name = name;
            this.value = value;
            this.addValues(value);
        }

        public void addValues(String value) {
            int newSize = value.length();
            this.size = this.size > newSize ? this.size : newSize;
        }

        public int getLevel() {
            return this.level;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getSize() {
            return this.size;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

