/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;

public class PathClassLocator
extends BaseClassLocator {
    private final BaseClassLocator _sourceLocator;
    private final BaseClassLocator _classLocator;

    public static PathClassLocator getInstance(URLPath sourcePath, URLPath classPath) {
        try {
            return PathClassLocator.getInstanceImpl(sourcePath, classPath, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PathClassLocator getInstanceInterruptibly(URLPath sourcePath, URLPath classPath) throws InterruptedException {
        return PathClassLocator.getInstanceImpl(sourcePath, classPath, true);
    }

    private static PathClassLocator getInstanceImpl(URLPath sourcePath, URLPath classPath, boolean checkInterrupt) throws InterruptedException {
        BaseClassLocator sourceLocator;
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        if (checkInterrupt) {
            PathClassLocator.checkInterrupt();
        }
        BaseClassLocator baseClassLocator = sourceLocator = checkInterrupt ? PathClassLocator.ensureValid(factory.getSourceLocatorInterruptibly(sourcePath)) : PathClassLocator.ensureValid(factory.getSourceLocator(sourcePath));
        if (checkInterrupt) {
            PathClassLocator.checkInterrupt();
        }
        BaseClassLocator classLocator = checkInterrupt ? PathClassLocator.ensureValid(factory.getClassLocatorInterruptibly(classPath)) : PathClassLocator.ensureValid(factory.getClassLocator(classPath));
        return new PathClassLocator(sourceLocator, classLocator);
    }

    protected PathClassLocator(BaseClassLocator sourceLocator, BaseClassLocator classLocator) {
        this._sourceLocator = sourceLocator;
        this._classLocator = classLocator;
    }

    @Override
    public void buildIndex() {
        this._sourceLocator.buildIndex();
        this._classLocator.buildIndex();
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        PathClassLocator.checkInterrupt();
        this._sourceLocator.buildIndexInterruptibly();
        PathClassLocator.checkInterrupt();
        this._classLocator.buildIndexInterruptibly();
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        this._sourceLocator.getPackages(packagePrefix, out);
        this._classLocator.getPackages(packagePrefix, out);
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        PathClassLocator.checkInterrupt();
        this._sourceLocator.getPackagesInterruptibly(packagePrefix, out);
        PathClassLocator.checkInterrupt();
        this._classLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._sourceLocator.getClassesInPackage(packagePrefix, out);
        this._classLocator.getClassesInPackage(packagePrefix, out);
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        PathClassLocator.checkInterrupt();
        this._sourceLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        PathClassLocator.checkInterrupt();
        this._classLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this._sourceLocator.getAllClasses(out, filter);
        this._classLocator.getAllClasses(out, filter);
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        PathClassLocator.checkInterrupt();
        this._sourceLocator.getAllClassesInterruptibly(out, filter);
        PathClassLocator.checkInterrupt();
        this._classLocator.getAllClassesInterruptibly(out, filter);
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._sourceLocator.getAllPackages(out, filter);
        this._classLocator.getAllPackages(out, filter);
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        PathClassLocator.checkInterrupt();
        this._sourceLocator.getAllPackagesInterruptibly(out, filter);
        PathClassLocator.checkInterrupt();
        this._classLocator.getAllPackagesInterruptibly(out, filter);
    }

    @Override
    public URL getURL(String fqClassName) {
        URL classURL = this._classLocator.getClassURL(fqClassName);
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        return this.chooseURL(classURL, sourceURL);
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        PathClassLocator.checkInterrupt();
        URL classURL = this._classLocator.getClassURLInterruptibly(fqClassName);
        PathClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        return this.chooseURL(classURL, sourceURL);
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        return sourceURL;
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        return sourceURL;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        URL classURL = this._classLocator.getClassURL(fqClassName);
        return classURL;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        URL classURL = this._classLocator.getClassURLInterruptibly(fqClassName);
        return classURL;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        return this._classLocator.getResourceURL(resourceName);
    }

    private URL chooseURL(URL classURL, URL sourceURL) {
        if (classURL != null || sourceURL != null) {
            long sourceTime;
            if (classURL == null) {
                return sourceURL;
            }
            if (sourceURL == null) {
                return classURL;
            }
            long classTime = this.getClassTimestamp(classURL);
            if (classTime >= (sourceTime = this.getSourceTimestamp(sourceURL))) {
                return classURL;
            }
            return sourceURL;
        }
        return null;
    }

    protected long getClassTimestamp(URL classURL) {
        return URLFileSystem.lastModified((URL)classURL);
    }

    protected long getSourceTimestamp(URL sourceURL) {
        return URLFileSystem.lastModified((URL)sourceURL);
    }

    @Override
    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(2);
        list.add(this._classLocator);
        if (options.contains((Object)ClasspathTreeVisitOptions.INCLUDE_SOURCE)) {
            list.add(this._sourceLocator);
        }
        return list;
    }
}

