/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.metadata.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialDimension;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialMetadataModel;
import oracle.dbtools.spatial.dialogs.metadata.view.SpatialMetadataView;

public class SpatialMetadataController {
    private SpatialMetadataModel model;
    private SpatialMetadataView view;
    private SpatialColumnBoxListener columnBoxlistener = new SpatialColumnBoxListener();
    private DimensionAddListener dimAddlistener = new DimensionAddListener();
    private DimensionRemoveListener dimRemovelistener = new DimensionRemoveListener();
    private SpatialReflistener sridlistener = new SpatialReflistener();
    private JEWTDialog dlg;
    private String columnName = null;

    public SpatialMetadataController(SpatialMetadataModel spatialMetadataModel, SpatialMetadataView spatialMetadataView) {
        this.model = spatialMetadataModel;
        this.view = spatialMetadataView;
    }

    public void addListeners() {
        this.view.addSpatialColumnBoxListener(this.columnBoxlistener);
        this.view.addDimensionAddListener(this.dimAddlistener);
        this.view.addDimensionRemoveListener(this.dimRemovelistener);
        this.view.addSridListener(this.sridlistener);
    }

    public void removeListeners() {
        this.view.removeSpatialColumnBoxListener(this.columnBoxlistener);
        this.view.removeDimensionAddListener(this.dimAddlistener);
        this.view.removeDimensionRemoveListener(this.dimRemovelistener);
        this.view.removeSridListener(this.sridlistener);
    }

    public void populateSpatialModel(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
        this.dlg.setEnabled(false);
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(SpatialArb.getString("SpatialPopulateModel"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            public Void doWork() {
                SpatialMetadataController.this.model.setInitialModelData();
                return null;
            }

            public boolean cancel() {
                return false;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + raptorTaskEvent.getTaskDescriptor().getMessage());
                SpatialMetadataController.this.dlg.setEnabled(true);
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                SpatialMetadataController.this.dlg.setEnabled(true);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SpatialMetadataController.this.view.decorateMainPanel();
                            if (SpatialMetadataController.this.model.getIsColumnSelected()) {
                                SpatialMetadataController.this.view.enableSpatialColumn(false);
                            } else {
                                SpatialMetadataController.this.view.enableSpatialColumn(true);
                            }
                            SpatialMetadataController.this.addListeners();
                            SpatialMetadataController.this.dlg.setEnabled(true);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void populateSpatialModelForColumn(String string) {
        this.columnName = string;
        this.dlg.setOKButtonEnabled(false);
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(SpatialArb.getString("SpatialPopulateModelForColumn"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            public Void doWork() {
                SpatialMetadataController.this.model.setModelDataForColumn(SpatialMetadataController.this.columnName);
                return null;
            }

            public boolean cancel() {
                return false;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SpatialMetadataController.this.view.updatePanel();
                            if (SpatialMetadataController.this.model.getDimensionSize() == 0) {
                                SpatialMetadataController.this.view.setDimensionRemoveEnabled(false);
                            } else {
                                SpatialMetadataController.this.view.setDimensionRemoveEnabled(true);
                            }
                            if (SpatialMetadataController.this.model.getDimensionSize() == 4) {
                                SpatialMetadataController.this.view.setDimensionAddEnabled(false);
                            } else {
                                SpatialMetadataController.this.view.setDimensionAddEnabled(true);
                            }
                            SpatialMetadataController.this.dlg.setOKButtonEnabled(true);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void applyModelData() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(SpatialArb.getString("SpatialApplyModelData"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            public Void doWork() {
                SpatialMetadataController.this.model.applyModelData();
                return null;
            }

            public boolean cancel() {
                return false;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + raptorTaskEvent.getTaskDescriptor().getMessage());
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    class DimensionRemoveListener
    implements ActionListener {
        DimensionRemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SpatialMetadataController.this.view.getDimensionRow();
            if (n != -1) {
                int n2 = SpatialMetadataController.this.model.getDimensionSize();
                if (n2 > 0 && n < n2) {
                    SpatialMetadataController.this.model.removeDimension(n);
                    SpatialMetadataController.this.view.setDimensionAddEnabled(true);
                    if (SpatialMetadataController.this.model.getDimensionSize() == 0) {
                        SpatialMetadataController.this.view.setDimensionRemoveEnabled(false);
                    }
                }
                SpatialMetadataController.this.view.updateDimensionPanel();
            }
        }
    }

    class SpatialReflistener
    implements DocumentListener {
        SpatialReflistener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            String string = SpatialMetadataController.this.view.getSrid();
            SpatialMetadataController.this.model.setSpatialRefID(string);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            String string = SpatialMetadataController.this.view.getSrid();
            SpatialMetadataController.this.model.setSpatialRefID(string);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            String string = SpatialMetadataController.this.view.getSrid();
            SpatialMetadataController.this.model.setSpatialRefID(string);
        }
    }

    class DimensionAddListener
    implements ActionListener {
        DimensionAddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpatialDimension spatialDimension = new SpatialDimension();
            SpatialMetadataController.this.model.addDimension(spatialDimension);
            SpatialMetadataController.this.view.setDimensionRemoveEnabled(true);
            if (SpatialMetadataController.this.model.getDimensionSize() == 4) {
                SpatialMetadataController.this.view.setDimensionAddEnabled(false);
            }
            SpatialMetadataController.this.view.updateDimensionPanel();
        }
    }

    class SpatialColumnBoxListener
    implements ActionListener {
        SpatialColumnBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = SpatialMetadataController.this.view.getSpatialColumnValue();
            SpatialMetadataController.this.populateSpatialModelForColumn(string);
        }
    }
}

