/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.Struct;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.views.SpatialDockableView;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.javatools.dialogs.MessageDialog;

public class SpatialShowGeometriesInMap
extends GridContextMenuItem {
    private static SpatialShowGeometriesInMap _instance;
    public static final String SPATIAL_SHOW_GEOMETRY_TITLE_IN_MAP = "SpatialShowGeometryInMap";
    public static final int SPATIAL_SHOW_GEOMETRY_ID_IN_MAP;
    protected static IdeAction SPATIAL_SHOW_GEOMETRY_IN_MAP;
    private JEWTDialog dlg = null;
    private boolean anyColIsGeom = false;
    private String geoColname = "";
    SpatialListReorderableTableWithTitleBar targetTitledTable;
    String targetConnection;
    String raptorQueryTitle;
    String raptorSQL;
    QueryObject queryObj;
    UUID identifier;
    SpatialListReorderableTableWithTitleBar targetTable;
    Connection cnx;

    private SpatialShowGeometriesInMap() {
        this.initAction();
    }

    private void initAction() {
        if (SPATIAL_SHOW_GEOMETRY_IN_MAP == null) {
            SPATIAL_SHOW_GEOMETRY_IN_MAP = this.createAction(SPATIAL_SHOW_GEOMETRY_ID_IN_MAP, StringUtils.stripMnemonic((String)SpatialArb.getString("ShowGeometries")), null);
        }
    }

    public static SpatialShowGeometriesInMap getInstance() {
        if (_instance == null) {
            _instance = new SpatialShowGeometriesInMap();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        this.anyColIsGeom = false;
        if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
            IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
            int n = iResultSetTableModel.getGridColumns().size();
            int n2 = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            n2 = this._table.convertRowIndexToModel(n2);
            for (int i = 0; i <= n - 1 && !this.anyColIsGeom; ++i) {
                this.geoColname = iResultSetTableModel.getColumnName(i);
                int n3 = iResultSetTableModel.getColumnSqlType(i);
                if (n3 != 2002) continue;
                Object object = iResultSetTableModel.getValueAt(n2, i);
                try {
                    Struct struct;
                    if (!(object instanceof Struct) || (struct = (Struct)object) == null || !struct.getSQLTypeName().equals("MDSYS.SDO_GEOMETRY")) continue;
                    this.anyColIsGeom = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.anyColIsGeom;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = SpatialUtil.getPanel().getSelectedTabPage();
        String string = null;
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SPATIAL_SHOW_GEOMETRY_IN_MAP);
        jMenuItem.setText(SpatialArb.getString("ShowGeometriesInMap"));
        contextMenu.add((Component)jMenuItem);
        if (spatialListReorderableTableWithTitleBar != null) {
            string = spatialListReorderableTableWithTitleBar.getCombobox().getCurrentConnectionName();
        }
        IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
        if (string != null && spatialListReorderableTableWithTitleBar != null) {
            if (iResultSetTableModel.getConnectionName().equals(string)) {
                this.identifier = spatialListReorderableTableWithTitleBar.getModel().getIdentifier();
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else {
            jMenuItem.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showGeometryShapeInMapRaptorized() {
        try {
            this.targetTable = SpatialUtil.getPanel().getSelectedTabPage();
            IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
            this.raptorSQL = iResultSetTableModel.getModifiedSql();
            this.targetConnection = iResultSetTableModel.getConnectionName();
            SpatialDockableView spatialDockableView = (SpatialDockableView)DockStation.getDockStation().findDockable(new ViewId("SPATIAL_VIEW_TYPE.SPATIAL_VIEW_ID"));
            this.cnx = Connections.getInstance().getConnection(this.targetConnection);
            Vector<Integer[]> vector = MapViewerHelper.getQuerySRIDS(this.raptorSQL, this.cnx);
            boolean bl = MapViewerHelper.isValidSpatialQuery(this.raptorSQL, this.cnx);
            int n = this.targetTable.getModel().getTableSRID();
            boolean bl2 = MapViewerHelper.areQuerySRIDsValid(n, vector);
            if (bl2 && bl) {
                if (spatialDockableView != null) {
                    spatialDockableView.show();
                    this.raptorQueryTitle = "Default";
                    if (this.geoColname != null) {
                        this.raptorQueryTitle = this.geoColname;
                    }
                    if (this.raptorSQL != null && this.raptorSQL.length() > 0) {
                        SpatialViewController.getInstance().lockUI();
                        this.insertResultsetTask();
                    }
                }
            } else if (!bl2) {
                throw new Exception(SpatialArb.getString("NonMatchingSRIDException"));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
        }
        catch (Exception exception) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)"", null);
        }
        finally {
            System.gc();
        }
    }

    private QueryObject buildQueryObject() {
        QueryObject queryObject = null;
        String[] stringArray = new String[]{};
        queryObject = new QueryObject(this.raptorQueryTitle, this.raptorSQL, "", Color.black, Color.black, Color.red, 8, 0, Color.black, 3, Color.gray, Color.yellow, stringArray, this.cnx);
        queryObject.setConnectionSourceName(this.targetConnection);
        queryObject.setTabIdentifier(this.identifier.toString());
        queryObject.setNewlyCreated();
        queryObject.setPreselected(true);
        return queryObject;
    }

    private void insertResultSetInMap(QueryObject queryObject) {
        if (queryObject != null && this.targetTable != null) {
            this.targetTable.getModel().hideBottomLayers();
            this.targetTable.setConnectionAndInsertQuery(queryObject, queryObject.getConnectionSourceName());
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, SpatialArb.getString("LogCannotDisplayResultSet"));
        }
    }

    private void insertResultsetTask() {
        RaptorTask<Object> raptorTask = new RaptorTask<Object>("Inserting new query object", true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Object doWork() {
                SpatialShowGeometriesInMap.this.queryObj = SpatialShowGeometriesInMap.this.buildQueryObject();
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialShowGeometriesInMap.this.insertResultSetInMap(SpatialShowGeometriesInMap.this.queryObj);
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == SPATIAL_SHOW_GEOMETRY_ID_IN_MAP) {
            this.showGeometryShapeInMapRaptorized();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    static {
        SPATIAL_SHOW_GEOMETRY_ID_IN_MAP = Ide.findOrCreateCmdID((String)SPATIAL_SHOW_GEOMETRY_TITLE_IN_MAP);
        SPATIAL_SHOW_GEOMETRY_IN_MAP = null;
    }
}

