/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProtocolMatcher {
    private static final Pattern sPattern = Pattern.compile("(.+?)://(.+?)");
    private static final Pattern fPattern = Pattern.compile("(.+?):///(.+?)");
    private Matcher _matcher;
    private boolean _containsProtocol;
    private String _protocol;

    public void setSource(String source) {
        if (source != null && source.length() > 0 && source.indexOf("\\") == -1) {
            this.match(source);
            this._containsProtocol = this._matcher.matches();
            this._protocol = this._containsProtocol ? this._matcher.group(1) : null;
        } else {
            this._containsProtocol = false;
            this._protocol = null;
        }
    }

    public boolean containsProtocol() {
        return this._containsProtocol;
    }

    public String getProtocol() {
        return this._protocol;
    }

    private void match(String source) {
        this._matcher = source.regionMatches(true, 0, "file", 0, 4) ? fPattern.matcher(source) : sPattern.matcher(source);
    }
}

