/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.compare;

import java.io.IOException;
import java.net.URL;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareModel;
import oracle.javatools.compare.algorithm.CompareModelExtension;
import oracle.jdeveloper.compare.ResourceCompareContributor;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.compare.SVNPropertiesCompareContributor;
import oracle.jdevimpl.vcs.svn.compare.SVNPropertyCompareMethod;
import oracle.jdevimpl.vcs.svn.compare.SVNResourceInfo;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tmatesoft.svn.core.SVNException;

public class SVNCompareModelExtension
extends CompareModelExtension {
    public static final String RESOURCE_INFO = "SVNCompareModelExtension.RESOURCE_INFO";

    public void extend(BaseCompareModel model) {
        if (model.getContributor(ContributorKind.ANCESTOR) != null) {
            return;
        }
        SVNResourceInfo ri1 = SVNCompareModelExtension.getResourceInfoForContributor(model.getContributor(ContributorKind.FIRST));
        SVNResourceInfo ri2 = SVNCompareModelExtension.getResourceInfoForContributor(model.getContributor(ContributorKind.SECOND));
        if (ri1 == null || ri2 == null) {
            return;
        }
        SVNPropertiesCompareContributor pcc1 = ri1.getURL() != null ? new SVNPropertiesCompareContributor(ri1.getURL(), ri1.getRevision()) : new SVNPropertiesCompareContributor(ri1.getFile(), ri1.getRevision());
        SVNPropertiesCompareContributor pcc2 = ri2.getURL() != null ? new SVNPropertiesCompareContributor(ri2.getURL(), ri2.getRevision()) : new SVNPropertiesCompareContributor(ri2.getFile(), ri2.getRevision());
        try {
            model.setExtensionData(SVNCompareModelExtension.class, (Object)CompareUtil.createCompareModel(null, (CompareContributor)pcc1, (CompareContributor)pcc2, (CompareType)SVNPropertyCompareMethod.SVN_PROPERTIES));
        }
        catch (CompareFailedException cfe) {
            FeedbackManager.getFeedbackManager();
            FeedbackManager.reportException((Throwable)cfe);
        }
    }

    static final SVNResourceInfo getResourceInfoForContributor(CompareContributor cc) {
        SVNResourceInfo resourceInfo = (SVNResourceInfo)cc.getProperty(RESOURCE_INFO);
        if (resourceInfo != null) {
            return resourceInfo;
        }
        if (!(cc instanceof ResourceCompareContributor)) {
            return null;
        }
        URL url = ((ResourceCompareContributor)cc).getURL();
        if (url == null) {
            return null;
        }
        if (!URLFileSystem.isLocal((URL)url)) {
            return null;
        }
        try {
            SVNURLInfo info = SVNURLInfoCache.getInstance().getURLInfo(url);
            if (info == null || info.getURL() == null || info.getRevision() < 0L) {
                return null;
            }
            return new SVNResourceInfo(info.getSVNURL(), (SVNRevision)new SVNRevision.Number(info.getRevision()));
        }
        catch (SVNException e) {
            FeedbackManager.getFeedbackManager();
            FeedbackManager.reportException((Throwable)e);
            return null;
        }
        catch (IOException e) {
            FeedbackManager.getFeedbackManager();
            FeedbackManager.reportException((Throwable)e);
            return null;
        }
    }
}

