/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.test;

import java.io.IOException;
import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.test.IdeFixture;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;

public class JDevFixture
extends IdeFixture {
    private static JDevFixture fixture;

    protected JDevFixture() {
        super("oracle.jdeveloper");
        this.addShroudedExtension("java-data", "java");
        fixture = this;
    }

    public static JDevFixture getJDevFixture() {
        if (fixture == null) {
            fixture = new JDevFixture();
        }
        return fixture;
    }

    public Node getNode(String path, Project project, int entry) {
        return this.getNode(this.translateSourcePathToWorkPath(path, project, entry));
    }

    public URL getSourcePathEntry(Project project, int entry) {
        return PathsConfiguration.getInstance((Project)project).getProjectSourcePath().getEntries()[entry];
    }

    public String translateSourcePathToWorkPath(String path, Project project, int entry) {
        URL url = URLFactory.newURL((URL)PathsConfiguration.getInstance((Project)project).getProjectSourcePath().getEntries()[entry], (String)path);
        String translation = URLFileSystem.toRelativeSpec((URL)url, (URL)this.getWorkDirectory(), (boolean)true);
        if (translation == null) {
            return path;
        }
        return translation;
    }

    protected Project createProject(URL url) {
        try {
            return NewEmptyProjectCommand.createProjectInWorkspace(url, null);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public Project createJDevProject() {
        return this.createJDevProject(null, 0, new String[0]);
    }

    public Project createJDevProject(String path, String ... techScopes) {
        return this.createJDevProject(path, 0, techScopes);
    }

    public Project createJDevProject(String path, int sourcePathCount, String ... techScopes) {
        if (path == null) {
            path = "project.jpr";
        }
        Project project = this.createJDevProjectNoSave(path, sourcePathCount, techScopes);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    public Project createJDevProject(String path, URL contentsURL) {
        if (contentsURL == null) {
            throw new IllegalArgumentException("contentsURL null");
        }
        Project project = this.createJDevProjectNoSave(path, 0, new String[0]);
        URL root = URLFileSystem.getParent((URL)project.getURL());
        URLPath sourcePath = new URLPath();
        this.copyFiles(contentsURL, root, new String[]{"", ".."}, sourcePath);
        PathsConfiguration.getInstance((Project)project).setProjectSourcePath(sourcePath);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    public Project updateJDevProject(Project project, URL contentsURL) {
        if (contentsURL == null) {
            throw new IllegalArgumentException("contentsURL null");
        }
        URL root = URLFileSystem.getParent((URL)project.getURL());
        URLPath sourcePath = new URLPath();
        this.copyFiles(contentsURL, root, new String[]{"", ".."}, sourcePath);
        PathsConfiguration.getInstance((Project)project).setProjectSourcePath(sourcePath);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return project;
    }

    public Project createJDevProjectRelative(String path, String contentsPath) {
        return this.createJDevProject(path, this.getDataUrl(contentsPath));
    }

    public Project updateJDevProjectRelative(Project project, String contentsPath) {
        return this.updateJDevProject(project, this.getDataUrl(contentsPath));
    }

    protected Project createJDevProjectNoSave(String path, int sourcePathCount, String ... techScopes) {
        if (path == null) {
            path = "project.jpr";
        }
        Project project = this.createProjectNoSave(path);
        JDevFixture.addTechScopes(project, techScopes);
        URL file = URLFactory.newURL((URL)this.getWorkDirectory(), (String)path);
        URL directory = URLFileSystem.getParent((URL)file);
        String name = URLFileSystem.getName((URL)file);
        if (sourcePathCount > 0) {
            URL[] sources = new URL[sourcePathCount];
            for (int i = 0; i < sourcePathCount; ++i) {
                sources[i] = URLFactory.newDirURL((URL)directory, (String)(name + "-src" + i));
                if (this.isVerbose()) {
                    this.output("Creating directory " + URLFileSystem.getPlatformPathName((URL)sources[i]));
                }
                URLFileSystem.mkdir((URL)sources[i]);
            }
            PathsConfiguration.getInstance((Project)project).setProjectSourcePath(new URLPath(sources));
        }
        URL classes = URLFactory.newDirURL((URL)directory, (String)(name + "-classes"));
        if (this.isVerbose()) {
            this.output("Creating directory " + URLFileSystem.getPlatformPathName((URL)classes));
        }
        URLFileSystem.mkdir((URL)classes);
        JavaProject.getInstance(project).setOutputDirectory(classes);
        return project;
    }

    private static void addTechScopes(Project project, String ... techScopes) {
        if (techScopes != null && techScopes.length > 0) {
            TechnologyScopeConfiguration techScopeConf = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
            techScopeConf.updateTechnologyScope(techScopes);
        }
    }

    public URL createSourcePathEntry(int entry, Project project) {
        PathsConfiguration configuration = PathsConfiguration.getInstance((Project)project);
        URLPath path = configuration.getProjectSourcePath();
        URL[] entries = path.getEntries();
        if (entries.length > entry) {
            return entries[entry];
        }
        URL projectURL = project.getURL();
        URL directory = URLFileSystem.getParent((URL)projectURL);
        String name = URLFileSystem.getName((URL)projectURL);
        if (this.isVerbose()) {
            this.output("Creating directory " + URLFileSystem.getPlatformPathName((URL)directory));
        }
        URLFileSystem.mkdirs((URL)directory);
        URL entryURL = null;
        for (int i = entries.length; i <= entry; ++i) {
            entryURL = URLFactory.newDirURL((URL)directory, (String)(name + "-src" + i));
            if (this.isVerbose()) {
                this.output("Creating directory " + URLFileSystem.getPlatformPathName((URL)entryURL));
            }
            URLFileSystem.mkdir((URL)entryURL);
            path.add(entryURL);
        }
        PathsConfiguration.getInstance((Project)project).setProjectSourcePath(path);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        return entryURL;
    }

    public URL createSourceDirectory(String path, Project project, int entry) {
        URL url = this.createDirectory(this.translateSourcePathToWorkPath(path, project, entry));
        return url;
    }

    public Node createSourceFile(String path, Project project) {
        return this.createSourceFile(path, project, 0);
    }

    public Node createSourceFile(String path, Project project, String contents) {
        return this.createSourceFile(path, project, 0, contents);
    }

    public Node createSourceFile(String path, Project project, int entry) {
        if (project == null) {
            project = this.createJDevProject();
        }
        this.createSourcePathEntry(entry, project);
        Node node = this.createFile(this.translateSourcePathToWorkPath(path, project, entry));
        this.addNode(path, node);
        return node;
    }

    public Node createSourceFile(String path, Project project, int entry, String contents) {
        if (contents == null) {
            throw new IllegalArgumentException("contents null");
        }
        if (project == null) {
            project = this.createJDevProject();
        }
        this.createSourcePathEntry(entry, project);
        Node node = this.createFile(this.translateSourcePathToWorkPath(path, project, entry), contents);
        this.addNode(path, node);
        return node;
    }

    public Node createSourceFile(String path, Project project, URL contentsURL) {
        return this.createSourceFile(path, project, 0, contentsURL);
    }

    public Node createSourceFile(String path, Project project, int entry, URL contentsURL) {
        if (contentsURL == null) {
            throw new IllegalArgumentException("contentsURL null");
        }
        if (project == null) {
            project = this.createJDevProject();
        }
        this.createSourcePathEntry(entry, project);
        String translatedPath = this.translateSourcePathToWorkPath(path, project, entry);
        Node node = this.createFile(translatedPath, contentsURL);
        this.addNode(path, node);
        return node;
    }

    public Node createSourceFileRelative(String path, Project project, String contentsPath) {
        return this.createSourceFileRelative(path, project, 0, contentsPath);
    }

    public Node createSourceFileRelative(String path, Project project, int entry, String contentsPath) {
        return this.createSourceFile(path, project, entry, this.getDataUrl(contentsPath));
    }

    public void assertEquals(URL expectedRootURL, Project actualProject) {
        if (expectedRootURL == null) {
            throw new IllegalArgumentException("expectedRootURL null");
        }
        URL actualRootURL = URLFileSystem.getParent((URL)actualProject.getURL());
        URL[] expectedChildren = this.getChildren(this.unlockArchiveUrl(expectedRootURL));
        for (int i = 0; i < expectedChildren.length; ++i) {
            URL expectedChild = expectedChildren[i];
            if (!URLFileSystem.isDirectory((URL)expectedChild)) continue;
            String name = URLFileSystem.getFileName((URL)expectedChild);
            URL actualChild = URLFactory.newDirURL((URL)actualRootURL, (String)name);
            Assert.check((boolean)URLFileSystem.isDirectory((URL)actualChild));
            this.assertEquals(expectedChild, actualChild);
        }
    }

    public void assertEqualsRelative(String expectedPath, Project actualProject) {
        this.assertEquals(this.getDataUrl(expectedPath), actualProject);
    }
}

