/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ColumnFilterPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JCheckBox jAttrImportanceCheckBox;
    private JCheckBox jAutoFilterCheckBox;
    private JCheckBox jAutoRemoveCheckBox;
    private JCheckBox jConstantPercentCheckBox;
    private JSpinner jConstantPercentSpinner;
    private JCheckBox jDataQualityCheckBox;
    private JCheckBox jImportanceCheckBox;
    private JSpinner jImportanceSpinner;
    private JCheckBox jNullPercentCheckBox;
    private JSpinner jNullPercentSpinner;
    private JLabel jSampleSizeLabel;
    private JSpinner jSampleSizeSpinner;
    private JCheckBox jSamplingCheckBox;
    private JComboBox jSamplingTypeComboBox;
    private JLabel jSamplingTypeLabel;
    private JLabel jStratifiedCutoffLabel;
    private JSpinner jStratifiedCutoffSpinner;
    private JCheckBox jTopNCheckBox;
    private JSpinner jTopNSpinner;
    private JCheckBox jUniquePercentCheckBox;
    private JSpinner jUniquePercentSpinner;

    public ColumnFilterPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.setHelpID("preferences_transforms_filter_col");
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_DATA_QUALITY"), this.jDataQualityCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_NULL_PERCENT"), this.jNullPercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_UNIQUE_PERCENT"), this.jUniquePercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_CONSTANT_PERCENT"), this.jConstantPercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_IMPORTANCE"), this.jAttrImportanceCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_AI_CUT_OFF"), this.jImportanceCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_AI_TOPN"), this.jTopNCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING"), this.jSamplingCheckBox);
        UIResourceHelper.setComponentText(hashMap);
        ResourceUtils.resLabel((JLabel)this.jSamplingTypeLabel, (Component)this.jSamplingTypeComboBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_TECHNIQUE"));
        ResourceUtils.resSpinner((JLabel)this.jStratifiedCutoffLabel, (JSpinner)this.jStratifiedCutoffSpinner, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_STRATIFIED_CUTOFF"));
        ResourceUtils.resSpinner((JLabel)this.jSampleSizeLabel, (JSpinner)this.jSampleSizeSpinner, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_SIZE"));
        this.jSamplingTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SamplingType.toHuman("System"), ServerConstants.SamplingType.toHuman("Random"), ServerConstants.SamplingType.toHuman("Stratified")}));
    }

    @Override
    public void initUI() {
        this.jAutoFilterCheckBox.setVisible(false);
        this.jAutoRemoveCheckBox.setVisible(false);
    }

    private void initComponents() {
        this.jStratifiedCutoffLabel = new JLabel();
        this.jSamplingTypeComboBox = new JComboBox();
        this.jSamplingTypeLabel = new JLabel();
        this.jAutoFilterCheckBox = new JCheckBox();
        this.jAutoRemoveCheckBox = new JCheckBox();
        this.jDataQualityCheckBox = new JCheckBox();
        this.jNullPercentCheckBox = new JCheckBox();
        this.jNullPercentSpinner = new JSpinner();
        this.jUniquePercentCheckBox = new JCheckBox();
        this.jUniquePercentSpinner = new JSpinner();
        this.jConstantPercentCheckBox = new JCheckBox();
        this.jConstantPercentSpinner = new JSpinner();
        this.jAttrImportanceCheckBox = new JCheckBox();
        this.jImportanceCheckBox = new JCheckBox();
        this.jImportanceSpinner = new JSpinner();
        this.jTopNCheckBox = new JCheckBox();
        this.jTopNSpinner = new JSpinner();
        this.jSamplingCheckBox = new JCheckBox();
        this.jSampleSizeLabel = new JLabel();
        this.jSampleSizeSpinner = new JSpinner();
        this.jStratifiedCutoffSpinner = new JSpinner();
        this.jStratifiedCutoffLabel.setText("Stratified Cutoff");
        this.jStratifiedCutoffLabel.setName("jStratifiedCutoffLabel");
        this.jSamplingTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSamplingTypeComboBox.setName("jSamplingTypeComboBox");
        this.jSamplingTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jSamplingTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSamplingTypeLabel.setText("Sampling Technique:");
        this.jSamplingTypeLabel.setName("jSamplingTypeLabel");
        this.jAutoFilterCheckBox.setText("Automatic Filterings");
        this.jAutoFilterCheckBox.setName("jAutoFilterCheckBox");
        this.jAutoFilterCheckBox.setOpaque(false);
        this.jAutoRemoveCheckBox.setText("Remove Missing Input Automatically");
        this.jAutoRemoveCheckBox.setName("jAutoRemoveCheckBox");
        this.jAutoRemoveCheckBox.setOpaque(false);
        this.jDataQualityCheckBox.setText("Data Quality");
        this.jDataQualityCheckBox.setName("jDataQualityCheckBox");
        this.jDataQualityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jDataQualityCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentCheckBox.setText("% Nulls less than or equal");
        this.jNullPercentCheckBox.setName("jNullPercentCheckBox");
        this.jNullPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jNullPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jNullPercentSpinner.setName("jNullPercentSpinner");
        this.jUniquePercentCheckBox.setText("% Unique less than or equal");
        this.jUniquePercentCheckBox.setName("jUniquePercentCheckBox");
        this.jUniquePercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jUniquePercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jUniquePercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jUniquePercentSpinner.setName("jUniquePercentSpinner");
        this.jConstantPercentCheckBox.setText("% Constant less than or equal");
        this.jConstantPercentCheckBox.setName("jConstantPercentCheckBox");
        this.jConstantPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jConstantPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jConstantPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jConstantPercentSpinner.setName("jConstantPercentSpinner");
        this.jAttrImportanceCheckBox.setText("Attribute Importance");
        this.jAttrImportanceCheckBox.setName("jAttrImportanceCheckBox");
        this.jAttrImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jAttrImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceCheckBox.setText("Importance Cutoff");
        this.jImportanceCheckBox.setName("jImportanceCheckBox");
        this.jImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceSpinner.setModel(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.1));
        this.jImportanceSpinner.setName("jImportanceSpinner");
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTopNSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        this.jTopNSpinner.setName("jTopNSpinner");
        this.jSamplingCheckBox.setText("Sampling");
        this.jSamplingCheckBox.setName("jSamplingCheckBox");
        this.jSampleSizeLabel.setText("Sample Size");
        this.jSampleSizeLabel.setName("jSampleSizeLabel");
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel((Number)2000, Integer.valueOf(1), null, (Number)1000));
        this.jSampleSizeSpinner.setName("jSampleSizeSpinner");
        this.jStratifiedCutoffSpinner.setModel(new SpinnerNumberModel((Number)10, null, null, (Number)1));
        this.jStratifiedCutoffSpinner.setName("jStratifiedCutoffSpinner");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAutoFilterCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jAutoRemoveCheckBox, -2, 242, -2).addComponent(this.jDataQualityCheckBox, -2, 170, -2).addComponent(this.jAttrImportanceCheckBox, -2, 169, -2)).addContainerGap(184, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jSampleSizeLabel, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSampleSizeSpinner, -2, 170, -2)).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jConstantPercentCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jUniquePercentCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jNullPercentCheckBox, -1, 184, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jNullPercentSpinner).addComponent(this.jUniquePercentSpinner).addComponent(this.jConstantPercentSpinner))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTopNCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jImportanceCheckBox, GroupLayout.Alignment.LEADING, -1, 184, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTopNSpinner, -2, 170, -2).addComponent(this.jImportanceSpinner, -2, 170, -2))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSamplingTypeLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jStratifiedCutoffLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSamplingTypeComboBox, GroupLayout.Alignment.TRAILING, -2, 170, -2).addComponent(this.jStratifiedCutoffSpinner, GroupLayout.Alignment.TRAILING, -2, 170, -2))))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSamplingCheckBox, -2, 292, -2))).addContainerGap(52, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAutoRemoveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDataQualityCheckBox).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNullPercentCheckBox).addComponent(this.jNullPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUniquePercentCheckBox).addComponent(this.jUniquePercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConstantPercentCheckBox).addComponent(this.jConstantPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jAttrImportanceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportanceCheckBox).addComponent(this.jImportanceSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTopNCheckBox).addComponent(this.jTopNSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSamplingTypeLabel).addComponent(this.jSamplingTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStratifiedCutoffLabel).addComponent(this.jStratifiedCutoffSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSamplingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleSizeLabel).addComponent(this.jSampleSizeSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jDataQualityCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jNullPercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.jUniquePercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.jConstantPercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.enableControls();
    }

    private void jAttrImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jImportanceCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.jTopNCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.enableControls();
    }

    private void jNullPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jUniquePercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jConstantPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jSamplingTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = this.jSamplingTypeComboBox.getSelectedItem().toString();
        boolean bl = false;
        if ("System".equals(ServerConstants.SamplingType.toSchema(string))) {
            bl = true;
        }
        this.jStratifiedCutoffLabel.setVisible(bl);
        this.jStratifiedCutoffSpinner.setVisible(bl);
    }

    private void enableControls() {
        boolean bl = this.jDataQualityCheckBox.isSelected();
        boolean bl2 = this.jAttrImportanceCheckBox.isSelected();
        this.jNullPercentCheckBox.setEnabled(bl);
        this.jUniquePercentCheckBox.setEnabled(bl);
        this.jConstantPercentCheckBox.setEnabled(bl);
        this.jNullPercentSpinner.setEnabled(bl && this.jNullPercentCheckBox.isSelected());
        this.jUniquePercentSpinner.setEnabled(bl && this.jUniquePercentCheckBox.isSelected());
        this.jConstantPercentSpinner.setEnabled(bl && this.jConstantPercentCheckBox.isSelected());
        this.jImportanceCheckBox.setEnabled(bl2);
        this.jTopNCheckBox.setEnabled(bl2);
        this.jImportanceSpinner.setEnabled(bl2 && this.jImportanceCheckBox.isSelected());
        this.jTopNSpinner.setEnabled(bl2 && this.jTopNCheckBox.isSelected());
        this.jSamplingTypeComboBox.setEnabled(bl2);
        this.jStratifiedCutoffSpinner.setEnabled(bl2);
        this.jSampleSizeSpinner.setEnabled(this.jSamplingCheckBox.isSelected());
    }

    public void onEntry(TraversableContext traversableContext) {
        ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jAutoFilterCheckBox.setSelected(columnFilterPreferenceSettings.getAutomaticFilter());
        this.jAutoRemoveCheckBox.setSelected(columnFilterPreferenceSettings.getAutomaticRemoveAttrs());
        this.jNullPercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseNullsPercent());
        this.jNullPercentSpinner.setValue(columnFilterPreferenceSettings.getNullsPercentValue());
        this.jUniquePercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseUniquePercent());
        this.jUniquePercentSpinner.setValue(columnFilterPreferenceSettings.getUniquePercentValue());
        this.jConstantPercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseConstantPercent());
        this.jConstantPercentSpinner.setValue(columnFilterPreferenceSettings.getConstantPercentValue());
        this.jImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUseCuttoff());
        this.jImportanceSpinner.setValue(columnFilterPreferenceSettings.getCutOffValue());
        this.jTopNCheckBox.setSelected(columnFilterPreferenceSettings.getUseTopN());
        this.jTopNSpinner.setValue(columnFilterPreferenceSettings.getTopNValue());
        this.jSamplingTypeComboBox.setSelectedItem(ServerConstants.SamplingType.toHuman(columnFilterPreferenceSettings.getSamplingType()));
        this.jStratifiedCutoffSpinner.setValue(columnFilterPreferenceSettings.getStratifiedCutoff());
        this.jSamplingCheckBox.setSelected(columnFilterPreferenceSettings.getUseSampling());
        this.jSampleSizeSpinner.setValue(columnFilterPreferenceSettings.getSamplingNumberOfRows());
        this.jDataQualityCheckBox.setSelected(columnFilterPreferenceSettings.getUseDataQuality());
        this.jAttrImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUseAttrImportance());
        this.enableControls();
        this.jSamplingTypeComboBoxActionPerformed(null);
    }

    public void onExit(TraversableContext traversableContext) {
        ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        columnFilterPreferenceSettings.setAutomaticFilter(this.jAutoFilterCheckBox.isSelected());
        columnFilterPreferenceSettings.setAutomaticRemoveAttrs(this.jAutoRemoveCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseNullsPercent(this.jNullPercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setNullsPercentValue((Double)this.jNullPercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseUniquePercent(this.jUniquePercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setUniquePercentValue((Double)this.jUniquePercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseConstantPercent(this.jConstantPercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setConstantPercentValue((Double)this.jConstantPercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseCuttoff(this.jImportanceCheckBox.isSelected());
        columnFilterPreferenceSettings.setCutOffValue((Double)this.jImportanceSpinner.getValue());
        columnFilterPreferenceSettings.setUseTopN(this.jTopNCheckBox.isSelected());
        columnFilterPreferenceSettings.setTopNValue((Integer)this.jTopNSpinner.getValue());
        columnFilterPreferenceSettings.setSamplingType(ServerConstants.SamplingType.toSchema(this.jSamplingTypeComboBox.getSelectedItem().toString()));
        columnFilterPreferenceSettings.setStratifiedCutoff((Integer)this.jStratifiedCutoffSpinner.getValue());
        columnFilterPreferenceSettings.setUseSampling(this.jSamplingCheckBox.isSelected());
        columnFilterPreferenceSettings.setSamplingNumberOfRows((Integer)this.jSampleSizeSpinner.getValue());
        columnFilterPreferenceSettings.setUseDataQuality(this.jDataQualityCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseAttrImportance(this.jAttrImportanceCheckBox.isSelected());
    }

    private static ColumnFilterPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ColumnFilterPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public static class ColumnFilterPreferenceSettings
    extends DataMinerPreferenceSettings {
        private static final String DATA_KEY = "oracle.dmt.dataminer.workflow.ColumnFilterPreferenceSettings";
        private static final boolean _AUTO_FILTER = false;
        private static final boolean _AUTO_REMOVE_ATTRS = true;
        private static final boolean _USE_DATA_QUALITY = true;
        private static final boolean _USE_ATTR_IMPORTANCE = false;
        private static final boolean _USE_NULLS_PERCENT = true;
        private static final boolean _USE_UNIQUE_PERCENT = true;
        private static final boolean _USE_CONSTANT_PERCENT = true;
        private static final boolean _USE_CUT_OFF = false;
        private static final boolean _USE_TOP_N = false;
        private static final boolean _USE_SAMPLING = true;
        private static final double _NULLS_PERCENT = 95.0;
        private static final double _UNIQUE_PERCENT = 95.0;
        private static final double _CONSTANT_PERCENT = 95.0;
        private static final double _CUT_OFF = 0.0;
        private static final int _TOP_N = 100;
        private static final int _STRATIFIED_CUTOFF = 10;
        private static final String _SAMPLING_TYPE = "System";
        private static final int _NUMBER_OF_ROWS = 2000;

        public static ColumnFilterPreferenceSettings getInstance() {
            return ColumnFilterPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private ColumnFilterPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static ColumnFilterPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new ColumnFilterPreferenceSettings(ColumnFilterPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setAutomaticFilter(boolean bl) {
            this._hash.putBoolean("AutomaticFilter", bl);
        }

        public boolean getAutomaticFilter() {
            return this._hash.getBoolean("AutomaticFilter", false);
        }

        public void setAutomaticRemoveAttrs(boolean bl) {
            this._hash.putBoolean("AutomaticRemoveAttrs", bl);
        }

        public boolean getAutomaticRemoveAttrs() {
            return this._hash.getBoolean("AutomaticRemoveAttrs", true);
        }

        public boolean getUseDataQuality() {
            return this._hash.getBoolean("UseDataQuality", true);
        }

        public void setUseDataQuality(boolean bl) {
            this._hash.putBoolean("UseDataQuality", bl);
        }

        public boolean getUseAttrImportance() {
            return this._hash.getBoolean("UseAttrImportance", false);
        }

        public void setUseAttrImportance(boolean bl) {
            this._hash.putBoolean("UseAttrImportance", bl);
        }

        public boolean getUseNullsPercent() {
            return this._hash.getBoolean("UseNullsPercent", true);
        }

        public void setUseNullsPercent(boolean bl) {
            this._hash.putBoolean("UseNullsPercent", bl);
        }

        public boolean getUseUniquePercent() {
            return this._hash.getBoolean("UseUniquePercent", true);
        }

        public void setUseUniquePercent(boolean bl) {
            this._hash.putBoolean("UseUniquePercent", bl);
        }

        public boolean getUseConstantPercent() {
            return this._hash.getBoolean("UseConstantPercent", true);
        }

        public void setUseConstantPercent(boolean bl) {
            this._hash.putBoolean("UseConstantPercent", bl);
        }

        public boolean getUseCuttoff() {
            return this._hash.getBoolean("UseCuttoff", false);
        }

        public void setUseCuttoff(boolean bl) {
            this._hash.putBoolean("UseCuttoff", bl);
        }

        public boolean getUseTopN() {
            return this._hash.getBoolean("UseTopN", false);
        }

        public void setUseTopN(boolean bl) {
            this._hash.putBoolean("UseTopN", bl);
        }

        public String getSamplingType() {
            return this._hash.getString("SamplingType", _SAMPLING_TYPE);
        }

        public void setSamplingType(String string) {
            this._hash.putString("SamplingType", string);
        }

        public int getStratifiedCutoff() {
            return this._hash.getInt("StratifiedCutoff", 10);
        }

        public void setStratifiedCutoff(int n) {
            this._hash.putInt("StratifiedCutoff", n);
        }

        public boolean getUseSampling() {
            return this._hash.getBoolean("UseSampling", true);
        }

        public void setUseSampling(boolean bl) {
            this._hash.putBoolean("UseSampling", bl);
        }

        public int getSamplingNumberOfRows() {
            return this._hash.getInt("SamplingNumberOfRows", 2000);
        }

        public void setSamplingNumberOfRows(int n) {
            this._hash.putInt("SamplingNumberOfRows", n);
        }

        public void removeSamplingNumberOfRows() {
            this._hash.remove("SamplingNumberOfRows");
        }

        public double getNullsPercentValue() {
            return this._hash.getDouble("NullsPercent", 95.0);
        }

        public void setNullsPercentValue(double d) {
            this._hash.putDouble("NullsPercent", d);
        }

        public void removeNullsPercentValue() {
            this._hash.remove("NullsPercent");
        }

        public double getUniquePercentValue() {
            return this._hash.getDouble("UniquePercent", 95.0);
        }

        public void setUniquePercentValue(double d) {
            this._hash.putDouble("UniquePercent", d);
        }

        public void removeUniquePercentValue() {
            this._hash.remove("UniquePercent");
        }

        public double getConstantPercentValue() {
            return this._hash.getDouble("ConstantPercent", 95.0);
        }

        public void setConstantPercentValue(double d) {
            this._hash.putDouble("ConstantPercent", d);
        }

        public void removeConstantPercentValue() {
            this._hash.remove("ConstantPercent");
        }

        public double getCutOffValue() {
            return this._hash.getDouble("CutOff", 0.0);
        }

        public void setCutOffValue(double d) {
            this._hash.putDouble("CutOff", d);
        }

        public void removeCutOffValue() {
            this._hash.remove("CutOff");
        }

        public int getTopNValue() {
            return this._hash.getInt("TopN", 100);
        }

        public void setTopNValue(int n) {
            this._hash.putInt("TopN", n);
        }

        public void removeTopNValue() {
            this._hash.remove("TopN");
        }
    }
}

