/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.codegen.SQLDefinition;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;

public final class UpdateTableNode
extends AbstractTransformNode
implements DataConsumer {
    private static final Logger theLogger = Logger.getLogger(UpdateTableNode.class.getName());
    private static final String _space = " ";
    public static final String AUTO_SPEC = "autoSpec";
    public static final String DROP_EXISTING = "dropExisting";
    public static final String TARGET_TABLE = "targetTable";
    public static final String TARGET_COLUMNS = "targetColumns";
    public static final String REFACTOR_INPUT_COLUMNS = "refactorInputColumns";
    public static final String UPDATE_WITH = "updateWith";
    public static final String UPDATE_TABLE_INPUT = NodeMessagesLrb.get("UPDATE_TABLE_INPUT");
    public static final String UPDATE_TABLE_PROPERTIES = NodeMessagesLrb.get("UPDATE_TABLE_PROPERTIES");

    public UpdateTableNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getSQLExpression() {
        return ((UpdateTableNodeType)this.getData()).getSQLExpression();
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_UPDATE_TABLE_NODE_NAME");
    }

    public static boolean isAutoSpec(UpdateTableNodeType updateTableNodeType) {
        AutoSpecType autoSpecType = updateTableNodeType.getAutoSpec();
        if (autoSpecType == null) {
            return false;
        }
        return 0 == autoSpecType.value().compareTo("Yes");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        UpdateTableAttributes updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        for (MapTargetSourceType mapTargetSourceType : updateTableAttributes.getUpdateTableItemType()) {
            AttributeType attributeType = new AttributeType();
            UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
            String string = updateTableColumnType.getAlias() == null ? updateTableColumnType.getName() : updateTableColumnType.getAlias();
            attributeType.setName(string);
            attributeType.setDataType(updateTableColumnType.getDataType());
            attributeType.setStatus(updateTableColumnType.getStatus());
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        TableType tableType = new TableType();
        tableType.setName(null);
        tableType.setSchema(null);
        updateTableNodeType.setUpdateTargetTable(tableType);
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        updateTableAttributes.getUpdateTableItemType();
        updateTableNodeType.setUpdateTableAttributes(updateTableAttributes);
        updateTableNodeType.setDropExisting(false);
        updateTableNodeType.setAutoSpec(AutoSpecType.YES);
        updateTableNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        updateTableNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public boolean validate(boolean bl) {
        return this.customValidate(bl, true);
    }

    public void validateAttributes(List<MapTargetSourceType> list, AbstractNode abstractNode, boolean bl) {
        Attributes attributes;
        if (list.isEmpty()) {
            return;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        Attributes attributes2 = attributes = dataProvider != null ? dataProvider.getAttributes() : null;
        if (bl) {
            UpdateTableNode.matchAttributes(list, attributes);
        } else {
            String string;
            String string2;
            List list2 = attributes != null ? attributes.getAttribute() : null;
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            if (list2 != null) {
                for (AttributeType attributeType : list2) {
                    string2 = attributeType.getAlias();
                    string = string2 != null && string2.trim().length() > 0 ? string2 : attributeType.getName();
                    hashMap.put(string, attributeType);
                }
            }
            for (MapTargetSourceType mapTargetSourceType : list) {
                string2 = mapTargetSourceType.getValue();
                if (null == string2.getName() || string2.getName().trim().isEmpty() || null != (string = (AttributeType)hashMap.get(string2.getName()))) continue;
                string2.setStatus(AttributeStatus.MISSING);
            }
        }
    }

    @Override
    public Object getProperty(String string) {
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        Object object = null;
        if (string.equals(TARGET_COLUMNS)) {
            UpdateTableAttributes updateTableAttributes;
            object = updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        } else if (string.equals(DROP_EXISTING)) {
            object = updateTableNodeType.isDropExisting();
        } else if (string.equals("dataSourceTable")) {
            TableType tableType = updateTableNodeType.getUpdateTargetTable();
            object = new TableVO(tableType.getSchema(), tableType.getName());
        } else if (string.equals(UPDATE_TABLE_PROPERTIES)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(AUTO_SPEC, updateTableNodeType.getAutoSpec());
            hashMap.put(DROP_EXISTING, updateTableNodeType.isDropExisting());
            HashMap<TableType, String> hashMap2 = new HashMap<TableType, String>();
            hashMap2.put(updateTableNodeType.getUpdateTargetTable(), updateTableNodeType.getName());
            hashMap.put(TARGET_TABLE, hashMap2);
            hashMap.put(TARGET_COLUMNS, updateTableNodeType.getUpdateTableAttributes());
            object = hashMap;
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else if (string.equals(REFACTOR_INPUT_COLUMNS)) {
            UpdateTableAttributes updateTableAttributes;
            object = updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        if (complexProperty.getPropertyName().equals("dataSourceTable")) {
            List list = updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType();
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            for (MapTargetSourceType mapTargetSourceType : list) {
                UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
                hashMap.put(updateTableColumnType.getName(), (AttributeType)updateTableColumnType);
            }
            TableVO tableVO = new TableVO(updateTableNodeType.getUpdateTargetTable().getSchema(), updateTableNodeType.getUpdateTargetTable().getName(), hashMap);
            return tableVO;
        }
        if (complexProperty.getPropertyName().equals(TARGET_COLUMNS) || complexProperty.getPropertyName().equals(DROP_EXISTING) || complexProperty.getPropertyName().equals(UPDATE_WITH) || complexProperty.getPropertyName().equals(REFACTOR_INPUT_COLUMNS) || complexProperty.getPropertyName().equals(AUTO_SPEC)) {
            return updateTableNodeType.getAutoSpec();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        if (string.equals(TARGET_COLUMNS)) {
            UpdateTableAttributes updateTableAttributes = (UpdateTableAttributes)object;
            updateTableNodeType.setUpdateTableAttributes(updateTableAttributes);
        } else if (string.equals(REFACTOR_INPUT_COLUMNS)) {
            UpdateTableAttributes updateTableAttributes = (UpdateTableAttributes)object;
            updateTableNodeType.setUpdateTableAttributes(updateTableAttributes);
        } else if (string.equals(DROP_EXISTING)) {
            boolean bl = (Boolean)object;
            updateTableNodeType.setDropExisting(bl);
        } else if (string.equals(AUTO_SPEC)) {
            updateTableNodeType.setAutoSpec((AutoSpecType)object);
        } else if (string.equals(UPDATE_WITH)) {
            MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)object;
            List list = updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType();
            for (MapTargetSourceType mapTargetSourceType2 : list) {
                if (!mapTargetSourceType2.getKey().getName().equals(mapTargetSourceType.getKey().getName())) continue;
                mapTargetSourceType2.setValue(mapTargetSourceType.getValue());
                mapTargetSourceType2.setKey(mapTargetSourceType.getKey());
                break;
            }
        } else if (string.equals("dataSourceTable")) {
            TableVO tableVO = (TableVO)object;
            TableType tableType = updateTableNodeType.getUpdateTargetTable();
            tableType.setName(tableVO.getName());
            tableType.setSchema(tableVO.getSchema());
            tableType.setSynonym(tableVO.isSynonym());
            List<AttributeType> list = tableVO.getColumnList();
            assert (list != null);
            ArrayList<MapTargetSourceType> arrayList = new ArrayList<MapTargetSourceType>(list.size());
            for (AttributeType attributeType : list) {
                MapTargetSourceType mapTargetSourceType = new MapTargetSourceType();
                mapTargetSourceType.setKey((UpdateTableColumnType)attributeType);
                mapTargetSourceType.setValue(UpdateTableNode.getEmptyAttributeType());
                arrayList.add(mapTargetSourceType);
            }
            updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType().clear();
            updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType().addAll(arrayList);
            this.setNavigatorRefreshPending();
        } else if (string.equals(UPDATE_TABLE_PROPERTIES)) {
            Map<String, Object> map = ConverterHelper.objectToMapStringObject(object);
            Object object2 = map.get(AUTO_SPEC);
            if (object2 != null) {
                AutoSpecType autoSpecType = (AutoSpecType)object2;
                updateTableNodeType.setAutoSpec(autoSpecType);
            }
            if ((object2 = map.get(DROP_EXISTING)) != null) {
                boolean bl = (Boolean)object2;
                updateTableNodeType.setDropExisting(bl);
            }
            if ((object2 = map.get(TARGET_TABLE)) != null) {
                TableType tableType = null;
                if (object2 instanceof Map) {
                    Map map2 = (Map)object2;
                    tableType = (TableType)map2.keySet().iterator().next();
                    updateTableNodeType.setUpdateTargetTable(tableType);
                    updateTableNodeType.setName((String)map2.get(tableType));
                } else if (object2 instanceof TableType) {
                    tableType = (TableType)object2;
                    updateTableNodeType.setUpdateTargetTable(tableType);
                    updateTableNodeType.setName(tableType.getName());
                }
                this.setNavigatorRefreshPending();
            }
            if ((object2 = map.get(TARGET_COLUMNS)) != null) {
                UpdateTableAttributes updateTableAttributes = (UpdateTableAttributes)object2;
                updateTableNodeType.setUpdateTableAttributes(updateTableAttributes);
            }
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public void setSQLExpression(String string) {
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        updateTableNodeType.setSQLExpression(string);
    }

    @Override
    public String generateSQLExpression() {
        List list;
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        UpdateTableAttributes updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        assert (updateTableAttributes != null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT \n" + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */ " : ""));
        if (updateTableAttributes != null && (list = updateTableAttributes.getUpdateTableItemType()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = null;
                string = !StringUtils.isDoubleQuotedString(((MapTargetSourceType)list.get(i)).getKey().getName()) ? "\"" + ((MapTargetSourceType)list.get(i)).getKey().getName() + "\"" : ((MapTargetSourceType)list.get(i)).getKey().getName();
                String string2 = ((MapTargetSourceType)list.get(i)).getKey().getAlias();
                if (string2 != null && !string2.isEmpty()) {
                    if (!StringUtils.isDoubleQuotedString(string2)) {
                        stringBuilder.append(string2);
                    } else {
                        stringBuilder.append(string);
                    }
                } else {
                    stringBuilder.append(string);
                }
                if (i < list.size() - 1) {
                    stringBuilder.append(",\n");
                    continue;
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append("\"" + updateTableNodeType.getUpdateTargetTable().getSchema() + "\"");
        stringBuilder.append(".");
        stringBuilder.append("\"" + updateTableNodeType.getUpdateTargetTable().getName() + "\"");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        String string2 = updateTableNodeType.getUpdateTargetTable().getName();
        String string3 = updateTableNodeType.getUpdateTargetTable().getSchema();
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_INSERT, true);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string3, string2, DatabaseObjectType.TARGET_TABLE);
        List list = updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType();
        String string6 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string3, string2, DatabaseObjectType.TARGET_TABLE);
        AbstractNode abstractNode = this.findParentNode();
        String string7 = ((AbstractDataNode)abstractNode).getInputSQL(true, false);
        if (abstractNode instanceof DataSourceNode) {
            object3 = (DataSourceNode)abstractNode;
            object2 = (DataSourceNodeType)((AbstractNode)object3).getData();
            object = object2.getSourceTable();
            String string8 = StringUtils.addDoubleQuotes(object.getName());
            String string9 = StringUtils.addDoubleQuotes(object.getSchema());
            String string10 = string9 + "." + string8;
            string7 = string7.replaceAll(string10, "&DATA_SOURCE_1");
            string7 = string7.replaceAll(string8 + ".", "");
            String string11 = this.getSQLNodeComment((AbstractDataNode)object3, true);
            string7 = string7.replaceAll("\\Q" + string11 + "\\E", "");
            String string12 = this.getSQLNodeComment((AbstractDataNode)object3, false);
            string7 = string7.replaceAll("\\Q" + string12 + "\\E", "");
        }
        object3 = null;
        object2 = SQLHelper.buildUpdateTableSQL(list, string6, string7, abstractNode.getData().getId(), updateTableNodeType.getId(), updateTableNodeType.isDropExisting(), string4, string5);
        object = ((StringBuilder)object2.get("INSERT_STATEMENT")).toString();
        object3 = CodeTemplate.updateBodyTemplate(string, "<UPDATE_TABLE_SQL_EXPRESSION>", StringUtils.escapeSingleQuotesForSQL((String)object));
        object = ((StringBuilder)object2.get("PURGE_TABLE")).toString();
        object3 = CodeTemplate.updateBodyTemplate((String)object3, "<PURGE_PREVIOUS_SQL_EXPRESSION>", (String)object);
        object3 = CodeTemplate.updateBodyTemplate((String)object3, "<UPDATE_TABLE_NAME>", string6);
        return object3;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        UpdateTableAttributes updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        if (updateTableAttributes == null) {
            updateTableAttributes = new UpdateTableAttributes();
            updateTableNodeType.setUpdateTableAttributes(updateTableAttributes);
        }
        if (node instanceof DataProvider) {
            List list = updateTableAttributes.getUpdateTableItemType();
            this.validateAttributes(list, this.findParentNode(), UpdateTableNode.isAutoSpec(updateTableNodeType));
        }
        this.excecuteInputColumnsTxn(updateTableAttributes, new UpdateTableAttributes());
        this.validate(false);
    }

    public static AttributeType getEmptyAttributeType() {
        AttributeType attributeType = new AttributeType();
        attributeType.setName(_space);
        attributeType.setDataType(_space);
        attributeType.setAlias(_space);
        attributeType.setStatus(AttributeStatus.VALID);
        return attributeType;
    }

    public static boolean isEmptyAttributeType(AttributeType attributeType) {
        return attributeType.getName().equals(_space) && attributeType.getDataType().equals(_space) && attributeType.getAlias().equals(_space);
    }

    public static boolean containsNonEmptyAttributeType(UpdateTableAttributes updateTableAttributes) {
        boolean bl = false;
        List list = updateTableAttributes.getUpdateTableItemType();
        for (MapTargetSourceType mapTargetSourceType : list) {
            if (UpdateTableNode.isEmptyAttributeType(mapTargetSourceType.getValue())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void copyAttributes(List<MapTargetSourceType> list, List<MapTargetSourceType> list2) {
        for (MapTargetSourceType mapTargetSourceType : list2) {
            MapTargetSourceType mapTargetSourceType2 = new MapTargetSourceType();
            UpdateTableColumnType updateTableColumnType = new UpdateTableColumnType();
            updateTableColumnType.setRequiredColumn(mapTargetSourceType.getKey().isRequiredColumn());
            AttributeTypeHelper.copyAttribute((AttributeType)updateTableColumnType, (AttributeType)mapTargetSourceType.getKey());
            mapTargetSourceType2.setKey(updateTableColumnType);
            AttributeType attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, mapTargetSourceType.getValue() != null ? mapTargetSourceType.getValue() : UpdateTableNode.getEmptyAttributeType());
            mapTargetSourceType2.setValue(attributeType);
            list.add(mapTargetSourceType2);
        }
    }

    public static void matchAttributes(List<MapTargetSourceType> list, Attributes attributes) {
        List list2 = attributes != null ? attributes.getAttribute() : null;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (list2 != null) {
            for (AttributeType attributeType : list2) {
                hashMap.put(attributeType.getName(), attributeType);
            }
        }
        for (MapTargetSourceType mapTargetSourceType : list) {
            UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
            AttributeType attributeType = (AttributeType)hashMap.get(updateTableColumnType.getName());
            if (attributeType != null && AttributeTypeHelper.areCompatibleTypes(attributeType.getDataType(), updateTableColumnType.getDataType()) && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                AttributeType attributeType2 = new AttributeType();
                AttributeTypeHelper.copyAttribute(attributeType2, attributeType);
                attributeType2.setStatus(AttributeStatus.VALID);
                mapTargetSourceType.setValue(attributeType2);
                continue;
            }
            mapTargetSourceType.setValue(UpdateTableNode.getEmptyAttributeType());
        }
    }

    private void excecuteInputColumnsTxn(UpdateTableAttributes updateTableAttributes, UpdateTableAttributes updateTableAttributes2) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(TARGET_COLUMNS, updateTableAttributes);
        complexProperty.setOldData(updateTableAttributes2);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    protected void getInternalStackedSQL(AbstractDataNode abstractDataNode, StringBuffer stringBuffer) {
    }

    @Override
    public SQLDefinition getLineageSQLDefinition(AbstractNode abstractNode, SQLDefinition sQLDefinition) throws Exception {
        if (!this.canGenerateLineageSQL()) {
            throw new Exception(NodeMessagesLrb.get("CODE_GEN_ERROR_NODE_STATE_INVALID"));
        }
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        StringBuffer stringBuffer = sQLDefinition.getSql();
        String string = sQLDefinition.getSourceDefinitionsForNode(this).get(0).getParmNameWithAmpersand();
        if (stringBuffer.indexOf("{INPUT_SOURCE}") > 0) {
            int n = stringBuffer.indexOf("{INPUT_SOURCE}");
            int n2 = n + "{INPUT_SOURCE}".length();
            stringBuffer.replace(n, n2, "(" + string + ")");
        } else {
            String string2 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", updateTableNodeType.getId());
            if (stringBuffer.indexOf(string2) > 0) {
                int n = stringBuffer.indexOf(string2);
                int n3 = n + string2.length();
                stringBuffer.replace(n, n3, "(" + string + ")");
            }
        }
        return sQLDefinition;
    }

    public static Map<String, String> getRequiredColumns(Context context, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        List<String> list = DatabaseMetadataUtils.getRequiredColumns(connectionFolder, string, string2);
        for (String string3 : list) {
            hashMap.put(string3, string3);
        }
        return hashMap;
    }

    @Override
    public String getHelpTopic() {
        return "updatetable_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_UPDATE_TABLE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_UPDATE_TABLE_ICON"));
    }

    @Override
    public ArrayList<SourceDefinition> getLineageSources() throws Exception {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        SourceDefinition sourceDefinition = new SourceDefinition(this, updateTableNodeType.getUpdateTargetTable().getSchema(), updateTableNodeType.getUpdateTargetTable().getName(), DatabaseObjectType.TABLE_OR_VIEW);
        arrayList.add(sourceDefinition);
        return arrayList;
    }

    public boolean validate2(boolean bl) {
        return this.customValidate(bl, false);
    }

    private boolean customValidate(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        if (null != updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType()) {
            UpdateTableNode.copyAttributes(list, updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType());
        }
        UpdateTableAttributes updateTableAttributes2 = updateTableNodeType.getUpdateTableAttributes();
        List list2 = updateTableAttributes2.getUpdateTableItemType();
        if (bl2) {
            this.validateAttributes(list2, this.findParentNode(), UpdateTableNode.isAutoSpec(updateTableNodeType));
            this.excecuteInputColumnsTxn(updateTableNodeType.getUpdateTableAttributes(), updateTableAttributes);
        }
        if (null == updateTableNodeType.getUpdateTableAttributes() || null == updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType() || updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType().isEmpty()) {
            bl3 = false;
            this.addMessage("UPDATE_TABLE_INCOMPLETE_TARGET_ATTRIBUTES", MessageEnumType.INCOMPLETE, new String[0]);
        } else if (!UpdateTableNode.containsNonEmptyAttributeType(updateTableNodeType.getUpdateTableAttributes())) {
            bl3 = false;
            this.addMessage("UPDATE_TABLE_INCOMPLETE_TARGET_ATTRIBUTES", MessageEnumType.INCOMPLETE, new String[0]);
        } else if (null != updateTableNodeType.getUpdateTableAttributes() && null != updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType()) {
            Object object4;
            Object object2;
            HashMap<String, UpdateTableColumnType> hashMap = new HashMap<String, UpdateTableColumnType>();
            List list3 = updateTableNodeType.getUpdateTableAttributes().getUpdateTableItemType();
            if (!list3.isEmpty()) {
                for (Object object3 : list3) {
                    object2 = object3.getKey();
                    object4 = object3.getValue();
                    hashMap.put(object2.getName(), (UpdateTableColumnType)object2);
                    if (!object2.getStatus().equals((Object)AttributeStatus.VALID)) {
                        bl3 = false;
                        this.addMessage("DATASRC_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
                        break;
                    }
                    if (object4.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    bl3 = false;
                    this.addMessage("DATASRC_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
                    break;
                }
            }
            if (bl3) {
                Object object3;
                TableType tableType = updateTableNodeType.getUpdateTargetTable();
                object3 = UpdateTableNode.getRequiredColumns(this.getContext(), StringUtils.escapeSingleQuotesForSQL(tableType.getSchema()), StringUtils.escapeSingleQuotesForSQL(tableType.getName()));
                if (!object3.isEmpty()) {
                    object2 = object3.values();
                    object4 = object2.iterator();
                    while (object4.hasNext()) {
                        String string = (String)object4.next();
                        boolean bl4 = false;
                        for (MapTargetSourceType mapTargetSourceType : list3) {
                            if (string.equals(mapTargetSourceType.getKey().getName())) {
                                bl4 = true;
                            }
                            if (!bl4) continue;
                            break;
                        }
                        if (bl4 || null == hashMap.get(string)) continue;
                        bl3 = false;
                        this.addMessage("UPDATE_TABLE_PROPERTIES_REQIRED_ATTRIBUTE_MISSING", MessageEnumType.INCOMPLETE, string);
                        break;
                    }
                }
                if (bl3) {
                    for (Object object4 : list3) {
                        if (!object4.getKey().isRequiredColumn() || object4.getValue().getName() != null && !object4.getValue().getName().trim().isEmpty()) continue;
                        bl3 = false;
                        this.addMessage("UPDATE_TABLE_INCOMPLETE_TARGET_ATTRIBUTE_UNDEFINED", MessageEnumType.INCOMPLETE, new String[0]);
                        break;
                    }
                }
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this.getData();
        UpdateTableAttributes updateTableAttributes2 = updateTableNodeType.getUpdateTableAttributes();
        List list2 = updateTableAttributes2.getUpdateTableItemType();
        for (MapTargetSourceType mapTargetSourceType : list2) {
            MapTargetSourceType mapTargetSourceType2 = (MapTargetSourceType)MetaDataHelper.copyMetadataObject(mapTargetSourceType);
            AttributeType attributeType = mapTargetSourceType2.getValue();
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (!(attributeType2 == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType()))) {
                String string = attributeType.getName();
                attributeType.setName(attributeType2.getName());
                if (UpdateTableNode.isAutoSpec(updateTableNodeType)) {
                    attributeType.setDataType(attributeType2.getDataType());
                }
                hashMap.put(string, attributeType);
            }
            list.add(mapTargetSourceType2);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), REFACTOR_INPUT_COLUMNS, updateTableAttributes);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }
}

