/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.dialog.tests.TestPreferencesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public final class TestNode
extends AbstractNode
implements ModelConsumer,
DataConsumer {
    private static final Logger theLogger = Logger.getLogger(AbstractBuildNode.class.getName());
    public static final String TARGET_ATTRIBUTE = "TargetAttribute";
    public static final String CASE_ATTRIBUTES = "CaseAttributes";
    public static final String TEST_MODELS = "TestModels";
    public static final String AUTO_SETTING = "AutoSetting";
    public static final String TEST_RESULTS = "testResults";
    public static final String GEN_ACCURACY_METRICS = "genAccuracyMetrics";
    public static final String GEN_CONFUSION_MATRIX = "genConfusionMatrix";
    public static final String GEN_ROC_CURVE = "genROC";
    public static final String GEN_LIFT_AND_PROFIT = "genLiftProfit";
    public static final String GEN_RESIDUALS = "genResiduals";
    public static final String TEST_SETTINGS_CHANGED = "testSettingsChanged";
    private HashMap<String, String> _nodesLookupMap = new HashMap();
    private HashMap<String, MiningResultType> _resultLookupMap = new HashMap();
    private static final String MODEL_STATUS = "modelStatus";

    public TestNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        TestPreferencesPanel.TestPreferenceSettings testPreferenceSettings = TestPreferencesPanel.TestPreferenceSettings.getInstance();
        boolean bl = testPreferenceSettings.getAutomaticSetting();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        TestModelType testModelType = new TestModelType();
        testModelType.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
        testModelType.setArchive("No");
        testNodeType.setTestModels(testModelType);
        ClassificationTestSettingsType classificationTestSettingsType = new ClassificationTestSettingsType();
        ClassificationTestSettingsType.TopNTargets topNTargets = new ClassificationTestSettingsType.TopNTargets();
        topNTargets.setValue(BigInteger.valueOf(100L));
        classificationTestSettingsType.setTopNTargets(topNTargets);
        testNodeType.setTestSettings(classificationTestSettingsType);
        CaseAttributes caseAttributes = new CaseAttributes();
        testNodeType.setCaseAttributes(caseAttributes);
        TestNodeType.Results results = new TestNodeType.Results();
        testNodeType.setResults(results);
        testNodeType.setStatus(NodeStatusType.INVALID);
    }

    private void initModelNodeLookup() {
        this._nodesLookupMap.clear();
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode abstractNode : list) {
            this._nodesLookupMap.put(abstractNode.getMetadataId(), abstractNode.getData().getName());
        }
    }

    private void initResultLookup() {
        this._resultLookupMap.clear();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        for (ClassificationResultType classificationResultType : testNodeType.getResults().getClassificationResult()) {
            this._resultLookupMap.put(classificationResultType.getModelId(), (MiningResultType)classificationResultType);
        }
        for (ClassificationResultType classificationResultType : testNodeType.getResults().getRegressionResult()) {
            this._resultLookupMap.put(classificationResultType.getModelId(), (MiningResultType)classificationResultType);
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TEST_NODE_NAME");
    }

    public boolean areNodesCompatible(Node node) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        boolean bl = false;
        ModelProvider modelProvider = (ModelProvider)((Object)node);
        bl = testNodeType.getTestModels().getModel().size() == 0 ? true : testNodeType.getTestModels().getMiningFunction().equals((Object)modelProvider.getMiningFunctionTypeSupported()) && testNodeType.getTargetAttribute().getName().equals(modelProvider.getTargetAttribute().getName()) && testNodeType.getTargetAttribute().getDataType().equals(modelProvider.getTargetAttribute().getDataType());
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (node instanceof BuildTextNodeRef) {
            return false;
        }
        if (node instanceof DataProvider) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof DataProvider)) continue;
                bl = false;
                break;
            }
        } else {
            ModelProvider modelProvider;
            bl = node instanceof ModelProvider ? ((modelProvider = (ModelProvider)((Object)node)).getMiningFunctionTypeSupported().equals((Object)MiningFunctionType.CLASSIFICATION) || modelProvider.getMiningFunctionTypeSupported().equals((Object)MiningFunctionType.REGRESSION) ? this.areNodesCompatible(node) : false) : false;
        }
        return bl;
    }

    @Override
    public void refactorModelReferences(Node node, Map<String, RefModelType> map, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        TestModelType testModelType = testNodeType.getTestModels();
        TestModelType testModelType2 = (TestModelType)MetaDataHelper.copyMetadataObject(testModelType);
        List list = testModelType2.getModel();
        for (TestModelType.Model model : list) {
            if (!map.containsKey(model.getName())) continue;
            RefModelType refModelType = map.get(model.getName());
            model.setName(refModelType.getName());
            model.setModelId(refModelType.getModelId());
            model.setTestStatus(ModelStatusType.READY);
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_MODELS, testModelType2);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        Object object;
        AttributeType attributeType;
        AttributeType attributeType2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        AttributeType attributeType3 = null;
        if (!(testNodeType.getCaseAttributes().getAttribute().isEmpty() || (attributeType2 = map.get((attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0)).getName())) == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType()))) {
            object = attributeType.getName();
            attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            attributeType3.setName(attributeType2.getName());
            attributeType3.setDataType(attributeType2.getDataType());
            hashMap.put((String)object, attributeType3);
        }
        attributeType = null;
        attributeType2 = testNodeType.getTargetAttribute();
        if (!(attributeType2 == null || (object = map.get(attributeType2.getName())) == null || attributeType2.getName().equals(object.getName()) && attributeType2.getDataType().equals(object.getDataType()))) {
            String string = attributeType2.getName();
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType2);
            attributeType.setName(object.getName());
            attributeType.setDataType(object.getDataType());
            hashMap.put(string, attributeType);
        }
        if (!hashMap.isEmpty()) {
            object = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (attributeType3 != null) {
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), CASE_ATTRIBUTES, attributeType3);
            }
            if (attributeType != null) {
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), TARGET_ATTRIBUTE, attributeType);
            }
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        ++this.refactorInvokeCount;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            TestNodeType testNodeType = (TestNodeType)this.getData();
            TestNodeType.Results results = new TestNodeType.Results();
            results.setGenAccuracyMetrics(testNodeType.getResults().isGenAccuracyMetrics());
            results.setGenConfusionMatrix(testNodeType.getResults().isGenConfusionMatrix());
            results.setGenLift(testNodeType.getResults().isGenLift());
            results.setGenROC(testNodeType.getResults().isGenROC());
            results.setGenResiduals(testNodeType.getResults().isGenResiduals());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, results);
            this.setNodeReady();
            this.validate(false);
            List<AbstractNode> list2 = this.findChildNodes();
            for (AbstractNode abstractNode : list2) {
                abstractNode.refactor(this, bl);
            }
        }
    }

    @Override
    public void parentNodeNameChanged(Node node, String string) {
        this._nodesLookupMap.clear();
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        Iterator iterator;
        List<PartitionExpressionType> list;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Object object62;
        boolean bl2 = super.validate(bl);
        this._nodesLookupMap.clear();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        boolean bl3 = testNodeType.getTestModels().getAutoSpec().equals((Object)AutoSpecType.YES);
        boolean bl4 = false;
        boolean bl5 = false;
        TestModelType testModelType = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        TestNodeType.Results results = null;
        boolean bl6 = false;
        AttributeType attributeType = null;
        List<AbstractNode> list2 = this.findTestModelNodes();
        for (AbstractNode model : list2) {
            ModelProvider modelProvider = (ModelProvider)((Object)model);
            object62 = modelProvider.getOutputModels();
            object5 = object62.iterator();
            while (object5.hasNext()) {
                object42 = object5.next();
                object3 = testModelType.getModel().iterator();
                while (object3.hasNext()) {
                    object2 = (TestModelType.Model)object3.next();
                    list = object2.getModelId();
                    if (list == null || !object42.getModelId().equals(list) || object2.getName().compareTo(object42.getName()) == 0) continue;
                    object2.setName(object42.getName());
                    bl5 = true;
                }
            }
        }
        if (bl3) {
            testModelType.getModel().clear();
            testModelType.setMiningFunction(null);
            iterator = testModelType.getMiningFunction();
            for (AbstractNode abstractNode : list2) {
                object62 = (ModelProvider)((Object)abstractNode);
                if (attributeType == null) {
                    attributeType = object62.getTargetAttribute();
                    bl6 = true;
                }
                object5 = object62.getOutputModels();
                object42 = object5.iterator();
                while (object42.hasNext()) {
                    object3 = (RefModelType)object42.next();
                    if (!object3.isUseForOutput()) continue;
                    if (iterator == null) {
                        testModelType.setMiningFunction(object3.getMiningFunction());
                        iterator = testModelType.getMiningFunction();
                    }
                    if (!iterator.equals(object3.getMiningFunction()) || !attributeType.getName().equals(object62.getTargetAttribute().getName()) || !attributeType.getDataType().equals(object62.getTargetAttribute().getDataType())) continue;
                    object2 = new TestModelType.Model();
                    list = object62.getPartitionAttributes((RefModelType)object3);
                    if (list != null && list.size() > 0) {
                        object = new PartitionExpressions();
                        object.getPartitionExpression().addAll(list);
                        object2.setPartitionExpressions((PartitionExpressions)object);
                    }
                    object2.setMiningAlgorithm(object3.getMiningAlgorithm());
                    object2.setMiningFunction(object3.getMiningFunction());
                    object2.setModelId(object3.getModelId());
                    object2.setName(object3.getName());
                    object2.setNodeId(object3.getNodeId());
                    object2.setSchema(object3.getSchema());
                    object2.setStatus(object3.getStatus());
                    object2.setTestStatus(ModelStatusType.READY);
                    object2.setUseForOutput(object3.isUseForOutput());
                    object2.setIsModelBuilt(object3.isIsModelBuilt());
                    testModelType.getModel().add(object2);
                }
            }
            bl = true;
            bl5 = true;
            bl6 = true;
        } else {
            iterator = this.findTestModelNodes();
            HashMap hashMap = new HashMap();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            object62 = iterator.iterator();
            while (object62.hasNext()) {
                object5 = (AbstractNode)object62.next();
                object42 = (ModelProvider)object5;
                object3 = object42.getTargetAttribute();
                hashMap.put(((AbstractNode)object5).getMetadataId(), object5);
                object2 = object42.getOutputModels();
                list = object2.iterator();
                while (list.hasNext()) {
                    object = (RefModelType)list.next();
                    if (!object.isUseForOutput()) continue;
                    String string = ((AbstractNode)object5).getMetadataId() + "." + object.getSchema() + "." + object.getName() + "." + object.getMiningAlgorithm() + "." + object3.getName() + "." + object3.getDataType();
                    hashMap2.put(string, object);
                }
            }
            object62 = new ArrayList();
            attributeType = testNodeType.getTargetAttribute();
            for (Object object42 : testModelType.getModel()) {
                if (object42.getStatus() != RefModelStatusType.VALID || (object2 = (RefModelType)hashMap2.get(object3 = object42.getNodeId() + "." + object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm() + "." + attributeType.getName() + "." + attributeType.getDataType())) != null) continue;
                if (hashMap.get(object42.getNodeId()) != null) {
                    object62.add(object42);
                    bl5 = true;
                    bl = true;
                    continue;
                }
                object42.setStatus(RefModelStatusType.INVALID);
                object42.setNodeId(null);
                object42.setModelId(null);
                if (!bl4) {
                    this.addMessage("TEST_INVAL_MODEL", MessageEnumType.WARNING, new String[0]);
                    bl4 = true;
                }
                bl2 = false;
                bl5 = true;
            }
            if (object62.size() > 0) {
                testModelType.getModel().removeAll((Collection<?>)object62);
                if (testModelType.getModel().size() == 0) {
                    testModelType.setMiningFunction(null);
                    attributeType = null;
                    bl5 = true;
                    bl6 = true;
                }
            }
            for (Object object42 : testModelType.getModel()) {
                if (object42.getNodeId() == null || hashMap.get(object3 = object42.getNodeId()) == null) continue;
                hashMap.remove(object3);
            }
            if (hashMap.size() > 0) {
                hashMap2.clear();
                for (Object object42 : hashMap.values()) {
                    object3 = (ModelProvider)object42;
                    object2 = object3.getTargetAttribute();
                    list = object3.getOutputModels();
                    for (RefModelType refModelType : list) {
                        if (!refModelType.isUseForOutput()) continue;
                        String string = refModelType.getSchema() + "." + refModelType.getName() + "." + refModelType.getMiningAlgorithm() + "." + object2.getName() + "." + object2.getDataType();
                        hashMap2.put(string, refModelType);
                    }
                }
                for (Object object42 : testModelType.getModel()) {
                    if (object42.getStatus() != RefModelStatusType.INVALID || attributeType == null || (object2 = (RefModelType)hashMap2.get(object3 = object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm() + "." + attributeType.getName() + "." + attributeType.getDataType())) == null) continue;
                    object42.setStatus(RefModelStatusType.VALID);
                    object42.setNodeId(object2.getNodeId());
                    object42.setModelId(object2.getModelId());
                    bl5 = true;
                }
            }
        }
        results = new TestNodeType.Results();
        results.setGenAccuracyMetrics(testNodeType.getResults().isGenAccuracyMetrics());
        results.setGenConfusionMatrix(testNodeType.getResults().isGenConfusionMatrix());
        results.setGenLift(testNodeType.getResults().isGenLift());
        results.setGenROC(testNodeType.getResults().isGenROC());
        results.setGenResiduals(testNodeType.getResults().isGenResiduals());
        for (TestModelType.Model model : testModelType.getModel()) {
            if (model.getModelId() == null) continue;
            for (Object object62 : testNodeType.getResults().getClassificationResult()) {
                if (!object62.getModelId().equals(model.getModelId())) continue;
                results.getClassificationResult().add(object62);
            }
            for (Object object62 : testNodeType.getResults().getRegressionResult()) {
                if (!object62.getModelId().equals(model.getModelId())) continue;
                results.getRegressionResult().add(object62);
            }
        }
        boolean bl7 = results.getClassificationResult().size() != testNodeType.getResults().getClassificationResult().size();
        boolean bl8 = results.getRegressionResult().size() != testNodeType.getResults().getRegressionResult().size();
        boolean bl9 = testModelType.isGeneratePartitions();
        boolean bl10 = TestNode.matchModelPartitions(testModelType, testModelType.getModel());
        if (bl10 != bl9) {
            testModelType.setGeneratePartitions(Boolean.valueOf(bl10));
            bl5 = true;
        }
        object5 = new ArrayList();
        object42 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            object3 = new ComplexProperty(TARGET_ATTRIBUTE, attributeType);
            ((ComplexProperty)object3).setOldData(testNodeType.getTargetAttribute());
            object5.add(object3);
        }
        if (bl5) {
            object3 = new ComplexProperty(TEST_MODELS, testModelType);
            ((ComplexProperty)object3).setOldData(testNodeType.getTestModels());
            object5.add(object3);
        }
        if (bl7 || bl8) {
            object3 = new ComplexProperty(TEST_RESULTS, results);
            ((ComplexProperty)object3).setOldData(testNodeType.getResults());
            object5.add(object3);
        }
        ((OdmrSDMUndoFilter)((Object)object42)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object5);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        AbstractDataNode abstractDataNode = this.findTestDataNode();
        if (abstractDataNode == null) {
            this.addMessage("TEST_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (testNodeType.getTestModels().getModel().size() == 0) {
            this.addMessage("TEST_NO_MODEL", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            if (modelProvider.getTargetAttribute() != null) continue;
            this.addMessage("TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public void setProperty(String string, Object object) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        if (string.equals(TARGET_ATTRIBUTE)) {
            AttributeType attributeType = (AttributeType)object;
            testNodeType.setTargetAttribute(attributeType);
        } else if (string.equals(CASE_ATTRIBUTES)) {
            AttributeType attributeType = (AttributeType)object;
            testNodeType.getCaseAttributes().getAttribute().clear();
            testNodeType.getCaseAttributes().getAttribute().add(attributeType);
        } else if (string.equals(TEST_MODELS)) {
            TestModelType testModelType = (TestModelType)object;
            testNodeType.setTestModels(testModelType);
            this._nodesLookupMap.clear();
        } else if (string.equals(AUTO_SETTING)) {
            testNodeType.getTestModels().setAutoSpec((AutoSpecType)object);
        } else if (string.equals(MODEL_STATUS)) {
            this.setModelStatus(object);
        } else if (string.equals(TEST_RESULTS)) {
            testNodeType.setResults((TestNodeType.Results)object);
        } else if (string.equals(GEN_ACCURACY_METRICS)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenAccuracyMetrics())) {
                results.setGenAccuracyMetrics(bl);
            }
        } else if (string.equals(GEN_CONFUSION_MATRIX)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenConfusionMatrix())) {
                results.setGenConfusionMatrix(bl);
            }
        } else if (string.equals(GEN_ROC_CURVE)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenROC())) {
                results.setGenROC(bl);
            }
        } else if (string.equals(GEN_LIFT_AND_PROFIT)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenLift())) {
                results.setGenLift(bl);
            }
        } else if (string.equals(GEN_RESIDUALS)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenResiduals())) {
                results.setGenResiduals(bl);
            }
        } else if (string.equals(TEST_SETTINGS_CHANGED)) {
            if (object == null || !(object instanceof ClassificationTestSettingsType)) {
                return;
            }
            ClassificationTestSettingsType classificationTestSettingsType = (ClassificationTestSettingsType)object;
            testNodeType.setTestSettings(classificationTestSettingsType);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(MODEL_STATUS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AUTO_SETTING)) {
            TestNodeType testNodeType = (TestNodeType)this.getData();
            return testNodeType.getTestModels().getAutoSpec();
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        Object object = null;
        if (string.equals(TARGET_ATTRIBUTE)) {
            object = testNodeType.getTargetAttribute();
        } else if (string.equals(CASE_ATTRIBUTES)) {
            if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
                object = testNodeType.getCaseAttributes().getAttribute().get(0);
            }
        } else if (string.equals(TEST_MODELS)) {
            object = testNodeType.getTestModels();
        } else if (string.equals(AUTO_SETTING)) {
            object = testNodeType.getTestModels().getAutoSpec();
        } else if (string.equals(TEST_RESULTS)) {
            object = testNodeType.getResults();
        } else if (string.equals(GEN_ACCURACY_METRICS)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenAccuracyMetrics();
        } else if (string.equals(GEN_CONFUSION_MATRIX)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenConfusionMatrix();
        } else if (string.equals(GEN_ROC_CURVE)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenROC();
        } else if (string.equals(GEN_LIFT_AND_PROFIT)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenLift();
        } else if (string.equals(GEN_RESIDUALS)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenLift();
        } else if (string.equals(TEST_SETTINGS_CHANGED)) {
            object = testNodeType.getTestSettings();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TEST_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TEST_ICON"));
    }

    public AbstractDataNode findTestDataNode() {
        AbstractDataNode abstractDataNode = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            abstractDataNode = (AbstractDataNode)abstractNode;
            break;
        }
        return abstractDataNode;
    }

    public List<AttributeType> findCaseIds() {
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                arrayList.add(attributeType);
            }
        }
        return arrayList;
    }

    public String getModelNodeName(String string) {
        if (this._nodesLookupMap.size() == 0) {
            this.initModelNodeLookup();
        }
        return this._nodesLookupMap.get(string);
    }

    public MiningResultType getModelResult(String string) {
        if (this._resultLookupMap.size() == 0) {
            this.initResultLookup();
        }
        return this._resultLookupMap.get(string);
    }

    public List<AbstractNode> findTestModelNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof ModelProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public static void removeModel(TestModelType testModelType, List<TestModelType.Model> list) {
        if (list.size() > 0) {
            testModelType.getModel().removeAll(list);
            if (testModelType.getModel().size() == 0) {
                testModelType.setMiningFunction(null);
            }
        }
    }

    public static boolean addModels2(TestModelType testModelType, List<TestModelType.Model> list) {
        boolean bl = true;
        if (list.size() > 0) {
            if (testModelType.getModel().size() == 0) {
                testModelType.setMiningFunction(list.get(0).getMiningFunction());
            }
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (TestModelType.Model model : testModelType.getModel()) {
                String string = model.getSchema() + "." + model.getName();
                hashMap.put(string, Boolean.TRUE);
            }
            for (TestModelType.Model model : list) {
                if (hashMap.get(model.getSchema() + "." + model.getName()) != null) {
                    model.setStatus(RefModelStatusType.INVALID);
                    bl = false;
                }
                testModelType.getModel().add(model);
            }
        }
        return bl;
    }

    public static boolean doesModelExist(TestModelType testModelType, RefModelType refModelType) {
        boolean bl = false;
        for (TestModelType.Model model : testModelType.getModel()) {
            String string;
            String string2 = model.getSchema() + "." + model.getName();
            if (!string2.equals(string = refModelType.getSchema() + "." + refModelType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean matchModelPartitions(TestModelType testModelType, List<TestModelType.Model> list) {
        boolean bl = true;
        if (list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (TestModelType.Model model : list) {
                if (model.getPartitionExpressions() == null) continue;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (PartitionExpressionType partitionExpressionType : model.getPartitionExpressions().getPartitionExpression()) {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append("|");
                    }
                    stringBuffer2.append(partitionExpressionType.getPartitionAttribute().getName() + "." + partitionExpressionType.getPartitionAttribute().getDataType());
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(stringBuffer2);
                    continue;
                }
                if (stringBuffer.toString().equals(stringBuffer2.toString())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void setModelStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (!subNodeProperty.getId().equals(model.getName())) continue;
            model.setTestStatus((ModelStatusType)subNodeProperty.getValue());
            break;
        }
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (!model.getTestStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(MODEL_STATUS, new SubNodeProperty(model.getName(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(model.getName(), model.getTestStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public String getHelpTopic() {
        return "test_node";
    }

    private String generateClassTestCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, TestModelType.Model model) throws Exception {
        Object object;
        String string;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        String string2 = null;
        String string3 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string5 = ConnectionFolder.getUserAccountName(this.getContext());
        String string6 = model.getName();
        String string7 = parameterizedSourceDefinitions.getParmNameWithAmpersand(model.getNodeId(), string5, string6, DatabaseObjectType.MODEL);
        String string8 = CodeTemplate.getInstance().getTemplate("workflow_class_test_model.sql");
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        CostMatrixInfo costMatrixInfo = Model.getModelCostMatrix(connectionFolder, string5, string6);
        boolean bl = false;
        boolean bl2 = false;
        if (costMatrixInfo != CostMatrixInfo._NONE) {
            bl = true;
            bl2 = true;
        }
        String string9 = null;
        if (bl) {
            string = "COST MODEL AUTO USING *";
            string9 = "COST";
        } else {
            string = "USING *";
            string9 = "PROBABILITY";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && bl2) {
            string2 = "  v_sql := \n  'WITH \n  tr_cost AS \n    ( \n      select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n      from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(''<MODEL_NAME_PARAM>'')) \n    ), \n  total_actuals AS \n    (SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n       SUM(a.VALUE * b.cost) actuals_cost, \n       SUM(a.VALUE) total_actuals \n     FROM '||v_confusion_matrix||' a, \n       tr_cost b \n     WHERE a.actual_target_value(+) = b.actual_target_value \n     AND a.predicted_target_value(+) = b.predicted_target_value \n     GROUP BY nvl(a.actual_target_value, b.actual_target_value)), \n  total_predicted AS \n    (SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n       SUM(a.VALUE * b.cost) predicted_cost, \n       SUM(a.VALUE) total_predicted \n     FROM '||v_confusion_matrix||' a, \n       tr_cost b \n     WHERE a.actual_target_value(+) = b.actual_target_value \n     AND a.predicted_target_value(+) = b.predicted_target_value \n     GROUP BY nvl(a.predicted_target_value, b.predicted_target_value)), \n  right_predictions AS \n    (SELECT actual_target_value, \n       VALUE AS correct \n     FROM '||v_confusion_matrix||' \n     WHERE actual_target_value = predicted_target_value), \n  actuals_total_cost as \n    (SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n     FROM '||v_confusion_matrix||' a, \n       tr_cost b \n     WHERE a.actual_target_value = b.actual_target_value \n     AND a.predicted_target_value = b.predicted_target_value) \n  SELECT \n    SUM(actuals_cost) COST \n  FROM total_actuals a, \n    total_predicted p, \n    right_predictions c, \n    actuals_total_cost tc \n  WHERE a.actual_target_value(+) = p.predicted_target_value AND p.predicted_target_value = c.actual_target_value(+)'; \n  EXECUTE IMMEDIATE v_sql INTO v_tot_cost; \n";
            stringBuffer.append(string2);
            stringBuffer.append("  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''COST'', NVL('||v_tot_cost||', 0))'); \n");
        }
        boolean bl3 = testNodeType.getResults().isGenLift() == null ? true : testNodeType.getResults().isGenLift();
        boolean bl4 = testNodeType.getResults().isGenROC() == null ? true : testNodeType.getResults().isGenROC();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        StringBuffer stringBuffer4 = new StringBuffer("");
        if (bl3 || bl4) {
            object = testNodeType.getTestSettings().getTopNTargets();
            ClassificationTestSettingsType.BottomNTargets bottomNTargets = testNodeType.getTestSettings().getBottomNTargets();
            String string10 = "DESC";
            int n = 5;
            if (object != null || bottomNTargets != null) {
                if (bottomNTargets != null) {
                    string10 = "ASC";
                    n = bottomNTargets.getValue().intValue();
                } else {
                    n = object.getValue().intValue();
                }
                string2 = "  -- targets for test results \n  v_sql := \n    'SELECT <PARALLEL_HINT> \"'||v_target||'\" as prediction FROM \n    ( \n      SELECT \"'||v_target||'\", \n      RANK() OVER (ORDER BY count(\"'||v_target||'\") " + string10 + ") \"Rank\" \n" + "      FROM '||v_test_data||'  \n" + "      GROUP BY \"'||v_target||'\" \n" + "    ) \n" + "    WHERE rownum <= " + n + "'; \n" + "  EXECUTE IMMEDIATE v_sql BULK COLLECT INTO v_targets; \n";
                string2 = StringUtils.getReplacedString(string2, "<PARALLEL_HINT>", string4);
            } else {
                StringBuffer stringBuffer5 = new StringBuffer();
                int n2 = 0;
                for (ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue : testNodeType.getTestSettings().getSpecificTargets().getTargetValue()) {
                    if (n2 > 0) {
                        stringBuffer5.append(", ");
                    }
                    stringBuffer5.append("'" + StringUtils.escapeSingleQuotesForSQL(targetValue.getValue()) + "'");
                    ++n2;
                }
                string2 = "  -- targets for test results \n  v_targets := ODMR_OBJECT_VALUES(" + stringBuffer5.toString() + "); \n";
            }
            stringBuffer4.append(string2);
            if (bl3) {
                string2 = "  FOR i IN 1..v_targets.COUNT LOOP \n    -- lift for each target \n    v_lift := generateUniqueName; \n    DBMS_DATA_MINING.COMPUTE_LIFT ( \n      apply_result_table_name   => v_apply_data, \n      target_table_name         => v_test_data, \n      case_id_column_name       => v_caseid, \n      target_column_name        => '\"'||v_target||'\"', \n      lift_table_name           => v_lift, \n      positive_target_value     => v_targets(i), \n      score_column_name         => 'PREDICTION', \n      score_criterion_column_name => '<SCORE_CRITERION>', \n      num_quantiles             => 100, \n      score_criterion_type      => '<SCORE_CRITERION>'); \n    recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_lift, 'TABLE', v_target||'='||v_targets(i), 'Lift Result'); \n  END LOOP; \n";
                stringBuffer2.append(string2);
            }
            if (bl4) {
                string2 = "  -- roc for each target (only binary target support) \n  IF (v_targets.COUNT <= 2) THEN \n    FOR i IN 1..v_targets.COUNT LOOP \n      v_roc := generateUniqueName; \n      DBMS_DATA_MINING.COMPUTE_ROC ( \n        roc_area_under_curve        => v_area_under_curve, \n        apply_result_table_name     => v_apply_data, \n        target_table_name           => v_test_data, \n        case_id_column_name         => v_caseid, \n        target_column_name          => '\"'||v_target||'\"', \n        roc_table_name              => v_roc, \n        positive_target_value       => v_targets(i), \n        score_column_name           => 'PREDICTION', \n        score_criterion_column_name => 'PROBABILITY'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_roc, 'TABLE', v_target||'='||v_targets(i), 'ROC Result'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_area_under_curve, 'SCALAR', v_target||'='||v_targets(i), 'ROC Area Under Curve'); \n    END LOOP; \n  END IF; \n";
                stringBuffer3.append(string2);
            }
        }
        string8 = CodeTemplate.updateBodyTemplate(string8, "<TABLE_PARALLEL_HINT>", string3);
        string8 = CodeTemplate.updateBodyTemplate(string8, "<PARALLEL_HINT>", string4);
        string8 = CodeTemplate.updateBodyTemplate(string8, "<TEST_APPLY_COST_OPTION>", string);
        string8 = CodeTemplate.updateBodyTemplate(string8, "<COST_SETTING>", "");
        string8 = CodeTemplate.updateBodyTemplate(string8, "<TEST_TARGET_VALUES>", stringBuffer4.toString());
        string8 = CodeTemplate.updateBodyTemplate(string8, "<GEN_LIFT_RESULT>", stringBuffer2.toString());
        string8 = CodeTemplate.updateBodyTemplate(string8, "<GEN_ROC_RESULT>", stringBuffer3.toString());
        string8 = CodeTemplate.updateBodyTemplate(string8, "<COMPUTE_TOTAL_COST>", stringBuffer.toString());
        string8 = CodeTemplate.updateBodyTemplate(string8, "<SCORE_CRITERION>", string9);
        string8 = CodeTemplate.updateBodyTemplate(string8, "<MODEL_NAME_PARAM>", string7);
        string8 = CodeTemplate.updateBodyTemplate(string8, "<BUILD_MODEL_ID>", model.getModelId());
        object = null;
        if (model.getMiningAlgorithm() == MiningAlgorithmType.DECISION_TREE) {
            object = MiningAlgorithms.DECISION_TREE.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.NAIVE_BAYES) {
            object = MiningAlgorithms.NAIVE_BAYES.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            object = MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            object = MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString();
        }
        string8 = CodeTemplate.updateBodyTemplate(string8, "<BUILD_MODEL_TYPE>", (String)object);
        return string8;
    }

    private String generateRegressTestCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, TestModelType.Model model) throws Exception {
        String string;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        String string2 = model.getSchema();
        String string3 = model.getName();
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string6 = parameterizedSourceDefinitions.getParmNameWithAmpersand(model.getNodeId(), string2, string3, DatabaseObjectType.MODEL);
        String string7 = CodeTemplate.getInstance().getTemplate("workflow_regress_test_model.sql");
        StringBuffer stringBuffer = new StringBuffer("");
        if (testNodeType.getResults().isGenResiduals() == null || testNodeType.getResults().isGenResiduals().booleanValue()) {
            string = "  -- Residual plot \n  v_residual_plot := generateUniqueName; \n  v_sql :=  'CREATE TABLE '||v_residual_plot||' <TABLE_PARALLEL_HINT> AS \n    SELECT <PARALLEL_HINT> * \n      FROM (SELECT \n            A.\"'||v_caseid||'\" CASEID, \n            (B.\"'||v_target||'\") TARGET, \n            A.pred PREDICTION, \n            ((B.\"'||v_target||'\") - A.pred) RESIDUAL \n              FROM '||v_apply_data||' A, \n                   '||v_test_data||' B \n             WHERE A.\"'||v_caseid||'\" = B.\"'||v_caseid||'\" \n            ORDER BY A.pred ASC) WHERE RESIDUAL IS NOT NULL'; \n  execSQL(v_sql); \n  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_residual_plot, 'TABLE', NULL, 'Residual Plot'); \n";
            string = StringUtils.getReplacedString(string, "<TABLE_PARALLEL_HINT>", string4);
            string = StringUtils.getReplacedString(string, "<PARALLEL_HINT>", string5);
            stringBuffer.append(string);
        }
        string7 = CodeTemplate.updateBodyTemplate(string7, "<TABLE_PARALLEL_HINT>", string4);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<PARALLEL_HINT>", string5);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<RESIDUAL_PLOT>", stringBuffer.toString());
        string7 = CodeTemplate.updateBodyTemplate(string7, "<MODEL_NAME_PARAM>", string6);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<BUILD_MODEL_ID>", model.getModelId());
        string = null;
        if (model.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            string = MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            string = MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString();
        }
        string7 = CodeTemplate.updateBodyTemplate(string7, "<BUILD_MODEL_TYPE>", string);
        return string7;
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
                TestNodeType testNodeType = (TestNodeType)this.getData();
                for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
                    ConnectionFolder connectionFolder;
                    Model model2;
                    Vector<MiningModelSettings> vector;
                    if (model.getMiningAlgorithm() != MiningAlgorithmType.GENERALIZED_LINEAR_MODEL || MiningModelSettings.findSetting("GLMS_FTR_SEL_CRIT", vector = (model2 = new Model()).getModelSettings((ConnectionManager)(connectionFolder = ConnectionFolder.getConnectionFolder(context)), model.getSchema(), model.getName())) == null && MiningModelSettings.findSetting("GLMS_MAX_FEATURES", vector) == null && MiningModelSettings.findSetting("GLMS_SELECT_BLOCK", vector) == null && MiningModelSettings.findSetting("GLMS_FTR_IDENTIFICATION", vector) == null && MiningModelSettings.findSetting("GLMS_PRUNE_MODEL", vector) == null && MiningModelSettings.findSetting("GLMS_FTR_ACCEPTANCE", vector) == null && MiningModelSettings.findSetting("GLMS_FTR_IDENTIFICATION", vector) == null && MiningModelSettings.findSetting("GLMS_FTR_GENERATION", vector) == null) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_GLM_BUILD_SETTING_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private String generateCaseIdColumn(Context context) {
        String string = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            string = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        Object object;
        Object object2;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        String string2 = this.findTestDataNode().getMetadataId();
        String string3 = testNodeType.getTargetAttribute().getName();
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = null;
        String string5 = null;
        boolean bl = true;
        String string6 = "        ";
        String string7 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string8 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        if (testNodeType.getCaseAttributes() != null && !testNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            string5 = ((AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0)).getName();
            string4 = "  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT t.* \n      FROM '||getInputSource('" + string2 + "')||' t \n" + "    )'; \n" + "  execSQL(v_sql); \n";
            string4 = StringUtils.getReplacedString(string4, "<PARALLEL_HINT>", string8);
            bl = true;
        } else {
            Object object3;
            Object object4;
            string5 = this.generateCaseIdColumn(context);
            stringBuffer.setLength(0);
            object2 = new ArrayList();
            object2 = this.getModel().findLinksToNode((IlvSDMNode)this);
            object = object2.iterator();
            Object object5 = null;
            while (object.hasNext()) {
                object4 = (GeneralLink)object.next();
                object3 = (AbstractNode)((GeneralLink)object4).getFrom();
                if (!(object3 instanceof AbstractDataNode)) continue;
                object5 = (AbstractDataNode)object3;
                break;
            }
            object4 = ((AbstractDataNode)object5).getInputSQL();
            object3 = null;
            String string9 = null;
            StringBuffer stringBuffer2 = new StringBuffer("");
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            try {
                object3 = ConnectionFolder.getUserAccountName(context);
                string9 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
                object4 = "SELECT * FROM (" + (String)object4 + ")";
                DatabaseMetadataUtils.createViewAs(connectionFolder, (String)object4, (String)object3, string9);
                Map<String, DatabaseMetadataUtils.ColumnInfo> map = DatabaseMetadataUtils.getColumnInfo(context, string9);
                for (DatabaseMetadataUtils.ColumnInfo columnInfo : map.values()) {
                    if (columnInfo.getDataType().compareToIgnoreCase("CLOB") == 0 || columnInfo.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(",\n" + string6);
                        }
                        stringBuffer2.append("LOB(" + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + ") STORE AS BASICFILE");
                        continue;
                    }
                    if (columnInfo.getDataType().contains("NESTED")) {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(",\n" + string6);
                        }
                        stringBuffer2.append("NESTED TABLE " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS '||generateUniqueName||'");
                        continue;
                    }
                    if (columnInfo.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(",\n" + string6);
                    }
                    stringBuffer2.append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS BASICFILE CLOB");
                }
            }
            finally {
                try {
                    DatabaseMetadataUtils.dropView(connectionFolder, (String)object3, string9);
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            string4 = "  \n  v_sql := \n    'CREATE TABLE '||v_input_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM '||v_caseid||', t.*  \n      FROM '||getInputSource('" + string2 + "')||' t \n" + "    )'; \n" + "  execSQL(v_sql); \n";
            string4 = StringUtils.getReplacedString(string4, "<STORAGE_CLAUSE>", stringBuffer2.toString());
            string4 = StringUtils.getReplacedString(string4, "<TABLE_PARALLEL_HINT>", string7);
            string4 = StringUtils.getReplacedString(string4, "<PARALLEL_HINT>", string8);
        }
        string4 = string4 + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_input_data, '" + (bl ? "VIEW" : "TABLE") + "', NULL, 'Input Data'); \n";
        object2 = CodeTemplate.updateBodyTemplate(string, "<CASEID>", string5);
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<INPUT_DATA>", string4);
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<SOURCE_NODE_ID>", string2);
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<TARGET>", string3);
        object = new StringBuffer();
        for (Object object4 : testNodeType.getTestModels().getModel()) {
            if (object4.getMiningFunction() == MiningFunctionType.REGRESSION) {
                ((StringBuffer)object).append(this.generateRegressTestCode(context, parameterizedSourceDefinitions, (TestModelType.Model)object4) + "\n");
                continue;
            }
            ((StringBuffer)object).append(this.generateClassTestCode(context, parameterizedSourceDefinitions, (TestModelType.Model)object4));
        }
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<TEST_MODELS>", ((StringBuffer)object).toString());
        return object2;
    }
}

