/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public abstract class SupervisedBuildNode
extends AbstractBuildNode {
    public static final String TARGET_ATTRIBUTE = "targetAttribute";
    private static final String TARGET_INVALID = "targetAttributeInvalid";
    protected static final String TEST_DATA = "testData";
    private static final String RESULT_STATUS = "resultStatus";

    public SupervisedBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_CLASS_BUILD_NODE_NAME");
    }

    @Override
    public void setProperty(String string, Object object) {
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        if (string.equals(TARGET_ATTRIBUTE)) {
            superviseBuildNodeType.setTargetAttribute((AttributeType)object);
        } else if (string.equals(TARGET_INVALID)) {
            AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
            if (attributeType != null) {
                attributeType.setStatus((AttributeStatus)object);
            }
        } else if (string.equals(TEST_DATA)) {
            superviseBuildNodeType.setTestDataSource((TestDataSource)object);
        } else if (string.equals(RESULT_STATUS)) {
            this.setResultStatus(object);
        } else {
            super.setProperty(string, object);
        }
    }

    private void setResultStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        MiningResultType miningResultType = MetaDataHelper.findResultById((SuperviseBuildNodeType)this.getData(), subNodeProperty.getId());
        miningResultType.setStatus((ModelStatusType)subNodeProperty.getValue());
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = new TestDataSource();
        TestDataSource.SplitData splitData = new TestDataSource.SplitData();
        splitData.setTestPercent(40.0);
        testDataSource.setSplitData(splitData);
        superviseBuildNodeType.setTestDataSource(testDataSource);
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (bl) {
            SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
            TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
            BuildDataSource buildDataSource = superviseBuildNodeType.getBuildDataSource();
            TestDataSource.TestData testData = testDataSource.getTestData();
            if (testData != null && buildDataSource != null) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
        TestDataSource.TestData testData = testDataSource.getTestData();
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        if (testData == null && list.size() == 2) {
            TestDataSource testDataSource2 = new TestDataSource();
            testData = new TestDataSource.TestData();
            testData.setSourceId(node.getMetadataId());
            testDataSource2.setTestData(testData);
            testDataSource2.setSplitData(null);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testOptionsChanged", testDataSource2);
            for (GeneralLink generalLink : list) {
                if (((AbstractNode)generalLink.getFrom()).getMetadataId().equals(testData.getSourceId())) {
                    odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("TEST_DATA_LINK_LABEL"));
                    continue;
                }
                odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("BUILD_DATA_LINK_LABEL"));
            }
            if (superviseBuildNodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || superviseBuildNodeType.getStatus().equals((Object)NodeStatusType.WARNING)) {
                this.setNodeReady();
            }
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
        TestDataSource.TestData testData = testDataSource.getTestData();
        if (testData != null && testData.getSourceId().equals(node.getMetadataId())) {
            this.handleRemoveTestDataSource(testDataSource);
        } else if (testData != null) {
            this.handleRemoveTestDataSource(testDataSource);
        }
    }

    private void handleRemoveTestDataSource(TestDataSource testDataSource) {
        TestDataSource testDataSource2 = new TestDataSource();
        testDataSource.setTestData(null);
        TestDataSource.SplitData splitData = new TestDataSource.SplitData();
        splitData.setTestPercent(50.0);
        testDataSource2.setSplitData(splitData);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testOptionsChanged", testDataSource2);
    }

    public void swapDataSources() {
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        BuildDataSource buildDataSource = MetaDataHelper.copyBuildDataSource(superviseBuildNodeType.getBuildDataSource());
        TestDataSource testDataSource = MetaDataHelper.copyTestDataSource(superviseBuildNodeType.getTestDataSource());
        TestDataSource.TestData testData = testDataSource.getTestData();
        String string = buildDataSource.getSourceId();
        buildDataSource.setSourceId(testData.getSourceId());
        testData.setSourceId(string);
        if (superviseBuildNodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || superviseBuildNodeType.getStatus().equals((Object)NodeStatusType.WARNING)) {
            this.setNodeReady();
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "buildDataSource", buildDataSource);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_DATA, testDataSource);
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            if (((AbstractNode)generalLink.getFrom()).getMetadataId().equals(testData.getSourceId())) {
                odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("TEST_DATA_LINK_LABEL"));
                continue;
            }
            odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("BUILD_DATA_LINK_LABEL"));
        }
    }

    @Override
    public boolean validate(boolean bl) {
        List list;
        Attributes attributes;
        boolean bl2 = super.validate(bl);
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        if (abstractDataNode != null) {
            attributes = ((DataProvider)abstractDataNode).getAttributes();
            list = attributes.getAttribute();
            if (!this.validateBuildAttributes(list)) {
                bl2 = false;
            }
            if (!this.validateTarget(list)) {
                bl2 = false;
            }
        } else {
            this.validateTarget(null);
            bl2 = false;
            return bl2;
        }
        attributes = (SuperviseBuildNodeType)this.getData();
        list = attributes.getTestDataSource();
        if (list != null && list.getTestData() != null) {
            AbstractDataNode abstractDataNode2 = this.findTestDataNode(this.getModel());
            if (abstractDataNode2 != null) {
                Attributes attributes2 = ((DataProvider)abstractDataNode2).getAttributes();
                List list2 = attributes2.getAttribute();
                if (!this.validateTestAttributes(list2)) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    protected boolean validateBuildAttributes(List<AttributeType> list) {
        boolean bl = true;
        if (list.size() == 0) {
            bl = false;
            this.addMessage("BUILD_NO_BUILD_ATTR", MessageEnumType.INCOMPLETE, new String[0]);
        }
        return bl;
    }

    protected boolean validateTestAttributes(List<AttributeType> list) {
        CaseAttributes caseAttributes;
        SuperviseBuildNodeType superviseBuildNodeType;
        AttributeType attributeType;
        boolean bl = true;
        if (list.size() == 0) {
            this.addMessage("BUILD_NO_TEST_ATTR", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if ((attributeType = (superviseBuildNodeType = (SuperviseBuildNodeType)this.getData()).getTargetAttribute()) != null && null == this.findCompatibleAttribute(attributeType, list)) {
            this.addMessage("BUILD_TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if ((caseAttributes = superviseBuildNodeType.getCaseAttributes()) != null && caseAttributes.getAttribute().size() > 0 && null == this.findCompatibleAttribute((AttributeType)caseAttributes.getAttribute().get(0), list)) {
            this.addMessage("BUILD_TEST_NO_CASEID", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    protected boolean validateTarget(List<AttributeType> list) {
        AttributeStatus attributeStatus;
        boolean bl = true;
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        AttributeStatus attributeStatus2 = attributeStatus = attributeType == null ? null : attributeType.getStatus();
        if (attributeType != null) {
            if (list != null) {
                if (null == this.findCompatibleAttribute(attributeType, list)) {
                    attributeType.setStatus(AttributeStatus.INVALID);
                    this.addMessage("BUILD_INVALID_TARGET", MessageEnumType.WARNING, new String[0]);
                    bl = false;
                } else {
                    attributeType.setStatus(AttributeStatus.VALID);
                }
            } else {
                attributeType.setStatus(AttributeStatus.INVALID);
                bl = false;
            }
        } else {
            this.addMessage("BUILD_NO_TARGET", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if (!bl) {
            ComplexProperty complexProperty = new ComplexProperty(TARGET_INVALID, AttributeStatus.INVALID);
            complexProperty.setOldData(attributeStatus);
            complexProperty.setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
        return bl;
    }

    public AbstractDataNode findTestDataNode(WorkflowModel workflowModel) {
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
        if (testDataSource == null) {
            return null;
        }
        if (testDataSource.getTestData() == null) {
            return null;
        }
        AbstractDataNode abstractDataNode = null;
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)generalLink.getFrom();
            if (!abstractDataNode2.getMetadataId().equals(testDataSource.getTestData().getSourceId())) continue;
            abstractDataNode = abstractDataNode2;
            break;
        }
        return abstractDataNode;
    }

    @Override
    public Object getProperty(String string) {
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        if (string.equals(TARGET_ATTRIBUTE)) {
            AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
            return attributeType;
        }
        if (string.equals(TARGET_INVALID)) {
            AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
            return attributeType == null ? null : attributeType.getStatus();
        }
        if (string.equals(TEST_DATA)) {
            return superviseBuildNodeType.getTestDataSource();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(TARGET_INVALID)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(RESULT_STATUS)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection((SuperviseBuildNodeType)this.getData());
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (MiningResultType miningResultType : list) {
            if (!miningResultType.getStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(RESULT_STATUS, new SubNodeProperty(miningResultType.getModelId(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(miningResultType.getModelId(), miningResultType.getStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        super.refactorAttributes(node, map);
        if (!map.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(superviseBuildNodeType.getTargetAttribute());
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (attributeType2 != null) {
                attributeType.setName(attributeType2.getName());
                attributeType.setDataType(attributeType2.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TARGET_ATTRIBUTE, attributeType);
            }
        }
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
            stringBuffer.setLength(0);
            String string = superviseBuildNodeType.getTargetAttribute().getName();
            String string2 = superviseBuildNodeType.getTargetAttribute().getDataType();
            if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(version, string2)) {
                Object[] objectArray = new Object[]{string, string2};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_TARGET_DATA_TYPE_NOT_SUPPORTED"), objectArray));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        String string3 = superviseBuildNodeType.getTargetAttribute().getName();
        string2 = CodeTemplate.updateBodyTemplate(string2, "<TARGET>", string3);
        return string2;
    }
}

