/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.wflownodes.GraphNavNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.graph.GraphEditor;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CacheSettings;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettings;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSourceAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.Messages;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class GraphNode
extends AbstractNode
implements SampleSettingsProperties,
DataConsumer {
    private static final Logger theLogger = Logger.getLogger(SQLQueryNode.class.getName());
    public static final String SQL_EXPRESSION = "SQL_EXPRESSION";
    public static final String SQL_EXPRESSION_GENERATE = "SQL_EXPRESSION_GENERATE";
    public static final String CACHE_SETTINGS = "CACHE_SETTINGS";
    public static final String GRAPH_SETTINGS = "GRAPH_SETTINGS";
    public static final String VIEW_NAME = "VIEW_NAME";
    public static final String SOURCE_ATTRIBUTES = "SOURCE_ATTRIBUTES";
    public static final String VIEW_DIRTY = "VIEW_DIRTY";
    public static final String SAMPLE_DIRTY = "SAMPLE_DIRTY";
    public static final String CACHE_SETTINGS_PERCENT = NodeMessagesLrb.get("CACHE_SETTINGS_PERCENT");
    public static final String CACHE_SETTINGS_NUMBER_OF_ROWS = NodeMessagesLrb.get("CACHE_SETTINGS_NUMBER_OF_ROWS");
    public static final String CACHE_SETTINGS_SEED = NodeMessagesLrb.get("CACHE_SETTINGS_SEED");
    public static final String CACHE_SETTINGS_TARGET = NodeMessagesLrb.get("CACHE_SETTINGS_TARGET");
    public static final String CACHE_SETTINGS_RANDOM = NodeMessagesLrb.get("CACHE_SETTINGS_RANDOM");
    public static final String CACHE_SETTINGS_STRATIFIED = NodeMessagesLrb.get("CACHE_SETTINGS_STRATIFIED");
    public static final String CACHE_SETTINGS_TOPN = NodeMessagesLrb.get("CACHE_SETTINGS_TOPN");
    public static final String INPUT_SOURCE = "{INPUT_SOURCE}";
    public static final String INPUT_SOURCE_WITH_PARENTID = "{INPUT_SOURCE:<NodeId>}";

    public GraphNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        CacheSettings cacheSettings = new CacheSettings();
        cacheSettings.setNumberOfRows(Long.valueOf(2000L));
        CacheSettings.Method method = new CacheSettings.Method();
        CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
        method.setTopN(topN);
        cacheSettings.setMethod(method);
        cacheSettings.setGenerateCache(true);
        cacheSettings.setUseFullData(Boolean.valueOf(false));
        graphNodeType.setCacheSettings(cacheSettings);
        SampleSettings sampleSettings = new SampleSettings();
        sampleSettings.setNumberOfRows(Long.valueOf(2000L));
        SampleSettings.Method method2 = new SampleSettings.Method();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(12345L));
        method2.setRandom(random);
        sampleSettings.setMethod(method2);
        sampleSettings.setUseFullData(false);
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        graphNodeType.setSampleSettings(sampleSettings);
        GraphSettings graphSettings = new GraphSettings();
        graphNodeType.setGraphSettings(graphSettings);
        GraphSourceAttributesType graphSourceAttributesType = new GraphSourceAttributesType();
        graphNodeType.setGraphSourceAttributes(graphSourceAttributesType);
        String string = "";
        try {
            string = WorkflowUtils.getNewOutputTableNameWfid(context);
            graphNodeType.setViewName(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        graphNodeType.setViewDirty(Boolean.valueOf(true));
        graphNodeType.setSampleDirty(Boolean.valueOf(true));
    }

    public void findOrCreateView(final Context context) throws Exception {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.findParentNode();
        if (abstractDataNode.parentContainsIncompleteModel(this.getModel())) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("MISSING_INPUT_MINING_MODELS_MSG"), (String)GraphLrb.get("MISSING_INPUT_MINING_MODELS_TITLE"), null);
            throw new ViewCreationNotPossibleException("View creation not possible due to potentially missing mining models");
        }
        class CreateViewWorker
        extends ProgressRunnable {
            private Exception exception;
            private Boolean canceled = false;

            CreateViewWorker() {
            }

            public Exception getException() {
                return this.exception;
            }

            protected Object doWork() throws Exception {
                GraphNodeType graphNodeType = (GraphNodeType)GraphNode.this.getData();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(GraphNode.this.getContext());
                try {
                    boolean bl;
                    boolean bl2;
                    String string = connectionFolder.getUserAccountName();
                    String string2 = graphNodeType.getViewName();
                    boolean bl3 = string2 != null && graphNodeType.isViewDirty() != false;
                    boolean bl4 = bl2 = string2 == null;
                    if (string2 != null && !graphNodeType.isViewDirty().booleanValue() && (bl = DatabaseMetadataUtils.isTable(connectionFolder, string, graphNodeType.getViewName()))) {
                        return Boolean.TRUE;
                    }
                    if (bl2) {
                        string2 = WorkflowUtils.getNewOutputTableNameWfid(context);
                    }
                    if (bl3) {
                        try {
                            DatabaseMetadataUtils.dropView(connectionFolder, string, string2);
                        }
                        catch (SQLException sQLException) {
                            theLogger.log(Level.INFO, "View could not be dropped, ignored.", sQLException);
                        }
                    }
                    AbstractDataNode abstractDataNode = (AbstractDataNode)GraphNode.this.findParentNode();
                    String string3 = abstractDataNode.getStackedSQL(GraphNode.this.getModel());
                    DatabaseMetadataUtils.createViewAs(connectionFolder, string3, string, string2);
                    final String string4 = string2;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)GraphNode.this.getUndoFilter();
                            if (bl2) {
                                odmrSDMUndoFilter.prepareUndo(GraphNode.this, GraphNode.this.getContext(), GraphNode.VIEW_NAME, string4, 1);
                            }
                            odmrSDMUndoFilter.prepareUndo(GraphNode.this, GraphNode.this.getContext(), GraphNode.VIEW_DIRTY, Boolean.FALSE, 1);
                        }
                    });
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    workflowNode.save();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    this.exception = exception;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this.canceled = true;
            }
        }
        CreateViewWorker createViewWorker = new CreateViewWorker();
        createViewWorker.setTitle("Creating View");
        createViewWorker.setMessage("Creating View");
        createViewWorker.setCancelable(false);
        createViewWorker.start(true);
        if (createViewWorker.getException() != null) {
            throw createViewWorker.getException();
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(CACHE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(CACHE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals(SQL_EXPRESSION)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        Object object = null;
        if (string.equals(CACHE_SETTINGS_PERCENT) || string.equals(CACHE_SETTINGS_NUMBER_OF_ROWS) || string.equals(CACHE_SETTINGS_SEED) || string.equals(CACHE_SETTINGS_TARGET) || string.equals(CACHE_SETTINGS_RANDOM) || string.equals(CACHE_SETTINGS_STRATIFIED) || string.equals(CACHE_SETTINGS_TOPN)) {
            CacheSettings cacheSettings;
            object = cacheSettings = graphNodeType.getCacheSettings();
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            SampleSettings sampleSettings = graphNodeType.getSampleSettings();
            object = sampleSettings;
        } else if (string.equals(GRAPH_SETTINGS)) {
            object = graphNodeType.getGraphSettings();
        } else if (string.equals(SQL_EXPRESSION)) {
            object = this.getSQLExpression();
        } else if (string.equals(VIEW_NAME)) {
            object = graphNodeType.getViewName();
        } else if (string.equals(SOURCE_ATTRIBUTES)) {
            object = graphNodeType.getGraphSourceAttributes();
        } else if (string.equals(VIEW_DIRTY)) {
            object = graphNodeType.isViewDirty();
        } else if (string.equals(SAMPLE_DIRTY)) {
            object = graphNodeType.isSampleDirty();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        if (string.equals(CACHE_SETTINGS_PERCENT) || string.equals(CACHE_SETTINGS_NUMBER_OF_ROWS) || string.equals(CACHE_SETTINGS_SEED) || string.equals(CACHE_SETTINGS_TARGET) || string.equals(CACHE_SETTINGS_RANDOM) || string.equals(CACHE_SETTINGS_STRATIFIED) || string.equals(CACHE_SETTINGS_TOPN)) {
            if (object instanceof CacheSettings) {
                graphNodeType.setCacheSettings((CacheSettings)object);
            }
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            if (object instanceof SampleSettings) {
                graphNodeType.setSampleSettings((SampleSettings)object);
            }
        } else if (string.equals(GRAPH_SETTINGS)) {
            graphNodeType.setGraphSettings((GraphSettings)object);
        } else if (string.equals(SOURCE_ATTRIBUTES)) {
            graphNodeType.setGraphSourceAttributes((GraphSourceAttributesType)object);
        } else if (string.equals(SQL_EXPRESSION)) {
            if (object != null && object.equals(SQL_EXPRESSION_GENERATE)) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else if (string.equals(VIEW_NAME)) {
            graphNodeType.setViewName((String)object);
        } else if (string.equals(VIEW_DIRTY)) {
            graphNodeType.setViewDirty((Boolean)object);
        } else if (string.equals(SAMPLE_DIRTY)) {
            graphNodeType.setSampleDirty((Boolean)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validate(bl, true);
    }

    public boolean validate(boolean bl, boolean bl2) {
        Object object;
        AttributeType attributeType;
        Object object22;
        Object object3;
        List list;
        Map<String, AttributeType> map;
        Object object4;
        Object object52;
        boolean bl3 = true;
        int n = bl2 ? 65535 : 1;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        this.clearMessages(odmrSDMUndoFilter, n);
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        GraphSettings graphSettings = graphNodeType.getGraphSettings();
        List list2 = graphSettings.getGraphSetting();
        GraphSettings graphSettings2 = new GraphSettings();
        List list3 = graphSettings2.getGraphSetting();
        for (Object object52 : list2) {
            object4 = (GraphSettingsType)MetaDataHelper.copyMetadataObject(object52);
            list3.add(object4);
        }
        DataProvider dataProvider = (DataProvider)((Object)this.findParentNode());
        if (dataProvider == null) {
            bl3 = false;
            this.setState(bl3, n);
            return bl3;
        }
        object52 = dataProvider.getAttributes().getAttribute();
        object4 = this.buildAttrMap((List<AttributeType>)object52);
        if (graphNodeType.getGraphSourceAttributes() == null) {
            graphNodeType.setGraphSourceAttributes(new GraphSourceAttributesType());
        }
        if (this.isStructureChanged(map = this.buildAttrMap(list = graphNodeType.getGraphSourceAttributes().getAttribute()), (Map<String, AttributeType>)object4)) {
            object3 = new GraphSourceAttributesType();
            object22 = object3.getAttribute();
            attributeType = object52.iterator();
            while (attributeType.hasNext()) {
                object = (AttributeType)attributeType.next();
                object22.add((AttributeType)MetaDataHelper.copyMetadataObject(object));
            }
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SOURCE_ATTRIBUTES, object3, n);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SAMPLE_DIRTY, Boolean.TRUE, n);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), VIEW_DIRTY, Boolean.TRUE, n);
        }
        for (Object object22 : list3) {
            attributeType = object22.getXAttribute();
            if (!this.validateAttribute((Map<String, AttributeType>)object4, attributeType)) {
                bl3 = false;
            }
            if (GraphUtils.isMultipleSeriesGraph(object22.getType())) {
                object = object22.getYAttributes().getYAttribute();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    AttributeType attributeType2 = (AttributeType)iterator.next();
                    if (this.validateAttribute((Map<String, AttributeType>)object4, attributeType2)) continue;
                    bl3 = false;
                }
            }
            if (!object22.getGroupByOption().isGroupByEnabled() || this.validateAttribute((Map<String, AttributeType>)object4, (AttributeType)(object = object22.getGroupByOption().getGroupByAttribute()))) continue;
            bl3 = false;
        }
        object3 = new ArrayList();
        object22 = new ComplexProperty(SQL_EXPRESSION, SQL_EXPRESSION_GENERATE);
        ((ComplexProperty)object22).setOldData(this.getSQLExpression());
        object3.add(object22);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3, n);
        if (!bl3) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), GRAPH_SETTINGS, graphSettings2, n);
            this.addMessage("GRAPH_NO_ATTR", MessageEnumType.WARNING, new String[0]);
        }
        this.requestEditorRefresh();
        this.setState(bl3, n);
        return bl3;
    }

    private void requestEditorRefresh() {
        EditorManager editorManager = EditorManager.getEditorManager();
        GraphNavNode graphNavNode = this.findGraphNavNode();
        if (null == graphNavNode) {
            return;
        }
        List list = editorManager.findEditors(Context.newIdeContext((oracle.ide.model.Node)graphNavNode));
        for (Editor editor : list) {
            if (!(editor instanceof GraphEditor)) continue;
            ((GraphEditor)editor).setNeedsRefresh();
        }
    }

    private GraphNavNode findGraphNavNode() {
        GraphNavNode graphNavNode = null;
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        TNode tNode = workflowNode.getParent();
        TreeExplorer treeExplorer = tNode.getOwner();
        TNode tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)workflowNode, tNode);
        if (null == tNode2) {
            return null;
        }
        Enumeration enumeration = tNode2.getChildTNodes();
        while (enumeration.hasMoreElements()) {
            NodeType nodeType;
            String string;
            TNode tNode3 = (TNode)enumeration.nextElement();
            BaseTreeNode baseTreeNode = (BaseTreeNode)tNode3.getData();
            if (!(baseTreeNode instanceof GraphNavNode) || !(string = (nodeType = (NodeType)baseTreeNode.getRepositoryData()).getName()).equals(this.getData().getName())) continue;
            graphNavNode = (GraphNavNode)baseTreeNode;
            break;
        }
        return graphNavNode;
    }

    public void checkForLegacySettings() {
        Boolean bl = false;
        int n = 1;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        for (GraphSettingsType graphSettingsType : graphNodeType.getGraphSettings().getGraphSetting()) {
            if (graphSettingsType.getId() != null) continue;
            bl = true;
            break;
        }
        if (bl.booleanValue()) {
            GraphSettingsType graphSettingsType;
            GraphSettings graphSettings = graphNodeType.getGraphSettings();
            graphSettingsType = MetaDataHelper.copyGraphSettings(graphSettings);
            GraphUtils.generateGraphSettingsIds((GraphSettings)graphSettingsType);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), GRAPH_SETTINGS, graphSettingsType, n);
        }
    }

    private Map<String, AttributeType> buildAttrMap(List<AttributeType> list) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list) {
            String string = attributeType.getName();
            if (attributeType.getAlias() != null) {
                string = attributeType.getAlias();
            }
            hashMap.put(string, attributeType);
        }
        return hashMap;
    }

    private boolean isStructureChanged(Map<String, AttributeType> map, Map<String, AttributeType> map2) {
        if (!this.compareWithCollection(map, map2.values())) {
            return true;
        }
        return !this.compareWithCollection(map2, map.values());
    }

    private boolean compareWithCollection(Map<String, AttributeType> map, Collection<AttributeType> collection) {
        boolean bl = true;
        for (AttributeType attributeType : collection) {
            String string = attributeType.getName();
            String string2 = attributeType.getDataType();
            if (attributeType.getAlias() != null) {
                string = attributeType.getAlias();
            }
            if (!map.containsKey(string)) {
                bl = false;
                break;
            }
            AttributeType attributeType2 = map.get(string);
            if (string.equals(attributeType2.getName()) && string2.equals(attributeType2.getDataType())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setState(boolean bl, int n) {
        NodeStatusType nodeStatusType = bl ? NodeStatusType.READY : NodeStatusType.INVALID;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "status", nodeStatusType, n);
    }

    protected void clearMessages(OdmrSDMUndoFilter odmrSDMUndoFilter, int n) {
        Messages messages = this.getData().getMessages();
        if (messages == null) {
            return;
        }
        List list = messages.getMessage();
        if (list == null || list.isEmpty()) {
            return;
        }
        Messages messages2 = new Messages();
        messages2.getMessage();
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "messages", messages2, n);
    }

    private boolean validateAttribute(Map<String, AttributeType> map, AttributeType attributeType) {
        boolean bl = true;
        AttributeType attributeType2 = map.get(attributeType.getName());
        if (attributeType2 == null || !attributeType2.getDataType().equals(attributeType.getDataType())) {
            attributeType.setStatus(AttributeStatus.INVALID);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (node instanceof BuildTextNodeRef) {
            return false;
        }
        List<AbstractNode> list = this.findParentNodes();
        if (!this.allowMoreThanOneInputNode()) {
            bl = list.isEmpty();
        }
        if (!bl) {
            return bl;
        }
        bl = node instanceof DataProvider;
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(true);
    }

    public String getCacheTableName() {
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        CacheSettings cacheSettings = graphNodeType.getCacheSettings();
        if (cacheSettings == null) {
            return null;
        }
        ResultType resultType = cacheSettings.getOutputTable();
        if (resultType == null) {
            return null;
        }
        return resultType.getName();
    }

    public CacheSettings getCacheSettings() {
        GraphNodeType graphNodeType = (GraphNodeType)this.getData();
        return graphNodeType.getCacheSettings();
    }

    public String getSQLExpression() {
        return ((GraphNodeType)this.getData()).getSQLExpression();
    }

    public void setSQLExpression(String string) {
        ((GraphNodeType)this.getData()).setSQLExpression(string);
    }

    public String generateSQLExpression() {
        StringBuffer stringBuffer = new StringBuffer(32000);
        StringBuffer stringBuffer2 = new StringBuffer(32000);
        StringBuffer stringBuffer3 = new StringBuffer(32000);
        StringBuffer stringBuffer4 = new StringBuffer(INPUT_SOURCE);
        DataProvider dataProvider = (DataProvider)((Object)this.findParentNode());
        List list = dataProvider.getAttributes().getAttribute();
        for (AttributeType attributeType : list) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("\"" + attributeType.getName() + "\"");
            if (attributeType.getAlias() == null || attributeType.getAlias().length() == 0) {
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer2.append(" \"" + attributeType.getAlias() + "\"" + "\n");
        }
        stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
        stringBuffer.append(stringBuffer2 + "\n");
        stringBuffer.append("FROM\n");
        stringBuffer.append(stringBuffer4 + "\n");
        if (stringBuffer3.length() > 0) {
            stringBuffer.append("WHERE\n");
            stringBuffer.append(stringBuffer3);
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    protected String wrapExpressionInWithClause(String string) {
        String string2 = this.getNodeNameForSQLExpression(true) + " as (" + string + " )";
        return string2;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_GRAPH_NODE_SVG"));
    }

    @Override
    public String getHelpTopic() {
        return "graph_node";
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_GRAPH_NODE_NAME");
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_GRAPH_NODE_ICON"));
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap hashMap = new HashMap();
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        OdmrSDMUndoFilter odmrSDMUndoFilter;
        List<GeneralLink> list;
        Object object;
        if (!bl) {
            try {
                object = ((GraphNodeType)this.getData()).getViewName();
                list = this.getRefactorTableName((String)object, this.getContext());
                if (object != null && list != null && !((String)object).equals(list)) {
                    odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), VIEW_NAME, list);
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), VIEW_DIRTY, Boolean.TRUE);
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SAMPLE_DIRTY, Boolean.TRUE);
                    this.getModel().addRefactoredTableName((String)object, (String)((Object)list));
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        ++this.refactorInvokeCount;
        object = (OdmrSDMUndoFilter)this.getUndoFilter();
        list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            odmrSDMUndoFilter = (DataNodeType)this.getData();
            CacheSettings cacheSettings = odmrSDMUndoFilter.getCacheSettings();
            CacheSettings cacheSettings2 = MetaDataHelper.copyCacheSettings(cacheSettings);
            cacheSettings2.setOutputTable(null);
            ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), CACHE_SETTINGS_NUMBER_OF_ROWS, cacheSettings2);
            List<AbstractNode> list2 = this.findChildNodes();
            for (AbstractNode abstractNode : list2) {
                abstractNode.refactor(this, bl);
            }
        }
    }

    public String getRefactorTableName(final String string, final Context context) throws Exception {
        class Loader
        extends ProgressRunnable {
            private Exception _exc = null;
            private String newName;

            Loader() {
            }

            protected Object doWork() throws Exception {
                try {
                    this.newName = WorkflowUtils.getNewOutputTableNameWfidRefactor(string, context);
                }
                catch (Exception exception) {
                    this._exc = exception;
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowDialogLrb.get("SYSTEM_FAILURE"), (String)WorkflowDialogLrb.get("SYSTEM_FAILURE"), null);
                }
                return this;
            }
        }
        Loader loader = new Loader();
        loader.setCancelable(false);
        loader.setTitle(NodeMessagesLrb.get("PASTE_OPERATION_TITLE"));
        loader.setMessage(NodeMessagesLrb.get("PASTE_OPERATION_TITLE_MSG"));
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                loader.start(true);
            } else {
                loader.doWork();
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        if (null != loader._exc) {
            throw loader._exc;
        }
        return loader.newName;
    }

    public class ViewCreationNotPossibleException
    extends Exception {
        public ViewCreationNotPossibleException(String string) {
            super(string);
        }
    }
}

