/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.ModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public abstract class AbstractBuildNode
extends AbstractNode
implements ModelProvider,
DataConsumer {
    private static final Logger theLogger = Logger.getLogger(AbstractBuildNode.class.getName());
    public static final String MODEL_NAME = "modelName";
    public static final String MODEL_IDS = "modelIds";
    public static final String MODEL_STATUSES = "modelStatuses";
    public static final String MODEL_BUILD_DATES = "modelBuildDates";
    public static final String MODEL_ADDED_REMOVED = "modelAddedorRemoved";
    public static final String MODEL_ADDED = "modelAdded";
    public static final String MODEL_REMOVED = "modelRemoved";
    public static final String MODELS_RERUN = "modelsRerun";
    public static final String TESTS_RERUN = "testsRerun";
    public static final String MODEL_ANNOTATION = "modelAnnotation";
    public static final String ALL_TESTS_REMOVED = "alltestsRemoved";
    public static final String ALL_TESTS_RESTORED = "alltestsRestored";
    public static final String TESTS_REMOVED = "testsRemoved";
    public static final String TESTS_RESTORED = "testsRestored";
    public static final String ALL_TESTS_FOR_TUNING_REMOVED = "alltestsForTuningRemoved";
    public static final String ALL_TESTS_FOR_TUNING_RESTORED = "alltestsForTuningRestored";
    public static final String TESTS_FOR_TUNING_REMOVED = "testsForTuningRemoved";
    public static final String TESTS_FOR_TUNING_RESTORED = "testsForTuningRestored";
    public static final String MODEL_USE_FOR_OUTPUT = "modelUseForOutput";
    public static final String ALG_SETTINGS = "algTreeSettings";
    public static final String TEST_OPTIONS_CHANGED = "testOptionsChanged";
    public static final String TEST_SETTINGS_CHANGED = "testSettingsChanged";
    public static final String SPLIT_VALUE_CHANGED = "splitValueChanged";
    public static final String SPLIT_DATA_FORMAT = "splitDataFormat";
    public static final String MINING_ATTRIBUTE_SETTINGS = "miningAttributeSettings";
    public static final String PARTITIONS_EXPRESSION_EDIT = "PARTITIONS_EXPRESSION_EDIT";
    public static final String PARTITIONS_MAX_NUM = "PARTITIONS_MAX_NUM";
    public static final int MAX_NUM_PARTITIONS = 1000000;
    public static final int MAX_NUM_PARTITION_KEY = 16;
    private static Preferences _p = Preferences.getPreferences();
    private ModelBuildPreferencesPanelSettings buildPref = ModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);
    private Long lastBuildNodeId = 1L;
    private Version _dbVersion = null;
    public static final String CASE_ATTRIBUTES = "caseAttributes";
    public static final String BUILD_DATA_SOURCE = "buildDataSource";
    private static final String ALL_ATTRIBUTES = "allAttributes";
    private static final String NODE_ATTRIBUTES = "nodeAttributes";
    private static final String MODELS_ATTRIBUTES = "modelsAttributes";
    private static final String MODEL_ATTRIBUTES = "modelAttributes";
    private static final String MODEL_STATUS = "modelStatus";
    private static final String TEXT_ATTRIBUTES = "textAttributes";
    private static final String CASE_ID_ATTRIBUTES = "caseAttributesInternal";

    public AbstractBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        BuildNodeType buildNodeType;
        this.initMaxModelId();
        try {
            this._dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true) && !(this instanceof AssociationBuildNode)) {
            this.initStoplistInstance(context);
            this.initTextSettingsInstance();
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, this._dbVersion, true) && (buildNodeType = (BuildNodeType)this.getData()) != null && buildNodeType.getMaxNumPartitions() == null) {
            buildNodeType.setMaxNumPartitions(BigInteger.valueOf(this.buildPref.getMaxNumPartition()));
        }
    }

    private void initMaxModelId() {
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)this.getData());
        for (ModelType modelType : list) {
            Long l = Long.valueOf(modelType.getId());
            if (this.lastBuildNodeId == null) {
                this.lastBuildNodeId = l;
                continue;
            }
            if (this.lastBuildNodeId.compareTo(l) >= 0) continue;
            this.lastBuildNodeId = l;
        }
    }

    public String getNextModelId() {
        this.lastBuildNodeId = this.lastBuildNodeId + 1L;
        return this.lastBuildNodeId.toString();
    }

    @Override
    protected void initNewInstance(Context context) {
        BuildNodeType buildNodeType;
        super.initNewInstance(context);
        this.initMiningAttributesInstance();
        this.initCaseAttributesInstance();
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true) && !(this instanceof AssociationBuildNode)) {
            this.initStoplistInstance(context);
            this.initTextSettingsInstance();
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, this._dbVersion, true) && (buildNodeType = (BuildNodeType)this.getData()) != null && buildNodeType.getMaxNumPartitions() == null) {
            buildNodeType.setMaxNumPartitions(BigInteger.valueOf(this.buildPref.getMaxNumPartition()));
        }
    }

    @Override
    public abstract String getDefaultName();

    public ModelType createNewModel(String string, String string2, String string3, String string4) {
        NaiveBayesModelType naiveBayesModelType = null;
        String string5 = null;
        try {
            string5 = this.getModel().getNextNewIdString();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        InputMiningData inputMiningData = new InputMiningData();
        MiningAttributes miningAttributes = new MiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        inputMiningData.setMiningAttributes(miningAttributes);
        if (string3.equals("ASSOCIATION")) {
            inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
            inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
        } else {
            inputMiningData.setDataUsage(InputMiningDataType.AUTO);
            inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
        }
        List list2 = ((BuildNodeType)this.getData()).getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list2) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
            list.add(miningAttributeType2);
        }
        if (string4.equals("ALGO_NAIVE_BAYES")) {
            naiveBayesModelType = MetaDataHelper.createNaiveBayesModel();
        } else if (string4.equals("ALGO_DECISION_TREE")) {
            naiveBayesModelType = MetaDataHelper.createDecisionTreeModel();
        } else if (string4.equals("ALGO_SUPPORT_VECTOR_MACHINES")) {
            if (string3.equals("CLASSIFICATION")) {
                naiveBayesModelType = MetaDataHelper.createSVMClassificationModel();
            } else if (string3.equals("REGRESSION")) {
                naiveBayesModelType = MetaDataHelper.createSVMRegressionModel();
            } else if (string3.equals("ANOMALY_DETECTION")) {
                naiveBayesModelType = MetaDataHelper.createSVMAnomalyModel();
            }
        } else if (string4.equals("ALGO_GENERALIZED_LINEAR_MODEL")) {
            if (string3.equals("CLASSIFICATION")) {
                naiveBayesModelType = MetaDataHelper.createGLMClassificationModel();
                if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true)) {
                    ((CGeneralizedLinearModelType)naiveBayesModelType).getCGeneralizedLinearAlgo().setGLMSFTRSELECTION("GLMS_FTR_SELECTION_DISABLE");
                }
            } else if (string3.equals("REGRESSION")) {
                naiveBayesModelType = MetaDataHelper.createGLMRegressionModel();
                if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true)) {
                    ((RGeneralizedLinearModelType)naiveBayesModelType).getRGeneralizedLinearModelAlgo().setGLMSFTRSELECTION("GLMS_FTR_SELECTION_DISABLE");
                }
            }
        } else if (string4.equals("ALGO_KMEANS")) {
            naiveBayesModelType = MetaDataHelper.createKMeansModel(this.getContext());
        } else if (string4.equals("ALGO_O_CLUSTER")) {
            naiveBayesModelType = MetaDataHelper.createOClusterModel();
        } else if (string4.equals("ALGO_EXPECTATION_MAXIMIZATION")) {
            naiveBayesModelType = MetaDataHelper.createEMModel();
        } else if (string4.equals("ALGO_APRIORI_ASSOCIATION_RULES")) {
            naiveBayesModelType = MetaDataHelper.createAprioriModel();
        } else if (string4.equals("ALGO_NONNEGATIVE_MATRIX_FACTOR")) {
            naiveBayesModelType = MetaDataHelper.createNMFModel();
        } else if (string4.equals("ALGO_SINGULAR_VALUE_DECOMP")) {
            naiveBayesModelType = MetaDataHelper.createSVDModel();
        } else if (string4.equals("ALGO_PRINCIPAL_COMPONENT_ANALYSIS")) {
            naiveBayesModelType = MetaDataHelper.createPCAModel();
        }
        naiveBayesModelType.setName(string);
        naiveBayesModelType.setAnnotation(string2);
        naiveBayesModelType.setInputMiningData(inputMiningData);
        naiveBayesModelType.setStatus(ModelStatusType.READY);
        naiveBayesModelType.setId(string5);
        this.initMiningAttributeInputs(miningAttributes, (ModelType)naiveBayesModelType);
        return naiveBayesModelType;
    }

    public abstract MiningFunctionType getMiningFunctionType();

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        return arrayList;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        return arrayList;
    }

    @Override
    public List<PartitionExpressionType> getPartitionAttributes(RefModelType refModelType) {
        List<Object> list = new ArrayList<PartitionExpressionType>();
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        PartitionExpressions partitionExpressions = buildNodeType.getPartitionExpressions();
        if (partitionExpressions != null) {
            list = partitionExpressions.getPartitionExpression();
        }
        return list;
    }

    public AbstractDataNode findBuildDataNode(WorkflowModel workflowModel) {
        AbstractDataNode abstractDataNode = null;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource == null) {
            return null;
        }
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)generalLink.getFrom();
            if (!abstractDataNode2.getMetadataId().equals(buildDataSource.getSourceId())) continue;
            abstractDataNode = abstractDataNode2;
            break;
        }
        return abstractDataNode;
    }

    @Override
    public List<RefModelType> getOutputModels() {
        List<RefModelType> list = new ArrayList<RefModelType>();
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        Context context = this.getContext();
        try {
            if (buildNodeType != null) {
                list = MetaDataHelper.getModelsCollection(buildNodeType, context);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return list;
    }

    @Override
    public Object getProperty(String string) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        try {
            if (string.equals(CASE_ATTRIBUTES)) {
                return buildNodeType.getCaseAttributes();
            }
            if (string.equals(BUILD_DATA_SOURCE)) {
                return buildNodeType.getBuildDataSource();
            }
            if (string.equals(NODE_ATTRIBUTES)) {
                return buildNodeType.getMiningAttributes();
            }
            if (string.equals(TEXT_ATTRIBUTES)) {
                return buildNodeType.getTextAttributes();
            }
            if (string.equals(PARTITIONS_MAX_NUM)) {
                return buildNodeType.getMaxNumPartitions();
            }
            if (string.equals(PARTITIONS_EXPRESSION_EDIT)) {
                return buildNodeType.getPartitionExpressions();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(ALL_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(CASE_ID_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODELS_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODEL_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODEL_STATUS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(PARTITIONS_MAX_NUM)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(PARTITIONS_EXPRESSION_EDIT)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODEL_ANNOTATION)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getAnnotation());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MODEL_NAME)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getName());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MODEL_IDS)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelByName(buildNodeType, string);
                hashMap.put(string, modelType.getId());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MODEL_STATUSES)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MODEL_BUILD_DATES)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, XMLGregorianCalendar> hashMap = new HashMap<String, XMLGregorianCalendar>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getCreationDate());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MINING_ATTRIBUTE_SETTINGS)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, Pair> hashMap = new HashMap<String, Pair>(map.size());
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                Pair pair = (Pair)entry.getValue();
                MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute((String)pair.getFirst(), modelType);
                MiningAttributeType miningAttributeType2 = miningAttributeType != null ? MetaDataHelper.createMiningAttributeFrom((AttributeType)miningAttributeType) : null;
                hashMap.put(string, new Pair((Object)(miningAttributeType != null ? miningAttributeType2.getName() : (String)pair.getFirst()), (Object)miningAttributeType2));
            }
            return hashMap;
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public void setProperty(String string, Object object) {
        try {
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            if (string.equals(CASE_ATTRIBUTES)) {
                buildNodeType.setCaseAttributes((CaseAttributes)object);
            } else if (string.equals(ALL_ATTRIBUTES)) {
                List list = (List)object;
                BuildNodeType buildNodeType2 = (BuildNodeType)this.getData();
                MiningAttributes miningAttributes = buildNodeType2.getMiningAttributes();
                List list2 = miningAttributes.getMiningAttribute();
                list2.clear();
                list2.addAll(list);
            } else if (string.equals(BUILD_DATA_SOURCE)) {
                buildNodeType.setBuildDataSource((BuildDataSource)object);
            } else if (string.equals(NODE_ATTRIBUTES)) {
                buildNodeType.setMiningAttributes((MiningAttributes)object);
            } else if (string.equals(TEXT_ATTRIBUTES)) {
                buildNodeType.setTextAttributes((TransformedAttributesType)object);
            } else if (string.equals(PARTITIONS_MAX_NUM)) {
                buildNodeType.setMaxNumPartitions((BigInteger)object);
            } else if (string.equals(PARTITIONS_EXPRESSION_EDIT)) {
                PartitionExpressions partitionExpressions = (PartitionExpressions)object;
                buildNodeType.setPartitionExpressions(partitionExpressions);
            } else if (string.equals(MODELS_ATTRIBUTES)) {
                if (!(object instanceof Map)) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    return;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    ModelType modelType = (ModelType)entry.getKey();
                    List list = modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
                    list.clear();
                    list.addAll((Collection)entry.getValue());
                }
            } else if (string.equals(CASE_ID_ATTRIBUTES)) {
                List list = (List)object;
                BuildNodeType buildNodeType3 = (BuildNodeType)this.getData();
                CaseAttributes caseAttributes = buildNodeType3.getCaseAttributes();
                List list3 = caseAttributes.getAttribute();
                list3.clear();
                list3.addAll(list);
            } else if (string.equals(MODEL_STATUS)) {
                this.setModelStatus(object);
            } else if (string.equals(MODEL_ATTRIBUTES)) {
                this.setModelAttributes(object);
            } else if (string.equals(MODEL_ANNOTATION)) {
                if (!(object instanceof Map)) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    return;
                }
                BuildNodeType buildNodeType4 = (BuildNodeType)this.getData();
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string2 = (String)entry.getKey();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType4, string2);
                    if (modelType == null) continue;
                    modelType.setAnnotation((String)entry.getValue());
                }
            } else if (string.equals(MODEL_NAME)) {
                if (!(object instanceof Map)) {
                    return;
                }
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return;
                }
                BuildNodeType buildNodeType5 = (BuildNodeType)this.getData();
                for (Map.Entry entry : map.entrySet()) {
                    String string3 = (String)entry.getKey();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType5, string3);
                    if (modelType == null) continue;
                    modelType.setName((String)entry.getValue());
                }
            } else if (string.equals(MODEL_IDS)) {
                if (!(object instanceof Map)) {
                    return;
                }
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return;
                }
                BuildNodeType buildNodeType6 = (BuildNodeType)this.getData();
                for (Map.Entry entry : map.entrySet()) {
                    String string4 = (String)entry.getKey();
                    ModelType modelType = MetaDataHelper.findModelByName(buildNodeType6, string4);
                    if (modelType == null) continue;
                    modelType.setId((String)entry.getValue());
                }
            } else if (string.equals(MODEL_STATUSES)) {
                if (!(object instanceof Map)) {
                    return;
                }
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return;
                }
                BuildNodeType buildNodeType7 = (BuildNodeType)this.getData();
                for (Map.Entry entry : map.entrySet()) {
                    String string5 = (String)entry.getKey();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType7, string5);
                    if (modelType == null) continue;
                    modelType.setStatus((ModelStatusType)entry.getValue());
                }
            } else if (string.equals(MODEL_BUILD_DATES)) {
                if (!(object instanceof Map)) {
                    return;
                }
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return;
                }
                BuildNodeType buildNodeType8 = (BuildNodeType)this.getData();
                for (Map.Entry entry : map.entrySet()) {
                    String string6 = (String)entry.getKey();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType8, string6);
                    if (modelType == null) continue;
                    modelType.setCreationDate((XMLGregorianCalendar)entry.getValue());
                }
            } else if (string.equals(MINING_ATTRIBUTE_SETTINGS)) {
                if (!(object instanceof Map)) {
                    return;
                }
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return;
                }
                BuildNodeType buildNodeType9 = (BuildNodeType)this.getData();
                for (Map.Entry entry : map.entrySet()) {
                    String string7 = (String)entry.getKey();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType9, string7);
                    Pair pair = (Pair)entry.getValue();
                    MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute(((MiningAttributeType)pair.getSecond()).getName(), modelType);
                    if (miningAttributeType == null) continue;
                    miningAttributeType.setAutoPrep(((MiningAttributeType)pair.getSecond()).getAutoPrep());
                    miningAttributeType.setInput(((MiningAttributeType)pair.getSecond()).getInput());
                }
            } else {
                super.setProperty(string, object);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public static void applyRefactoredModels(Map<String, RefModelType> map, List<ModelType> list) {
        for (ModelType modelType : list) {
            RefModelType refModelType = map.get(modelType.getName());
            if (refModelType == null) continue;
            modelType.setName(refModelType.getName());
            modelType.setId(refModelType.getModelId());
            modelType.setCreationDate(null);
            modelType.setStatus(ModelStatusType.READY);
        }
    }

    private void setModelAttributes(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)this.getData(), subNodeProperty.getId());
        InputMiningData inputMiningData = modelType.getInputMiningData();
        inputMiningData.setMiningAttributes((MiningAttributes)subNodeProperty.getValue());
    }

    private void setModelStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)this.getData(), subNodeProperty.getId());
        modelType.setStatus((ModelStatusType)subNodeProperty.getValue());
    }

    private void initMiningAttributesInstance() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = new MiningAttributes();
        miningAttributes.setAutoSpec(AutoSpecType.fromValue((String)AutoSpecType.YES.value()));
        buildNodeType.setMiningAttributes(miningAttributes);
    }

    private void initCaseAttributesInstance() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        CaseAttributes caseAttributes = new CaseAttributes();
        buildNodeType.setCaseAttributes(caseAttributes);
    }

    private void initStoplistInstance(Context context) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        if (buildNodeType != null && buildNodeType.getStoplists() == null) {
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
            StoplistType stoplistType = AbstractTextNode.generateDefaultStoplist(context, arrayList);
            BuildNodeType.Stoplists stoplists = new BuildNodeType.Stoplists();
            stoplists.getStoplist().add(stoplistType);
            buildNodeType.setStoplists(stoplists);
        }
    }

    private void initTextSettingsInstance() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        if (buildNodeType != null && buildNodeType.getTextSettings() == null) {
            String string2;
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            BuildNodeType.TextSettings textSettings = new BuildNodeType.TextSettings();
            textSettings.setTransformType(buildTextPreferencesPanelSettings.getTransformType());
            textSettings.setCategoricalCutOffValue(buildTextPreferencesPanelSettings.getCategoricalCutoffValue());
            TransformationTokenType.Token token = new TransformationTokenType.Token();
            token.setPolicy("");
            TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
            TransformationTokenType.Token.Languages.Language language = null;
            ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
            for (String string2 : arrayList) {
                if (ServerConstants.StoplistLanguage.isALL(string2) || ServerConstants.StoplistLanguage.isNone(string2)) continue;
                language = new TransformationTokenType.Token.Languages.Language();
                language.setName(string2);
                if (ServerConstants.StoplistLanguage.isTraditionalChinese(string2) || ServerConstants.StoplistLanguage.isSimplifiedChinese(string2) || ServerConstants.StoplistLanguage.isJapanese(string2) || ServerConstants.StoplistLanguage.isKorean(string2)) {
                    language.setType("MultiByte");
                } else {
                    language.setType("SingleByte");
                }
                languages.getLanguage().add(language);
            }
            token.setLanguages(languages);
            LexerType lexerType = new LexerType();
            lexerType.setName("");
            string2 = null;
            if (languages.getLanguage().size() <= 1) {
                lexerType.setType("Basic");
                if (buildTextPreferencesPanelSettings.useStemming()) {
                    string2 = new LexerType.Settings.Attribute();
                    string2.setName("index_stems");
                    string2.setType("String");
                    string2.setValueString(((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName());
                }
            } else {
                lexerType.setType("Auto");
                if (buildTextPreferencesPanelSettings.useStemming()) {
                    string2 = new LexerType.Settings.Attribute();
                    string2.setName("index_stems");
                    string2.setType("String");
                    string2.setValueString("TRUE");
                }
            }
            token.setLexer(lexerType);
            LexerType.Settings settings = new LexerType.Settings();
            if (string2 != null) {
                settings.getAttribute().add(string2);
            }
            lexerType.setSettings(settings);
            token.setStoplistId(null);
            String string3 = buildTextPreferencesPanelSettings.getTokenStoplist();
            if (string3 != null && ServerConstants.StoplistLanguage.isDefault(string3)) {
                token.setStoplistId("1");
            }
            Integer n = buildTextPreferencesPanelSettings.getTokenMaxNumAllDocs();
            token.setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
            n = buildTextPreferencesPanelSettings.getTokenMaxNumPerDoc();
            token.setMaxNumberPerDoc(BigInteger.valueOf(n.intValue()));
            token.setFrequency("IDF");
            TransformationTokenType transformationTokenType = new TransformationTokenType();
            transformationTokenType.setToken(token);
            textSettings.setToken(transformationTokenType);
            token = new TransformationTokenType.Token();
            token.setPolicy("");
            languages = new TransformationTokenType.Token.Languages();
            language = null;
            String string4 = buildTextPreferencesPanelSettings.getThemeLanguages().get(0);
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(string4);
            language.setType("SingleByte");
            languages.getLanguage().add(language);
            token.setLanguages(languages);
            lexerType = new LexerType();
            lexerType.setName("");
            lexerType.setType("Basic");
            token.setLexer(lexerType);
            settings = new LexerType.Settings();
            string2 = new LexerType.Settings.Attribute();
            string2.setName("index_themes");
            string2.setType("String");
            string2.setValueString("YES");
            settings.getAttribute().add(string2);
            string2 = new LexerType.Settings.Attribute();
            string2.setName("theme_language");
            string2.setType("String");
            string2.setValueString("ENGLISH");
            settings.getAttribute().add(string2);
            lexerType.setSettings(settings);
            token.setStoplistId(null);
            string3 = buildTextPreferencesPanelSettings.getThemeStoplist();
            if (string3 != null && ServerConstants.StoplistLanguage.isDefault(string3)) {
                token.setStoplistId("1");
            }
            n = buildTextPreferencesPanelSettings.getThemeMaxNumAllDocs();
            token.setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
            n = buildTextPreferencesPanelSettings.getThemeMaxNumPerDoc();
            token.setMaxNumberPerDoc(BigInteger.valueOf(n.intValue()));
            token.setFrequency("IDF");
            BuildNodeType.TextSettings.Theme theme = new BuildNodeType.TextSettings.Theme();
            theme.setToken(token);
            theme.setType("Single");
            textSettings.setTheme(theme);
            buildNodeType.setTextSettings(textSettings);
            buildNodeType.setTextAttributes(new TransformedAttributesType());
        }
    }

    private MiningAttributes createMiningAttributesFrom(List<? extends AttributeType> list) {
        MiningAttributes miningAttributes = new MiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        for (AttributeType attributeType : list) {
            MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
            list2.add(miningAttributeType);
        }
        return miningAttributes;
    }

    private void initMiningAttributeInputs(MiningAttributes miningAttributes, ModelType modelType) {
        List list = miningAttributes.getMiningAttribute();
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        for (MiningAttributeType miningAttributeType : list) {
            if (AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, version).booleanValue()) continue;
            miningAttributeType.setInput("No");
        }
    }

    public static Boolean isInputAllowed(MiningAttributeType miningAttributeType, ModelType modelType, Version version) {
        assert (version != null);
        String string = miningAttributeType.getDataTypeQualifier();
        if (string != null && string.equalsIgnoreCase("JSON")) {
            return false;
        }
        String string2 = miningAttributeType.getDataType();
        if (string2.equals("NCHAR") || string2.equals("NVARCHAR2")) {
            return false;
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_0, version, false, 2) && (string2.equals("CLOB") || string2.equals("BLOB") || string2.equals("NCLOB") || string2.equals("BFILE"))) {
            return false;
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true) && DatabaseMetadataUtils.isTypeSupportedAsText(string2) && (modelType instanceof OClusterModelType || modelType instanceof AprioriModelType)) {
            if (DatabaseMetadataUtils.isLOBType(string2) || string2.equals("BFILE") || miningAttributeType.getMiningType().equals("Text")) {
                return false;
            }
            if ((string2.equals("VARCHAR2") || string2.equals("CHAR")) && (modelType instanceof SVDModelType || modelType instanceof PCAModelType && miningAttributeType.getMiningType().equals("Categorical"))) {
                return false;
            }
            return true;
        }
        if (modelType instanceof PCAModelType && miningAttributeType.getMiningType().equals("Categorical")) {
            return false;
        }
        if (string2.equals("VARCHAR2") || string2.equals("CHAR")) {
            if ((modelType instanceof SVDModelType || modelType instanceof PCAModelType) && miningAttributeType.getMiningType().equals("Categorical")) {
                return false;
            }
            return true;
        }
        if (DatabaseMetadataUtils.isNumericType(string2) || DatabaseMetadataUtils.isLOBType(string2) || string2.equals("BFILE")) {
            return true;
        }
        if (DatabaseMetadataUtils.isBinaryNumericType(string2) && ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
            return true;
        }
        if (DatabaseMetadataUtils.isNestedType(string2)) {
            if (DatabaseMetadataUtils.isNestedBinaryNumericType(string2) && !ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
                return false;
            }
            if (modelType instanceof OClusterModelType) {
                return false;
            }
            if (modelType instanceof DecisionTreeModelType) {
                if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
                    return true;
                }
                return false;
            }
            if (modelType instanceof SVDModelType || modelType instanceof PCAModelType) {
                if (DatabaseMetadataUtils.isNestedNumericType(string2)) {
                    return true;
                }
                return false;
            }
            return true;
        }
        if (string2.equals("DATE")) {
            return false;
        }
        return false;
    }

    protected boolean validateCaseAttributes(List<AttributeType> list) {
        AttributeType attributeType;
        boolean bl = true;
        CaseAttributes caseAttributes = ((BuildNodeType)this.getData()).getCaseAttributes();
        List list2 = caseAttributes.getAttribute();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list2.size());
        ArrayList<AttributeType> arrayList2 = new ArrayList<AttributeType>(list2.size());
        for (Object object2 : list2) {
            AttributeType object3 = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            arrayList.add(object3);
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            arrayList2.add(attributeType);
        }
        boolean bl2 = false;
        for (AttributeType attributeType2 : arrayList) {
            if (list == null) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                bl = false;
                continue;
            }
            attributeType = this.findCompatibleAttribute(attributeType2, list);
            if (null == attributeType) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_CASEIDS", MessageEnumType.INCOMPLETE, new String[0]);
                bl = false;
                continue;
            }
            if (!bl2) {
                bl2 = attributeType2.getStatus().equals((Object)AttributeStatus.INVALID);
            }
            attributeType2.setStatus(AttributeStatus.VALID);
        }
        if (!bl || bl2) {
            Object object2;
            object2 = new ComplexProperty(CASE_ID_ATTRIBUTES, arrayList);
            ((ComplexProperty)object2).setOldData(arrayList2);
            ((ComplexProperty)object2).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object2);
        }
        return bl;
    }

    protected boolean validatePartitionColumns(List<AttributeType> list) {
        boolean bl = true;
        if (((BuildNodeType)this.getData()).getPartitionExpressions() != null) {
            Object object3;
            PartitionExpressions partitionExpressions = new PartitionExpressions();
            PartitionExpressions partitionExpressions2 = new PartitionExpressions();
            for (Object object2 : ((BuildNodeType)this.getData()).getPartitionExpressions().getPartitionExpression()) {
                object3 = (PartitionExpressionType)MetaDataHelper.copyMetadataObject(object2);
                partitionExpressions.getPartitionExpression().add(object3);
                partitionExpressions2.getPartitionExpression().add(object3);
            }
            boolean bl2 = false;
            for (Object object3 : partitionExpressions.getPartitionExpression()) {
                if (list == null) {
                    if (object3.getSQLExpression() == null) {
                        object3.getPartitionAttribute().setStatus(AttributeStatus.INVALID);
                    }
                    bl = false;
                    continue;
                }
                if (object3.getSQLExpression() != null) continue;
                AttributeType attributeType = this.findCompatibleAttribute(object3.getPartitionAttribute(), list);
                if (null == attributeType) {
                    object3.getPartitionAttribute().setStatus(AttributeStatus.INVALID);
                    this.addMessage("BUILD_INVALID_PARTITION_ATTRS", MessageEnumType.INCOMPLETE, new String[0]);
                    bl = false;
                    continue;
                }
                if (!bl2) {
                    bl2 = object3.getPartitionAttribute().getStatus().equals((Object)AttributeStatus.INVALID);
                }
                object3.getPartitionAttribute().setStatus(AttributeStatus.VALID);
            }
            if (!bl || bl2) {
                Object object2;
                object2 = new ComplexProperty(PARTITIONS_EXPRESSION_EDIT, partitionExpressions);
                ((ComplexProperty)object2).setOldData(partitionExpressions2);
                ((ComplexProperty)object2).setForceUpdate(true);
                object3 = (OdmrSDMUndoFilter)this.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object3)).prepareUndo(this, this.getContext(), (ComplexProperty)object2);
            }
        }
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (!(node instanceof AbstractDataNode) || node instanceof BuildTextNodeRef) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.handleBuildDataSourceConnected(node);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        List<GeneralLink> list;
        super.handleRemoveConnectionFrom(node);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource != null && buildDataSource.getSourceId().equals(node.getMetadataId()) && node.getMetadataId().equals(buildDataSource.getSourceId())) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
        }
        if ((list = this.getModel().findLinksToNode((IlvSDMNode)this)).size() == 1) {
            Node node2 = (Node)list.get(0).getFrom();
            this.handleBuildDataSourceConnected(node2);
        }
    }

    private void handleBuildDataSourceConnected(Node node) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list2 = attributes.getAttribute();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource == null) {
            buildDataSource = new BuildDataSource();
            buildDataSource.setSourceId(node.getMetadataId());
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, buildDataSource);
            if (list.size() == 0) {
                MiningAttributes miningAttributes2 = this.createMiningAttributesFrom(list2);
                miningAttributes2.setAutoSpec(miningAttributes.getAutoSpec());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, miningAttributes2);
                List<ModelType> list3 = MetaDataHelper.getModelsCollection(buildNodeType);
                for (ModelType modelType : list3) {
                    MiningAttributes miningAttributes3 = modelType.getInputMiningData().getMiningAttributes();
                    MiningAttributes miningAttributes4 = this.createMiningAttributesFrom(miningAttributes2.getMiningAttribute());
                    this.initMiningAttributeInputs(miningAttributes4, modelType);
                    ComplexProperty complexProperty = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(modelType.getId(), miningAttributes4));
                    complexProperty.setOldData(new SubNodeProperty(modelType.getId(), miningAttributes3));
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
                }
            }
        }
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        TestDataSource.BuildData buildData;
        TestDataSource testDataSource;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ++this.refactorInvokeCount;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
            object4 = null;
            object3 = buildNodeType.getBuildDataSource();
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object4 = ((SuperviseBuildNodeType)buildNodeType).getTestDataSource();
            }
            if ((object2 = ((AbstractNode)node).getOldId()) != null && ((String)object2).equals(object3.getSourceId())) {
                object = MetaDataHelper.copyBuildDataSource((BuildDataSource)object3);
                object.setSourceId(node.getMetadataId());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, object);
                if (list.size() == 1 && object4 != null) {
                    testDataSource = new TestDataSource();
                    if (object4.getBuildData() != null) {
                        buildData = new TestDataSource.BuildData();
                        testDataSource.setBuildData(buildData);
                    } else if (object4.getSplitData() != null) {
                        buildData = new TestDataSource.SplitData();
                        buildData.setTestPercent(object4.getSplitData().getTestPercent());
                        buildData.setDataFormat(object4.getSplitData().getDataFormat());
                        testDataSource.setSplitData((TestDataSource.SplitData)buildData);
                    } else if (object4.getTestData() != null) {
                        buildData = new TestDataSource.TestData();
                        buildData.setSourceId(object4.getTestData().getSourceId());
                        testDataSource.setTestData((TestDataSource.TestData)buildData);
                    } else {
                        buildData = new TestDataSource.SplitData();
                        buildData.setTestPercent(50.0);
                        testDataSource.setSplitData((TestDataSource.SplitData)buildData);
                    }
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testData", testDataSource);
                }
            } else if (object4 != null && object2 != null && ((String)object2).equals(object4.getTestData().getSourceId())) {
                object = MetaDataHelper.copyTestDataSource((TestDataSource)object4);
                object.getTestData().setSourceId(node.getMetadataId());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testData", object);
                if (list.size() == 1 && object4 != null) {
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
                }
            }
        } else {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object4 = (SuperviseBuildNodeType)buildNodeType;
                object3 = object4.getTestDataSource();
                object2 = MetaDataHelper.copyTestDataSource((TestDataSource)object3);
                object2.setTestData(null);
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testData", object2);
            }
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            object4 = this.getOutputModels();
            object3 = WorkflowUtils.refactorModels(this.getContext(), (List<RefModelType>)object4, this.getModel(), bl);
            object2 = new HashMap();
            object = new HashMap();
            testDataSource = new HashMap();
            buildData = new HashMap();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap<String, ModelStatusType> hashMap3 = new HashMap<String, ModelStatusType>();
            HashMap<String, XMLGregorianCalendar> hashMap4 = new HashMap<String, XMLGregorianCalendar>();
            for (Map.Entry entry : object3.entrySet()) {
                String string = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelByName(buildNodeType, string);
                RefModelType refModelType = (RefModelType)entry.getValue();
                hashMap.put(modelType.getId(), modelType.getName());
                hashMap2.put(refModelType.getName(), modelType.getId());
                hashMap3.put(refModelType.getModelId(), modelType.getStatus());
                hashMap4.put(refModelType.getModelId(), modelType.getCreationDate());
                object2.put(modelType.getId(), refModelType.getName());
                object.put(refModelType.getName(), refModelType.getModelId());
                testDataSource.put(refModelType.getModelId(), ModelStatusType.READY);
                buildData.put(refModelType.getModelId(), null);
            }
            Object object5 = new ComplexProperty(MODEL_NAME, object2);
            ((ComplexProperty)object5).setOldData(hashMap);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            object5 = new ComplexProperty(MODEL_IDS, object);
            ((ComplexProperty)object5).setOldData(hashMap2);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            object5 = new ComplexProperty(MODEL_STATUSES, testDataSource);
            ((ComplexProperty)object5).setOldData(hashMap3);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            object5 = new ComplexProperty(MODEL_BUILD_DATES, buildData);
            ((ComplexProperty)object5).setOldData(hashMap4);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object5);
            this.refactorChildModelReferences((Map<String, RefModelType>)object3, bl);
        }
    }

    public void refactorChildModelReferences(Map<String, RefModelType> map) throws Exception {
        this.refactorChildModelReferences(map, false);
    }

    public void refactorChildModelReferences(Map<String, RefModelType> map, boolean bl) throws Exception {
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode instanceof ModelConsumer) {
                ((ModelConsumer)((Object)abstractNode)).refactorModelReferences(this, map, bl);
            }
            abstractNode.refactor(this, bl);
        }
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        if (!map.isEmpty()) {
            AttributeType attributeType;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            AttributeType attributeType2;
            MiningAttributeType miningAttributeType;
            Object object5;
            Object object6;
            String string;
            BuildNodeType buildNodeType;
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (this instanceof SupervisedBuildNode) {
                buildNodeType = (BuildNodeType)this.getData();
                BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
                string = buildDataSource.getSourceId();
                object6 = ((AbstractNode)node).getOldId();
                object5 = this.findBuildDataNode(this.getModel());
                if (object5 != node && object6 != null && !string.equals(object6)) {
                    return;
                }
            }
            buildNodeType = (BuildNodeType)this.getData();
            boolean bl = false;
            string = MetaDataHelper.copyMiningAttributes(buildNodeType.getMiningAttributes());
            object6 = string.getMiningAttribute();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                miningAttributeType = (MiningAttributeType)object5.next();
                attributeType2 = map.get(miningAttributeType.getName());
                if (attributeType2 == null) continue;
                bl = true;
                miningAttributeType.setName(attributeType2.getName());
                miningAttributeType.setDataType(attributeType2.getDataType());
                miningAttributeType.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
            }
            if (bl) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, string);
            }
            boolean bl2 = false;
            miningAttributeType = buildNodeType.getTextAttributes();
            if (miningAttributeType != null) {
                attributeType2 = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(miningAttributeType);
                object4 = attributeType2.getMapTextTransformedSource();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (MapTextTransformedSourceType)object3.next();
                    object = map.get(object2.getKey().getName());
                    if (object == null) continue;
                    bl2 = true;
                    object2.getKey().setName(object.getName());
                    object2.getKey().setSource(object.getName());
                    object2.getKey().setDataType(object.getDataType());
                }
                if (bl2) {
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEXT_ATTRIBUTES, attributeType2);
                }
            }
            boolean bl3 = false;
            object4 = MetaDataHelper.copyCaseAttributes(buildNodeType.getCaseAttributes());
            object3 = object4.getAttribute();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (AttributeType)object2.next();
                attributeType = map.get(object.getName());
                if (attributeType == null) continue;
                bl3 = true;
                object.setName(attributeType.getName());
                object.setDataType(attributeType.getDataType());
                object.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            }
            if (bl3) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), CASE_ATTRIBUTES, object4);
            }
            object2 = MetaDataHelper.getModelsCollection(buildNodeType);
            object = object2.iterator();
            while (object.hasNext()) {
                attributeType = (ModelType)object.next();
                boolean bl4 = false;
                if (attributeType instanceof AprioriModelType) continue;
                MiningAttributes miningAttributes = MetaDataHelper.copyMiningAttributes(attributeType.getInputMiningData().getMiningAttributes());
                MiningAttributes miningAttributes2 = MetaDataHelper.copyMiningAttributes(attributeType.getInputMiningData().getMiningAttributes());
                List list = miningAttributes2.getMiningAttribute();
                for (MiningAttributeType miningAttributeType2 : list) {
                    AttributeType attributeType3 = map.get(miningAttributeType2.getName());
                    if (attributeType3 == null) continue;
                    bl4 = true;
                    miningAttributeType2.setName(attributeType3.getName());
                    miningAttributeType2.setDataType(attributeType3.getDataType());
                    miningAttributeType2.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                }
                if (!bl4) continue;
                ComplexProperty complexProperty = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(attributeType.getId(), miningAttributes2));
                complexProperty.setOldData(new SubNodeProperty(attributeType.getId(), miningAttributes));
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
            }
        }
    }

    protected abstract boolean validateImpl(boolean var1, boolean var2);

    public boolean validateAfterEdit() {
        return this.validateImpl(true, false);
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        AttributeType attributeType;
        Object object2;
        Object object3;
        MiningAttributeType miningAttributeType2;
        Object object42;
        boolean bl2 = super.validate(bl);
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>(list.size());
        ArrayList<MiningAttributeType> arrayList2 = new ArrayList<MiningAttributeType>(list.size());
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildNodeType.getTextAttributes());
        for (Object object42 : list) {
            miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object42);
            arrayList.add(miningAttributeType2);
            object3 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object42);
            arrayList2.add((MiningAttributeType)object3);
        }
        HashMap hashMap = new HashMap();
        for (MiningAttributeType miningAttributeType2 : arrayList) {
            hashMap.put(miningAttributeType2.getName(), miningAttributeType2);
        }
        object42 = this.findBuildDataNode(this.getModel());
        if (object42 == null) {
            this.validateDisconnectedNode(arrayList, miningAttributes.getAutoSpec(), transformedAttributesType);
            return false;
        }
        miningAttributeType2 = ((DataProvider)object42).getAttributes();
        object3 = miningAttributeType2.getAttribute();
        boolean bl3 = false;
        Iterator iterator = arrayList.iterator();
        block2: while (iterator.hasNext()) {
            MapTextTransformedSourceType mapTextTransformedSourceType;
            Iterator iterator2;
            object2 = (MiningAttributeType)iterator.next();
            attributeType = this.findCompatibleAttribute((AttributeType)object2, (List<? extends AttributeType>)object3);
            if (null == attributeType) {
                iterator.remove();
                hashMap.remove(object2.getName());
                bl3 = true;
                if (transformedAttributesType == null) continue;
                object = transformedAttributesType.getMapTextTransformedSource();
                iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator2.next();
                    if (!mapTextTransformedSourceType.getKey().getName().equals(object2.getName())) continue;
                    object.remove(mapTextTransformedSourceType);
                    continue block2;
                }
                continue;
            }
            if (!object2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            object2.setStatus(AttributeStatus.VALID);
            bl3 = true;
            if (transformedAttributesType == null) continue;
            object = transformedAttributesType.getMapTextTransformedSource();
            iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator2.next();
                if (!mapTextTransformedSourceType.getKey().getName().equals(object2.getName())) continue;
                mapTextTransformedSourceType.getKey().setStatus(AttributeStatus.VALID);
                continue block2;
            }
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            attributeType = (AttributeType)object2.next();
            object = (MiningAttributeType)hashMap.get(attributeType.getName());
            if (object != null) continue;
            arrayList.add(MetaDataHelper.createMiningAttributeFrom(attributeType));
        }
        if (!bl2 || bl3 || arrayList2.size() != arrayList.size()) {
            object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
            attributeType = new MiningAttributes();
            attributeType.getMiningAttribute().addAll(arrayList);
            attributeType.setAutoSpec(miningAttributes.getAutoSpec());
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, attributeType);
            if (transformedAttributesType != null) {
                ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), TEXT_ATTRIBUTES, transformedAttributesType);
            }
        }
        if (!this.validateCaseAttributes((List<AttributeType>)object3)) {
            bl2 = false;
        }
        if (!this.validatePartitionColumns((List<AttributeType>)object3)) {
            bl2 = false;
        }
        return bl2;
    }

    private void validateDisconnectedNode(List<MiningAttributeType> list, AutoSpecType autoSpecType, TransformedAttributesType transformedAttributesType) {
        MiningAttributes miningAttributes2;
        this.addMessage("BUILD_NO_BUILD_DATA", MessageEnumType.WARNING, new String[0]);
        for (MiningAttributeType object2 : list) {
            object2.setStatus(AttributeStatus.INVALID);
        }
        if (transformedAttributesType != null) {
            for (MiningAttributes miningAttributes2 : transformedAttributesType.getMapTextTransformedSource()) {
                miningAttributes2.getKey().setStatus(AttributeStatus.VALID);
            }
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        miningAttributes2 = new MiningAttributes();
        miningAttributes2.getMiningAttribute().addAll(list);
        miningAttributes2.setAutoSpec(autoSpecType);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, miningAttributes2);
        if (transformedAttributesType != null) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEXT_ATTRIBUTES, transformedAttributesType);
        }
        this.validateCaseAttributes(null);
        this.validatePartitionColumns(null);
    }

    public boolean validateModels(List<? extends ModelType> list) {
        boolean bl = true;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (ModelType modelType : list) {
            Object object;
            Object object2;
            Object object32;
            boolean bl2 = false;
            boolean bl3 = false;
            MiningAttributes miningAttributes2 = modelType.getInputMiningData().getMiningAttributes();
            if (miningAttributes2 == null) {
                bl = false;
                continue;
            }
            MiningAttributes miningAttributes3 = MetaDataHelper.copyMiningAttributes(miningAttributes2);
            List list3 = miningAttributes3.getMiningAttribute();
            HashMap<String, MiningAttributeType> hashMap2 = new HashMap<String, MiningAttributeType>();
            AttributeType attributeType = this.getTargetAttribute();
            for (Object object32 : list3) {
                hashMap2.put(object32.getName(), (MiningAttributeType)object32);
            }
            if (list3 != null && !list3.isEmpty()) {
                bl = false;
                for (Object object32 : list3) {
                    if (!"Yes".equals(object32.getInput()) || attributeType != null && (attributeType == null || object32.getName().equals(attributeType.getName()))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.addMessage("BUILD_INVALID_MODEL_MISSING_INPUT", MessageEnumType.INCOMPLETE, modelType.getName());
                    continue;
                }
            }
            for (Object object32 : list2) {
                object2 = (MiningAttributeType)hashMap2.get(object32.getName());
                if (null == object2) {
                    object = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object32);
                    object.setInput(((MiningAttributeType)hashMap.get(object32.getName())).getInput());
                    list3.add(object);
                    bl3 = true;
                    continue;
                }
                if (!object32.getDataType().equals(object2.getDataType()) || object32.getStatus().equals((Object)AttributeStatus.INVALID)) {
                    if (MetaDataHelper.isAutomatic(modelType)) continue;
                    object2.setStatus(AttributeStatus.INVALID);
                    bl2 = true;
                    bl3 = true;
                    continue;
                }
                if (object32.getAlias() == null || !object32.getAlias().equals(object2.getAlias())) continue;
                object2.setAlias(object32.getAlias());
                bl3 = true;
            }
            Iterator iterator = list3.iterator();
            object32 = this.findBuildDataNode(this.getModel());
            while (iterator.hasNext()) {
                object2 = (MiningAttributeType)iterator.next();
                if (object32 == null) {
                    object2.setStatus(AttributeStatus.INVALID);
                    bl3 = true;
                    continue;
                }
                object = (MiningAttributeType)hashMap.get(object2.getName());
                if (null == object) {
                    iterator.remove();
                    bl3 = true;
                    continue;
                }
                if (!object2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                object2.setStatus(AttributeStatus.VALID);
                bl3 = true;
            }
            if (bl2) {
                bl = false;
                this.addMessage("BUILD_INVALID_MODEL", MessageEnumType.WARNING, modelType.getName());
            }
            if (!bl3) continue;
            object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
            object = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(modelType.getId(), miningAttributes3));
            ((ComplexProperty)object).setOldData(new SubNodeProperty(modelType.getId(), miningAttributes2));
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    public String getStackSQLExpression(SQLContext sQLContext, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        String string2 = abstractDataNode.getInputSQL(true, false);
        stringBuffer.append(string2 + ",\n");
        String string3 = StringUtils.addDoubleQuotes("N$" + abstractDataNode.getMetadataId());
        String string4 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(sQLContext.getName()));
        stringBuffer.append(this.getNodeNameForSQLExpression(true) + " as (" + "SELECT (\n" + string + "\n) " + string4 + " FROM " + string3 + ")\n");
        stringBuffer.append("SELECT * FROM " + this.getNodeNameForSQLExpression(true));
        stringBuffer.insert(0, "WITH ");
        return stringBuffer.toString();
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            String string;
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            stringBuffer.setLength(0);
            if (buildNodeType.getCaseAttributes() != null && !buildNodeType.getCaseAttributes().getAttribute().isEmpty() && buildNodeType.getCaseAttributes().getAttribute().size() == 1) {
                String string2 = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
                Object object = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getDataType();
                if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(version, DatabaseMetadataUtils.getJSONDataType((String)object, string = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getDataTypeQualifier()))) {
                    Object[] objectArray = new Object[]{string2, DatabaseMetadataUtils.getJSONDataType((String)object, string)};
                    stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_CASEID_DATA_TYPE_NOT_SUPPORTED"), objectArray));
                    return false;
                }
            }
            for (Object object : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                if (!"Yes".equals(object.getInput())) continue;
                string = object.getName();
                if (!object.getMiningType().equals("Text") && !object.getMiningType().equals("TextCustom") || ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) continue;
                Object[] objectArray = new Object[]{string, object.getMiningType()};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_ATTR_MINING_TYPE_NOT_SUPPORTED"), objectArray));
                return false;
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return true;
    }

    protected String generateTextSettingsCode(Context context) {
        List list;
        List list2;
        Object object;
        Object object22;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object22 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
            if (!"Yes".equals(object22.getInput()) && !"Force".equals(object22.getInput())) continue;
            if (object22.getMiningType().equals("Text")) {
                bl = true;
            }
            if (object22.getMiningType().equals("TextCustom")) {
                arrayList.add(object22.getName());
            }
            if (!object22.getDataType().equals("BFILE") && !object22.getDataType().equals("BLOB")) continue;
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            boolean bl3;
            String string = buildNodeType.getTextSettings().getTransformType();
            if ("Token".equals(string)) {
                object = buildNodeType.getTextSettings().getToken().getToken().getMaxNumberAllDocs();
                object22 = buildNodeType.getTextSettings().getToken().getToken().getStoplistId();
                list2 = buildNodeType.getTextSettings().getToken().getToken().getLanguages().getLanguage();
                list = buildNodeType.getTextSettings().getToken().getToken().getLexer().getSettings().getAttribute();
            } else {
                object = buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberAllDocs();
                object22 = buildNodeType.getTextSettings().getTheme().getToken().getStoplistId();
                list2 = buildNodeType.getTextSettings().getTheme().getToken().getLanguages().getLanguage();
                list = buildNodeType.getTextSettings().getTheme().getToken().getLexer().getSettings().getAttribute();
            }
            boolean bl4 = false;
            for (Object object3 : list) {
                if (!"index_stems".equals(object3.getName())) continue;
                bl4 = true;
                break;
            }
            stringBuffer.append("  v_policy_name := generateUniqueName; \n");
            stringBuffer.append("  v_lexer_name := generateUniqueName; \n");
            if (bl2) {
                stringBuffer.append("  v_auto_filter_name := (SUBSTR(v_lexer_name, 1, 28)||'_F'); \n");
            }
            boolean bl5 = bl3 = list2.size() > 1 || bl4;
            if (bl3) {
                stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'AUTO_LEXER'); \n");
            } else if ("TRADITIONAL CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName()) || "SIMPLIFIED CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'CHINESE_LEXER'); \n");
            } else if ("JAPANESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'JAPANESE_LEXER'); \n");
            } else if ("KOREAN".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'KOREAN_MORPH_LEXER'); \n");
            } else {
                stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'BASIC_LEXER'); \n");
            }
            stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_lexer_name, 'LEXER', 'Policy='||v_policy_name, 'Lexer'); \n");
            if (bl2) {
                stringBuffer.append("  ctx_ddl.create_preference(v_auto_filter_name, 'AUTO_FILTER'); \n");
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_auto_filter_name, 'AUTOFILTER', 'Policy='||v_policy_name, 'Auto Filter'); \n");
            }
            for (Object object4 : list) {
                if ("index_stems".equals(object4.getName())) {
                    if (bl3) {
                        stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object4.getName() + "', 'YES'); \n");
                        continue;
                    }
                    stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object4.getName() + "', '" + ((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName() + "'); \n");
                    continue;
                }
                if ("String".equals(object4.getType())) {
                    stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object4.getName() + "', '" + object4.getValueString() + "'); \n");
                    continue;
                }
                stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object4.getName() + "', " + object4.getValueNumber() + "); \n");
            }
            if (object22 != null) {
                Object object3;
                stringBuffer.append("  v_stoplist_name := generateUniqueName; \n");
                if (bl3) {
                    stringBuffer.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'MULTI_STOPLIST'); \n");
                } else {
                    stringBuffer.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'BASIC_STOPLIST'); \n");
                }
                object3 = new HashMap();
                for (TransformationTokenType.Token.Languages.Language language : list2) {
                    object3.put(language.getName().toUpperCase(), Boolean.TRUE);
                }
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_stoplist_name, 'STOPLIST', 'Policy='||v_policy_name, 'Stoplist'); \n");
                for (TransformationTokenType.Token.Languages.Language language : buildNodeType.getStoplists().getStoplist()) {
                    if (!language.getId().equals(object22)) continue;
                    for (Object object52 : language.getStopTokens().getToken()) {
                        if (!object3.containsKey(object52.getLanguage().toUpperCase()) && !"ALL".equals(object52.getLanguage().toUpperCase())) continue;
                        if ("Token".equals(string) && "Word".equals(object52.getType())) {
                            if (bl3) {
                                stringBuffer.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(object52.getItem()) + "', '" + object52.getLanguage() + "'); \n");
                            } else {
                                stringBuffer.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(object52.getItem()) + "'); \n");
                            }
                        }
                        if (!"Theme".equals(string) || !"Theme".equals(object52.getType())) continue;
                        stringBuffer.append("  ctx_ddl.add_stoptheme(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(object52.getItem()) + "'); \n");
                    }
                }
                if (bl2) {
                    stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                } else {
                    stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                }
            } else if (bl2) {
                stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name); \n");
            } else {
                stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name); \n");
            }
            stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_policy_name, 'POLICY', NULL, 'Policy'); \n");
        }
        for (String string : arrayList) {
            bl2 = false;
            for (Object object3 : buildNodeType.getTextAttributes().getMapTextTransformedSource()) {
                boolean bl6;
                Object object52;
                Object object4;
                if (!object3.getKey().getName().equals(string)) continue;
                object4 = object3.getKey().getTransformationElement();
                if (object3.getKey().getDataType().equals("BFILE") || object3.getKey().getDataType().equals("BLOB")) {
                    bl2 = true;
                }
                if (object4.getToken() != null) {
                    object = object4.getToken().getToken().getMaxNumberAllDocs();
                    object22 = object4.getToken().getToken().getStoplistId();
                    list2 = object4.getToken().getToken().getLanguages().getLanguage();
                    list = object4.getToken().getToken().getLexer().getSettings().getAttribute();
                } else {
                    object = object4.getTheme().getToken().getMaxNumberAllDocs();
                    object22 = object4.getTheme().getToken().getStoplistId();
                    list2 = object4.getTheme().getToken().getLanguages().getLanguage();
                    list = object4.getTheme().getToken().getLexer().getSettings().getAttribute();
                }
                boolean bl7 = false;
                for (Object object52 : list) {
                    if (!"index_stems".equals(object52.getName())) continue;
                    bl7 = true;
                    break;
                }
                stringBuffer.append("  v_policy_name := generateUniqueName; \n");
                stringBuffer.append("  v_lexer_name := generateUniqueName; \n");
                if (bl2) {
                    stringBuffer.append("  v_auto_filter_name := (SUBSTR(v_lexer_name, 1, 28)||'_F'); \n");
                }
                boolean bl8 = bl6 = list2.size() > 1 || bl7;
                if (bl6) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'AUTO_LEXER'); \n");
                } else if ("TRADITIONAL CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName()) || "SIMPLIFIED CHINESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'CHINESE_LEXER'); \n");
                } else if ("JAPANESE".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'JAPANESE_LEXER'); \n");
                } else if ("KOREAN".equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'KOREAN_MORPH_LEXER'); \n");
                } else {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'BASIC_LEXER'); \n");
                }
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_lexer_name, 'LEXER', 'Policy='||v_policy_name, 'Lexer'); \n");
                if (bl2) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_auto_filter_name, 'AUTO_FILTER'); \n");
                    stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_auto_filter_name, 'AUTOFILTER', 'Policy='||v_policy_name, 'Auto Filter'); \n");
                }
                object52 = list.iterator();
                while (object52.hasNext()) {
                    LexerType.Settings.Attribute attribute = (LexerType.Settings.Attribute)object52.next();
                    if ("index_stems".equals(attribute.getName())) {
                        if (bl6) {
                            stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + attribute.getName() + "', 'YES'); \n");
                            continue;
                        }
                        stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + attribute.getName() + "', '" + ((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName() + "'); \n");
                        continue;
                    }
                    if ("String".equals(attribute.getType())) {
                        stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + attribute.getName() + "', '" + attribute.getValueString() + "'); \n");
                        continue;
                    }
                    stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + attribute.getName() + "', " + attribute.getValueNumber() + "); \n");
                }
                if (object22 != null) {
                    stringBuffer.append("  v_stoplist_name := generateUniqueName; \n");
                    if (bl6) {
                        stringBuffer.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'MULTI_STOPLIST'); \n");
                    } else {
                        stringBuffer.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'BASIC_STOPLIST'); \n");
                    }
                    object52 = new HashMap();
                    for (TransformationTokenType.Token.Languages.Language language : list2) {
                        object52.put(language.getName().toUpperCase(), Boolean.TRUE);
                    }
                    stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_stoplist_name, 'STOPLIST', 'Policy='||v_policy_name, 'Stoplist'); \n");
                    for (TransformationTokenType.Token.Languages.Language language : buildNodeType.getStoplists().getStoplist()) {
                        if (!language.getId().equals(object22)) continue;
                        for (StoplistType.StopTokens.Token token : language.getStopTokens().getToken()) {
                            if (!object52.containsKey(token.getLanguage().toUpperCase()) && !"ALL".equals(token.getLanguage().toUpperCase())) continue;
                            if (object4.getToken() != null && "Word".equals(token.getType())) {
                                if (bl6) {
                                    stringBuffer.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(token.getItem()) + "', '" + token.getLanguage() + "'); \n");
                                } else {
                                    stringBuffer.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(token.getItem()) + "'); \n");
                                }
                            }
                            if (object4.getToken() != null || !"Theme".equals(token.getType())) continue;
                            stringBuffer.append("  ctx_ddl.add_stoptheme(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(token.getItem()) + "'); \n");
                        }
                    }
                    if (bl2) {
                        stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                    } else {
                        stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                    }
                } else if (bl2) {
                    stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name); \n");
                } else {
                    stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name); \n");
                }
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_policy_name, 'POLICY', 'Column=" + string + "', 'Policy'); \n");
            }
        }
        return stringBuffer.toString();
    }

    protected boolean generateDataUsageCode(Version version, BuildNodeType buildNodeType, ModelType modelType, AttributeType attributeType, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        stringBuffer2.append("  v_xlst := dbms_data_mining_transform.TRANSFORM_LIST(); \n");
        String string = "        ";
        String string2 = null;
        if (attributeType != null) {
            string2 = attributeType.getName();
        }
        boolean bl = false;
        List list = modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
        for (int i = 0; i < list.size(); ++i) {
            MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(i);
            if ("Yes".equals(miningAttributeType.getInput())) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append(string + StringUtils.addDoubleQuotes(miningAttributeType.getName()));
            }
            if (!"Yes".equals(miningAttributeType.getInput()) && !"Force".equals(miningAttributeType.getInput())) continue;
            boolean bl2 = false;
            String string3 = null;
            string3 = ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_2, version, true) ? StringUtils.addDoubleQuotes(miningAttributeType.getName()) : StringUtils.escapeSingleQuotesForSQL(miningAttributeType.getName());
            String string4 = null;
            String string5 = string3;
            String string6 = string3;
            StringBuffer stringBuffer3 = new StringBuffer();
            if ("No".equals(miningAttributeType.getAutoPrep())) {
                stringBuffer3.append("NOPREP");
                if ((miningAttributeType.getDataType().equals("DM_NESTED_NUMERICALS") || miningAttributeType.getDataType().equals("DM_NESTED_CATEGORICALS") || miningAttributeType.getDataType().equals("DM_NESTED_BINARY_DOUBLES") || miningAttributeType.getDataType().equals("DM_NESTED_BINARY_FLOATS")) && ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_3, version, true)) {
                    string3 = null;
                    string4 = StringUtils.escapeSingleQuotesForSQL(miningAttributeType.getName());
                    string5 = "value";
                    string6 = "value";
                }
                bl2 = true;
            } else {
                bl = true;
            }
            if (string2 == null || !string2.equals(miningAttributeType.getName())) {
                TextTransformationType textTransformationType;
                Object object;
                Object object2;
                Object object3;
                if (miningAttributeType.getDataType().equals("NUMBER") && miningAttributeType.getMiningType().equals("Categorical")) {
                    string5 = "TO_CHAR(" + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + ")";
                    string6 = null;
                    bl2 = true;
                }
                if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true) && (miningAttributeType.getDataType().equals("NVARCHAR2") || miningAttributeType.getDataType().equals("NCHAR") || miningAttributeType.getDataType().equals("VARCHAR2") || miningAttributeType.getDataType().equals("CHAR")) && miningAttributeType.getMiningType().equals("Categorical")) {
                    string5 = "SUBSTRB(" + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + ", 1, 4000)";
                    string6 = null;
                    bl2 = true;
                }
                if ("Force".equals(miningAttributeType.getInput())) {
                    if (stringBuffer3.length() > 0) {
                        stringBuffer3.append(",");
                    }
                    stringBuffer3.append("FORCE_IN");
                    bl2 = true;
                }
                if (miningAttributeType.getMiningType().equals("Text")) {
                    Object object4;
                    if (stringBuffer3.length() > 0) {
                        stringBuffer3.append(",");
                    }
                    object3 = "NORMAL";
                    object2 = buildNodeType.getTextSettings().getTransformType();
                    if ("Token".equals(object2)) {
                        object4 = buildNodeType.getTextSettings().getToken().getToken().getMaxNumberAllDocs();
                        Object object5 = buildNodeType.getTextSettings().getToken().getToken().getLexer().getSettings().getAttribute();
                        object = object5.iterator();
                        while (object.hasNext()) {
                            textTransformationType = (LexerType.Settings.Attribute)object.next();
                            if (!"index_stems".equals(textTransformationType.getName())) continue;
                            object3 = "STEM";
                            break;
                        }
                    } else {
                        object4 = buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberAllDocs();
                        object3 = "THEME";
                    }
                    stringBuffer3.append("TEXT(POLICY_NAME:'||getTextPolicy('" + buildNodeType.getId() + "')||')(MAX_FEATURES:" + ((BigInteger)object4).intValue() + ")(TOKEN_TYPE:" + (String)object3 + ")");
                    bl2 = true;
                }
                if (miningAttributeType.getMiningType().equals("TextCustom")) {
                    if (stringBuffer3.length() > 0) {
                        stringBuffer3.append(",");
                    }
                    for (Object object5 : buildNodeType.getTextAttributes().getMapTextTransformedSource()) {
                        object = "NORMAL";
                        if (!object5.getKey().getName().equals(miningAttributeType.getName())) continue;
                        textTransformationType = object5.getKey().getTransformationElement();
                        if (textTransformationType.getToken() != null) {
                            object3 = textTransformationType.getToken().getToken().getMaxNumberAllDocs();
                            object2 = textTransformationType.getToken().getToken().getLexer().getSettings().getAttribute();
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                LexerType.Settings.Attribute attribute = (LexerType.Settings.Attribute)iterator.next();
                                if (!"index_stems".equals(attribute.getName())) continue;
                                object = "STEM";
                                break;
                            }
                        } else {
                            object3 = textTransformationType.getTheme().getToken().getMaxNumberAllDocs();
                            object = "THEME";
                        }
                        stringBuffer3.append("TEXT(POLICY_NAME:'||getTextPolicy('" + buildNodeType.getId() + "', '" + miningAttributeType.getName() + "')||')(MAX_FEATURES:" + ((BigInteger)object3).intValue() + ")(TOKEN_TYPE:" + (String)object + ")");
                        bl2 = true;
                        break;
                    }
                }
            }
            if (!bl2) continue;
            stringBuffer2.append("  DBMS_DATA_MINING_TRANSFORM.SET_TRANSFORM(v_xlst, " + (string3 == null ? "NULL" : "'" + string3 + "'") + ", " + (string4 == null ? "NULL" : StringUtils.addSingleQuotes(string4)) + ", '" + string5 + "', " + (string6 == null ? "NULL" : "'" + string6 + "'") + ", " + (stringBuffer3.length() == 0 ? "NULL" : StringUtils.addSingleQuotes(stringBuffer3.toString())) + "); \n");
        }
        return bl;
    }

    private String generateCaseIdColumn(Context context) {
        String string = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            string = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        Object object3;
        Object object2;
        boolean bl;
        String string2;
        String string3;
        String string4;
        block25: {
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            string4 = buildNodeType.getBuildDataSource().getSourceId();
            StringBuffer stringBuffer = new StringBuffer();
            string3 = null;
            string2 = null;
            bl = true;
            String string5 = "        ";
            String string6 = "";
            if (this instanceof ClassificationBuildNode || this instanceof RegressionBuildNode) {
                string6 = "WHERE LENGTH(TRIM('||v_target||')) IS NOT NULL";
            }
            String string7 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
            if (buildNodeType.getCaseAttributes() != null && !buildNodeType.getCaseAttributes().getAttribute().isEmpty()) {
                if (this instanceof AssociationBuildNode) {
                    object2 = (AssociationBuildNodeType)buildNodeType;
                    stringBuffer.setLength(0);
                    stringBuffer.append(StringUtils.addDoubleQuotes(object2.getItemID().getName()));
                    if (object2.getItemValue() != null) {
                        stringBuffer.append(",\n" + string5);
                        stringBuffer.append(StringUtils.addDoubleQuotes(object2.getItemValue().getName()));
                    }
                    if (buildNodeType.getCaseAttributes().getAttribute().size() > 1) {
                        object3 = new StringBuffer();
                        for (AttributeType attributeType : buildNodeType.getCaseAttributes().getAttribute()) {
                            if (((StringBuffer)object3).length() > 0) {
                                ((StringBuffer)object3).append(", ");
                            }
                            ((StringBuffer)object3).append(StringUtils.addDoubleQuotes(attributeType.getName()));
                        }
                        string2 = this.generateCaseIdColumn(context);
                        string3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n       SELECT RANK() OVER (ORDER BY <CASEID_LIST>) \"'||v_caseid||'\", \n        <ATTR_LIST> \n       FROM '||getInputSource('" + string4 + "')||' \n" + "    )'; \n" + "  execSQL(v_sql); \n" + "  _END_CHECK_SQL_SIZE_ \n";
                        string3 = StringUtils.getReplacedString(string3, "<PARALLEL_HINT>", string7);
                        string3 = StringUtils.getReplacedString(string3, "<CASEID_LIST>", ((StringBuffer)object3).toString());
                        string3 = StringUtils.getReplacedString(string3, "<ATTR_LIST>", stringBuffer.toString());
                        bl = true;
                    }
                } else {
                    string2 = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
                    stringBuffer.setLength(0);
                    for (Object object3 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (object3.getInput().compareToIgnoreCase("Yes") != 0 && object3.getInput().compareToIgnoreCase("Maybe") != 0 || object3.getName().compareTo(string2) == 0) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",\n" + string5);
                        }
                        stringBuffer.append(StringUtils.addDoubleQuotes(object3.getName()));
                    }
                }
                if (buildNodeType.getCaseAttributes().getAttribute().size() == 1) {
                    string2 = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
                    string3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT \"'||v_caseid||'\", \n        <ATTR_LIST> \n      FROM '||getInputSource('" + string4 + "')||' <FILTER_NULLS_SPACES> \n" + "    )'; \n" + "  execSQL(v_sql); \n" + "  _END_CHECK_SQL_SIZE_ \n";
                    string3 = StringUtils.getReplacedString(string3, "<PARALLEL_HINT>", string7);
                    string3 = StringUtils.getReplacedString(string3, "<ATTR_LIST>", stringBuffer.toString());
                    string3 = StringUtils.getReplacedString(string3, "<FILTER_NULLS_SPACES>", string6);
                    bl = true;
                }
            } else {
                string2 = this.generateCaseIdColumn(context);
                stringBuffer.setLength(0);
                try {
                    for (Object object3 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (object3.getInput().compareToIgnoreCase("Yes") != 0 && object3.getInput().compareToIgnoreCase("Maybe") != 0) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",\n" + string5);
                        }
                        stringBuffer.append(StringUtils.addDoubleQuotes(object3.getName()));
                    }
                    if (this instanceof ClassificationBuildNode || this instanceof RegressionBuildNode) {
                        object2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
                        object3 = new StringBuffer("");
                        for (MiningAttributeType miningAttributeType : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                            if (miningAttributeType.getInput().compareToIgnoreCase("Yes") != 0 && miningAttributeType.getInput().compareToIgnoreCase("Maybe") != 0) continue;
                            if (miningAttributeType.getDataType().compareToIgnoreCase("CLOB") == 0 || miningAttributeType.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                                if (((StringBuffer)object3).length() > 0) {
                                    ((StringBuffer)object3).append(",\n" + string5);
                                }
                                ((StringBuffer)object3).append("LOB(" + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + ") STORE AS BASICFILE");
                                continue;
                            }
                            if (miningAttributeType.getDataType().contains("NESTED")) {
                                if (((StringBuffer)object3).length() > 0) {
                                    ((StringBuffer)object3).append(",\n" + string5);
                                }
                                ((StringBuffer)object3).append("NESTED TABLE " + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + " STORE AS '||generateUniqueName||'");
                                continue;
                            }
                            if (miningAttributeType.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                            if (((StringBuffer)object3).length() > 0) {
                                ((StringBuffer)object3).append(",\n" + string5);
                            }
                            ((StringBuffer)object3).append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + " STORE AS BASICFILE CLOB");
                        }
                        string3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE TABLE '||v_input_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM \"'||v_caseid||'\", \n        <ATTR_LIST> \n      FROM '||getInputSource('" + string4 + "')||' <FILTER_NULLS_SPACES> \n" + "    )'; \n" + "  execSQL(v_sql); \n" + "  _END_CHECK_SQL_SIZE_ \n";
                        string3 = StringUtils.getReplacedString(string3, "<STORAGE_CLAUSE>", ((StringBuffer)object3).toString());
                        string3 = StringUtils.getReplacedString(string3, "<TABLE_PARALLEL_HINT>", (String)object2);
                        string3 = StringUtils.getReplacedString(string3, "<PARALLEL_HINT>", string7);
                        string3 = StringUtils.getReplacedString(string3, "<ATTR_LIST>", stringBuffer.toString());
                        string3 = StringUtils.getReplacedString(string3, "<FILTER_NULLS_SPACES>", string6);
                        bl = false;
                        break block25;
                    }
                    string3 = "  _START_CHECK_SQL_SIZE_ \n  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM \"'||v_caseid||'\", \n        <ATTR_LIST> \n      FROM '||getInputSource('" + string4 + "')||' <FILTER_NULLS_SPACES>\n" + "    )'; \n" + "  execSQL(v_sql); \n" + "  _END_CHECK_SQL_SIZE_ \n";
                    string3 = StringUtils.getReplacedString(string3, "<PARALLEL_HINT>", string7);
                    string3 = StringUtils.getReplacedString(string3, "<ATTR_LIST>", stringBuffer.toString());
                    string3 = StringUtils.getReplacedString(string3, "<FILTER_NULLS_SPACES>", string6);
                    bl = true;
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        string3 = string3 + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_input_data, '" + (bl ? "VIEW" : "TABLE") + "', NULL, 'Input Data'); \n";
        object2 = this.generateTextSettingsCode(context);
        object3 = CodeTemplate.updateBodyTemplate(string, "<CASEID>", string2);
        object3 = CodeTemplate.updateBodyTemplate((String)object3, "<INPUT_DATA>", string3);
        object3 = CodeTemplate.updateBodyTemplate((String)object3, "<SOURCE_NODE_ID>", string4);
        object3 = CodeTemplate.updateBodyTemplate((String)object3, "<BUILD_TEXT_SETTING>", (String)object2);
        return object3;
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)this.getData());
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (ModelType modelType : list) {
            if (!modelType.getStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(MODEL_STATUS, new SubNodeProperty(modelType.getId(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(modelType.getId(), modelType.getStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    public static StoplistType findDefaultStoplist(BuildNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!stoplistType2.getName().equals("Default")) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public static String findStoplistId(BuildNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = AbstractBuildNode.findStoplistWithName(stoplists, string);
        return stoplistType != null ? stoplistType.getId() : null;
    }

    public static StoplistType findStoplistWithName(BuildNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!stoplistType2.getName().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public static int getStoplistNextId(BuildNodeType.Stoplists stoplists) {
        int n = 0;
        for (StoplistType stoplistType : stoplists.getStoplist()) {
            int n2 = Integer.parseInt(stoplistType.getId());
            if (n >= n2) continue;
            n = n2;
        }
        return ++n;
    }

    public static ArrayList<String> stoplistCheckLanguagesUsed(String string, BuildNodeType buildNodeType, StoplistType stoplistType, String string2, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        AbstractTextNode.stoplistCheckLanguagesUsed(string, buildNodeType.getTextAttributes(), stoplistType, string2, arrayList, arrayList2);
        return arrayList2;
    }

    private static void getDefaultTextAttributes(ModelType modelType, TextAttributes textAttributes) {
        MiningAttributes miningAttributes = modelType.getInputMiningData().getMiningAttributes();
        if (miningAttributes != null) {
            for (MiningAttributeType miningAttributeType : miningAttributes.getMiningAttribute()) {
                if (!miningAttributeType.getMiningType().equals("Text")) continue;
                TextAttribute textAttribute = new TextAttribute(modelType.getCreationDate(), modelType.getName(), miningAttributeType.getName());
                textAttributes.addTextAttribute(textAttribute);
            }
        }
    }

    public static void copyTextSettingsFromBuildText(BuildTextNodeType buildTextNodeType, TextTransformationOutputAttributeType textTransformationOutputAttributeType, BuildNodeType buildNodeType, MiningAttributeType miningAttributeType, boolean bl, boolean bl2) {
        block52: {
            ClassificationBuildNodeType classificationBuildNodeType;
            Object object13;
            Object object22;
            block56: {
                Object object3;
                Object object4;
                block55: {
                    block54: {
                        Object object5;
                        Object object6;
                        block53: {
                            Object object7;
                            block51: {
                                Object object8;
                                Object object92;
                                Object object10;
                                Object object11;
                                Object object122;
                                String string = null;
                                String string2 = null;
                                StoplistType stoplistType = null;
                                StoplistType stoplistType2 = null;
                                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                                string = transformationTokenType != null ? transformationTokenType.getToken().getStoplistId() : textTransformationOutputAttributeType.getTransformationElement().getTheme().getToken().getStoplistId();
                                if (string != null) {
                                    for (Object object122 : buildTextNodeType.getStoplists().getStoplist()) {
                                        if (!object122.getId().equals(string)) continue;
                                        stoplistType = object122;
                                        break;
                                    }
                                    for (Object object122 : buildNodeType.getStoplists().getStoplist()) {
                                        if (!object122.getName().equals(stoplistType.getName())) continue;
                                        string2 = object122.getId();
                                        stoplistType2 = object122;
                                        break;
                                    }
                                }
                                if (stoplistType != null) {
                                    if (stoplistType.getName().equals("Default")) {
                                        if (bl) {
                                            object11 = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
                                            object11.setDBName(stoplistType2.getDBName());
                                            buildNodeType.getStoplists().getStoplist().remove(stoplistType2);
                                            buildNodeType.getStoplists().getStoplist().add(object11);
                                        }
                                    } else if (stoplistType2 != null) {
                                        if (bl2) {
                                            object11 = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
                                            object11.setId(stoplistType2.getId());
                                            object11.setDBName(stoplistType2.getDBName());
                                            buildNodeType.getStoplists().getStoplist().remove(stoplistType2);
                                            buildNodeType.getStoplists().getStoplist().add(object11);
                                        }
                                    } else {
                                        string2 = AbstractBuildNode.getStoplistNextId(buildNodeType.getStoplists()) + "";
                                        object11 = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
                                        object11.setId(string2);
                                        object11.setDBName("");
                                        buildNodeType.getStoplists().getStoplist().add(object11);
                                    }
                                }
                                object11 = null;
                                object122 = null;
                                String string3 = null;
                                boolean bl3 = false;
                                TextTransformationType textTransformationType = null;
                                for (Object object22 : buildNodeType.getTextAttributes().getMapTextTransformedSource()) {
                                    object13 = object22.getKey();
                                    if (!object13.getName().equals(miningAttributeType.getName())) continue;
                                    textTransformationType = object13.getTransformationElement();
                                    if (textTransformationType.getToken() != null) {
                                        object11 = textTransformationType.getToken().getToken().getStoplistId();
                                        object122 = textTransformationType.getToken().getToken().getPolicy();
                                        string3 = textTransformationType.getToken().getToken().getLexer().getName();
                                    } else {
                                        object11 = textTransformationType.getTheme().getToken().getStoplistId();
                                        object122 = textTransformationType.getTheme().getToken().getPolicy();
                                        string3 = textTransformationType.getTheme().getToken().getLexer().getName();
                                    }
                                    object22.setKey((TextTransformationOutputAttributeType)MetaDataHelper.copyMetadataObject(textTransformationOutputAttributeType));
                                    object13 = object22.getKey();
                                    object13.setName(object13.getSource());
                                    textTransformationType = object13.getTransformationElement();
                                    if (textTransformationType.getToken() != null) {
                                        textTransformationType.getToken().getToken().setStoplistId(string2 != null ? string2 : object11);
                                        textTransformationType.getToken().getToken().setPolicy((String)object122);
                                        textTransformationType.getToken().getToken().getLexer().setName(string3);
                                    } else {
                                        textTransformationType.getTheme().getToken().setStoplistId(string2 != null ? string2 : object11);
                                        textTransformationType.getTheme().getToken().setPolicy((String)object122);
                                        textTransformationType.getTheme().getToken().getLexer().setName(string3);
                                    }
                                    bl3 = true;
                                    break;
                                }
                                if (!bl3) {
                                    MapTextTransformedSourceType mapTextTransformedSourceType = new MapTextTransformedSourceType();
                                    mapTextTransformedSourceType.setKey((TextTransformationOutputAttributeType)MetaDataHelper.copyMetadataObject(textTransformationOutputAttributeType));
                                    buildNodeType.getTextAttributes().getMapTextTransformedSource().add(mapTextTransformedSourceType);
                                    object22 = mapTextTransformedSourceType.getKey();
                                    object22.setName(object22.getSource());
                                    textTransformationType = object22.getTransformationElement();
                                    if (textTransformationType.getToken() != null) {
                                        textTransformationType.getToken().getToken().setStoplistId(string2);
                                        textTransformationType.getToken().getToken().setPolicy("");
                                        textTransformationType.getToken().getToken().setFeatureTable(null);
                                        textTransformationType.getToken().getToken().setStatisticTable(null);
                                        textTransformationType.getToken().getToken().getLexer().setName("");
                                    } else {
                                        textTransformationType.getTheme().getToken().setStoplistId(string2);
                                        textTransformationType.getTheme().getToken().setPolicy("");
                                        textTransformationType.getTheme().getToken().setFeatureTable(null);
                                        textTransformationType.getTheme().getToken().setStatisticTable(null);
                                        textTransformationType.getTheme().getToken().getLexer().setName("");
                                    }
                                }
                                if (textTransformationType.getToken() != null) {
                                    textTransformationType.getToken().getToken().setFrequency("IDF");
                                } else {
                                    boolean bl4 = false;
                                    for (Object object13 : textTransformationType.getTheme().getToken().getLexer().getSettings().getAttribute()) {
                                        if (!"index_themes".equals(object13.getName())) continue;
                                        bl4 = true;
                                        break;
                                    }
                                    if (!bl4) {
                                        object22 = new LexerType.Settings.Attribute();
                                        object22.setName("index_themes");
                                        object22.setType("String");
                                        object22.setValueString("YES");
                                        textTransformationType.getTheme().getToken().getLexer().getSettings().getAttribute().add(object22);
                                    }
                                    textTransformationType.getTheme().getToken().setFrequency("IDF");
                                }
                                for (Object object22 : buildNodeType.getMiningAttributes().getMiningAttribute()) {
                                    if (!object22.getName().equals(miningAttributeType.getName())) continue;
                                    object22.setMiningType("TextCustom");
                                    break;
                                }
                                if (!(buildNodeType instanceof ClassificationBuildNodeType)) break block51;
                                classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
                                object22 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                                object13 = object22.iterator();
                                block5: while (object13.hasNext()) {
                                    object10 = (ModelType)object13.next();
                                    for (Object object92 : object10.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                        if (!object92.getName().equals(miningAttributeType.getName())) continue;
                                        object92.setMiningType("TextCustom");
                                        continue block5;
                                    }
                                }
                                object13 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                                object10 = object13.iterator();
                                block7: while (object10.hasNext()) {
                                    object8 = (ModelType)object10.next();
                                    for (Object object14 : object8.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                        if (!object14.getName().equals(miningAttributeType.getName())) continue;
                                        object14.setMiningType("TextCustom");
                                        continue block7;
                                    }
                                }
                                object10 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                                object8 = object10.iterator();
                                block9: while (object8.hasNext()) {
                                    object92 = (ModelType)object8.next();
                                    for (Object object15 : object92.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                        if (!object15.getName().equals(miningAttributeType.getName())) continue;
                                        object15.setMiningType("TextCustom");
                                        continue block9;
                                    }
                                }
                                object8 = classificationBuildNodeType.getModels().getNaiveBayesModel();
                                object92 = object8.iterator();
                                block11: while (object92.hasNext()) {
                                    Object object14;
                                    object14 = (ModelType)object92.next();
                                    for (MiningAttributeType miningAttributeType2 : object14.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                        if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
                                        miningAttributeType2.setMiningType("TextCustom");
                                        continue block11;
                                    }
                                }
                                break block52;
                            }
                            if (!(buildNodeType instanceof RegressionBuildNodeType)) break block53;
                            classificationBuildNodeType = (RegressionBuildNodeType)buildNodeType;
                            object22 = classificationBuildNodeType.getModels().getRGeneralizedLinearModel();
                            object13 = object22.iterator();
                            block13: while (object13.hasNext()) {
                                object7 = (ModelType)object13.next();
                                for (Object object16 : object7.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                    if (!object16.getName().equals(miningAttributeType.getName())) continue;
                                    object16.setMiningType("TextCustom");
                                    continue block13;
                                }
                            }
                            object13 = classificationBuildNodeType.getModels().getRSupportVectorMachineModel();
                            object7 = object13.iterator();
                            block15: while (object7.hasNext()) {
                                ModelType modelType = (ModelType)object7.next();
                                for (MiningAttributeType miningAttributeType3 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                    if (!miningAttributeType3.getName().equals(miningAttributeType.getName())) continue;
                                    miningAttributeType3.setMiningType("TextCustom");
                                    continue block15;
                                }
                            }
                            break block52;
                        }
                        if (!(buildNodeType instanceof ClusteringBuildNodeType)) break block54;
                        classificationBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
                        object22 = classificationBuildNodeType.getModels().getExpectationMaximizationModel();
                        object13 = object22.iterator();
                        block17: while (object13.hasNext()) {
                            object6 = (ModelType)object13.next();
                            for (Object object17 : object6.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                if (!object17.getName().equals(miningAttributeType.getName())) continue;
                                object17.setMiningType("TextCustom");
                                continue block17;
                            }
                        }
                        object13 = classificationBuildNodeType.getModels().getKMeansModel();
                        object6 = object13.iterator();
                        block19: while (object6.hasNext()) {
                            object5 = (ModelType)object6.next();
                            for (Object object18 : object5.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                if (!object18.getName().equals(miningAttributeType.getName())) continue;
                                object18.setMiningType("TextCustom");
                                continue block19;
                            }
                        }
                        object6 = classificationBuildNodeType.getModels().getOClusterModel();
                        object5 = object6.iterator();
                        block21: while (object5.hasNext()) {
                            Object object17;
                            object17 = (ModelType)object5.next();
                            for (MiningAttributeType miningAttributeType4 : object17.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                                if (!miningAttributeType4.getName().equals(miningAttributeType.getName())) continue;
                                miningAttributeType4.setMiningType("TextCustom");
                                continue block21;
                            }
                        }
                        break block52;
                    }
                    if (!(buildNodeType instanceof AssociationBuildNodeType)) break block55;
                    classificationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
                    object22 = classificationBuildNodeType.getModels().getAprioriModel();
                    object13 = object22.iterator();
                    block23: while (object13.hasNext()) {
                        ModelType modelType = (ModelType)object13.next();
                        for (MiningAttributeType miningAttributeType5 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                            if (!miningAttributeType5.getName().equals(miningAttributeType.getName())) continue;
                            miningAttributeType5.setMiningType("TextCustom");
                            continue block23;
                        }
                    }
                    break block52;
                }
                if (!(buildNodeType instanceof FeatureExtractionBuildNodeType)) break block56;
                classificationBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType;
                object22 = classificationBuildNodeType.getModels().getNonNegativeMatrixFactorModel();
                object13 = object22.iterator();
                block25: while (object13.hasNext()) {
                    object4 = (ModelType)object13.next();
                    for (Object object19 : object4.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                        if (!object19.getName().equals(miningAttributeType.getName())) continue;
                        object19.setMiningType("TextCustom");
                        continue block25;
                    }
                }
                object13 = classificationBuildNodeType.getModels().getPCAModel();
                object4 = object13.iterator();
                block27: while (object4.hasNext()) {
                    object3 = (ModelType)object4.next();
                    for (Object object20 : object3.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                        if (!object20.getName().equals(miningAttributeType.getName())) continue;
                        object20.setMiningType("TextCustom");
                        continue block27;
                    }
                }
                object4 = classificationBuildNodeType.getModels().getSVDModel();
                object3 = object4.iterator();
                block29: while (object3.hasNext()) {
                    Object object19;
                    object19 = (ModelType)object3.next();
                    for (MiningAttributeType miningAttributeType6 : object19.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                        if (!miningAttributeType6.getName().equals(miningAttributeType.getName())) continue;
                        miningAttributeType6.setMiningType("TextCustom");
                        continue block29;
                    }
                }
                break block52;
            }
            if (!(buildNodeType instanceof AnomalyDetectionBuildNodeType)) break block52;
            classificationBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
            object22 = classificationBuildNodeType.getModels().getAnomalyDetectionModel();
            object13 = object22.iterator();
            block31: while (object13.hasNext()) {
                ModelType modelType = (ModelType)object13.next();
                for (MiningAttributeType miningAttributeType7 : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                    if (!miningAttributeType7.getName().equals(miningAttributeType.getName())) continue;
                    miningAttributeType7.setMiningType("TextCustom");
                    continue block31;
                }
            }
        }
    }

    public static List<TextAttribute> getDefaultTextAttributes(BuildNodeType buildNodeType) {
        TextAttributes textAttributes;
        block15: {
            block19: {
                Object object;
                Object object22;
                block18: {
                    block17: {
                        Object object3;
                        Object object42;
                        block16: {
                            Object object52;
                            block14: {
                                Object object6;
                                Object object7;
                                Object object82;
                                textAttributes = new TextAttributes();
                                if (!(buildNodeType instanceof ClassificationBuildNodeType)) break block14;
                                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
                                List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                                for (Object object82 : list) {
                                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object82, textAttributes);
                                }
                                List list2 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                                object82 = list2.iterator();
                                while (object82.hasNext()) {
                                    object7 = (ModelType)object82.next();
                                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object7, textAttributes);
                                }
                                object82 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                                object7 = object82.iterator();
                                while (object7.hasNext()) {
                                    object6 = (ModelType)object7.next();
                                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object6, textAttributes);
                                }
                                object7 = classificationBuildNodeType.getModels().getNaiveBayesModel();
                                object6 = object7.iterator();
                                while (object6.hasNext()) {
                                    ModelType modelType = (ModelType)object6.next();
                                    AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                                }
                                break block15;
                            }
                            if (!(buildNodeType instanceof RegressionBuildNodeType)) break block16;
                            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
                            List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
                            for (Object object52 : list) {
                                AbstractBuildNode.getDefaultTextAttributes((ModelType)object52, textAttributes);
                            }
                            List list3 = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
                            object52 = list3.iterator();
                            while (object52.hasNext()) {
                                ModelType modelType = (ModelType)object52.next();
                                AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                            }
                            break block15;
                        }
                        if (!(buildNodeType instanceof ClusteringBuildNodeType)) break block17;
                        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
                        List list = clusteringBuildNodeType.getModels().getExpectationMaximizationModel();
                        for (Object object42 : list) {
                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object42, textAttributes);
                        }
                        List list4 = clusteringBuildNodeType.getModels().getKMeansModel();
                        object42 = list4.iterator();
                        while (object42.hasNext()) {
                            object3 = (ModelType)object42.next();
                            AbstractBuildNode.getDefaultTextAttributes((ModelType)object3, textAttributes);
                        }
                        object42 = clusteringBuildNodeType.getModels().getOClusterModel();
                        object3 = object42.iterator();
                        while (object3.hasNext()) {
                            ModelType modelType = (ModelType)object3.next();
                            AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                        }
                        break block15;
                    }
                    if (!(buildNodeType instanceof AssociationBuildNodeType)) break block18;
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
                    List list = associationBuildNodeType.getModels().getAprioriModel();
                    for (ModelType modelType : list) {
                        AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                    }
                    break block15;
                }
                if (!(buildNodeType instanceof FeatureExtractionBuildNodeType)) break block19;
                FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType;
                List list = featureExtractionBuildNodeType.getModels().getNonNegativeMatrixFactorModel();
                for (Object object22 : list) {
                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object22, textAttributes);
                }
                List list5 = featureExtractionBuildNodeType.getModels().getPCAModel();
                object22 = list5.iterator();
                while (object22.hasNext()) {
                    object = (ModelType)object22.next();
                    AbstractBuildNode.getDefaultTextAttributes((ModelType)object, textAttributes);
                }
                object22 = featureExtractionBuildNodeType.getModels().getSVDModel();
                object = object22.iterator();
                while (object.hasNext()) {
                    ModelType modelType = (ModelType)object.next();
                    AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
                }
                break block15;
            }
            if (!(buildNodeType instanceof AnomalyDetectionBuildNodeType)) break block15;
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
            List list = anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel();
            for (ModelType modelType : list) {
                AbstractBuildNode.getDefaultTextAttributes(modelType, textAttributes);
            }
        }
        return textAttributes.getTextAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TextFeature> getDefaultTextFeatures(Context context, BuildNodeType buildNodeType) {
        ArrayList<TextFeature> arrayList = new ArrayList<TextFeature>();
        String string = "select t.ATTRIBUTE_NAME, t.FEATURE_NAME, t.FREQUENCY, SUBSTR(s.ATTRIBUTE_SPEC, INSTR(s.ATTRIBUTE_SPEC,'TOKEN_TYPE:',-1,1)+LENGTH('TOKEN_TYPE:'), 10) \"TYPE\" from\ntable(ODM_UTIL.SYS_DM_TEXT_DF('<model>', '<column>')) t, USER_MINING_MODEL_ATTRIBUTES s\nwhere s.MODEL_NAME='<model>' and s.ATTRIBUTE_NAME='<column>'\n";
        int n = 300;
        try (SQLHelper sQLHelper = new SQLHelper();){
            List<TextAttribute> list = AbstractBuildNode.getDefaultTextAttributes(buildNodeType);
            if (!list.isEmpty()) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select ATTRIBUTE_NAME, FEATURE_NAME, FREQUENCY, TYPE from\n(\n");
                int n2 = 0;
                for (TextAttribute object : list) {
                    if (n2 > 0) {
                        stringBuffer.append("union\n");
                    }
                    String string3 = StringUtils.getReplacedString(string, "<model>", object.getModel());
                    string2 = StringUtils.getReplacedString(string3, "<column>", object.getAttribute());
                    stringBuffer.append(string2);
                    ++n2;
                }
                stringBuffer.append(") order by frequency desc, feature_name\n");
                sQLHelper.conn = ConnectionFolder.getConnection(context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuffer.toString());
                sQLHelper.pstmt.setFetchSize(n);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    String string5 = sQLHelper.rs.getString("FEATURE_NAME");
                    int n3 = sQLHelper.rs.getInt("FREQUENCY");
                    string2 = sQLHelper.rs.getString("TYPE");
                    string2 = string2.startsWith("NORMAL") || string2.startsWith("STEM") ? "Word" : (string2.startsWith("THEME") ? "Theme" : "Unknown");
                    TextFeature textFeature = new TextFeature(string4, string5, string2, n3);
                    arrayList.add(textFeature);
                }
            }
        }
        return arrayList;
    }

    public static class TextFeature {
        private String _column;
        private String _type;
        private String _name;
        private Integer _frequency;

        public TextFeature(String string, String string2, String string3, Integer n) {
            this._column = string;
            this._name = string2;
            this._type = string3;
            this._frequency = n;
        }

        public String getColumn() {
            return this._column;
        }

        public String getType() {
            return this._type;
        }

        public String getName() {
            return this._name;
        }

        public Integer getFrequency() {
            return this._frequency;
        }
    }

    private static class TextAttributes {
        ArrayList<TextAttribute> _attrsMap = new ArrayList();

        public void addTextAttribute(TextAttribute textAttribute) {
            this._attrsMap.add(textAttribute);
        }

        public List<TextAttribute> getTextAttributes() {
            return this._attrsMap;
        }
    }

    public static class TextAttribute {
        XMLGregorianCalendar _creationDate;
        String _model;
        String _attribute;

        public TextAttribute(XMLGregorianCalendar xMLGregorianCalendar, String string, String string2) {
            this._creationDate = xMLGregorianCalendar;
            this._model = string;
            this._attribute = string2;
        }

        public String getModel() {
            return this._model;
        }

        public String getAttribute() {
            return this._attribute;
        }

        public XMLGregorianCalendar getCreationDate() {
            return this._creationDate;
        }
    }
}

