/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.StatisticSelectionDefinitions;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;

public class ExtendedTransformationSettingsTableModel
extends TransformationSettingsTableModel {
    private String[] getExtendedcolumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_COLUMN"));
        arrayList.add(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_TYPE"));
        arrayList.add(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_SOURCE_COLUMN"));
        arrayList.add(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_TRANSFORM"));
        arrayList.add(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_OUTPUT"));
        if (this.getStatsSelection().isHistogram()) {
            arrayList.add(StatisticSelectionDefinitions.HISTOGRAM);
        }
        if (this.getStatsSelection().isPercentnull()) {
            arrayList.add(StatisticSelectionDefinitions.PERCENT_NULL);
        }
        if (this.getStatsSelection().isPercentdistinct()) {
            arrayList.add(StatisticSelectionDefinitions.DISTINCT);
        }
        if (this.getStatsSelection().isMode()) {
            arrayList.add(StatisticSelectionDefinitions.MODE);
        }
        if (this.getStatsSelection().isAvg()) {
            arrayList.add(StatisticSelectionDefinitions.AVG);
        }
        if (this.getStatsSelection().isMedian()) {
            arrayList.add(StatisticSelectionDefinitions.MEDIAN);
        }
        if (this.getStatsSelection().isMin()) {
            arrayList.add(StatisticSelectionDefinitions.MIN);
        }
        if (this.getStatsSelection().isMax()) {
            arrayList.add(StatisticSelectionDefinitions.MAX);
        }
        if (this.getStatsSelection().isStd()) {
            arrayList.add(StatisticSelectionDefinitions.STD);
        }
        if (this.getStatsSelection().isVar()) {
            arrayList.add(StatisticSelectionDefinitions.VAR);
        }
        if (this.getStatsSelection().isSkewness()) {
            arrayList.add(StatisticSelectionDefinitions.SKEWNESS);
        }
        if (this.getStatsSelection().isKurtosis()) {
            arrayList.add(StatisticSelectionDefinitions.KURTOSIS);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    public ExtendedTransformationSettingsTableModel(StatsSelection statsSelection, TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector, List<DataProfileStatisticsData> list, String string, int n) {
        super(statsSelection, transformedAttributes, vector, list, string, n);
        this.setColumnNumer();
    }

    @Override
    protected String[] getColumnNames() {
        return this.getExtendedcolumnNames();
    }

    @Override
    public String getColumnName(int n) {
        return this.getExtendedcolumnNames()[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        if (n2 <= OUTPUT) {
            return super.getValueAt(n, n2);
        }
        DataProfileStatisticsData dataProfileStatisticsData = this.getDataProfileStatisticsData(n);
        if (dataProfileStatisticsData == null) {
            return "";
        }
        Object object2 = null;
        if (n2 == this.getPercentNullNumber()) {
            object2 = dataProfileStatisticsData.getPercentNulls();
        } else if (n2 == this.getDistinctNumber()) {
            object2 = dataProfileStatisticsData.getNumOfDistincts();
        } else if (n2 == this.getModeNumber()) {
            object2 = dataProfileStatisticsData.getMode();
        } else if (n2 == this.getAvgNumber()) {
            object2 = dataProfileStatisticsData.getAvg();
        } else if (n2 == this.getMedianNumber()) {
            object2 = dataProfileStatisticsData.getMedian();
        } else if (n2 == this.getMinNumber()) {
            object2 = dataProfileStatisticsData.getMin();
        } else if (n2 == this.getMaxNumber()) {
            object2 = dataProfileStatisticsData.getMax();
        } else if (n2 == this.getStdNumber()) {
            object2 = dataProfileStatisticsData.getStd();
        } else if (n2 == this.getVarNumber()) {
            object2 = dataProfileStatisticsData.getVar();
        } else if (n2 == this.getSkewnessNumber()) {
            object2 = dataProfileStatisticsData.getSkewness();
        } else if (n2 == this.getKurtosisNumber()) {
            object2 = dataProfileStatisticsData.getKurtosis();
        } else if (n2 == this.getHistogramNumber()) {
            object2 = dataProfileStatisticsData.getGraphDataModel();
            if (object2 != null && object2 instanceof DefaultGraphDataModel) {
                object = (DefaultGraphDataModel)object2;
                if (((DefaultGraphDataModel)object).getGraphData() == null || ((DefaultGraphDataModel)object).getGraphData().length == 0) {
                    return "";
                }
                ((DefaultGraphDataModel)object).setComment(MessageFormat.format(DataProfileStatisticsLrb.get("DETAIL_TABLE_TOOL_TIP_HISTOGRAM"), dataProfileStatisticsData.getName()));
            }
        } else assert (false) : "Out of bounds column when accessing statistics";
        if (object2 instanceof Date || object2 instanceof Timestamp) {
            object = null;
            if (object2 instanceof Timestamp) {
                object = TimeUtils.getShortSimpleDateFormatZone();
            } else if (object2 instanceof Date) {
                object = TimeUtils.getShortSimpleDateFormat();
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = ((SimpleDateFormat)object).format((Date)object2, stringBuffer, new FieldPosition(0));
            return stringBuffer2.toString();
        }
        if (object2 instanceof GregorianCalendar) {
            object = (GregorianCalendar)object2;
            SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
            simpleDateFormat.setTimeZone(((GregorianCalendar)object).getTimeZone());
            Date date = ((Calendar)object).getTime();
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
            StringBuffer stringBuffer3 = new StringBuffer(TimeUtils.removeGMT(stringBuffer.toString()));
            return stringBuffer3.toString();
        }
        return object2 != null ? object2 : "";
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator<Object> comparator = null;
        comparator = n == this.getPercentNullNumber() ? NumberComparator.getComparator() : (n == this.getDistinctNumber() ? NumberComparator.getComparator() : (n == this.getStdNumber() ? NumberComparator.getComparator() : (n == this.getVarNumber() ? NumberComparator.getComparator() : (n == this.getSkewnessNumber() ? NumberComparator.getComparator() : (n == this.getKurtosisNumber() ? NumberComparator.getComparator() : (n == this.getAvgNumber() ? NumberComparator.getComparator() : (n == this.getMedianNumber() ? NumberComparator.getComparator() : (n == this.getMinNumber() ? NumberComparator.getComparator() : (n == this.getMaxNumber() ? NumberComparator.getComparator() : (n == this.getModeNumber() ? super.getColumnSortComparator(n) : super.getColumnSortComparator(n)))))))))));
        return comparator;
    }

    @Override
    public void setFailedStatus() {
        DataProfileStatisticsData dataProfileStatisticsData = new DataProfileStatisticsData(XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILED_TO_LOAD_TABLE_SUMMARY"));
        this.clearRows();
        this.addDataItem(dataProfileStatisticsData);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }
}

