/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningCustomBase;
import oracle.dmt.dataminer.workflow.dialog.transformations.CustomBinningType;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class BinningDatePickerPanel
extends DialogDisplayer {
    private static final String AM = XformDialogsLrb.get("DATEPICKER_AM");
    private static final String PM = XformDialogsLrb.get("DATEPICKER_PM");
    private Calendar calendar;
    private boolean showTimezone;
    private NameValuePair nameValuePair;
    private Vector<NameValuePair> allData;
    private int editedRowNumber = -1;
    private CustomBinningType binningType;
    private boolean allowEditing;
    private boolean isLabels;
    private JToggleButton jCalendarPopupButton;
    private JComboBox jComboAmApm;
    private JLabel jLabelDate;
    private JLabel jLabelTime;
    private JLabel jLabelTimeZone;
    private JSpinner jSpinnerHour;
    private JSpinner jSpinnerMin;
    private JSpinner jSpinnerSec;
    private JTextField jTextFieldDate;
    private JComboBox jTimeZoneCombo;
    private JLabel jlblLabel;
    private JTextField jtxtLabel;

    public BinningDatePickerPanel(GregorianCalendar gregorianCalendar, boolean bl, CustomBinningType customBinningType, int n, Vector<NameValuePair> vector, boolean bl2) {
        this.showTimezone = bl;
        this.calendar = gregorianCalendar;
        NameValuePair nameValuePair = vector.get(n);
        this.nameValuePair = new NameValuePair(nameValuePair.getName(), nameValuePair.getValue());
        this.editedRowNumber = n;
        this.allData = vector;
        this.binningType = customBinningType;
        this.allowEditing = bl2;
        this.isLabels = customBinningType.isDateLabels();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jTextFieldDate = new JTextField();
        this.jLabelDate = new JLabel();
        this.jCalendarPopupButton = new CalendarPopupButton();
        this.jLabelTime = new JLabel();
        this.jSpinnerHour = new JSpinner();
        this.jSpinnerMin = new JSpinner();
        this.jSpinnerSec = new JSpinner();
        this.jComboAmApm = new JComboBox();
        this.jLabelTimeZone = new JLabel();
        this.jTimeZoneCombo = new JComboBox();
        this.jlblLabel = new JLabel();
        this.jtxtLabel = this.isLabels ? new JTextField() : new NumberTextField();
        this.jTextFieldDate.setEditable(false);
        this.jLabelDate.setText("Date:");
        this.jLabelTime.setText("Time:");
        this.jSpinnerHour.setModel(new SpinnerNumberModel(11, 0, 11, 1));
        this.jSpinnerMin.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        this.jSpinnerSec.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        this.jComboAmApm.setModel(new DefaultComboBoxModel<String>(new String[]{"AM", "PM"}));
        this.jLabelTimeZone.setText("Time Zone:");
        this.jTimeZoneCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jlblLabel.setText("Bin Label:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelTime, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelDate, -1, 62, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSpinnerHour, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerMin, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSec, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboAmApm, 0, 0, Short.MAX_VALUE)).addComponent(this.jTextFieldDate))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTimeZone, -1, 62, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTimeZoneCombo, 0, 178, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCalendarPopupButton, -2, 33, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jlblLabel, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jtxtLabel))).addContainerGap()));
        groupLayout.linkSize(0, this.jLabelDate, this.jLabelTime, this.jLabelTimeZone);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlblLabel).addComponent(this.jtxtLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDate, -2, -1, -2).addComponent(this.jLabelDate)).addComponent(this.jCalendarPopupButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTime).addComponent(this.jSpinnerHour, -2, -1, -2).addComponent(this.jSpinnerMin, -2, -1, -2).addComponent(this.jSpinnerSec, -2, -1, -2)).addComponent(this.jComboAmApm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTimeZone).addComponent(this.jTimeZoneCombo, -2, -1, -2)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelDate, (Component)this.jTextFieldDate, (String)XformDialogsLrb.get("DATEPICKER_DATE"));
        this.jLabelTime.setText(XformDialogsLrb.get("DATEPICKER_TIME"));
        this.jComboAmApm.setModel(new DefaultComboBoxModel<String>(new String[]{AM, PM}));
        if (this.showTimezone) {
            ResourceUtils.resLabel((JLabel)this.jLabelTimeZone, (Component)this.jTimeZoneCombo, (String)XformDialogsLrb.get("DATEPICKER_TIME_ZONE"));
            this.jTimeZoneCombo.setModel(new DefaultComboBoxModel<String>(TimeUtils.getTimeZoneStrings()));
        } else {
            this.jLabelTimeZone.setVisible(false);
            this.jTimeZoneCombo.setVisible(false);
        }
        this.jlblLabel.setText(XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_LABEL"));
        this.jlblLabel.setLabelFor(this.jtxtLabel);
    }

    private String toDate(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n3);
        stringBuilder.append(".");
        if (n2 + 1 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n2 + 1);
        stringBuilder.append(".");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private void setDate() {
        this.jTextFieldDate.setText(this.toDate(this.calendar));
        int n = this.calendar.get(10);
        this.jSpinnerHour.setValue(n);
        int n2 = this.calendar.get(12);
        this.jSpinnerMin.setValue(n2);
        int n3 = this.calendar.get(13);
        this.jSpinnerSec.setValue(n3);
        int n4 = this.calendar.get(9);
        if (n4 == 0) {
            this.jComboAmApm.setSelectedItem(AM);
        } else {
            this.jComboAmApm.setSelectedItem(PM);
        }
        if (this.showTimezone) {
            TimeZone timeZone = this.calendar.getTimeZone();
            String string = timeZone.getDisplayName(Locale.getDefault());
            this.jTimeZoneCombo.setSelectedItem(string);
        }
    }

    @Override
    public void initUI() {
        boolean bl = this.editedRowNumber > 0;
        this.setDate();
        this.jCalendarPopupButton.setEnabled(bl);
        this.jSpinnerHour.setEnabled(bl);
        this.jSpinnerMin.setEnabled(bl);
        this.jSpinnerSec.setEnabled(bl);
        this.jTextFieldDate.setEnabled(bl);
        this.jTimeZoneCombo.setEnabled(bl);
        this.jComboAmApm.setEnabled(bl);
        CalendarPanel calendarPanel = ((CalendarPopupButton)this.jCalendarPopupButton).getCalendarPanel();
        calendarPanel.setMultiSelect(false);
        calendarPanel.setShowTime(false);
        calendarPanel.setShowTimeZone(false);
        calendarPanel.setSelectedDate(this.calendar.getTime());
        calendarPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("DOUBLE_CLICK_COMMAND".equals(actionEvent.getActionCommand())) {
                    Date[] dateArray = ((CalendarPopupButton)BinningDatePickerPanel.this.jCalendarPopupButton).getSelectedDates();
                    for (int i = 0; i < dateArray.length; ++i) {
                        Date date = dateArray[i];
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        BinningDatePickerPanel.this.jTextFieldDate.setText(BinningDatePickerPanel.this.toDate(calendar));
                        int n = calendar.get(1);
                        int n2 = calendar.get(2);
                        int n3 = calendar.get(5);
                        BinningDatePickerPanel.this.calendar.set(n, n2, n3);
                    }
                }
            }
        });
        Container container = calendarPanel.getParent();
        do {
            if (container == null || !(container instanceof JDialog)) continue;
            ((JDialog)container).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            break;
        } while ((container = container.getParent()) != null);
        if (this.isLabels) {
            this.jtxtLabel.setText(this.nameValuePair.getName());
        } else {
            ((NumberTextField)this.jtxtLabel).setDataType(Integer.class);
            ((NumberTextField)this.jtxtLabel).setSigned(false);
            this.jtxtLabel.setLocale(Locale.getDefault());
            Integer n = Integer.parseInt(this.nameValuePair.getName().toString());
            ((NumberTextField)this.jtxtLabel).setNumber((Number)n);
        }
        this.jtxtLabel.setEditable(this.allowEditing);
        if (!this.allowEditing) {
            this.jtxtLabel.setFocusable(false);
        }
    }

    @Override
    public boolean doWork() {
        Object object;
        int n = (Integer)this.jSpinnerHour.getValue();
        this.calendar.set(10, n);
        int n2 = (Integer)this.jSpinnerMin.getValue();
        this.calendar.set(12, n2);
        int n3 = (Integer)this.jSpinnerSec.getValue();
        this.calendar.set(13, n3);
        String string = (String)this.jComboAmApm.getSelectedItem();
        int n4 = string.equals(AM) ? 0 : 1;
        this.calendar.set(9, n4);
        if (this.showTimezone) {
            object = (String)this.jTimeZoneCombo.getSelectedItem();
            Iterator<NameValuePair> iterator = TimeUtils.toTimeZone((String)object);
            this.calendar.setTimeZone((TimeZone)((Object)iterator));
        }
        if (!this.isValidateBinValue(this.calendar)) {
            return false;
        }
        if (this.isLabels) {
            object = this.jtxtLabel.getText();
            if (((String)object).isEmpty()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_INVALID_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                return false;
            }
            if (!((String)object).equals(this.nameValuePair.getName())) {
                for (NameValuePair nameValuePair : this.allData) {
                    if (!nameValuePair.getName().equals(object)) continue;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_DUPLICATE_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                    return false;
                }
                this.nameValuePair.setName((String)object);
            }
        } else {
            object = ((NumberTextField)this.jtxtLabel).getNumber();
            if (object == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_INVALID_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                return false;
            }
            if (!object.equals(Integer.parseInt(this.nameValuePair.getName()))) {
                for (NameValuePair nameValuePair : this.allData) {
                    Integer n5 = Integer.parseInt(nameValuePair.getName());
                    if (!n5.equals(object)) continue;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_DUPLICATE_LABEL"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_NUM_EDIT_BIN_ERROR_TITLE"), null);
                    return false;
                }
                this.nameValuePair.setName(object.toString());
            }
        }
        return true;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    protected String getDialogTitle() {
        return XformDialogsLrb.get("DATEPICKER_LABEL");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }

    public String getBinLabel() {
        return this.nameValuePair.getName();
    }

    private boolean isValidateBinValue(Calendar calendar) {
        Object object;
        if (this.editedRowNumber == 0) {
            return true;
        }
        SimpleDateFormat simpleDateFormat = this.showTimezone ? TimeUtils.getShortSimpleDateFormatZoneRFCTZ() : TimeUtils.getShortSimpleDateFormatZoneRFC2();
        Date date = calendar.getTime();
        TimeZone timeZone = calendar.getTimeZone();
        simpleDateFormat.setTimeZone(timeZone);
        StringBuffer stringBuffer = new StringBuffer();
        simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
        NameValuePair nameValuePair = this.allData.get(this.editedRowNumber - 1);
        NameValuePair nameValuePair2 = this.editedRowNumber == this.allData.size() - 1 ? null : this.allData.get(this.editedRowNumber + 1);
        Object object2 = nameValuePair.getValue();
        Object object3 = object = nameValuePair2 != null ? nameValuePair2.getValue() : TransformationStatisticsState.UNBOUNDED;
        if (this.binningType.isCustomDateBinning() || this.binningType.isCustomTimestampBinning()) {
            boolean bl = this.binningType.isCustomTimestampBinning();
            GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, stringBuffer, bl);
            GregorianCalendar gregorianCalendar2 = object2.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : BinningCustomBase.toDate(simpleDateFormat, object2, bl);
            GregorianCalendar gregorianCalendar3 = object.equals(TransformationStatisticsState.UNBOUNDED) ? null : BinningCustomBase.toDate(simpleDateFormat, object, bl);
            boolean bl2 = false;
            if (gregorianCalendar2 != null && gregorianCalendar3 != null) {
                if (gregorianCalendar.before(gregorianCalendar2) || gregorianCalendar.after(gregorianCalendar3)) {
                    bl2 = true;
                }
            } else if (gregorianCalendar2 == null && gregorianCalendar3 != null) {
                if (gregorianCalendar.after(gregorianCalendar3)) {
                    bl2 = true;
                }
            } else if (gregorianCalendar2 != null && gregorianCalendar3 == null && gregorianCalendar.before(gregorianCalendar2)) {
                bl2 = true;
            }
            if (bl2) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return false;
            }
        }
        return true;
    }
}

