/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel2;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCDetailPanel;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.tviewer.roc.ThresholdPanel;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitDetailPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixDetailPanel;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCAccuracyType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCCustomThresholdType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class ROCTabPanel
extends AbstractPropertiesDialogPanel
implements GraphDataDisplay {
    private GraphPanel2 _graphPanel;
    private boolean _loading = true;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private DataMinerTablePanel dataMinerTablePanel;
    private JButton jClearButton;
    private JComboBox<String> jComboAccurayTypes;
    private JButton jCostMatrixBtn;
    private JPanel jCostMatrixPanel;
    private JButton jCustomROCButton;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jMatrixLbl;
    private JLabel jMatrixLbl1;
    private GenericTable jMatrixTable;
    private JPanel jROCPanel;
    private JPanel jRocControls;
    private JPanel jRocGraphPanel;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JComboBox<String> jTargetComb;
    private JLabel jTargetLbl;
    private JButton jTuneBtn;
    private JLabel jTuneCriteriaLabel;
    private JLabel jTuneCriteriaValue;
    private GenericTable jTuneMatrixTable;
    private JLabel jTuneMethodLabel;
    private JLabel jTuneMethodValue;
    private JLabel jTuneSettingsLabel;
    private JLabel jTuneTargetLabel;
    private JLabel jTuneTargetValue;
    private JLabel jTuneThresholdLabel;
    private JLabel jTuneThresholdValue;
    private JButton jDetailBtn;

    public ROCTabPanel(TraversableContext traversableContext) {
        super(traversableContext);
        boolean bl = false;
        List<TestResult> list = this.getPanelState().getTestCompareNode().getTestResults();
        for (TestResult testResult : list) {
            if (!((ClassTestResult)testResult).rocResultExists()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.initComponents();
            this.initGraph();
            this.initRes();
            this.initUI();
        }
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel2(this, new DefaultGraphDataModel(null, null, null, null, null));
        this.jRocGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        this.jRocGraphPanel.updateUI();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jCustomROCButton, (String)TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleName(TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("ROC_CUSTOM_BTN_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl, (Component)this.jMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX"));
        this.jMatrixLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX")));
        this.jMatrixLbl.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX_ADA"));
        this.jLabel1.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        this.jLabel1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        ResourceUtils.resButton((AbstractButton)this.jTuneBtn, (String)DialogsLrb.get("TUNE_COMMON_TUNE"));
        this.jTuneBtn.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE")));
        this.jTuneBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TUNE_ADA"));
        this.jTuneSettingsLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        this.jTuneSettingsLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        ResourceUtils.resButton((AbstractButton)this.jClearButton, (String)DialogsLrb.get("TUNE_COMMON_CLEAR"));
        this.jClearButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CLEAR")));
        this.jClearButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CLEAR_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneMethodLabel, (Component)this.jTuneMethodValue, (String)DialogsLrb.get("TUNE_COMMON_METHOD"));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_METHOD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneTargetLabel, (Component)this.jTuneTargetValue, (String)DialogsLrb.get("TUNE_COMMON_TARGET"));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TARGET_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneCriteriaLabel, (Component)this.jTuneCriteriaValue, (String)DialogsLrb.get("TUNE_COMMON_CRITERIA"));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CRITERIA_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneThresholdLabel, (Component)this.jTuneThresholdValue, (String)DialogsLrb.get("TUNE_COMMON_THRESHOLD"));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_THRESHOLD")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_THRESHOLD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl1, (Component)this.jTuneMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX"));
        this.jMatrixLbl1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX_ADA"));
    }

    public void initUI() {
        this._loading = true;
        this.dataMinerTablePanel.setTitle(TestViewerLrb.get("ROC_RESULT_SUMMARY_TABLE"));
        this.installROCSummaryActions();
        this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void installROCSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jDetailBtnActionPerformed();
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
    }

    private void enableControls(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0;
        this.jTargetComb.setEnabled(bl);
        this.jCustomROCButton.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && bl5);
        if (bl5) {
            String string = this.getPanelState().getShareState().getSelectTestResult();
            bl2 = this.getPanelState().isTuningCustom(string);
            bl4 = this.getPanelState().isTuningBenefit(string);
            bl3 = this.getPanelState().isTuningCost(string);
        }
        this.jClearButton.setEnabled(bl && bl5 && (bl2 || bl3 || bl4));
        this.jTuneBtn.setEnabled(bl && bl5);
        this.jTuneTargetLabel.setVisible(bl && bl2);
        this.jTuneTargetValue.setVisible(bl && bl2);
        this.jTuneThresholdLabel.setVisible(bl && bl2);
        this.jTuneThresholdValue.setVisible(bl && bl2);
        this.jTuneCriteriaLabel.setVisible(bl && bl2);
        this.jTuneCriteriaValue.setVisible(bl && bl2);
        this.jMatrixLbl1.setVisible(bl && (bl2 || bl3 || bl4));
        this.jCostMatrixBtn.setVisible(bl && (bl3 || bl4));
        this.jScrollPane2.setVisible(bl && bl2);
        this.jTuneMatrixTable.setVisible(bl && bl2);
        this.jLabel7.setVisible(bl && bl2);
    }

    private void initializeControls() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this.getPanelState().getShareState(), null);
        rOCTabPanelState.getClass();
        dataMinerTable.setModel((TableModel)((Object)rOCTabPanelState.new ROCTabPanelState.ROCTuneTableModel(null, false)));
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{CommonLrb.get("COMMON_LOADING")}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ROCTabPanel.this.jROCSummaryTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    private void jDetailBtnActionPerformed() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this.getPanelState().getRocState().getRocTableModel().getValueAt(nArray[0], this.getPanelState().getRocState().getMODEL());
        ROCDetailPanel rOCDetailPanel = new ROCDetailPanel(this.getPanelState().getContext(), string, this.getPanelState().getRocState().getROCData().get(string));
        rOCDetailPanel.showAsDialog(this);
    }

    private void jROCSummaryTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this.getPanelState().getRocState().getRocTableModel().getValueAt(nArray[0], this.getPanelState().getRocState().getMODEL());
            this.getPanelState().getShareState().setSelectTestResult(string);
            this.loadConfusionMatrix();
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    protected final TuneState getPanelState() {
        return (TuneState)super.getDialogState();
    }

    @Override
    public void tabSelected() {
        if (this.getPanelState().getRocState().getRocTableModel() == null) {
            return;
        }
        String string = this.getPanelState().getShareState().getSelectTestResult();
        if (string != null) {
            int n = 0;
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                Object object = this.getPanelState().getRocState().getRocTableModel().getValueAt(i, this.getPanelState().getRocState().getMODEL());
                if (!string.equals(object)) continue;
                n = i;
                break;
            }
            this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        }
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    @Override
    public void processInput() {
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jROCPanel = new JPanel();
        this.jRocControls = new JPanel();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jCustomROCButton = new JButton();
        this.jRocGraphPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jCostMatrixPanel = new JPanel();
        this.jMatrixLbl = new JLabel();
        this.jComboAccurayTypes = new JComboBox();
        this.jScrollPane = new JScrollPane();
        this.jMatrixTable = new BaseCostMatrixTable();
        this.jLabel1 = new JLabel();
        this.jClearButton = new JButton();
        this.jTuneBtn = new JButton();
        this.jTuneSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTuneMethodLabel = new JLabel();
        this.jTuneMethodValue = new JLabel();
        this.jTuneTargetLabel = new JLabel();
        this.jTuneTargetValue = new JLabel();
        this.jTuneCriteriaLabel = new JLabel();
        this.jTuneCriteriaValue = new JLabel();
        this.jTuneThresholdLabel = new JLabel();
        this.jTuneThresholdValue = new JLabel();
        this.jMatrixLbl1 = new JLabel();
        this.jCostMatrixBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTuneMatrixTable = new BaseCostMatrixTable();
        this.jLabel7 = new JLabel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.setMinimumSize(new Dimension(750, 490));
        this.setPreferredSize(new Dimension(750, 490));
        this.jSplitPane1.setDividerLocation(360);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setAutoscrolls(true);
        this.jSplitPane1.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(0, 0));
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setAutoscrolls(true);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jROCPanel.setAutoscrolls(true);
        this.jROCPanel.setName("jROCPanel");
        this.jROCPanel.setPreferredSize(new Dimension(300, 300));
        this.jRocControls.setName("jRocControls");
        this.jTargetLbl.setHorizontalAlignment(2);
        this.jTargetLbl.setText("Target Value:");
        this.jTargetLbl.setName("jTargetLbl");
        this.jTargetComb.setName("jTargetComb");
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jCustomROCButton.setHorizontalAlignment(4);
        this.jCustomROCButton.setName("jCustomROCButton");
        this.jCustomROCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jCustomROCActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jRocControls);
        this.jRocControls.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addComponent(this.jCustomROCButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jCustomROCButton).addComponent(this.jTargetComb, -2, -1, -2))));
        this.jRocGraphPanel.setName("jRocGraphPanel");
        this.jRocGraphPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout2 = new GroupLayout(this.jROCPanel);
        this.jROCPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRocGraphPanel, -1, 300, Short.MAX_VALUE).addComponent(this.jRocControls, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jRocControls, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRocGraphPanel, -1, 325, Short.MAX_VALUE)));
        this.jSplitPane2.setLeftComponent(this.jROCPanel);
        this.jScrollPane1.setName("jScrollPane1");
        this.jCostMatrixPanel.setName("jCostMatrixPanel");
        this.jMatrixLbl.setText("Performance Matrix:");
        this.jMatrixLbl.setName("jMatrixLbl");
        this.jComboAccurayTypes.setName("jComboAccurayTypes");
        this.jComboAccurayTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jComboAccurayTypesActionPerformed(actionEvent);
            }
        });
        this.jScrollPane.setName("jScrollPane");
        this.jScrollPane.setPreferredSize(new Dimension(450, 200));
        this.jMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jMatrixTable.setName("jMatrixTable");
        this.jMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane.setViewportView((Component)this.jMatrixTable);
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        this.jLabel1.setName("jLabel1");
        this.jClearButton.setText("Clear");
        this.jClearButton.setName("jClearButton");
        this.jClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jClearButtonActionPerformed(actionEvent);
            }
        });
        this.jTuneBtn.setText("Tune");
        this.jTuneBtn.setName("jTuneBtn");
        this.jTuneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTuneBtnActionPerformed(actionEvent);
            }
        });
        this.jTuneSettingsLabel.setText("Tune Settings");
        this.jTuneSettingsLabel.setName("jTuneSettingsLabel");
        this.jSeparator1.setName("jSeparator1");
        this.jTuneMethodLabel.setText("Method:");
        this.jTuneMethodLabel.setName("jTuneMethodLabel");
        this.jTuneMethodValue.setText("ROC");
        this.jTuneMethodValue.setName("jTuneMethodValue");
        this.jTuneTargetLabel.setText("Target Value:");
        this.jTuneTargetLabel.setName("jTuneTargetLabel");
        this.jTuneTargetValue.setText("1");
        this.jTuneTargetValue.setName("jTuneTargetValue");
        this.jTuneCriteriaLabel.setText("Criteria:");
        this.jTuneCriteriaLabel.setName("jTuneCriteriaLabel");
        this.jTuneCriteriaValue.setText("Average Accuracy");
        this.jTuneCriteriaValue.setName("jTuneCriteriaValue");
        this.jTuneThresholdLabel.setText("Threshold:");
        this.jTuneThresholdLabel.setName("jTuneThresholdLabel");
        this.jTuneThresholdValue.setText("0.56789");
        this.jTuneThresholdValue.setName("jTuneThresholdValue");
        this.jMatrixLbl1.setText("Derived Cost Matrix:");
        this.jMatrixLbl1.setName("jMatrixLbl1");
        this.jCostMatrixBtn.setText("View...");
        this.jCostMatrixBtn.setName("jCostMatrixBtn");
        this.jCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTuneMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jTuneMatrixTable.setName("jTuneMatrixTable");
        this.jTuneMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.jTuneMatrixTable);
        this.jLabel7.setText("Rows: Actual; Columns: Predicted");
        this.jLabel7.setName("jLabel7");
        GroupLayout groupLayout3 = new GroupLayout(this.jCostMatrixPanel);
        this.jCostMatrixPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jComboAccurayTypes, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneBtn)).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jMatrixLbl, GroupLayout.Alignment.LEADING).addComponent(this.jTuneSettingsLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jTuneMethodValue)).addComponent(this.jTuneMethodLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneCriteriaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneTargetValue).addComponent(this.jTuneCriteriaValue).addComponent(this.jTuneThresholdValue))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addComponent(this.jMatrixLbl1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCostMatrixBtn))).addContainerGap(28, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jMatrixLbl).addGap(1, 1, 1).addComponent(this.jComboAccurayTypes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jTuneSettingsLabel)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneBtn).addComponent(this.jClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneMethodLabel).addComponent(this.jTuneMethodValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneCriteriaLabel).addComponent(this.jTuneCriteriaValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneThresholdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatrixLbl1).addComponent(this.jCostMatrixBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jCostMatrixPanel);
        this.jSplitPane2.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.dataMinerTablePanel.setName("dataMinerTablePanel");
        this.jSplitPane1.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 750, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 490, Short.MAX_VALUE));
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this.getPanelState().getRocState().setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jRocGraphPanel.removeAll();
        this.jRocGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this.getPanelState().getShareState(), null);
        rOCTabPanelState.getClass();
        dataMinerTable.setModel((TableModel)((Object)rOCTabPanelState.new ROCTabPanelState.ROCTuneTableModel(null, false)));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void jCustomROCActionPerformed(ActionEvent actionEvent) {
        ThresholdPanel thresholdPanel = new ThresholdPanel(this.getPanelState().getRocState());
        if (thresholdPanel.showAsDialog(this)) {
            this.getPanelState().getRocState().refreshCustomThresholdData();
            this.jRocGraphPanel.removeAll();
            this.jRocGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
            DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
            ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this.getPanelState().getShareState(), null);
            rOCTabPanelState.getClass();
            dataMinerTable.setModel((TableModel)((Object)rOCTabPanelState.new ROCTabPanelState.ROCTuneTableModel(null, false)));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(true);
            loadUI.execute();
        }
    }

    private void jComboAccurayTypesActionPerformed(ActionEvent actionEvent) {
        this.loadConfusionMatrix();
    }

    private void jTuneBtnActionPerformed(ActionEvent actionEvent) {
        Object object;
        ROCAccuracyType rOCAccuracyType = null;
        ROCCustomThresholdType rOCCustomThresholdType = null;
        double d = 0.0;
        String string = (String)this.jComboAccurayTypes.getSelectedItem();
        String string2 = this.getPanelState().getShareState().getSelectTestResult();
        int n = 0;
        if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string2).getMaxOverallAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.MAX_ACCURACY;
        } else if (string.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string2).getMaxAvgAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.AVG_ACCURACY;
        } else if (string.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string2).getCustomAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.CUSTOM_ACCURACY;
            d = this.getPanelState().getRocState().getCustomThresholdValue();
            object = this.getPanelState().getRocState().getCustomThresholdOption();
            if (((String)object).compareTo("CUSTOM_THRESHOLD_OP_HIT_RATIO") == 0) {
                rOCCustomThresholdType = ROCCustomThresholdType.HIT_RATIO;
            } else if (((String)object).compareTo("CUSTOM_THRESHOLD_OP_FALSE_ALARM") == 0) {
                rOCCustomThresholdType = ROCCustomThresholdType.FALSE_ALARM;
            } else if (((String)object).compareTo("CUSTOM_THRESHOLD_OP_FALSE_RATIO") == 0) {
                rOCCustomThresholdType = ROCCustomThresholdType.FALSE_POS_NEG_RATIO;
            }
        } else if (string.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string2).getModelAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.CURRENT_MODEL;
        }
        if (n >= 0) {
            Object object2;
            object = this.getPanelState().getRocState().getROCData().get(string2).get(n);
            double d2 = ((ROCTabPanelState.ROCData)object).getProb();
            this.getPanelState().getRocState().setCustomThresholdValue(d2);
            double d3 = 1.0E-6f;
            double d4 = d2 - d3 < 0.0 ? d2 : d2 - d3;
            double d5 = (1.0 - d4) / d4;
            String string3 = this.getPanelState().getRocState().getSelectedTargetValue();
            CostMatrixType costMatrixType = new CostMatrixType();
            TuningType.Custom.Settings.ROC rOC = new TuningType.Custom.Settings.ROC();
            rOC.setAccuracy(rOCAccuracyType);
            rOC.setThreshold(d2);
            if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                object2 = new TuningType.Custom.Settings.ROC.CustomThreshold();
                object2.setType(rOCCustomThresholdType);
                object2.setValue(d);
                rOC.setCustomThreshold((TuningType.Custom.Settings.ROC.CustomThreshold)object2);
            }
            object2 = this.getPanelState().getModelTargetValues();
            Iterator iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Iterator iterator2 = ((Vector)object2).iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    CostMatrixType.Item item = new CostMatrixType.Item();
                    item.setActual(e.toString());
                    item.setPredict(e2.toString());
                    if (e.toString().compareTo(e2.toString()) == 0) {
                        item.setCost(0.0);
                    } else if (e.toString().compareTo(string3) == 0 && e2.toString().compareTo(string3) != 0) {
                        item.setCost(d5);
                    } else {
                        item.setCost(1.0);
                    }
                    costMatrixType.getItem().add(item);
                }
            }
            this.getPanelState().setTuningCustom(string2, string3, rOC, costMatrixType);
            int n2 = this.dataMinerTablePanel.getTable().getSelectedRow();
            this.dataMinerTablePanel.getTable().tableChanged(new TableModelEvent(this.dataMinerTablePanel.getTable().getModel()));
            this.dataMinerTablePanel.getTable().setRowSelectionInterval(n2, n2);
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    private void jClearButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getPanelState().getShareState().getSelectTestResult();
        this.getPanelState().setTuningNone(string);
        int n = this.dataMinerTablePanel.getTable().getSelectedRow();
        this.dataMinerTablePanel.getTable().tableChanged(new TableModelEvent(this.dataMinerTablePanel.getTable().getModel()));
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = this.getPanelState().getShareState().getSelectTestResult();
        boolean bl2 = this.getPanelState().getBenefitState().getTuneBenefitWeight(string) != null;
        boolean bl3 = bl = this.getPanelState().getCostState().getTuneCostMatrix(string) != null;
        if (bl2) {
            WeightsType weightsType = this.getPanelState().getBenefitState().getTuneBenefitWeight(string);
            CostBenefitDetailPanel costBenefitDetailPanel = new CostBenefitDetailPanel(weightsType);
            costBenefitDetailPanel.showAsDialog(this);
        } else if (bl) {
            CostMatrixInfo costMatrixInfo = this.getPanelState().getCostState().getTuneCostMatrixInfo(string);
            CostMatrixDetailPanel costMatrixDetailPanel = new CostMatrixDetailPanel(costMatrixInfo);
            costMatrixDetailPanel.showAsDialog(this);
        }
    }

    private void loadConfusionMatrix() {
        String string = this.getPanelState().getShareState().getSelectTestResult();
        ROCTabPanelState.ROCData rOCData = null;
        String string2 = null;
        String string3 = null;
        String string4 = (String)this.jComboAccurayTypes.getSelectedItem();
        int n = 0;
        if (string4.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string).getMaxOverallAccuracyIdx();
        } else if (string4.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string).getMaxAvgAccuracyIdx();
        } else if (string4.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string).getCustomAccuracyIdx();
        } else if (string4.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
            n = this.getPanelState().getRocState().getStatisticsData().get(string).getModelAccuracyIdx();
        }
        rOCData = n >= 0 ? this.getPanelState().getRocState().getROCData().get(string).get(n) : null;
        string2 = this.getPanelState().getRocState().getSelectedTargetValue();
        Vector<Object> vector = this.getPanelState().getModelTargetValues();
        string3 = vector.size() == 2 ? (string2.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
        ((BaseCostMatrixTable)this.jMatrixTable).setModel(new TuneState.MatrixModel(new PerformanceMatrixDataProvider(this.getPanelState().getRocState().getSelectedTargetValue(), string3, rOCData, this._percentageFormat)));
    }

    private void loadTuneMatrix() {
        String string = this.getPanelState().getShareState().getSelectTestResult();
        if (this.getPanelState().isTuningNone(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        } else if (this.getPanelState().isTuningBenefit(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_BENEFIT);
        } else if (this.getPanelState().isTuningCost(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_COST);
        } else if (this.getPanelState().isTuningCustom(string)) {
            String string2 = null;
            TuneState.TuningCustomData tuningCustomData = this.getPanelState().getTuningCustomData(string);
            String string3 = tuningCustomData.getTargetValue();
            Vector<Object> vector = this.getPanelState().getModelTargetValues();
            this.jTuneTargetValue.setText(string3);
            Object object = tuningCustomData.getTuneType();
            CostMatrixType costMatrixType = tuningCustomData.getCostMatrix();
            if (object instanceof TuningType.Custom.Settings.ROC) {
                TuningType.Custom.Settings.ROC rOC = (TuningType.Custom.Settings.ROC)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_ROC);
                ROCAccuracyType rOCAccuracyType = rOC.getAccuracy();
                if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                    TuningType.Custom.Settings.ROC.CustomThreshold customThreshold = rOC.getCustomThreshold();
                    String string4 = customThreshold.getType().value();
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value() + ", " + string4 + ": " + this._percentageFormat.format(customThreshold.getValue()));
                } else {
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value());
                }
                this.jTuneThresholdValue.setText(this._percentageFormat.format(rOC.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Lift) {
                TuningType.Custom.Settings.Lift lift = (TuningType.Custom.Settings.Lift)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_LIFT);
                String string5 = lift.getType().value();
                this.jTuneCriteriaValue.setText("Quantile: " + lift.getQuantile() + " (" + string5 + ")");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(lift.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Profit) {
                TuningType.Custom.Settings.Profit profit = (TuningType.Custom.Settings.Profit)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_PROFIT);
                this.jTuneCriteriaValue.setText("Population: " + this._percentageFormat.format(profit.getPopulation()) + "%, ROI: " + this._percentageFormat.format(profit.getROI()) + "%");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(profit.getProfit()));
            }
            string2 = vector.size() == 2 ? (string3.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
            ((BaseCostMatrixTable)this.jTuneMatrixTable).setModel(new TuneState.MatrixModel(new TuneState.TuneMatrixDataProvider(string3, string2, costMatrixType, this._percentageFormat)));
        }
    }

    private void initConfusionMatrix() {
        this.jComboAccurayTypes.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("OVERALL_ACCURACY"), TestViewerLrb.get("AVG_ACCURACY"), TestViewerLrb.get("CUSTOM_ACCURACY"), TestViewerLrb.get("CURRENT_ACCURACY")}));
        this.jComboAccurayTypes.setSelectedIndex(0);
        this.loadConfusionMatrix();
    }

    @Override
    public void showData(Object object) {
        this.jDetailBtnActionPerformed();
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._reload) {
                    ROCTabPanel.this.getPanelState().getRocState().refreshROCStatData(false);
                } else {
                    ROCTabPanel.this.getPanelState().getRocState().load(false);
                }
                ROCTabPanel.this._graphPanel.initGraph(ROCTabPanel.this.getPanelState().getRocState().getRocGraphModel());
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ROCTabPanel.this.getPanelState().getRocState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    ROCTabPanel.this.jRocGraphPanel.removeAll();
                    ROCTabPanel.this.jRocGraphPanel.add((Component)ROCTabPanel.this._graphPanel, "Center");
                    ROCTabPanel.this.jRocGraphPanel.updateUI();
                    String string = ROCTabPanel.this.getPanelState().getShareState().getSelectTestResult();
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 275);
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)ROCTabPanel.this.getPanelState().getRocState().getRocTableModel()));
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                    ROCTabPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                    TableColumnModel tableColumnModel = ROCTabPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                        @Override
                        public Color getColorFor(Object object) {
                            String string = (String)object;
                            return ROCTabPanel.this.getPanelState().getRocState().getParentTestViewerState().getTestResultGraphColor(string);
                        }
                    });
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getMODEL()).setCellRenderer(colorCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getAREA_UNDER_CURVE()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getCURRENT()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getCUSTOM()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getMAX_AVG()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getMAX_OVERALL()).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getCREATION_DATE()).setCellRenderer(new DateCellRenderer2());
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getTUNE()).setPreferredWidth(90);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getAREA_UNDER_CURVE()).setPreferredWidth(120);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getCURRENT()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getCUSTOM()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getMAX_AVG()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getMAX_OVERALL()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getALGORITHM()).setPreferredWidth(150);
                    tableColumnModel.getColumn(ROCTabPanel.this.getPanelState().getRocState().getCREATION_DATE()).setPreferredWidth(150);
                    if (!this._reload) {
                        ROCTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ROCTabPanel.this.getPanelState().getRocState().getTargetValues()));
                        ROCTabPanel.this.jTargetComb.setSelectedItem(ROCTabPanel.this.getPanelState().getRocState().getSelectedTargetValue());
                        ROCTabPanel.this.initConfusionMatrix();
                    } else {
                        ROCTabPanel.this.loadConfusionMatrix();
                    }
                    int n = -1;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ROCTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            d = (Double)ROCTabPanel.this.getPanelState().getRocState().getRocTableModel().getValueAt(i, ROCTabPanel.this.getPanelState().getRocState().getAREA_UNDER_CURVE());
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n = i;
                        }
                    } else {
                        for (int i = 0; i < ROCTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            Object object = ROCTabPanel.this.getPanelState().getRocState().getRocTableModel().getValueAt(i, ROCTabPanel.this.getPanelState().getRocState().getMODEL());
                            if (!string.equals(object)) continue;
                            n = i;
                            break;
                        }
                    }
                    if (n >= 0) {
                        ROCTabPanel.this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), null);
                }
                ROCTabPanel.this.enableControls(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ROCTabPanel.this._loading = false;
            }
        }
    }

    private static class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private ROCTabPanelState.ROCData _data;
        private NumberFormat _percentageFormat;

        PerformanceMatrixDataProvider(String string, String string2, ROCTabPanelState.ROCData rOCData, NumberFormat numberFormat) {
            this._positiveTarget = string;
            this._otherTarget = string2;
            this._data = rOCData;
            this._percentageFormat = numberFormat;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return this._percentageFormat.format(this._data.getTruePositives());
            }
            if (n == 0 && n2 == 1) {
                return this._percentageFormat.format(this._data.getFalseNegatives());
            }
            if (n == 1 && n2 == 0) {
                return this._percentageFormat.format(this._data.getFalsePositives());
            }
            if (n == 1 && n2 == 1) {
                return this._percentageFormat.format(this._data.getTrueNegatives());
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

