/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONQueryStructureTreeTable;
import oracle.dmt.dataminer.controls.JSONStructureDefaultTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructurePanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONDataPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.NameChangeListener;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class JSONPanel
extends AbstractPanel<JSONQueryNode>
implements NameChangeListener {
    private JSONStructurePanel2 _JSONStructurePanel2;
    private JSONDataPanel _JSONDataPanel;
    private JSONQueryEditorPanel _parent;
    private UserObject _curJSONCol = null;
    private Map<String, JSONAttributeType> _JSONAttributesMap = new HashMap<String, JSONAttributeType>();
    private static UserObject SELECT_A_COLUMN;
    private static String JSON_STARTING_ARRAY;
    private JComboBox jColumnComboBox;
    private JLabel jColumnLabel;
    private JPanel jInfoPanel;
    private JLabel jStatusIconLabel;
    private JTabbedPane jTabbedPane;
    private JLabel infoMsg = new JLabel();
    private static String SOURCE_TAB;
    private static String DATA_TAB;

    public JSONPanel(Context context, JSONQueryEditorPanel jSONQueryEditorPanel) {
        super(context, null);
        assert (context != null) : "Context must not be null.";
        this._parent = jSONQueryEditorPanel;
        AttributeType attributeType = new AttributeType();
        attributeType.setName(DialogsLrb.get("JSON_QUERY_SOURCE_SELECT_COLUMN"));
        attributeType.setStatus(AttributeStatus.INVALID);
        SELECT_A_COLUMN = new UserObject(attributeType);
        JSONAttributesType jSONAttributesType = this._parent.getJSONAttributes();
        if (jSONAttributesType != null) {
            for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                this._JSONAttributesMap.put(jSONAttributeType.getPath(), jSONAttributeType);
            }
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.jStatusIconLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.jStatusIconLabel.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_COLUMN_INVALID_TIP"));
        this.jStatusIconLabel.setText("");
        this.infoMsg.setText(DialogsLrb.get("JSON_QUERY_MISSING_DATA_GUIDE_MESSAGE"));
        this.infoMsg.setIcon(OracleIcons.getIcon((String)"warning.png"));
    }

    @Override
    public void initUI() {
        List list;
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.infoMsg.setVerticalTextPosition(1);
        this.infoMsg.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jInfoPanel.setVisible(false);
        this.jInfoPanel.setMaximumSize(new Dimension(100, 50));
        this.jInfoPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.jInfoPanel.setLayout(new BorderLayout());
        this.jInfoPanel.add(this.infoMsg);
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)jSONQueryNode.findParentNode());
        this._JSONStructurePanel2 = new JSONStructurePanel2(this._context, jSONQueryNode, null, null, null, dataGuideProvider);
        this.jTabbedPane.add(SOURCE_TAB, this._JSONStructurePanel2);
        this._JSONDataPanel = new JSONDataPanel(this._context, this._parent);
        this.jTabbedPane.add(DATA_TAB, this._JSONDataPanel);
        AttributeType attributeType = this._parent.getJSONSourceColumn();
        DataProvider dataProvider = (DataProvider)((Object)jSONQueryNode.findParentNode());
        Vector<Object> vector = new Vector<Object>();
        if (dataProvider != null) {
            list = dataProvider.getAttributes().getAttribute();
            for (AttributeType attributeType2 : list) {
                if (!DatabaseMetadataUtils.isJSONTypeSupported(DatabaseMetadataUtils.getJSONDataType(attributeType2.getDataType(), attributeType2.getDataTypeQualifier()))) continue;
                UserObject userObject = new UserObject(attributeType2);
                vector.addElement(userObject);
                if (attributeType == null || attributeType.getName() == null || attributeType.getName().compareToIgnoreCase(attributeType2.getName()) != 0) continue;
                this._curJSONCol = userObject;
                this.jStatusIconLabel.setVisible(false);
            }
        }
        if (this._curJSONCol == null) {
            if (attributeType != null && attributeType.getName() != null) {
                list = new AttributeType();
                list.setName(attributeType.getName());
                list.setDataType(attributeType.getDataType());
                list.setStatus(AttributeStatus.INVALID);
                UserObject userObject = new UserObject((AttributeType)list);
                vector.addElement(userObject);
                this._curJSONCol = userObject;
            } else {
                this._curJSONCol = SELECT_A_COLUMN;
                vector.add(0, SELECT_A_COLUMN);
            }
            this.jStatusIconLabel.setVisible(true);
        }
        this.jColumnComboBox.setModel(new DefaultComboBoxModel(vector));
        this.jColumnComboBox.setSelectedItem(this._curJSONCol);
        if (this._curJSONCol != SELECT_A_COLUMN) {
            this.reload();
        }
    }

    private void initComponents() {
        this.jColumnLabel = new JLabel();
        this.jColumnComboBox = new JComboBox();
        this.jStatusIconLabel = new JLabel();
        this.jTabbedPane = new JTabbedPane();
        this.jInfoPanel = new JPanel();
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setName("jColumnLabel");
        this.jColumnComboBox.setName("jColumnComboBox");
        this.jColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONPanel.this.jColumnComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStatusIconLabel.setText("warnIcon");
        this.jStatusIconLabel.setName("jStatusIconLabel");
        this.jTabbedPane.setName("jTabbedPane");
        this.jInfoPanel.setName("jInfoPanel");
        this.jInfoPanel.setPreferredSize(new Dimension(0, 30));
        this.jInfoPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 785, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jColumnLabel, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jColumnComboBox, -2, 228, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStatusIconLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jInfoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jColumnLabel).addComponent(this.jColumnComboBox, -2, -1, -2).addComponent(this.jStatusIconLabel)).addGap(18, 18, 18).addComponent(this.jTabbedPane, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInfoPanel, -2, -1, -2).addContainerGap()));
    }

    private void jColumnComboBoxActionPerformed(ActionEvent actionEvent) {
        UserObject userObject = (UserObject)this.jColumnComboBox.getSelectedItem();
        if (userObject != SELECT_A_COLUMN) {
            this.jColumnComboBox.removeItem(SELECT_A_COLUMN);
            if (this._curJSONCol != userObject) {
                this._parent.setJSONSourceColumn(userObject.getAttr());
                this._curJSONCol = userObject;
                JSONAttributesType jSONAttributesType = this._parent.getJSONAttributes();
                this._JSONAttributesMap.clear();
                if (jSONAttributesType != null) {
                    for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                        this._JSONAttributesMap.put(jSONAttributeType.getPath(), jSONAttributeType);
                    }
                }
                if (this._JSONStructurePanel2 != null) {
                    if (this._curJSONCol != SELECT_A_COLUMN) {
                        this.reload();
                    }
                    this._parent.setJSONDirty(true);
                }
            }
        }
    }

    protected String getHelpTopic() {
        return "json_attributes";
    }

    private DataGuideType generateDataGuideFromMeta(AttributeType attributeType) {
        DataGuideType dataGuideType = null;
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)jSONQueryNode.getData();
        JSONAttributesType jSONAttributesType = jSONQueryNodeType.getJSONAttributes();
        if (jSONAttributesType.getSource() != null && jSONAttributesType.getSource().compareTo(attributeType.getName()) == 0) {
            dataGuideType = new DataGuideType();
            for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                DataGuideType.Item item = new DataGuideType.Item();
                item.setPath(jSONAttributeType.getPath());
                item.setType(jSONAttributeType.getDataType());
                dataGuideType.getItem().add(item);
            }
        }
        return dataGuideType;
    }

    private List<JSONAttributeType> collectJSONAttributes() {
        ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>();
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)jSONQueryNode.getData();
        if (null != jSONQueryNodeType.getJSONAttributes()) {
            return jSONQueryNodeType.getJSONAttributes().getJSONAttribute();
        }
        return arrayList;
    }

    private Map<String, JSONAttributeType> collectAggregationJSONAttributes() {
        HashMap<String, JSONAttributeType> hashMap = new HashMap<String, JSONAttributeType>();
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)jSONQueryNode.getData();
        AggregationElementsExType aggregationElementsExType = jSONQueryNodeType.getAggregationElements();
        if (aggregationElementsExType != null && aggregationElementsExType.getAggregationElement() != null && !aggregationElementsExType.getAggregationElement().isEmpty()) {
            for (AggregationElementsExType.AggregationElement aggregationElement : aggregationElementsExType.getAggregationElement()) {
                AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy;
                if (null == hashMap.get(aggregationElement.getJSONAttribute().getPath())) {
                    hashMap.put(aggregationElement.getJSONAttribute().getPath(), aggregationElement.getJSONAttribute());
                }
                if ((subGroupBy = aggregationElement.getSubGroupBy()) == null || subGroupBy.getAttributes() == null || subGroupBy.getAttributes().getJSONAttribute().isEmpty()) continue;
                for (JSONAttributeType jSONAttributeType : subGroupBy.getAttributes().getJSONAttribute()) {
                    if (null != hashMap.get(jSONAttributeType.getPath())) continue;
                    hashMap.put(jSONAttributeType.getPath(), jSONAttributeType);
                }
            }
        }
        return hashMap;
    }

    @Override
    public void relColNameChanged(String string, String string2) {
    }

    @Override
    public void jsonColNameChanged(String string, String string2, String string3) {
        JSONAttributesType jSONAttributesType = this._parent.getJSONAttributes();
        if (jSONAttributesType != null) {
            for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                if (jSONAttributeType.getPath().compareTo(string) != 0 || jSONAttributeType.getDBName().compareTo(string2) != 0) continue;
                jSONAttributeType.setDBName(string3);
            }
        }
    }

    @Override
    public void aggColNameChanged(String string, String string2, List<String> list, String string3, String string4) {
    }

    private void reload() {
        this._JSONStructurePanel2.getJsonTree().getTree().setRootVisible(true);
        DataGuideType dataGuideType = null;
        try {
            dataGuideType = this._parent.getDataGuide();
            this._JSONStructurePanel2.clearTree();
            this._JSONDataPanel.clear();
            if (dataGuideType == null) {
                if (this._parent.getJSONSourceColumn() != null) {
                    dataGuideType = this.generateDataGuideFromMeta(this._parent.getJSONSourceColumn());
                }
                this.jStatusIconLabel.setVisible(true);
                this.jInfoPanel.setVisible(true);
                if (dataGuideType != null) {
                    ((JSONStructureDefaultTreeTableModel)((Object)this._JSONStructurePanel2.getJsonTree().getTree().getModel())).setLoadingStatus();
                    this._JSONStructurePanel2.reload2(this._curJSONCol.getAttr(), null, dataGuideType, this.collectJSONAttributes());
                }
            } else {
                this.jInfoPanel.setVisible(false);
                this.jStatusIconLabel.setVisible(false);
                if (dataGuideType != null) {
                    ((JSONStructureDefaultTreeTableModel)((Object)this._JSONStructurePanel2.getJsonTree().getTree().getModel())).setLoadingStatus();
                    this._JSONStructurePanel2.reload2(this._curJSONCol.getAttr(), this._parent.getJSONAttributes().getJSONAttribute(), dataGuideType, this.collectJSONAttributes());
                    this._JSONDataPanel.reload();
                }
            }
            this._JSONStructurePanel2.updatePanelTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        JSON_STARTING_ARRAY = "$.\"[*]\"";
        SOURCE_TAB = DialogsLrb.get("JSON_QUERY_SOURCE_STRUCTURE_TAB");
        DATA_TAB = DialogsLrb.get("JSON_QUERY_SOURCE_DATA_TAB");
    }

    private class UserObject {
        private AttributeType attr;

        public UserObject(AttributeType attributeType) {
            this.attr = attributeType;
        }

        public String toString() {
            return this.attr.getName();
        }

        public AttributeType getAttr() {
            return this.attr;
        }
    }

    private class JSONStructurePanel2
    extends JSONStructurePanel {
        public JSONStructurePanel2(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, List<JSONAttributeType> list, List<JSONAttributeType> list2, DataGuideProvider dataGuideProvider) {
            super(context, abstractDataNode, attributeType, list, list2, dataGuideProvider, true);
        }

        @Override
        protected void setPreferredColumnWidth() {
            this.jsonTree.getColumnModel().getColumn(0).setPreferredWidth(300);
            this.jsonTree.getColumnModel().getColumn(1).setPreferredWidth(10);
            this.jsonTree.getColumnModel().getColumn(2).setPreferredWidth(10);
        }

        @Override
        protected void setPanelTitle() {
            this.titleLabel.setText(ControlsLrb.get("JSON_GUIDE_STRUCTURE_PANEL_TITLE"));
        }

        @Override
        protected void createJSONTree() {
            this.jsonTree = new JSONQueryStructureTreeTable();
        }

        @Override
        protected void updatePanelTitle() {
            ArrayList arrayList = new ArrayList(JSONPanel.this._JSONAttributesMap.values());
            String string = "";
            JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
            int n = jSONStructureDefaultTreeTableModel.getNodeCount();
            if (1 < n) {
                int n2 = 0;
                if (arrayList != null) {
                    n2 += arrayList.size();
                }
                Object[] objectArray = new Object[]{n2, n - 1};
                string = MessageFormat.format(titleTemplate, objectArray);
            }
            this.titleLabel.setText(string);
        }

        @Override
        public void jsonAttrSelectionChanged(Map<String, Boolean> map) {
            if (map.isEmpty()) {
                return;
            }
            JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.getJsonTree().getTreeModel();
            Iterator<String> iterator = map.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                int n;
                String string = iterator.next();
                if (string.compareTo(JSON_STARTING_ARRAY) == 0 || (n = string.lastIndexOf(46)) <= 0) continue;
                JSONAttributeType jSONAttributeType = (JSONAttributeType)JSONPanel.this._JSONAttributesMap.get(string);
                if (Boolean.TRUE.equals(map.get(string))) {
                    if (jSONAttributeType != null) continue;
                    jSONAttributeType = new JSONAttributeType();
                    jSONAttributeType.setPath(string);
                    String string2 = StringUtils.trimDoubleQuotes(string.substring(n + 1, string.length()));
                    string2 = string2.toUpperCase();
                    string2 = string2.replaceAll("\\s+", "");
                    JSONElement jSONElement = jSONStructureDefaultTreeTableModel.getNodeByPath(string);
                    jSONAttributeType.setDataType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN));
                    if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                        jSONAttributeType.setUnnest(Boolean.TRUE);
                    }
                    jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN)));
                    jSONAttributeType.setDBName(JSONPanel.this._parent.getNameGenerator().GenerateName(string2, jSONAttributeType.getPath()));
                    jSONAttributeType.setStatus(AttributeStatus.VALID);
                    JSONPanel.this._JSONAttributesMap.put(string, jSONAttributeType);
                    bl = true;
                    continue;
                }
                if (jSONAttributeType == null) continue;
                JSONPanel.this._JSONAttributesMap.remove(string);
                bl = true;
            }
            if (bl) {
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().clear();
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().addAll(JSONPanel.this._JSONAttributesMap.values());
                JSONPanel.this._parent.setJSONDirty(true);
            }
            super.jsonAttrSelectionChanged(map);
        }

        @Override
        public void jsonAttrUnnestedChanged(Map<String, Boolean> map) {
            if (map.isEmpty()) {
                return;
            }
            Iterator<String> iterator = map.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                JSONAttributeType jSONAttributeType;
                int n;
                String string = iterator.next();
                if (string.compareTo(JSON_STARTING_ARRAY) == 0 || (n = string.lastIndexOf(46)) <= 0 || (jSONAttributeType = (JSONAttributeType)JSONPanel.this._JSONAttributesMap.get(string)) == null) continue;
                if (Boolean.TRUE.equals(map.get(string))) {
                    jSONAttributeType.setUnnest(Boolean.TRUE);
                    jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType(jSONAttributeType.getDataType()));
                    bl = true;
                    continue;
                }
                jSONAttributeType.setUnnest(Boolean.FALSE);
                jSONAttributeType.setDBDataType("VARCHAR2");
                bl = true;
            }
            if (bl) {
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().clear();
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().addAll(JSONPanel.this._JSONAttributesMap.values());
                JSONPanel.this._parent.setJSONDirty(true);
            }
        }
    }
}

