/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AddGroupByColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONDataMinerTablePanel;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class GroupByAggregationTablePanel
extends JSONDataMinerTablePanel {
    public static int NAME = 0;
    public static int PATH = 1;
    protected static String[] _colNames = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
    private static final int PATH_INDEX = 0;
    private static final int DATA_TYPE_INDEX = 1;
    private static String title = DialogsLrb.get("JSON_QUERY_AGGREGATION_GROUP_BY_TITLE");

    @Override
    public void initUI() {
        super.initUI();
        this.addControlBarComponents(new Component[0]);
        this.getTable().setFillsViewportHeight(true);
        this.getTable().setSelectionMode(2);
        this.getTable().setShowGrid(true);
        this.getTable().setShowHorizontalLines(true);
        this.getTable().setShowVerticalLines(true);
        this.getTable().setFixedColumns(0, new int[0]);
        GroupByTableModel groupByTableModel = new GroupByTableModel();
        this.getTable().setModel((TableModel)((Object)groupByTableModel));
        this.getTable().setSorted(true);
        this.getTable().setColumnSelectorAvailable(true);
        this.getTable().setAutoResizeMode(4);
        TableColumnModel tableColumnModel = this.getTable().getFullColumnModel();
        tableColumnModel.getColumn(NAME).setPreferredWidth(200);
        tableColumnModel.getColumn(PATH).setPreferredWidth(90);
        tableColumnModel.getColumn(NAME).setCellRenderer(new JSONDataMinerTablePanel.CustomCellRenderer(this, NAME));
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = GroupByAggregationTablePanel.this.getTable().getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    GroupByAggregationTablePanel.this.enableRemoveButton(true);
                } else {
                    GroupByAggregationTablePanel.this.enableRemoveButton(false);
                }
            }
        });
        if (this._parent.getJSONSourceColumn() != null) {
            this.enableControls(true);
        }
        this.configureSearchField();
    }

    @Override
    protected void configureSearchField() {
        this.getSearchField().setPrompt(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_PROMPT"));
        SearchCategory searchCategory = new SearchCategory(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PATH"));
        this.getSearchField().addCategory(searchCategory);
        this.getSearchField().addCategory(new SearchCategory(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_TYPE")));
        this.getSearchField().setSelectedCategory(searchCategory);
        RowFilter<GroupByTableModel, Integer> rowFilter = new RowFilter<GroupByTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends GroupByTableModel, ? extends Integer> entry) {
                int n = -1;
                String string = GroupByAggregationTablePanel.this.getSearchField().getSelectedCategory().getLabel();
                if (string.equals(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PATH"))) {
                    n = 0;
                } else if (string.equals(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_TYPE"))) {
                    n = 1;
                }
                String string2 = GroupByAggregationTablePanel.this.getSearchField().getText();
                SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string2, (boolean)true);
                boolean bl = false;
                boolean bl2 = false;
                Integer n2 = entry.getIdentifier();
                GroupByTableModel groupByTableModel = entry.getModel();
                Object object = groupByTableModel.getRowData(n2);
                String string3 = "";
                if (object instanceof JSONAttributeType) {
                    JSONAttributeType jSONAttributeType = (JSONAttributeType)object;
                    if (n == NAME) {
                        if (GroupByAggregationTablePanel.this.isShowPath()) {
                            string3 = jSONAttributeType.getPath();
                        } else {
                            String string4 = jSONAttributeType.getPath();
                            int n3 = string4.lastIndexOf(".");
                            string3 = string4.substring(n3 + 1, string4.length());
                        }
                    } else {
                        string3 = jSONAttributeType.getDataType();
                    }
                } else if (object instanceof AttributeExType) {
                    AttributeExType attributeExType = (AttributeExType)object;
                    string3 = n == NAME ? attributeExType.getName() : (attributeExType.getNewDataType() != null ? attributeExType.getNewDataType() : attributeExType.getDataType());
                }
                bl2 = searchMatcher.matches((CharSequence)string3);
                bl = bl2;
                return bl;
            }
        };
        this.getSearchField().addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this.getTable(), rowFilter, 0));
    }

    public void reload() {
        GroupByTableModel groupByTableModel = (GroupByTableModel)((Object)this.getTable().getModel());
        groupByTableModel.reload();
        if (this._parent.getJSONSourceColumn() != null) {
            this.enableControls(true);
        }
    }

    @Override
    protected boolean isValidElement(int n) {
        GroupByTableModel groupByTableModel = (GroupByTableModel)((Object)this.getTable().getModel());
        Object object = groupByTableModel.getRowData(n);
        if (object instanceof JSONAttributeType) {
            JSONAttributeType jSONAttributeType = (JSONAttributeType)object;
            return this.isValidJSONAttributeType(jSONAttributeType);
        }
        if (object instanceof AttributeExType) {
            AttributeExType attributeExType = (AttributeExType)object;
            return attributeExType.getStatus().equals((Object)AttributeStatus.VALID);
        }
        return false;
    }

    private void enableControls(boolean bl) {
        this.getSearchField().setEnabled(bl);
        this.enableEditBtn(true);
    }

    @Override
    protected void showJSONPaths() {
        GroupByTableModel groupByTableModel = (GroupByTableModel)((Object)this.getTable().getModel());
        groupByTableModel.showFullPath();
    }

    @Override
    public String getTableTitle() {
        return title;
    }

    @Override
    protected void editAction(ActionEvent actionEvent) {
        AddGroupByColumnPanel addGroupByColumnPanel;
        GroupingElementExType.Attributes attributes;
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        GroupingElementExType groupingElementExType = (GroupingElementExType)MetaDataHelper.copyMetadataObject(this._parent.getGroupingElement());
        if (null == this._parent.getGroupingElement().getAttributes()) {
            attributes = new GroupingElementExType.Attributes();
            this._parent.getGroupingElement().setAttributes(attributes);
        }
        if ((addGroupByColumnPanel = new AddGroupByColumnPanel(this._context, jSONQueryNode, this._parent, attributes = this._parent.getGroupingElement())).showAsDialog(this)) {
            GroupByTableModel groupByTableModel = (GroupByTableModel)((Object)this.getTable().getModel());
            groupByTableModel.reload();
            this._parent.setAggregDirty(true);
        } else {
            this._parent.setGroupingElement(groupingElementExType);
        }
    }

    @Override
    protected void removeAction(ActionEvent actionEvent) {
        ArrayList<AttributeExType> arrayList = new ArrayList<AttributeExType>();
        ArrayList<JSONAttributeType> arrayList2 = new ArrayList<JSONAttributeType>();
        GroupByTableModel groupByTableModel = (GroupByTableModel)((Object)this.getTable().getModel());
        int[] nArray = this.getTable().getSelectedRowsInModel();
        for (int i = 0; i < nArray.length; ++i) {
            Object object = groupByTableModel.getRowData(nArray[i]);
            if (object instanceof AttributeExType) {
                arrayList.add((AttributeExType)object);
                continue;
            }
            if (!(object instanceof JSONAttributeType)) continue;
            arrayList2.add((JSONAttributeType)object);
        }
        if (!arrayList.isEmpty()) {
            this._parent.getGroupingElement().getAttributes().getAttribute().removeAll(arrayList);
        }
        if (!arrayList2.isEmpty()) {
            this._parent.getGroupingElement().getAttributes().getJSONAttribute().removeAll(arrayList2);
        }
        groupByTableModel.reload();
        this._parent.setAggregDirty(true);
    }

    @Override
    protected boolean showAddButton() {
        return false;
    }

    @Override
    protected boolean showEditButton() {
        return true;
    }

    class GroupByTableModel
    extends GenericBaseTableModel {
        private Map<String, AttributeExType> mapNameAttr;
        private List<Object> allGroupByColumns = new ArrayList<Object>();

        GroupByTableModel() {
            this.setColumnIdentifiers(_colNames);
            this.createRelAttrMap();
            if (null != GroupByAggregationTablePanel.this._parent.getGroupingElement() && null != GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes()) {
                for (AttributeExType attributeExType : GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes().getAttribute()) {
                    AttributeExType attributeExType2 = this.mapNameAttr != null ? this.mapNameAttr.get(attributeExType.getName()) : null;
                }
                this.allGroupByColumns.addAll(GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes().getAttribute());
                this.allGroupByColumns.addAll(GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes().getJSONAttribute());
            }
            this.setRowCount(this.allGroupByColumns.size());
            GroupByAggregationTablePanel.this.numberOfAttributes = this.allGroupByColumns.size();
            GroupByAggregationTablePanel.this.setTitle(GroupByAggregationTablePanel.this.getTableHeaderText());
        }

        private void createRelAttrMap() {
            if (!GroupByAggregationTablePanel.this._parent.getAvailRelationalAttributes().isEmpty()) {
                this.mapNameAttr = new HashMap<String, AttributeExType>();
                for (AttributeExType attributeExType : GroupByAggregationTablePanel.this._parent.getAvailRelationalAttributes()) {
                    this.mapNameAttr.put(attributeExType.getName(), attributeExType);
                }
            }
        }

        public void reload() {
            this.allGroupByColumns.clear();
            this.createRelAttrMap();
            if (null != GroupByAggregationTablePanel.this._parent.getGroupingElement() && null != GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes()) {
                for (AttributeExType attributeExType : GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes().getAttribute()) {
                    AttributeExType attributeExType2 = this.mapNameAttr != null ? this.mapNameAttr.get(attributeExType.getName()) : null;
                }
                this.allGroupByColumns.addAll(GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes().getAttribute());
                this.allGroupByColumns.addAll(GroupByAggregationTablePanel.this._parent.getGroupingElement().getAttributes().getJSONAttribute());
            }
            this.setRowCount(this.allGroupByColumns.size());
            this.fireTableDataChanged();
            GroupByAggregationTablePanel.this.numberOfAttributes = this.allGroupByColumns.size();
            GroupByAggregationTablePanel.this.setTitle(GroupByAggregationTablePanel.this.getTableHeaderText());
        }

        public String getColumnName(int n) {
            return _colNames[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public Object getRowData(int n) {
            return this.allGroupByColumns.get(n);
        }

        public Object getValueAt(int n, int n2) {
            Object var3_3 = null;
            Object object = this.allGroupByColumns.get(n);
            if (object instanceof JSONAttributeType) {
                JSONAttributeType jSONAttributeType = (JSONAttributeType)object;
                if (n2 == NAME) {
                    if (GroupByAggregationTablePanel.this.isShowPath()) {
                        return jSONAttributeType.getPath();
                    }
                    String string = jSONAttributeType.getPath();
                    int n3 = string.lastIndexOf(".");
                    return string.substring(n3 + 1, string.length());
                }
                return jSONAttributeType.getDataType();
            }
            if (object instanceof AttributeExType) {
                AttributeExType attributeExType = (AttributeExType)object;
                if (n2 == NAME) {
                    return attributeExType.getName();
                }
                return attributeExType.getNewDataType() != null ? attributeExType.getNewDataType() : attributeExType.getDataType();
            }
            return var3_3;
        }

        public void showFullPath() {
            this.fireTableDataChanged();
        }
    }
}

