/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideSettingsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class JSONParsingSettingsPanel
extends DialogDisplayer<AbstractNode> {
    private DataGuideSettingsType dataGuideSettings;
    private JCheckBox jChkBoxGenerateDataGuide;
    private JCheckBox jChkBoxLimitDocValues;
    private JCheckBox jChkBoxSampling;
    private JLabel jLblMaxNumDocs;
    private JLabel jLblMaxNumPerDoc;
    private JSpinner jSpinnerMaxNumDocs;
    private JSpinner jSpinnerNumPerDoc;

    public DataGuideSettingsType getDataGuideSettings() {
        return this.dataGuideSettings;
    }

    public JSONParsingSettingsPanel(Context context, DataGuideSettingsType dataGuideSettingsType) {
        super(context, null);
        this.dataGuideSettings = JSONHelper.copyDataGuideSettings(dataGuideSettingsType);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jChkBoxGenerateDataGuide = new JCheckBox();
        this.jChkBoxSampling = new JCheckBox();
        this.jSpinnerMaxNumDocs = new JSpinner();
        this.jLblMaxNumDocs = new JLabel();
        this.jChkBoxLimitDocValues = new JCheckBox();
        this.jLblMaxNumPerDoc = new JLabel();
        this.jSpinnerNumPerDoc = new JSpinner();
        this.jChkBoxGenerateDataGuide.setText("Generate Data Guide if necessary");
        this.jChkBoxSampling.setSelected(true);
        this.jChkBoxSampling.setText("Sampling");
        this.jLblMaxNumDocs.setText("Max. number of documents:");
        this.jChkBoxLimitDocValues.setText("Limit Document Values to Process");
        this.jLblMaxNumPerDoc.setText("Max. number per document:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jChkBoxSampling, -1, -1, Short.MAX_VALUE).addGap(191, 191, 191)).addGroup(groupLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jChkBoxGenerateDataGuide, -1, -1, Short.MAX_VALUE).addContainerGap(194, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(64, 64, 64).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblMaxNumDocs, -2, 214, -2).addComponent(this.jLblMaxNumPerDoc)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerMaxNumDocs, -2, 93, -2).addComponent(this.jSpinnerNumPerDoc))).addGroup(groupLayout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jChkBoxLimitDocValues, -2, 275, -2))).addContainerGap(23, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLblMaxNumDocs, this.jLblMaxNumPerDoc);
        groupLayout.linkSize(0, this.jSpinnerMaxNumDocs, this.jSpinnerNumPerDoc);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jChkBoxGenerateDataGuide).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkBoxSampling).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblMaxNumDocs).addComponent(this.jSpinnerMaxNumDocs, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jChkBoxLimitDocValues).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblMaxNumPerDoc).addComponent(this.jSpinnerNumPerDoc, -2, -1, -2)).addContainerGap(35, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        this.jChkBoxGenerateDataGuide.setText(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_DATA_GUIDE_LABEL"));
        this.jChkBoxSampling.setText(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_SAMPLING"));
        this.jLblMaxNumDocs.setText(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_MAX_NUM_DOCS"));
        this.jLblMaxNumDocs.setLabelFor(this.jSpinnerMaxNumDocs);
        this.jChkBoxLimitDocValues.setText(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_LIM_DOC_VALS"));
        this.jLblMaxNumPerDoc.setText(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_MAX_NUM_PER_DOC"));
        this.jLblMaxNumPerDoc.setLabelFor(this.jSpinnerNumPerDoc);
    }

    @Override
    public void initUI() {
        boolean bl = this.dataGuideSettings.isGenerate();
        this.jChkBoxGenerateDataGuide.setSelected(bl);
        this.jChkBoxGenerateDataGuide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = JSONParsingSettingsPanel.this.jChkBoxGenerateDataGuide.isSelected();
                JSONParsingSettingsPanel.this.jChkBoxSampling.setEnabled(bl);
                JSONParsingSettingsPanel.this.jSpinnerMaxNumDocs.setEnabled(bl && JSONParsingSettingsPanel.this.jChkBoxSampling.isSelected());
                JSONParsingSettingsPanel.this.jChkBoxLimitDocValues.setEnabled(bl);
                JSONParsingSettingsPanel.this.jSpinnerNumPerDoc.setEnabled(bl && JSONParsingSettingsPanel.this.jChkBoxLimitDocValues.isSelected());
            }
        });
        this.jChkBoxSampling.setSelected(!this.dataGuideSettings.isUseFullData());
        this.jChkBoxSampling.setEnabled(bl);
        this.jChkBoxSampling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = JSONParsingSettingsPanel.this.jChkBoxSampling.isSelected();
                JSONParsingSettingsPanel.this.jSpinnerMaxNumDocs.setEnabled(bl);
            }
        });
        this.jSpinnerMaxNumDocs.setValue(this.dataGuideSettings.getNumberOfRows());
        this.jSpinnerMaxNumDocs.setEnabled(bl && !this.dataGuideSettings.isUseFullData());
        this.jChkBoxLimitDocValues.setSelected(!this.dataGuideSettings.isUseFullDoc());
        this.jChkBoxLimitDocValues.setEnabled(bl);
        this.jChkBoxLimitDocValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = JSONParsingSettingsPanel.this.jChkBoxLimitDocValues.isSelected();
                JSONParsingSettingsPanel.this.jSpinnerNumPerDoc.setEnabled(bl);
            }
        });
        this.jSpinnerNumPerDoc.setValue(this.dataGuideSettings.getNumberOfValues());
        this.jSpinnerNumPerDoc.setEnabled(bl && !this.dataGuideSettings.isUseFullDoc());
    }

    @Override
    public boolean doWork() {
        boolean bl;
        Object object;
        int n;
        boolean bl2 = this.jChkBoxGenerateDataGuide.isSelected();
        this.dataGuideSettings.setGenerate(bl2);
        if (!bl2) {
            return true;
        }
        boolean bl3 = this.jChkBoxSampling.isSelected();
        this.dataGuideSettings.setUseFullData(!bl3);
        if (bl3) {
            Object object2 = this.jSpinnerMaxNumDocs.getValue();
            n = -1;
            if (object2 instanceof Long) {
                object = (Long)this.jSpinnerMaxNumDocs.getValue();
                n = ((Long)object).intValue();
            } else if (object2 instanceof Integer) {
                n = (Integer)object2;
            }
            if (n <= 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_MAX_NUM_DOCS_ERROR"), (String)DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_ERROR_TITLE"), null);
                return false;
            }
            this.dataGuideSettings.setNumberOfRows(Long.valueOf(n));
        }
        this.dataGuideSettings.setUseFullDoc(!(bl = this.jChkBoxLimitDocValues.isSelected()));
        if (bl) {
            n = -1;
            object = this.jSpinnerNumPerDoc.getValue();
            if (object instanceof Long) {
                Long l = (Long)object;
                n = l.intValue();
            } else if (object instanceof Integer) {
                n = (Integer)object;
            }
            if (n <= 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_MAX_NUM_PER_DOC_ERROR"), (String)DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_ERROR_TITLE"), null);
                return false;
            }
            this.dataGuideSettings.setNumberOfValues(Long.valueOf(n));
        }
        return true;
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_PARSING_SETTINGS_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "json_settings.htm";
    }
}

