/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistWizard;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPage;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class TextTransColumnSettingThemePanel
extends JPanel {
    private JPanel _parent;
    private String _sourceAttributeName = null;
    private TextNodeType.Stoplists _stoplists = null;
    private AbstractTextNode _node;
    private Context _context;
    private PropertyModel _propertyModel;
    private TextTransformationOutputAttributeType _textTransformationOutputAttribute;
    private TextTransformationType _textTransformation;
    private boolean _isAdjusting;
    private static Icon _editIcon;
    private boolean _isReadOnly;
    private boolean _dirty;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JButton jEditStoplistButton;
    private JLabel jFrequencyLabel;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JLabel jMaxNumPerDocLabel;
    private JSpinner jMaxNumPerDocSpinner;
    private JButton jNewStoplistButton;
    private JComboBox<String> jSelectedStoplistComboBox;
    private JComboBox<String> jSingleLanguageComboBox;
    private JLabel jStoplistLabel;
    private JRadioButton jTermFrequencyIDFRadioButton;
    private JRadioButton jTermFrequencyRadioButton;
    private JRadioButton jThemeTypeFullRadioButton;
    private JLabel jThemeTypeLabel;
    private JRadioButton jThemeTypeSingleRadioButton;
    private JLabel jTokensLabel;

    public TextTransColumnSettingThemePanel(PropertyModel propertyModel, Context context, JPanel jPanel, AbstractTextNode abstractTextNode, String string, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        this._propertyModel = propertyModel;
        this._node = abstractTextNode;
        this._context = context;
        this._parent = jPanel;
        if (jPanel instanceof TextTransColumnSettingPanel) {
            this._stoplists = ((TextTransColumnSettingPanel)jPanel).getStoplists();
        } else if (jPanel instanceof TextTransColumnSettingPage) {
            this._stoplists = ((TextTransColumnSettingPage)((Object)jPanel)).getStoplists();
        }
        this._sourceAttributeName = string;
        this._textTransformationOutputAttribute = textTransformationOutputAttributeType;
        this._textTransformation = textTransformationOutputAttributeType == null ? null : textTransformationOutputAttributeType.getTransformationElement();
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    /*
     * WARNING - void declaration
     */
    public void initUI() {
        void var2_5;
        this._isAdjusting = true;
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_ADD_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setEnabled(!this._isReadOnly);
        Vector<String> vector = new Vector<String>();
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            vector.add(bASIC_LEXER_LANG.value());
        }
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel(vector));
        String string = "ENGLISH";
        if (this._textTransformationOutputAttribute != null && this._textTransformationOutputAttribute.getTransformationElement().getTheme() != null) {
            LexerType lexerType = this._textTransformationOutputAttribute.getTransformationElement().getTheme().getToken().getLexer();
            for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG : lexerType.getSettings().getAttribute()) {
                if (!bASIC_LEXER_LANG.getName().equals("theme_language")) continue;
                String string2 = bASIC_LEXER_LANG.getValueString();
                break;
            }
        }
        this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)var2_5));
        this.initStoplists(null);
        this.jSingleLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)TextTransColumnSettingThemePanel.this.jSingleLanguageComboBox.getSelectedItem();
                String string2 = ServerConstants.StoplistLanguage.toHuman("ENGLISH");
                String string3 = ServerConstants.StoplistLanguage.toHuman("FRENCH");
                if (!string.equals(string2) && !string.equals(string3)) {
                    MessageDialog.optionalInformation((String)(Workflow.class.getName() + "ThemeWarning2"), (Component)Ide.getMainWindow(), (Object)MessageFormat.format(WorkflowEditorLrb.get("ORACLE_TEXT_KB"), string), (String)WorkflowEditorLrb.get("ORACLE_TEXT_KB_TITLE"), null);
                }
            }
        });
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 100));
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(300, 1, 100000, 1000));
        this.refreshUI(this._textTransformation);
        this._isAdjusting = false;
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, this.jSingleLanguageComboBox, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGE"));
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, this.jSelectedStoplistComboBox, (String)DialogsLrb.get("BUILDTEXT_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jTokensLabel, null, (String)DialogsLrb.get("BUILDTEXT_THEMES"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumPerDocLabel, (JSpinner)this.jMaxNumPerDocSpinner, (String)DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumAllDocsLabel, (JSpinner)this.jMaxNumAllDocsSpinner, (String)DialogsLrb.get("BUILDTEXT_MAX_NUM_ALL_DOCS"));
        ResourceUtils.resLabel((JLabel)this.jThemeTypeLabel, null, (String)DialogsLrb.get("BUILDTEXT_THEME_TYPE"));
        ResourceUtils.resButton((AbstractButton)this.jThemeTypeSingleRadioButton, (String)DialogsLrb.get("BUILDTEXT_THEME_SINGLE_TYPE"));
        ResourceUtils.resButton((AbstractButton)this.jThemeTypeFullRadioButton, (String)DialogsLrb.get("BUILDTEXT_THEME_FULL_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jFrequencyLabel, null, (String)DialogsLrb.get("BUILDTEXT_FREQUENCY"));
        ResourceUtils.resButton((AbstractButton)this.jTermFrequencyRadioButton, (String)DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM"));
        ResourceUtils.resButton((AbstractButton)this.jTermFrequencyIDFRadioButton, (String)DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM_IDF"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    private void initStoplists(String string) {
        List list = null;
        list = this._stoplists.getStoplist();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : list) {
            arrayList.add(stoplistType.getName());
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman("None"));
        this.jSelectedStoplistComboBox.removeAllItems();
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()])));
        if (string != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string);
        }
    }

    public void refreshUI(TextTransformationType textTransformationType) {
        this._textTransformation = textTransformationType;
        if (textTransformationType != null && textTransformationType.getTheme() != null) {
            List list = null;
            list = this._textTransformation.getTheme().getToken().getLanguages().getLanguage();
            this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(((TransformationTokenType.Token.Languages.Language)list.get(0)).getName()));
            StoplistType stoplistType = null;
            String string = textTransformationType.getTheme().getToken().getStoplistId();
            if (string != null) {
                for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
                    if (!stoplistType2.getId().equals(string)) continue;
                    stoplistType = stoplistType2;
                    break;
                }
            }
            if (stoplistType != null) {
                this.jSelectedStoplistComboBox.setSelectedItem(stoplistType.getName());
            } else {
                this.jSelectedStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("None"));
            }
            int n = textTransformationType.getTheme().getToken().getMaxNumberPerDoc().intValue();
            this.jMaxNumPerDocSpinner.setValue(n);
            int n2 = textTransformationType.getTheme().getToken().getMaxNumberAllDocs().intValue();
            this.jMaxNumAllDocsSpinner.setValue(n2);
            String string2 = textTransformationType.getTheme().getToken().getFrequency();
            this.jTermFrequencyRadioButton.setSelected(string2.equals("Terms"));
            this.jTermFrequencyIDFRadioButton.setSelected(string2.equals("IDF"));
            String string3 = textTransformationType.getTheme().getType();
            this.jThemeTypeSingleRadioButton.setSelected(string3.equals("Single"));
            this.jThemeTypeFullRadioButton.setSelected(string3.equals("Full"));
        } else {
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getThemeLanguages();
            if (arrayList.size() > 0) {
                this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)arrayList.get(0)));
            }
            this.jSelectedStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("Default"));
            this.jMaxNumPerDocSpinner.setValue(buildTextPreferencesPanelSettings.getThemeMaxNumPerDoc());
            this.jMaxNumAllDocsSpinner.setValue(buildTextPreferencesPanelSettings.getThemeMaxNumAllDocs());
            this.jTermFrequencyIDFRadioButton.setSelected(true);
            this.jThemeTypeSingleRadioButton.setSelected(true);
        }
        this.enableControls();
    }

    public boolean copySettings(TextTransformationType textTransformationType, TextNodeType.Stoplists stoplists) throws ValidationException {
        Object object;
        ConnectionFolder connectionFolder;
        boolean bl = false;
        StoplistType stoplistType = null;
        Integer n = (Integer)this.jMaxNumPerDocSpinner.getValue();
        Integer n2 = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        if (n > n2) {
            throw new ValidationException(DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC_ERROR"));
        }
        TransformationTokenType.Token token = new TransformationTokenType.Token();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        String string = null;
        String string2 = null;
        if (textTransformationType.getTheme() != null) {
            string = textTransformationType.getTheme().getToken().getPolicy();
            string2 = textTransformationType.getTheme().getToken().getStatisticTable().getName();
        } else {
            bl = true;
            try {
                connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                string = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connectionFolder, "_PL");
                string2 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connectionFolder, "_FT");
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        }
        token.setPolicy(string);
        connectionFolder = new ResultType();
        connectionFolder.setName(string2);
        token.setStatisticTable((ResultType)connectionFolder);
        String string3 = (String)this.jSingleLanguageComboBox.getSelectedItem();
        language = new TransformationTokenType.Token.Languages.Language();
        language.setName(ServerConstants.StoplistLanguage.toSchema(string3));
        language.setType("SingleByte");
        languages.getLanguage().add(language);
        token.setLanguages(languages);
        LexerType lexerType = new LexerType();
        lexerType.setType("Basic");
        token.setLexer(lexerType);
        LexerType.Settings settings = new LexerType.Settings();
        LexerType.Settings.Attribute attribute = new LexerType.Settings.Attribute();
        attribute.setName("index_themes");
        attribute.setType("String");
        attribute.setValueString("YES");
        settings.getAttribute().add(attribute);
        attribute = new LexerType.Settings.Attribute();
        attribute.setName("theme_language");
        attribute.setType("String");
        attribute.setValueString(ServerConstants.StoplistLanguage.toSchema(string3));
        settings.getAttribute().add(attribute);
        lexerType.setSettings(settings);
        token.setStoplistId(null);
        String string4 = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        if (string4 != null) {
            if (ServerConstants.StoplistLanguage.isDefault(ServerConstants.StoplistLanguage.toSchema(string4))) {
                string3 = (String)this.jSingleLanguageComboBox.getSelectedItem();
                string3 = ServerConstants.StoplistLanguage.toSchema(string3);
                object = null;
                stoplistType = AbstractTextNode.findDefaultStoplist(stoplists, string3);
                object = stoplistType.getId();
                token.setStoplistId((String)object);
            } else {
                token.setStoplistId(AbstractTextNode.findStoplistId(stoplists, string4));
            }
        }
        object = (Integer)this.jMaxNumPerDocSpinner.getValue();
        token.setMaxNumberPerDoc(BigInteger.valueOf(((Integer)object).intValue()));
        object = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        token.setMaxNumberAllDocs(BigInteger.valueOf(((Integer)object).intValue()));
        String string5 = this.jTermFrequencyRadioButton.isSelected() ? "Terms" : "IDF";
        token.setFrequency(string5);
        String string6 = this.jThemeTypeSingleRadioButton.isSelected() ? "Single" : "Full";
        TextTransformationType.Theme theme = new TextTransformationType.Theme();
        theme.setToken(token);
        theme.setType(string6);
        if (!bl) {
            if (!textTransformationType.getTheme().getType().equals(theme.getType())) {
                this._dirty = true;
            }
            if (!textTransformationType.getTheme().getToken().getFrequency().equals(theme.getToken().getFrequency())) {
                this._dirty = true;
            }
            if (!textTransformationType.getTheme().getToken().getMaxNumberAllDocs().equals(theme.getToken().getMaxNumberAllDocs())) {
                this._dirty = true;
            }
            if (!textTransformationType.getTheme().getToken().getMaxNumberPerDoc().equals(theme.getToken().getMaxNumberPerDoc())) {
                this._dirty = true;
            }
            if (!(this._dirty || textTransformationType.getTheme().getToken().getStoplistId() == null && theme.getToken().getStoplistId() == null)) {
                if (textTransformationType.getTheme().getToken().getStoplistId() == null && theme.getToken().getStoplistId() != null) {
                    this._dirty = true;
                } else if (textTransformationType.getTheme().getToken().getStoplistId() != null && theme.getToken().getStoplistId() == null) {
                    this._dirty = true;
                } else if (!textTransformationType.getTheme().getToken().getStoplistId().equals(theme.getToken().getStoplistId())) {
                    this._dirty = true;
                }
            }
            List list = textTransformationType.getTheme().getToken().getLanguages().getLanguage();
            List list2 = theme.getToken().getLanguages().getLanguage();
            if (!((TransformationTokenType.Token.Languages.Language)list.get(0)).getName().equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                this._dirty = true;
            }
        }
        textTransformationType.setTheme(theme);
        textTransformationType.setToken(null);
        return this._dirty;
    }

    private void enableControls() {
        for (Component component : this.getComponents()) {
            component.setEnabled(!this._isReadOnly);
        }
        if (this.jSelectedStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jSingleLanguageComboBox = new JComboBox();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jTokensLabel = new JLabel();
        this.jMaxNumPerDocLabel = new JLabel();
        this.jMaxNumPerDocSpinner = new JSpinner();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.jThemeTypeLabel = new JLabel();
        this.jThemeTypeSingleRadioButton = new JRadioButton();
        this.jThemeTypeFullRadioButton = new JRadioButton();
        this.jFrequencyLabel = new JLabel();
        this.jTermFrequencyRadioButton = new JRadioButton();
        this.jTermFrequencyIDFRadioButton = new JRadioButton();
        this.setPreferredSize(new Dimension(388, 264));
        this.jLanguageLabel.setText("Language:");
        this.jStoplistLabel.setText("Stoplist:");
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jTokensLabel.setText("Themes:");
        this.jMaxNumPerDocLabel.setLabelFor(this.jMaxNumPerDocSpinner);
        this.jMaxNumPerDocLabel.setText("Max number per document");
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 10));
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        this.jThemeTypeLabel.setText("Theme Type:");
        this.buttonGroup3.add(this.jThemeTypeSingleRadioButton);
        this.jThemeTypeSingleRadioButton.setText("Single");
        this.buttonGroup3.add(this.jThemeTypeFullRadioButton);
        this.jThemeTypeFullRadioButton.setText("Full");
        this.jFrequencyLabel.setText("Frequency:");
        this.buttonGroup4.add(this.jTermFrequencyRadioButton);
        this.jTermFrequencyRadioButton.setText("Term Frequency");
        this.buttonGroup4.add(this.jTermFrequencyIDFRadioButton);
        this.jTermFrequencyIDFRadioButton.setText("Term Frequency - IDF");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jStoplistLabel).addComponent(this.jLanguageLabel, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedStoplistComboBox, 0, 220, Short.MAX_VALUE).addComponent(this.jSingleLanguageComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jThemeTypeLabel).addComponent(this.jTokensLabel).addComponent(this.jFrequencyLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jThemeTypeFullRadioButton, -2, 347, -2).addComponent(this.jThemeTypeSingleRadioButton, -2, 347, -2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumPerDocLabel, -2, 171, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2))).addComponent(this.jTermFrequencyIDFRadioButton, -2, 347, -2).addComponent(this.jTermFrequencyRadioButton, -2, 347, -2)))).addGap(10, 10, 10)))));
        groupLayout.linkSize(0, this.jMaxNumAllDocsSpinner, this.jMaxNumPerDocSpinner);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jSingleLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStoplistLabel).addComponent(this.jEditStoplistButton).addComponent(this.jNewStoplistButton).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumPerDocLabel).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jThemeTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeTypeSingleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeTypeFullRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFrequencyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyIDFRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        StoplistType stoplistType = null;
        boolean bl = false;
        for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
            if (!stoplistType2.getName().equals(string)) continue;
            stoplistType = stoplistType2;
            break;
        }
        bl = !this._isReadOnly;
        Object object = null;
        boolean bl2 = false;
        if (this._propertyModel != null) {
            object = new StoplistDetailsPanel(this._propertyModel, this, stoplistType, bl);
            bl2 = ((DialogDisplayer)object).showAsDialog(this);
        } else {
            object = new StoplistDetailsPanel(this._context, this._node, this, stoplistType, bl);
            bl2 = ((DialogDisplayer)object).showAsDialog(this);
        }
        if (bl2 && ((StoplistDetailsPanel)object).isDirty()) {
            StoplistType stoplistType3 = ((StoplistDetailsPanel)object).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType3.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType3);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType3.getName());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, this._propertyModel, this._context, (BuildTextNode)this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractTextNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getName());
        }
    }

    public void setSourceAttributeName(String string) {
        this._sourceAttributeName = string;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }

    public boolean isTokenTransformType() {
        if (this._textTransformation != null) {
            TransformationTokenType transformationTokenType = this._textTransformation.getToken();
            return transformationTokenType != null;
        }
        return false;
    }

    public boolean isThemeTransformType() {
        if (this._textTransformation != null) {
            TextTransformationType.Theme theme = this._textTransformation.getTheme();
            return theme != null;
        }
        return false;
    }
}

