/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;

public class ModelDTBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JComboBox jComboBoxHomogenity;
    private JLabel jLabelHomogenity;
    private JLabel jLabelMaxDepth;
    private JLabel jLabelMinPcntRecsNode;
    private JLabel jLabelMinPcntRecsSplit;
    private JLabel jLabelMinRecsNode;
    private JLabel jLabelMinRecsSplit;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTxtMaxDepth;
    private JTextField jTxtMinPercentRecordsInNode;
    private JTextField jTxtMinPercentRecordsSplit;
    private JTextField jTxtMinRecordsInNode;
    private JTextField jTxtMinRecordsSplit;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel _hommogenityMetrix;
    private String _currentHommogenityMetrixValue;

    public ModelDTBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelHomogenity = new JLabel();
        this.jLabelMaxDepth = new JLabel();
        this.jComboBoxHomogenity = new JComboBox();
        this.jLabelMinRecsNode = new JLabel();
        this.jLabelMinPcntRecsNode = new JLabel();
        this.jLabelMinRecsSplit = new JLabel();
        this.jLabelMinPcntRecsSplit = new JLabel();
        this.jTxtMaxDepth = new NumberTextField();
        this.jTxtMinRecordsInNode = new NumberTextField();
        this.jTxtMinPercentRecordsInNode = new NumberTextField();
        this.jTxtMinRecordsSplit = new NumberTextField();
        this.jTxtMinPercentRecordsSplit = new NumberTextField();
        this.jScrollPaneTitle = new JScrollPane();
        this.jLabelHomogenity.setText("Homogenity Metric:");
        this.jLabelMaxDepth.setText("Maximum Depth:");
        this.jComboBoxHomogenity.setModel(new DefaultComboBoxModel<String>(new String[]{"Gini", "Entropy"}));
        this.jLabelMinRecsNode.setText("Minimum Records in a Node:");
        this.jLabelMinPcntRecsNode.setText("Minimum Percent of Records in a Node:");
        this.jLabelMinRecsSplit.setText("Minimum Records for a Split:");
        this.jLabelMinPcntRecsSplit.setText("Minimum Percent of Records for a Split:");
        this.jTxtMaxDepth.setText("7");
        this.jTxtMinRecordsInNode.setText("10");
        this.jTxtMinRecordsSplit.setText("20");
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -1, 403, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMinPcntRecsNode, -1, 250, Short.MAX_VALUE).addComponent(this.jLabelMinRecsSplit, -1, 250, Short.MAX_VALUE).addComponent(this.jLabelMinPcntRecsSplit, -1, 250, Short.MAX_VALUE).addComponent(this.jLabelMaxDepth, -1, 250, Short.MAX_VALUE).addComponent(this.jLabelMinRecsNode, -1, 250, Short.MAX_VALUE).addComponent(this.jLabelHomogenity, -2, 250, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxHomogenity, -2, 136, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTxtMinPercentRecordsSplit, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMinRecordsSplit, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMinPercentRecordsInNode, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMinRecordsInNode, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMaxDepth, GroupLayout.Alignment.LEADING, -2, 106, -2))).addGap(3, 3, 3))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxHomogenity, -2, -1, -2).addComponent(this.jLabelHomogenity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMaxDepth).addComponent(this.jTxtMaxDepth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinRecsNode).addComponent(this.jTxtMinRecordsInNode, -2, -1, -2)).addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinPcntRecsNode).addComponent(this.jTxtMinPercentRecordsInNode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinRecsSplit).addComponent(this.jTxtMinRecordsSplit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinPcntRecsSplit).addComponent(this.jTxtMinPercentRecordsSplit, -2, -1, -2)).addContainerGap(108, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLabelHomogenity, this.jLabelMaxDepth, this.jLabelMinPcntRecsNode, this.jLabelMinPcntRecsSplit, this.jLabelMinRecsNode, this.jLabelMinRecsSplit);
        groupLayout.linkSize(1, this.jTxtMaxDepth, this.jTxtMinPercentRecordsInNode, this.jTxtMinPercentRecordsSplit, this.jTxtMinRecordsInNode, this.jTxtMinRecordsSplit);
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        ResourceUtils.resLabel((JLabel)this.jLabelHomogenity, (Component)this.jComboBoxHomogenity, (String)AlgSettingsLrb.get("DT_HOMOGENITY_METRIC"));
        this._hommogenityMetrix = new DefaultComboBoxModel<String>(new String[]{ServerConstants.DTSettings.toHuman("TREE_IMPURITY_GINI"), ServerConstants.DTSettings.toHuman("TREE_IMPURITY_ENTROPY")});
        this.jComboBoxHomogenity.setModel(this._hommogenityMetrix);
        this._currentHommogenityMetrixValue = commonSettingDataObject.getModelSettingStringValue("TREE_IMPURITY_METRIC");
        this.jComboBoxHomogenity.setSelectedItem(ServerConstants.DTSettings.toHuman(this._currentHommogenityMetrixValue));
        commonSettingDataObject.setBackupValue("TREE_IMPURITY_METRIC", this._currentHommogenityMetrixValue);
        this.jComboBoxHomogenity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDTBuildSettingsPanel.this._currentHommogenityMetrixValue = ServerConstants.DTSettings.toAlgorithm((String)ModelDTBuildSettingsPanel.this.jComboBoxHomogenity.getSelectedItem());
            }
        });
        ResourceUtils.resLabel((JLabel)this.jLabelMaxDepth, (Component)this.jTxtMaxDepth, (String)AlgSettingsLrb.get("DT_TREE_TERM_MAX_DEPTH"));
        this.jTxtMaxDepth.setToolTipText(AlgSettingsLrb.get("DT_TREE_TERM_MAX_DEPTH_TOOLTIP"));
        this.setDataType(this.jTxtMaxDepth, Integer.class);
        this.setSigned(this.jTxtMaxDepth, false);
        this.setLocale(this.jTxtMaxDepth, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("TREE_TERM_MAX_DEPTH");
        commonSettingDataObject.setBackupValue("TREE_TERM_MAX_DEPTH", bigDecimal);
        this.setNumber(this.jTxtMaxDepth, bigDecimal);
        ResourceUtils.resLabel((JLabel)this.jLabelMinRecsNode, (Component)this.jTxtMinRecordsInNode, (String)AlgSettingsLrb.get("DT_TREE_TERM_MINREC_NODE"));
        this.jTxtMinRecordsInNode.setToolTipText(AlgSettingsLrb.get("DT_TREE_TERM_MINREC_NODE_TOOLTIP"));
        this.setDataType(this.jTxtMinRecordsInNode, Integer.class);
        this.setSigned(this.jTxtMinRecordsInNode, false);
        this.setLocale(this.jTxtMinRecordsInNode, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("TREE_TERM_MINREC_NODE");
        commonSettingDataObject.setBackupValue("TREE_TERM_MINREC_NODE", bigDecimal);
        this.setNumber(this.jTxtMinRecordsInNode, bigDecimal);
        ResourceUtils.resLabel((JLabel)this.jLabelMinPcntRecsNode, (Component)this.jTxtMinPercentRecordsInNode, (String)AlgSettingsLrb.get("DT_TREE_TERM_MINPCT_NODE"));
        this.jTxtMinPercentRecordsInNode.setToolTipText(AlgSettingsLrb.get("DT_TREE_TERM_MINPCT_NODE_TOOLTIP"));
        this.setDataType(this.jTxtMinPercentRecordsInNode, Double.class);
        ((NumberTextField)this.jTxtMinPercentRecordsInNode).setDecimal(true, 4);
        this.setSigned(this.jTxtMinPercentRecordsInNode, false);
        this.setLocale(this.jTxtMinPercentRecordsInNode, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("TREE_TERM_MINPCT_NODE");
        commonSettingDataObject.setBackupValue("TREE_TERM_MINPCT_NODE", bigDecimal);
        this.setNumber(this.jTxtMinPercentRecordsInNode, bigDecimal);
        ResourceUtils.resLabel((JLabel)this.jLabelMinRecsSplit, (Component)this.jTxtMinRecordsSplit, (String)AlgSettingsLrb.get("DT_TREE_TERM_MINREC_SPLIT"));
        this.jTxtMinRecordsSplit.setToolTipText(AlgSettingsLrb.get("DT_TREE_TERM_MINREC_SPLIT_TOOLTIP"));
        this.setDataType(this.jTxtMinRecordsSplit, Integer.class);
        this.setSigned(this.jTxtMinRecordsSplit, false);
        this.setLocale(this.jTxtMinRecordsSplit, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("TREE_TERM_MINREC_SPLIT");
        commonSettingDataObject.setBackupValue("TREE_TERM_MINREC_SPLIT", bigDecimal);
        this.setNumber(this.jTxtMinRecordsSplit, bigDecimal);
        ResourceUtils.resLabel((JLabel)this.jLabelMinPcntRecsSplit, (Component)this.jTxtMinPercentRecordsSplit, (String)AlgSettingsLrb.get("DT_TREE_TERM_MINPCT_SPLIT"));
        this.jTxtMinPercentRecordsSplit.setToolTipText(AlgSettingsLrb.get("DT_TREE_TERM_MINPCT_SPLIT_TOOLTIP"));
        this.setDataType(this.jTxtMinPercentRecordsSplit, Double.class);
        ((NumberTextField)this.jTxtMinPercentRecordsSplit).setDecimal(true, 4);
        this.setSigned(this.jTxtMinPercentRecordsSplit, false);
        this.setLocale(this.jTxtMinPercentRecordsSplit, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("TREE_TERM_MINPCT_SPLIT");
        commonSettingDataObject.setBackupValue("TREE_TERM_MINPCT_SPLIT", bigDecimal);
        this.setNumber(this.jTxtMinPercentRecordsSplit, bigDecimal);
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        commonSettingDataObject.setCommonPerformanceOption();
        this.setObjectValue("TREE_IMPURITY_METRIC", this._currentHommogenityMetrixValue);
        Number number = this.getNumber(this.jTxtMaxDepth);
        if (null == number || number.intValue() < 2 || number.intValue() > 20) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("DT_TREE_TERM_MAX_DEPTH_INVALID"));
            return;
        }
        this.setObjectValue("TREE_TERM_MAX_DEPTH", number);
        number = this.getNumber(this.jTxtMinRecordsInNode);
        if (null == number || number.intValue() < 0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("DT_TREE_TERM_MINREC_NODE_INVALID"));
            return;
        }
        this.setObjectValue("TREE_TERM_MINREC_NODE", number);
        number = this.getNumber(this.jTxtMinPercentRecordsInNode);
        if (null == number || number.intValue() < 0 || number.intValue() > 10) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("DT_TREE_TERM_MINPCT_NODE_INVALID"));
            return;
        }
        this.setObjectValue("TREE_TERM_MINPCT_NODE", number);
        number = this.getNumber(this.jTxtMinRecordsSplit);
        if (null == number || number.intValue() < 0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("DT_TREE_TERM_MINREC_SPLIT_INVALID"));
            return;
        }
        this.setObjectValue("TREE_TERM_MINREC_SPLIT", number);
        number = this.getNumber(this.jTxtMinPercentRecordsSplit);
        if (null == number || number.intValue() < 0 || number.intValue() > 20) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("DT_TREE_TERM_MINPCT_SPLIT_INVALID"));
            return;
        }
        this.setObjectValue("TREE_TERM_MINPCT_SPLIT", number);
    }
}

