/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class GLMTargetValuesPanel
extends JPanel
implements DataminerGUIPanel,
ActionListener {
    private JLabel jLabelTarget;
    private JRadioButton jRadioAuto;
    private JRadioButton jRadioCustom;
    private JScrollPane jScrollPane1;
    private DataMinerTable genericTableTargets;
    private static SystemDefaultTableAttributesModel _sysDefault;
    private CommonSettingDataObject _state;
    private static String _TARGET_VALUE;
    static String[] _columnNames;

    public GLMTargetValuesPanel(CommonSettingDataObject commonSettingDataObject) {
        this._state = commonSettingDataObject;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioAuto = new JRadioButton();
        this.jRadioCustom = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.genericTableTargets = new DataMinerTable();
        this.jLabelTarget = new JLabel();
        buttonGroup.add(this.jRadioAuto);
        buttonGroup.add(this.jRadioCustom);
        this.jRadioAuto.setText("Auto");
        this.jRadioAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAuto.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioCustom.setText("Custom");
        this.jRadioCustom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioCustom.setMargin(new Insets(0, 0, 0, 0));
        this.genericTableTargets.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)((Object)this.genericTableTargets));
        this.jLabelTarget.setText("Target");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioAuto, -2, 125, -2).addComponent(this.jRadioCustom).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabelTarget, -2, 180, -2)))).addGroup(groupLayout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.jScrollPane1, -1, 308, Short.MAX_VALUE))).addGap(30, 30, 30)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jRadioAuto).addGap(18, 18, 18).addComponent(this.jRadioCustom).addGap(15, 15, 15).addComponent(this.jLabelTarget).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 182, -2).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.jRadioAuto.setText(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_AUTO"));
        this.jRadioCustom.setText(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_CUSTOM"));
        this.jLabelTarget.setText(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_TARGET"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"glmc_choose_ref_val");
        String string = this._state.getCurClassRefValue();
        boolean bl = string.equals(CommonSettingDataObject.SYSTEM_DETERMINED);
        this.jRadioAuto.setSelected(bl);
        this.jRadioCustom.setSelected(!bl);
        int n = 0;
        TableAttributesModel tableAttributesModel = null;
        if (!bl && this._state.isGlmClassRefValuesLoaded()) {
            tableAttributesModel = new TableAttributesModel(this._state.getGlmClassRefValues());
            n = tableAttributesModel.getDataList().indexOf(this._state.getCurClassRefValue());
        } else {
            _sysDefault = new SystemDefaultTableAttributesModel();
            tableAttributesModel = _sysDefault;
        }
        this.setupTable(tableAttributesModel, n);
        this.jRadioAuto.addActionListener(this);
        if (this._state.isDataSourcePresent() && this._state.isTargetSelected()) {
            this.jRadioCustom.addActionListener(this);
        } else {
            this.jRadioCustom.setEnabled(false);
        }
    }

    private void setupTable(TableAttributesModel tableAttributesModel, int n) {
        this.genericTableTargets.setModel((TableModel)((Object)tableAttributesModel));
        this.genericTableTargets.setSelectionMode(0);
        if (n != -1) {
            this.genericTableTargets.setSelectedRowsInModel(new int[]{n});
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.genericTableTargets.getSelectedRow();
        if (n == -1) {
            return;
        }
        TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)this.genericTableTargets.getModel());
        String string = tableAttributesModel.getDataList().get(n);
        this._state.setCurClassRefValue(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (jRadioButton.equals(this.jRadioCustom)) {
                if (!this._state.isGlmClassRefValuesLoaded()) {
                    this.launch();
                }
                if (this._state.isGlmClassRefValuesLoaded()) {
                    this.setupTable(new TableAttributesModel(this._state.getGlmClassRefValues()), -1);
                } else {
                    this.genericTableTargets.setModel((TableModel)((Object)new FailedLoadingTableAttributesModel()));
                }
            } else if (jRadioButton.equals(this.jRadioAuto)) {
                this.genericTableTargets.setModel((TableModel)((Object)_sysDefault));
            }
        }
    }

    private boolean launch() {
        GLMClassRefLoader gLMClassRefLoader = new GLMClassRefLoader();
        gLMClassRefLoader.setTitle(AlgSettingsLrb.get("GLMS_RETRIEVING_AVAILABLE_REFERENCE_CLASS_VALUES"));
        gLMClassRefLoader.setMessage(AlgSettingsLrb.get("GLMS_RETRIEVING_AVAILABLE_REFERENCE_CLASS_VALUES_DETAILS"));
        boolean bl = true;
        try {
            gLMClassRefLoader.start(true);
        }
        catch (ProgressException progressException) {
            bl = false;
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)AlgSettingsLrb.get("GLMS_ERROR_RETRIEVING_AVAILABLE_REFERENCE_APP_ERROR"), (String)AlgSettingsLrb.get("GLMS_ERROR_RETRIEVING_AVAILABLE_REFERENCE_CLASS_VALUES"), null);
        }
        return bl;
    }

    public boolean doWork() {
        int n = this.genericTableTargets.getSelectedRow();
        if (n == -1) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("GLM_REFERENCE_SELECT_TARGET"), (String)AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_MSG"), null);
        } else {
            TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)this.genericTableTargets.getModel());
            String string = tableAttributesModel.getDataList().get(n);
            this._state.setCurClassRefValue(string);
        }
        return -1 != n;
    }

    static {
        _TARGET_VALUE = AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_TARGET_VALUE");
        _columnNames = new String[]{_TARGET_VALUE};
    }

    class GLMClassRefLoader
    extends ProgressRunnable {
        private boolean _canceled;
        List<String> _values;

        GLMClassRefLoader() {
        }

        protected Object doWork() throws Exception {
            LoadingTableAttributesModel loadingTableAttributesModel = new LoadingTableAttributesModel();
            GLMTargetValuesPanel.this.genericTableTargets.setModel((TableModel)((Object)loadingTableAttributesModel));
            this._values = GLMTargetValuesPanel.this._state.getGlmClassRefValues();
            return this._values;
        }

        protected void finish(Object object) {
            TableAttributesModel tableAttributesModel = new TableAttributesModel(this._values);
            GLMTargetValuesPanel.this.setupTable(tableAttributesModel, -1);
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class TableAttributesModel
    extends GenericBaseTableModel {
        protected List<String> _data = new ArrayList<String>();
        protected final int COLUMN_COUNT = 1;
        public static final int VALUE = 0;

        protected TableAttributesModel(String string) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>();
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        protected TableAttributesModel(List<String> list) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>(list.size());
            this._data.addAll(list);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            String string = null;
            switch (n2) {
                case 0: {
                    string = this._data.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public List<String> getDataList() {
            return this._data;
        }
    }

    class LoadingTableAttributesModel
    extends TableAttributesModel {
        public LoadingTableAttributesModel() {
            super(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_LOADING"));
        }
    }

    class FailedLoadingTableAttributesModel
    extends TableAttributesModel {
        public FailedLoadingTableAttributesModel() {
            super(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAILED"));
        }
    }

    class SystemDefaultTableAttributesModel
    extends TableAttributesModel {
        public SystemDefaultTableAttributesModel() {
            super(CommonSettingDataObject.SYSTEM_DETERMINED);
        }
    }
}

