/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.CostBenefitsInfo;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.controls.PerformanceInfo;
import oracle.dmt.dataminer.controls.PriorsInfo;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractAlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PerformanceType;
import oracle.dmt.dataminer.workflow.xmlschema.PriorType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public class CommonSettingDataObject {
    private static final Logger theLogger = Logger.getLogger(CommonSettingDataObject.class.getName());
    private static final int _ROUNDING_PRECISION = 4;
    private static final String _NO_DATA = "_NO_DATA";
    private static final String _VALIDATION_ERROR = "_VALIDATION_ERROR";
    private static final String _NULL_VALUE = "_NULL_VALUE";
    private static final String _ALGORITHM_CONTENT = "_ALGORITHM_CONTENT";
    private static final String _PERFORMANCE_CONTENT = "_PERFORMANCE_CONTENT";
    public static final String SYSTEM_DETERMINED = AlgSettingsLrb.get("SYSTEM_DETERMINED");
    private boolean loaded = false;
    private Version _dbVersion = null;
    private ModelType _modelType;
    private Context _context;
    private Locale _locale;
    private Map<String, ModifiedObject> _data = new HashMap<String, ModifiedObject>();
    private Map<String, ModifiedObject> _copy = new HashMap<String, ModifiedObject>();
    private Map<String, Object> _allSetting;
    private Map<String, AbstractAlgorithmSettingsPanel> clientPanels = Collections.synchronizedMap(new HashMap());
    private Object _selectedTargetValue;
    private boolean _falsePositive = true;
    private ArrayList<String> _ignoredSettings = new ArrayList();
    private PerformanceInfo _pOriginalPerfInfo;
    private PerformanceInfo _pResultPerfInfo;
    private PriorsInfo _priorsOriginalInfo = PriorsInfo._NO_PRIOR;
    private PriorsInfo _priorsResultInfo = PriorsInfo._NO_PRIOR;
    private Model _odmModel;
    private AbstractDataNode _dataProvider;
    private NodeType _nodeType;
    private List<String> _glmClassRefValues;
    private String _curClassRefValue;
    private AdvancedSettingsPanel _parentPanel;
    Map<String, List<String>> mapContentPanelToListOfSettings = new HashMap<String, List<String>>();
    private OPTION _option = OPTION.PROPERTIES;
    private HashMap<String, Object> _modifiedSettings = new HashMap();

    public void addSetting(String string, String string2) {
        List<String> list = this.mapContentPanelToListOfSettings.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.mapContentPanelToListOfSettings.put(string, list);
        }
        list.add(string2);
    }

    public void addValidationErrorSetting(String string) {
        this.addSetting(string, _VALIDATION_ERROR);
    }

    public void clearContentSettings(String string) {
        List<String> list = this.mapContentPanelToListOfSettings.get(string);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            this._data.remove(string2);
        }
        list.clear();
    }

    public CommonSettingDataObject(Context context, AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType, BuildNodeType buildNodeType, AbstractDataNode abstractDataNode, Locale locale) {
        this._parentPanel = advancedSettingsPanel;
        this._nodeType = buildNodeType;
        this._dataProvider = abstractDataNode;
        this._modelType = modelType;
        this._context = context;
        this._locale = locale;
        try {
            this._dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (this._nodeType instanceof RegressionBuildNodeType) {
            this._ignoredSettings.add("BUILD_SETTING_PERFORM_OPTION");
        }
        if (this._nodeType instanceof ClusteringBuildNodeType) {
            this._ignoredSettings.add("BUILD_SETTING_PERFORM_OPTION");
        }
        if (this._nodeType instanceof AssociationBuildNodeType) {
            this._ignoredSettings.add("BUILD_SETTING_PERFORM_OPTION");
        }
        if (this._nodeType instanceof AnomalyDetectionBuildNodeType) {
            this._ignoredSettings.add("BUILD_SETTING_PERFORM_OPTION");
        }
        if (this._nodeType instanceof FeatureExtractionBuildNodeType) {
            this._ignoredSettings.add("BUILD_SETTING_PERFORM_OPTION");
        }
    }

    public void setCostMatrixOption() {
        this._option = OPTION.COST_MATRIX;
    }

    public void setCostBenefitsOption() {
        this._option = OPTION.COST_BENEFIT;
    }

    public void setCurClassRefValue(String string) {
        this._curClassRefValue = string;
    }

    public String getCurClassRefValue() {
        return this._curClassRefValue;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void addPerformancePanel(AbstractAlgorithmSettingsPanel abstractAlgorithmSettingsPanel) {
        this.clientPanels.put(_PERFORMANCE_CONTENT, abstractAlgorithmSettingsPanel);
    }

    public void addAlgorithmPanel(AbstractAlgorithmSettingsPanel abstractAlgorithmSettingsPanel) {
        this.clientPanels.put(_ALGORITHM_CONTENT, abstractAlgorithmSettingsPanel);
    }

    public void setCommonPerformanceOption() {
        if (this._nodeType instanceof RegressionBuildNodeType) {
            return;
        }
        if (this._nodeType instanceof ClusteringBuildNodeType) {
            return;
        }
        if (this._nodeType instanceof AssociationBuildNodeType) {
            return;
        }
        if (this._nodeType instanceof AnomalyDetectionBuildNodeType) {
            return;
        }
        if (this._nodeType instanceof FeatureExtractionBuildNodeType) {
            return;
        }
        if (null == this._data.get("BUILD_SETTING_PERFORM_OPTION")) {
            String string = this.getOriginalPerformanceOption();
            this.setValue("BUILD_SETTING_PERFORM_OPTION", string);
        }
    }

    public void initializeClients() {
        for (String string : this.clientPanels.keySet()) {
            AbstractAlgorithmSettingsPanel abstractAlgorithmSettingsPanel = this.clientPanels.get(string);
            abstractAlgorithmSettingsPanel.initializeFromState(this);
        }
    }

    public Model getOdmModel() {
        return this._odmModel;
    }

    public static boolean isNullValue(String string) {
        return string.endsWith(_NULL_VALUE);
    }

    public ModelType getModelType() {
        ModelType modelType = this._parentPanel.findEditedModel(this._modelType);
        return modelType != null ? modelType : this._modelType;
    }

    public String getAlgorithm() {
        if (this._modelType == null) {
            return null;
        }
        return MetaDataHelper.getAlgorithmName(this._modelType);
    }

    public String getAlgorithmType() {
        if (this._modelType == null) {
            return null;
        }
        return MetaDataHelper.getAlgorithmType(this._modelType);
    }

    public MiningFunctionType getFunction() {
        if (this._nodeType instanceof ClassificationBuildNodeType) {
            return MiningFunctionType.CLASSIFICATION;
        }
        if (this._nodeType instanceof RegressionBuildNodeType) {
            return MiningFunctionType.REGRESSION;
        }
        if (this._nodeType instanceof ClusteringBuildNodeType) {
            return MiningFunctionType.CLUSTERING;
        }
        if (this._nodeType instanceof AssociationBuildNodeType) {
            return MiningFunctionType.ASSOCIATION;
        }
        if (this._nodeType instanceof AnomalyDetectionBuildNodeType) {
            return MiningFunctionType.ANOMALY_DETECTION;
        }
        if (this._nodeType instanceof FeatureExtractionBuildNodeType) {
            return MiningFunctionType.FEATURE_EXTRACTION;
        }
        return null;
    }

    public boolean isDataSourcePresent() {
        return this._dataProvider != null;
    }

    public boolean isTargetSelected() {
        AttributeType attributeType;
        boolean bl = false;
        if (this._nodeType instanceof SuperviseBuildNodeType && (attributeType = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute()) != null && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            bl = true;
        }
        return bl;
    }

    public List<AttributeType> getAttributes() {
        if (this._dataProvider == null) {
            return null;
        }
        Attributes attributes = this._dataProvider.getAttributes();
        if (null == attributes) {
            return null;
        }
        return attributes.getAttribute();
    }

    private String getStackedSQL() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this._dataProvider.getInputSQL());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    void setNullValue(String string) {
        this.setValue(string, _NULL_VALUE);
    }

    void setValue(String string, Object object) {
        this._data.put(string, new ModifiedObject(object));
    }

    public void setBackupValue(String string, Object object) {
        this._copy.put(string, new ModifiedObject(object));
    }

    public void removeValue(String string) {
        this._data.remove(string);
        this._copy.remove(string);
    }

    public Object getBackupValue(String string) {
        ModifiedObject modifiedObject = this._copy.get(string);
        return modifiedObject.getContent();
    }

    public void setBackupNullValue(String string) {
        this.setBackupValue(string, _NULL_VALUE);
    }

    public static boolean isValueNull(Object object) {
        if (object == null) {
            return true;
        }
        return object instanceof String && ((String)object).compareTo(_NULL_VALUE) == 0;
    }

    void setValidationError(String string) {
        if (!this._data.isEmpty()) {
            this._data.clear();
        }
        this._data.put(_VALIDATION_ERROR, new ModifiedObject(string));
    }

    public void clearValidationError() {
        if (!this._data.isEmpty()) {
            this._data.remove(_VALIDATION_ERROR);
        }
    }

    public boolean isModified() throws ValidationException {
        ModifiedObject modifiedObject;
        if (this._data.size() != this._copy.size()) {
            return true;
        }
        if (this.hasValidationError()) {
            return true;
        }
        boolean bl = false;
        Set<String> set = this._data.keySet();
        for (String object2 : set) {
            Object object;
            Object object3;
            if (this.isPerformanceSetting(object2)) {
                if (this._pResultPerfInfo != null && this._pResultPerfInfo.equals(this._pOriginalPerfInfo)) {
                    modifiedObject = this._data.get(object2);
                    modifiedObject.clearModifiedFlag();
                    continue;
                }
                bl = true;
                continue;
            }
            if (this.isCostMatrixSetting(object2)) {
                bl = true;
                continue;
            }
            if (this.isCostBenefitSetting(object2)) {
                bl = true;
                continue;
            }
            modifiedObject = this._data.get(object2);
            ModifiedObject modifiedObject2 = this._copy.get(object2);
            if (modifiedObject.getContent() instanceof Number && modifiedObject2.getContent() instanceof Number) {
                object3 = (Number)modifiedObject.getContent();
                object = (Number)modifiedObject2.getContent();
                if (NameValuePair.areEqual(((Number)object3).doubleValue(), ((Number)object).doubleValue())) {
                    modifiedObject.clearModifiedFlag();
                    continue;
                }
                bl = true;
                continue;
            }
            if (modifiedObject.getContent() == null && modifiedObject2.getContent() == null) {
                modifiedObject.clearModifiedFlag();
                continue;
            }
            if (modifiedObject.getContent() == null || modifiedObject2.getContent() == null) {
                bl = true;
                continue;
            }
            object3 = modifiedObject.getContent().toString();
            if (0 == ((String)object3).compareTo((String)(object = modifiedObject2.getContent().toString()))) {
                modifiedObject.clearModifiedFlag();
                continue;
            }
            bl = true;
        }
        ModifiedObject modifiedObject3 = this._data.get("GLMS_RIDGE_REGRESSION");
        if (modifiedObject3 != null && !modifiedObject3.isDirty() && (modifiedObject = this._data.get("GLMS_RIDGE_VALUE")) != null && modifiedObject.isDirty()) {
            this.setValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_ENABLE");
        }
        return bl;
    }

    private boolean isPerformanceSetting(String string) {
        return 0 == string.compareToIgnoreCase("BUILD_SETTING_PERFORM_OPTION");
    }

    private boolean isCostMatrixSetting(String string) {
        return 0 == string.compareToIgnoreCase("BUILD_SETTING_COST_MATRIX_OPTION");
    }

    private boolean isCostBenefitSetting(String string) {
        return 0 == string.compareToIgnoreCase("BUILD_SETTING_COST_BENEFITS_OPTION");
    }

    public void clear() {
    }

    private String getValidationError() {
        ModifiedObject modifiedObject = this._data.get(_VALIDATION_ERROR);
        return modifiedObject != null ? (String)modifiedObject.getContent() : null;
    }

    private boolean hasValidationError() {
        return null != this.getValidationError();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void finish() {
        Set<String> set = this._data.keySet();
        for (String string : set) {
            Object object;
            ModifiedObject modifiedObject;
            if (this._ignoredSettings.contains(string) || (modifiedObject = this._data.get(string)) == null || !modifiedObject.isDirty()) continue;
            if (string.equals("BUILD_SETTING_PERFORM_OPTION")) {
                PerformanceType.Balanced balanced;
                Object object2;
                object = new PerformanceType();
                if (this._pResultPerfInfo.isCustom()) {
                    if (this._pResultPerfInfo.equals(this._pOriginalPerfInfo)) continue;
                    object2 = new PerformanceType.Custom();
                    balanced = new WeightsType();
                    List list = balanced.getItem();
                    ArrayList<NameValuePair> arrayList = this._pResultPerfInfo.getValues();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        NameValuePair nameValuePair = arrayList.get(i);
                        WeightsType.Item item = new WeightsType.Item();
                        item.setTargetValue(nameValuePair.getName());
                        BigDecimal bigDecimal = (BigDecimal)nameValuePair.getValue();
                        item.setWeight(bigDecimal.doubleValue());
                        list.add(item);
                    }
                    object2.setWeights((WeightsType)balanced);
                    object.setCustom((PerformanceType.Custom)object2);
                    this._modifiedSettings.put(string, object);
                    continue;
                }
                object2 = modifiedObject.getContent();
                if (object2.equals("BUILD_SETTING_PERFORM_OP_OVRL")) {
                    object.setNatural(new PerformanceType.Natural());
                } else {
                    balanced = new PerformanceType.Balanced();
                    object.setBalanced(balanced);
                }
                this._modifiedSettings.put(string, object);
                continue;
            }
            object = modifiedObject.getContent();
            this._modifiedSettings.put(string, object);
        }
    }

    private void cleanUpUnusedSettings() {
        if (this._allSetting.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = this._allSetting.keySet();
        for (String object : set) {
            if (null != this._data.get(object)) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (String string : arrayList) {
            this._allSetting.remove(string);
        }
    }

    public void apply() {
        this.cleanUpUnusedSettings();
        if (this._modifiedSettings.isEmpty()) {
            return;
        }
        ModelType modelType = this.getModelType();
        if (modelType instanceof NaiveBayesModelType) {
            this.applyModifiedPropertiesNB();
        } else if (modelType instanceof DecisionTreeModelType) {
            this.applyModifiedPropertiesDT();
        } else if (modelType instanceof CSupportVectorMachineModelType) {
            this.applyModifiedPropertiesSV();
        } else if (modelType instanceof CGeneralizedLinearModelType) {
            this.applyModifiedPropertiesGL();
        } else {
            if (modelType instanceof RSupportVectorMachineModelType) {
                this.applyModifiedPropertiesSV();
                return;
            }
            if (modelType instanceof RGeneralizedLinearModelType) {
                this.applyModifiedPropertiesGL();
                return;
            }
            if (modelType instanceof KMeansModelType) {
                this.applyModifiedPropertiesKM();
                return;
            }
            if (modelType instanceof OClusterModelType) {
                this.applyModifiedPropertiesOC();
                return;
            }
            if (modelType instanceof ExpectationMaximizationModelType) {
                this.applyModifiedPropertiesEM();
                return;
            }
            if (modelType instanceof AprioriModelType) {
                this.applyModifiedPropertiesAR();
                return;
            }
            if (modelType instanceof AnomalyDetectionModelType) {
                this.applyModifiedPropertiesSVO();
            } else if (modelType instanceof NonNegativeMatrixFactorModelType) {
                this.applyModifiedPropertiesNMF();
            } else if (modelType instanceof SVDModelType) {
                this.applyModifiedPropertiesSVD();
            } else if (modelType instanceof PCAModelType) {
                this.applyModifiedPropertiesPCA();
            }
        }
        this.applyPerformanceInfo();
    }

    private void applyPerformanceInfo() {
        ModelType modelType = this.getModelType();
        PerformanceType performanceType = (PerformanceType)this._modifiedSettings.get("BUILD_SETTING_PERFORM_OPTION");
        if (performanceType != null) {
            ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
            classificationModelType.setPerformance(performanceType);
            this._pOriginalPerfInfo = new PerformanceInfo(this._pResultPerfInfo);
        }
    }

    private void applyModifiedPropertiesGL() {
        ModelType modelType = this.getModelType();
        if (modelType instanceof ClassificationModelType) {
            ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
            CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = ((CGeneralizedLinearModelType)classificationModelType).getCGeneralizedLinearAlgo();
            this.applyModifiedPropertiesGLM((GeneralizedLinearAlgoType)cGeneralizedLinearAlgoType);
        } else if (modelType instanceof RegressionModelType) {
            RegressionModelType regressionModelType = (RegressionModelType)modelType;
            RGeneralizedLinearAlgoType rGeneralizedLinearAlgoType = ((RGeneralizedLinearModelType)regressionModelType).getRGeneralizedLinearModelAlgo();
            this.applyModifiedPropertiesGLM((GeneralizedLinearAlgoType)rGeneralizedLinearAlgoType);
        }
    }

    private void applyModifiedPropertiesGLM(GeneralizedLinearAlgoType generalizedLinearAlgoType) {
        Object object;
        String string;
        String string2 = (String)this._modifiedSettings.get("GLMS_DIAGNOSTICS_TABLE_NAME");
        if (string2 != null && !CommonSettingDataObject.isNullValue(string2)) {
            generalizedLinearAlgoType.setGLMSDIAGNOSTICSTABLENAME(string2);
            this._allSetting.put("GLMS_DIAGNOSTICS_TABLE_NAME", string2);
        } else {
            generalizedLinearAlgoType.setGLMSDIAGNOSTICSTABLENAME(null);
            this._allSetting.put("GLMS_DIAGNOSTICS_TABLE_NAME", null);
        }
        Object object2 = this._modifiedSettings.get("GLMS_CONF_LEVEL");
        if (object2 != null && object2 instanceof Number) {
            generalizedLinearAlgoType.setGLMSCONFLEVEL(((Number)object2).doubleValue());
            this._allSetting.put("GLMS_CONF_LEVEL", ((Number)object2).doubleValue());
        }
        if ((string = (String)this._modifiedSettings.get("GLMS_REFERENCE_CLASS_NAME")) != null && !CommonSettingDataObject.isNullValue(string)) {
            generalizedLinearAlgoType.setGLMSREFERENCECLASSNAME(string);
            this._allSetting.put("GLMS_REFERENCE_CLASS_NAME", string);
        } else {
            generalizedLinearAlgoType.setGLMSREFERENCECLASSNAME(null);
            this._allSetting.put("GLMS_REFERENCE_CLASS_NAME", null);
        }
        if (this._modifiedSettings.containsKey("ODMS_MISSING_VALUE_TREATMENT") && (object = (String)this._modifiedSettings.get("ODMS_MISSING_VALUE_TREATMENT")) != null) {
            generalizedLinearAlgoType.setODMSMISSINGVALUETREATMENT((String)object);
            this._allSetting.put("ODMS_MISSING_VALUE_TREATMENT", object);
        }
        if (this._modifiedSettings.containsKey("ODMS_ROW_WEIGHT_COLUMN_NAME")) {
            object = (String)this._modifiedSettings.get("ODMS_ROW_WEIGHT_COLUMN_NAME");
            if (object != null && !CommonSettingDataObject.isNullValue((String)object)) {
                generalizedLinearAlgoType.setODMSROWWEIGHTCOLUMNNAME((String)object);
                this._allSetting.put("ODMS_ROW_WEIGHT_COLUMN_NAME", object);
            } else {
                generalizedLinearAlgoType.setODMSROWWEIGHTCOLUMNNAME(null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_RIDGE_REGRESSION")) {
            object = (String)this._modifiedSettings.get("GLMS_RIDGE_REGRESSION");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSRIDGEREGRESSION((String)object);
                this._allSetting.put("GLMS_RIDGE_REGRESSION", object);
            } else {
                generalizedLinearAlgoType.setGLMSRIDGEREGRESSION(null);
                this._allSetting.put("GLMS_RIDGE_REGRESSION", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_RIDGE_VALUE")) {
            object2 = this._modifiedSettings.get("GLMS_RIDGE_VALUE");
            if (object2 != null) {
                generalizedLinearAlgoType.setGLMSRIDGEVALUE(Double.valueOf(((Number)object2).doubleValue()));
                this._allSetting.put("GLMS_RIDGE_VALUE", ((Number)object2).doubleValue());
            } else {
                generalizedLinearAlgoType.setGLMSRIDGEVALUE(null);
                this._allSetting.put("GLMS_RIDGE_VALUE", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_VIF_FOR_RIDGE")) {
            object = (String)this._modifiedSettings.get("GLMS_VIF_FOR_RIDGE");
            if (object != null) {
                generalizedLinearAlgoType.setGLMSVIFFORRIDGE((String)object);
                this._allSetting.put("GLMS_VIF_FOR_RIDGE", object);
            } else {
                generalizedLinearAlgoType.setGLMSVIFFORRIDGE("GLMS_VIF_RIDGE_DISABLE");
                this._allSetting.put("GLMS_VIF_FOR_RIDGE", "GLMS_VIF_RIDGE_DISABLE");
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_FTR_SEL_CRIT")) {
            object = (String)this._modifiedSettings.get("GLMS_FTR_SEL_CRIT");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSFTRSELCRIT((String)object);
                this._allSetting.put("GLMS_FTR_SEL_CRIT", object);
            } else {
                generalizedLinearAlgoType.setGLMSFTRSELCRIT(null);
                this._allSetting.put("GLMS_FTR_SEL_CRIT", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_MAX_FEATURES")) {
            object = (Number)this._modifiedSettings.get("GLMS_MAX_FEATURES");
            if (object != null) {
                generalizedLinearAlgoType.setGLMSMAXFEATURES(Integer.valueOf(((Number)object).intValue()));
                this._allSetting.put("GLMS_MAX_FEATURES", ((Number)object).intValue());
            } else {
                generalizedLinearAlgoType.setGLMSMAXFEATURES(null);
                this._allSetting.put("GLMS_MAX_FEATURES", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_SELECT_BLOCK")) {
            object = (String)this._modifiedSettings.get("GLMS_SELECT_BLOCK");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSSELECTBLOCK((String)object);
                this._allSetting.put("GLMS_SELECT_BLOCK", object);
            } else {
                generalizedLinearAlgoType.setGLMSSELECTBLOCK(null);
                this._allSetting.put("GLMS_SELECT_BLOCK", null);
            }
        }
        if (this._modifiedSettings.containsKey("ODMS_APPROXIMATE_COMPUTATION")) {
            object = (String)this._modifiedSettings.get("ODMS_APPROXIMATE_COMPUTATION");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setODMSAPPROXIMATECOMPUTATION((String)object);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", object);
            } else {
                generalizedLinearAlgoType.setODMSAPPROXIMATECOMPUTATION(null);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_PRUNE_MODEL")) {
            object = (String)this._modifiedSettings.get("GLMS_PRUNE_MODEL");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSPRUNEMODEL((String)object);
                this._allSetting.put("GLMS_PRUNE_MODEL", object);
            } else {
                generalizedLinearAlgoType.setGLMSPRUNEMODEL(null);
                this._allSetting.put("GLMS_PRUNE_MODEL", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_FTR_ACCEPTANCE")) {
            object = (String)this._modifiedSettings.get("GLMS_FTR_ACCEPTANCE");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSFTRACCEPTANCE((String)object);
                this._allSetting.put("GLMS_FTR_ACCEPTANCE", object);
            } else {
                generalizedLinearAlgoType.setGLMSFTRACCEPTANCE(null);
                this._allSetting.put("GLMS_FTR_ACCEPTANCE", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_FTR_SELECTION")) {
            object = (String)this._modifiedSettings.get("GLMS_FTR_SELECTION");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSFTRSELECTION((String)object);
                this._allSetting.put("GLMS_FTR_SELECTION", object);
            } else {
                generalizedLinearAlgoType.setGLMSFTRSELECTION(null);
                this._allSetting.put("GLMS_FTR_SELECTION", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_FTR_GENERATION")) {
            object = (String)this._modifiedSettings.get("GLMS_FTR_GENERATION");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSFTRGENERATION((String)object);
                this._allSetting.put("GLMS_FTR_GENERATION", object);
            } else {
                generalizedLinearAlgoType.setGLMSFTRGENERATION(null);
                this._allSetting.put("GLMS_FTR_GENERATION", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_FTR_GEN_METHOD")) {
            object = (String)this._modifiedSettings.get("GLMS_FTR_GEN_METHOD");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSFTRGENMETHOD((String)object);
                this._allSetting.put("GLMS_FTR_GEN_METHOD", object);
            } else {
                generalizedLinearAlgoType.setGLMSFTRGENMETHOD(null);
                this._allSetting.put("GLMS_FTR_GEN_METHOD", null);
            }
        }
        if (this._modifiedSettings.containsKey("GLMS_FTR_IDENTIFICATION")) {
            object = (String)this._modifiedSettings.get("GLMS_FTR_IDENTIFICATION");
            if (object != null && !((String)object).isEmpty()) {
                generalizedLinearAlgoType.setGLMSFTRIDENTIFICATION((String)object);
                this._allSetting.put("GLMS_FTR_IDENTIFICATION", object);
            } else {
                generalizedLinearAlgoType.setGLMSFTRIDENTIFICATION(null);
                this._allSetting.put("GLMS_FTR_IDENTIFICATION", null);
            }
        }
    }

    private void applyModifiedPropertiesDT() {
        Number number;
        ModelType modelType = this.getModelType();
        ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
        DecisionTreeAlgoType decisionTreeAlgoType = ((DecisionTreeModelType)classificationModelType).getDecisionTreeAlgo();
        String string = (String)this._modifiedSettings.get("TREE_IMPURITY_METRIC");
        if (string != null) {
            decisionTreeAlgoType.setTREEIMPURITYMETRIC(string);
            this._allSetting.put("TREE_IMPURITY_METRIC", string);
        }
        if ((number = (Number)this._modifiedSettings.get("TREE_TERM_MAX_DEPTH")) != null) {
            decisionTreeAlgoType.setTREETERMMAXDEPTH(number.intValue());
            this._allSetting.put("TREE_TERM_MAX_DEPTH", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("TREE_TERM_MINREC_NODE")) != null) {
            decisionTreeAlgoType.setTREETERMMINRECNODE(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("TREE_TERM_MINREC_NODE", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("TREE_TERM_MINPCT_NODE")) != null) {
            decisionTreeAlgoType.setTREETERMMINPCTNODE(number.doubleValue());
            this._allSetting.put("TREE_TERM_MINPCT_NODE", number.doubleValue());
        }
        if ((number = (Number)this._modifiedSettings.get("TREE_TERM_MINREC_SPLIT")) != null) {
            decisionTreeAlgoType.setTREETERMMINRECSPLIT(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("TREE_TERM_MINREC_SPLIT", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("TREE_TERM_MINPCT_SPLIT")) != null) {
            decisionTreeAlgoType.setTREETERMMINPCTSPLIT(number.doubleValue());
            this._allSetting.put("TREE_TERM_MINPCT_SPLIT", number.doubleValue());
        }
    }

    private void applyModifiedPropertiesNB() {
        Double d;
        ModelType modelType = this.getModelType();
        ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
        NaiveBayesAlgoType naiveBayesAlgoType = ((NaiveBayesModelType)classificationModelType).getNaiveBayesAlgo();
        Double d2 = (Double)this._modifiedSettings.get("NABS_PAIRWISE_THRESHOLD");
        if (d2 != null) {
            naiveBayesAlgoType.setNABSPAIRWISETHRESHOLD(d2.doubleValue());
            this._allSetting.put("NABS_PAIRWISE_THRESHOLD", d2);
        }
        if ((d = (Double)this._modifiedSettings.get("NABS_SINGLETON_THRESHOLD")) != null) {
            naiveBayesAlgoType.setNABSSINGLETONTHRESHOLD(d.doubleValue());
            this._allSetting.put("NABS_SINGLETON_THRESHOLD", d);
        }
    }

    private void applyModifiedPropertiesSV() {
        ModelType modelType = this.getModelType();
        if (modelType instanceof ClassificationModelType) {
            ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
            CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = ((CSupportVectorMachineModelType)classificationModelType).getCSupportVectorMachineAlgo();
            this.applyModifiedPropertiesSVM((SupportVectorMachineAlgoType)cSupportVectorMachineAlgoType);
        } else if (modelType instanceof RegressionModelType) {
            RegressionModelType regressionModelType = (RegressionModelType)modelType;
            RSupportVectorMachineAlgoType rSupportVectorMachineAlgoType = ((RSupportVectorMachineModelType)regressionModelType).getRSupportVectorMachineAlgo();
            this.applyModifiedPropertiesSVM((SupportVectorMachineAlgoType)rSupportVectorMachineAlgoType);
        }
    }

    private void applyModifiedPropertiesSVM(SupportVectorMachineAlgoType supportVectorMachineAlgoType) {
        Object object;
        Object object2;
        if (this._modifiedSettings.containsKey("SVMS_KERNEL_FUNCTION")) {
            object2 = (String)this._modifiedSettings.get("SVMS_KERNEL_FUNCTION");
            if (object2 != null && ((String)object2).equals("SVMS_SYSTEM_DETERMINED")) {
                object2 = null;
            }
            supportVectorMachineAlgoType.setSVMSKERNELFUNCTION((String)object2);
            this._allSetting.put("SVMS_KERNEL_FUNCTION", object2 != null ? object2 : "SVMS_SYSTEM_DETERMINED");
            if (object2 == null || ((String)object2).equals("SVMS_LINEAR")) {
                supportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
                supportVectorMachineAlgoType.setSVMSSTDDEV(null);
            }
        }
        if (this._modifiedSettings.containsKey("SVMS_CONV_TOLERANCE")) {
            object2 = null;
            object = this._modifiedSettings.get("SVMS_CONV_TOLERANCE");
            if (object instanceof String) {
                if (CommonSettingDataObject.isNullValue((String)object)) {
                    object2 = null;
                }
            } else {
                object2 = (Number)object;
            }
            supportVectorMachineAlgoType.setSVMSCONVTOLERANCE(object2 != null ? ((Number)object2).doubleValue() : 0.0);
            this._allSetting.put("SVMS_CONV_TOLERANCE", object2 != null ? ((Number)object2).doubleValue() : 0.0);
        }
        if (supportVectorMachineAlgoType instanceof RSupportVectorMachineAlgoType && this._modifiedSettings.containsKey("SVMS_EPSILON")) {
            object2 = null;
            object = this._modifiedSettings.get("SVMS_EPSILON");
            if (object instanceof String) {
                if (CommonSettingDataObject.isNullValue((String)object)) {
                    object2 = null;
                }
            } else {
                object2 = (Number)object;
            }
            ((RSupportVectorMachineAlgoType)supportVectorMachineAlgoType).setSVMSEPSILON(object2 != null ? Double.valueOf(((Number)object2).doubleValue()) : null);
            this._allSetting.put("SVMS_EPSILON", object2 != null ? Double.valueOf(((Number)object2).doubleValue()) : null);
        }
        if (this._modifiedSettings.containsKey("SVMS_COMPLEXITY_FACTOR")) {
            object2 = null;
            object = this._modifiedSettings.get("SVMS_COMPLEXITY_FACTOR");
            if (object instanceof String) {
                if (CommonSettingDataObject.isNullValue((String)object)) {
                    object2 = null;
                }
            } else {
                object2 = (Number)object;
            }
            supportVectorMachineAlgoType.setSVMSCOMPLEXITYFACTOR(object2 != null ? Double.valueOf(((Number)object2).doubleValue()) : null);
            this._allSetting.put("SVMS_COMPLEXITY_FACTOR", object2 != null ? Double.valueOf(((Number)object2).doubleValue()) : null);
        }
        if (this._modifiedSettings.containsKey("SVMS_ACTIVE_LEARNING") && (object2 = (String)this._modifiedSettings.get("SVMS_ACTIVE_LEARNING")) != null) {
            supportVectorMachineAlgoType.setSVMSACTIVELEARNING((String)object2);
            this._allSetting.put("SVMS_ACTIVE_LEARNING", object2);
        }
        if (this._modifiedSettings.containsKey("SVMS_STD_DEV")) {
            object2 = null;
            object = this._modifiedSettings.get("SVMS_STD_DEV");
            if (object instanceof String) {
                if (CommonSettingDataObject.isNullValue((String)object)) {
                    object2 = null;
                }
            } else {
                object2 = (Number)object;
            }
            supportVectorMachineAlgoType.setSVMSSTDDEV(object2 != null ? Double.valueOf(((Number)object2).doubleValue()) : null);
            this._allSetting.put("SVMS_STD_DEV", object2 != null ? Double.valueOf(((Number)object2).doubleValue()) : null);
        }
        if (this._modifiedSettings.containsKey("SVMS_KERNEL_CACHE_SIZE")) {
            object2 = null;
            object = this._modifiedSettings.get("SVMS_KERNEL_CACHE_SIZE");
            if (object instanceof String) {
                if (CommonSettingDataObject.isNullValue((String)object)) {
                    object2 = null;
                }
            } else {
                object2 = (Number)object;
            }
            supportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(object2 != null ? BigInteger.valueOf(((Number)object2).longValue()) : BigInteger.ZERO);
            this._allSetting.put("SVMS_KERNEL_CACHE_SIZE", object2 != null ? BigInteger.valueOf(((Number)object2).longValue()) : BigInteger.ZERO);
        }
    }

    private void applyModifiedPropertiesSVO() {
        ModelType modelType = this.getModelType();
        AnomalyDetectionModelType anomalyDetectionModelType = (AnomalyDetectionModelType)modelType;
        AnomalyDetectionAlgoType anomalyDetectionAlgoType = anomalyDetectionModelType.getAnomalyDetectionAlgo();
        this.applyModifiedPropertiesSVM((SupportVectorMachineAlgoType)anomalyDetectionAlgoType);
        if (this._modifiedSettings.containsKey("SVMS_OUTLIER_RATE")) {
            Number number = null;
            Object object = this._modifiedSettings.get("SVMS_OUTLIER_RATE");
            if (object instanceof String) {
                if (CommonSettingDataObject.isNullValue((String)object)) {
                    number = null;
                }
            } else {
                number = (Number)object;
            }
            anomalyDetectionAlgoType.setSVMSOUTLIERRATE(number != null ? Double.valueOf(number.doubleValue()) : null);
            this._allSetting.put("SVMS_OUTLIER_RATE", number != null ? Double.valueOf(number.doubleValue()) : null);
        }
    }

    private void applyModifiedPropertiesKM() {
        String string;
        String string2;
        ModelType modelType = this.getModelType();
        KMeansModelType kMeansModelType = (KMeansModelType)modelType;
        KMeansAlgoType kMeansAlgoType = kMeansModelType.getKMeansAlgo();
        Number number = (Number)this._modifiedSettings.get("CLUS_NUM_CLUSTERS");
        if (number != null) {
            kMeansAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("CLUS_NUM_CLUSTERS", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("KMNS_BLOCK_GROWTH")) != null) {
            kMeansAlgoType.setKMNSBLOCKGROWTH(number.intValue());
            this._allSetting.put("KMNS_BLOCK_GROWTH", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("KMNS_CONV_TOLERANCE")) != null) {
            kMeansAlgoType.setKMNSCONVTOLERANCE(number.doubleValue());
            this._allSetting.put("KMNS_CONV_TOLERANCE", number.doubleValue());
        }
        if ((string2 = (String)this._modifiedSettings.get("KMNS_DISTANCE")) != null) {
            kMeansAlgoType.setKMNSDISTANCE(string2);
            this._allSetting.put("KMNS_DISTANCE", string2);
        }
        if ((number = (Number)this._modifiedSettings.get("KMNS_ITERATIONS")) != null) {
            kMeansAlgoType.setKMNSITERATIONS(BigInteger.valueOf(number.intValue()));
            this._allSetting.put("KMNS_ITERATIONS", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("KMNS_MIN_PCT_ATTR_SUPPORT")) != null) {
            kMeansAlgoType.setKMNSMINPCTATTRSUPPORT(number.doubleValue());
            this._allSetting.put("KMNS_MIN_PCT_ATTR_SUPPORT", number.doubleValue());
        }
        if ((number = (Number)this._modifiedSettings.get("KMNS_NUM_BINS")) != null) {
            kMeansAlgoType.setKMNSNUMBINS(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("KMNS_NUM_BINS", number.intValue());
        }
        if ((string = (String)this._modifiedSettings.get("KMNS_SPLIT_CRITERION")) != null) {
            kMeansAlgoType.setKMNSSPLITCRITERION(string);
            this._allSetting.put("KMNS_SPLIT_CRITERION", string2);
        }
    }

    private void applyModifiedPropertiesOC() {
        ModelType modelType = this.getModelType();
        OClusterModelType oClusterModelType = (OClusterModelType)modelType;
        OClusterAlgoType oClusterAlgoType = oClusterModelType.getOClusterAlgo();
        Number number = (Number)this._modifiedSettings.get("CLUS_NUM_CLUSTERS");
        if (number != null) {
            oClusterAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("CLUS_NUM_CLUSTERS", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("OCLT_MAX_BUFFER")) != null) {
            oClusterAlgoType.setOCLTMAXBUFFER(number.doubleValue());
            this._allSetting.put("OCLT_MAX_BUFFER", number.doubleValue());
        }
        if ((number = (Number)this._modifiedSettings.get("OCLT_SENSITIVITY")) != null) {
            oClusterAlgoType.setOCLTSENSITIVITY(number.doubleValue());
            this._allSetting.put("OCLT_SENSITIVITY", number.doubleValue());
        }
    }

    private void applyModifiedPropertiesEM() {
        Object object;
        ModelType modelType = this.getModelType();
        ExpectationMaximizationModelType expectationMaximizationModelType = (ExpectationMaximizationModelType)modelType;
        ExpectationMaximizationAlgoType expectationMaximizationAlgoType = expectationMaximizationModelType.getExpectationMaximizationAlgo();
        if (this._modifiedSettings.containsKey("CLUS_NUM_CLUSTERS")) {
            object = (Number)this._modifiedSettings.get("CLUS_NUM_CLUSTERS");
            if (object != null) {
                expectationMaximizationAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(((Number)object).longValue()));
                this._allSetting.put("CLUS_NUM_CLUSTERS", ((Number)object).intValue());
            } else {
                expectationMaximizationAlgoType.setCLUSNUMCLUSTERS(null);
                this._allSetting.put("CLUS_NUM_CLUSTERS", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_CLUSTER_COMPONENTS")) {
            object = (String)this._modifiedSettings.get("EMCS_CLUSTER_COMPONENTS");
            expectationMaximizationAlgoType.setEMCSCLUSTERCOMPONENTS((String)object);
            this._allSetting.put("EMCS_CLUSTER_COMPONENTS", object);
        }
        if (this._modifiedSettings.containsKey("EMCS_CLUSTER_THRESH")) {
            object = (Number)this._modifiedSettings.get("EMCS_CLUSTER_THRESH");
            if (object != null) {
                expectationMaximizationAlgoType.setEMCSCLUSTERTHRESH(Double.valueOf(((Number)object).doubleValue()));
                this._allSetting.put("EMCS_CLUSTER_THRESH", ((Number)object).doubleValue());
            } else {
                expectationMaximizationAlgoType.setEMCSCLUSTERTHRESH(null);
                this._allSetting.put("EMCS_CLUSTER_THRESH", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_LINKAGE_FUNCTION")) {
            object = (String)this._modifiedSettings.get("EMCS_LINKAGE_FUNCTION");
            expectationMaximizationAlgoType.setEMCSLINKAGEFUNCTION((String)object);
            this._allSetting.put("EMCS_LINKAGE_FUNCTION", object);
        }
        if (this._modifiedSettings.containsKey("ODMS_APPROXIMATE_COMPUTATION")) {
            object = (String)this._modifiedSettings.get("ODMS_APPROXIMATE_COMPUTATION");
            if (object != null && !((String)object).isEmpty()) {
                expectationMaximizationAlgoType.setODMSAPPROXIMATECOMPUTATION((String)object);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", object);
            } else {
                expectationMaximizationAlgoType.setODMSAPPROXIMATECOMPUTATION(null);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_COMPONENTS")) {
            object = (Number)this._modifiedSettings.get("EMCS_NUM_COMPONENTS");
            if (object != null) {
                expectationMaximizationAlgoType.setEMCSNUMCOMPONENTS(BigInteger.valueOf(((Number)object).longValue()));
                this._allSetting.put("EMCS_NUM_COMPONENTS", ((Number)object).intValue());
            } else {
                expectationMaximizationAlgoType.setEMCSNUMCOMPONENTS(null);
                this._allSetting.put("EMCS_NUM_COMPONENTS", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_ITERATIONS")) {
            object = (Number)this._modifiedSettings.get("EMCS_NUM_ITERATIONS");
            expectationMaximizationAlgoType.setEMCSNUMITERATIONS(BigInteger.valueOf(((Number)object).longValue()));
            this._allSetting.put("EMCS_NUM_ITERATIONS", ((Number)object).intValue());
        }
        if (this._modifiedSettings.containsKey("EMCS_LOGLIKE_IMPROVEMENT")) {
            object = (Number)this._modifiedSettings.get("EMCS_LOGLIKE_IMPROVEMENT");
            expectationMaximizationAlgoType.setEMCSLOGLIKEIMPROVEMENT(((Number)object).doubleValue());
            this._allSetting.put("EMCS_LOGLIKE_IMPROVEMENT", ((Number)object).doubleValue());
        }
        if (this._modifiedSettings.containsKey("EMCS_CONVERGENCE_CRITERION")) {
            object = (String)this._modifiedSettings.get("EMCS_CONVERGENCE_CRITERION");
            if (object != null && !((String)object).isEmpty()) {
                expectationMaximizationAlgoType.setEMCSCONVERGENCECRITERION((String)object);
                this._allSetting.put("EMCS_CONVERGENCE_CRITERION", object);
            } else {
                expectationMaximizationAlgoType.setEMCSCONVERGENCECRITERION(null);
                this._allSetting.put("EMCS_CONVERGENCE_CRITERION", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_DISTRIBUTION")) {
            object = (String)this._modifiedSettings.get("EMCS_NUM_DISTRIBUTION");
            if (object != null && !((String)object).isEmpty()) {
                expectationMaximizationAlgoType.setEMCSNUMDISTRIBUTION((String)object);
                this._allSetting.put("EMCS_NUM_DISTRIBUTION", object);
            } else {
                expectationMaximizationAlgoType.setEMCSNUMDISTRIBUTION(null);
                this._allSetting.put("EMCS_NUM_DISTRIBUTION", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_CLUSTER_STATISTICS")) {
            object = (String)this._modifiedSettings.get("EMCS_CLUSTER_STATISTICS");
            expectationMaximizationAlgoType.setEMCSCLUSTERSTATISTICS((String)object);
            this._allSetting.put("EMCS_CLUSTER_STATISTICS", object);
        }
        if (this._modifiedSettings.containsKey("EMCS_MIN_PCT_ATTR_SUPPORT")) {
            object = (Number)this._modifiedSettings.get("EMCS_MIN_PCT_ATTR_SUPPORT");
            if (object != null) {
                expectationMaximizationAlgoType.setEMCSMINPCTATTRSUPPORT(Double.valueOf(((Number)object).doubleValue()));
                this._allSetting.put("EMCS_MIN_PCT_ATTR_SUPPORT", ((Number)object).doubleValue());
            } else {
                expectationMaximizationAlgoType.setEMCSMINPCTATTRSUPPORT(null);
                this._allSetting.put("EMCS_MIN_PCT_ATTR_SUPPORT", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_MAX_NUM_ATTR_2D")) {
            object = (Number)this._modifiedSettings.get("EMCS_MAX_NUM_ATTR_2D");
            expectationMaximizationAlgoType.setEMCSMAXNUMATTR2D(BigInteger.valueOf(((Number)object).longValue()));
            this._allSetting.put("EMCS_MAX_NUM_ATTR_2D", ((Number)object).intValue());
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_PROJECTIONS")) {
            object = (Number)this._modifiedSettings.get("EMCS_NUM_PROJECTIONS");
            expectationMaximizationAlgoType.setEMCSNUMPROJECTIONS(BigInteger.valueOf(((Number)object).longValue()));
            this._allSetting.put("EMCS_NUM_PROJECTIONS", ((Number)object).intValue());
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_QUANTILE_BINS")) {
            object = (Number)this._modifiedSettings.get("EMCS_NUM_QUANTILE_BINS");
            if (object != null) {
                expectationMaximizationAlgoType.setEMCSNUMQUANTILEBINS(Integer.valueOf(((Number)object).intValue()));
                this._allSetting.put("EMCS_NUM_QUANTILE_BINS", ((Number)object).intValue());
            } else {
                expectationMaximizationAlgoType.setEMCSNUMQUANTILEBINS(null);
                this._allSetting.put("EMCS_NUM_QUANTILE_BINS", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_TOPN_BINS")) {
            object = (Number)this._modifiedSettings.get("EMCS_NUM_TOPN_BINS");
            if (object != null) {
                expectationMaximizationAlgoType.setEMCSNUMTOPNBINS(Integer.valueOf(((Number)object).intValue()));
                this._allSetting.put("EMCS_NUM_TOPN_BINS", ((Number)object).intValue());
            } else {
                expectationMaximizationAlgoType.setEMCSNUMTOPNBINS(null);
                this._allSetting.put("EMCS_NUM_TOPN_BINS", null);
            }
        }
        if (this._modifiedSettings.containsKey("EMCS_NUM_EQUIWIDTH_BINS")) {
            object = (Number)this._modifiedSettings.get("EMCS_NUM_EQUIWIDTH_BINS");
            expectationMaximizationAlgoType.setEMCSNUMEQUIWIDTHBINS(Integer.valueOf(((Number)object).intValue()).intValue());
            this._allSetting.put("EMCS_NUM_EQUIWIDTH_BINS", ((Number)object).intValue());
        }
        if (this._modifiedSettings.containsKey("EMCS_ATTRIBUTE_FILTER")) {
            object = (String)this._modifiedSettings.get("EMCS_ATTRIBUTE_FILTER");
            if (object != null && !((String)object).isEmpty()) {
                expectationMaximizationAlgoType.setEMCSATTRIBUTEFILTER((String)object);
                this._allSetting.put("EMCS_ATTRIBUTE_FILTER", object);
            } else {
                expectationMaximizationAlgoType.setEMCSATTRIBUTEFILTER(null);
                this._allSetting.put("EMCS_ATTRIBUTE_FILTER", null);
            }
        }
    }

    private void applyModifiedPropertiesAR() {
        ModelType modelType = this.getModelType();
        AprioriModelType aprioriModelType = (AprioriModelType)modelType;
        AprioriAlgoType aprioriAlgoType = aprioriModelType.getAprioriAlgo();
        Number number = (Number)this._modifiedSettings.get("ASSO_MAX_RULE_LENGTH");
        if (number != null) {
            aprioriAlgoType.setASSOMAXRULELENGTH(number.intValue());
            this._allSetting.put("ASSO_MAX_RULE_LENGTH", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("ASSO_MIN_CONFIDENCE")) != null) {
            aprioriAlgoType.setASSOMINCONFIDENCE(number.doubleValue() / 100.0);
            this._allSetting.put("ASSO_MIN_CONFIDENCE", number.doubleValue());
        }
        if ((number = (Number)this._modifiedSettings.get("ASSO_MIN_SUPPORT")) != null) {
            aprioriAlgoType.setASSOMINSUPPORT(number.doubleValue() / 100.0);
            this._allSetting.put("ASSO_MIN_SUPPORT", number.doubleValue());
        }
    }

    private void applyModifiedPropertiesNMF() {
        Number number;
        ModelType modelType = this.getModelType();
        NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType = (NonNegativeMatrixFactorModelType)modelType;
        NonNegativeMatrixFactorAlgoType nonNegativeMatrixFactorAlgoType = nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo();
        Object object = this._modifiedSettings.get("FEAT_NUM_FEATURES");
        if (object != null && object instanceof Number) {
            number = (Number)object;
            nonNegativeMatrixFactorAlgoType.setFEATNUMFEATURES(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("FEAT_NUM_FEATURES", number.intValue());
        } else if (object != null && object instanceof String && CommonSettingDataObject.isNullValue((String)object)) {
            nonNegativeMatrixFactorAlgoType.setFEATNUMFEATURES(null);
            this._allSetting.put("FEAT_NUM_FEATURES", null);
        }
        number = (Number)this._modifiedSettings.get("NMFS_CONV_TOLERANCE");
        if (number != null) {
            nonNegativeMatrixFactorAlgoType.setNMFSCONVTOLERANCE(number.doubleValue());
            this._allSetting.put("NMFS_CONV_TOLERANCE", number.doubleValue());
        }
        if ((number = (Number)this._modifiedSettings.get("NMFS_NUM_ITERATIONS")) != null) {
            nonNegativeMatrixFactorAlgoType.setNMFSNUMITERATIONS(number.intValue());
            this._allSetting.put("NMFS_NUM_ITERATIONS", number.intValue());
        }
        if ((number = (Number)this._modifiedSettings.get("NMFS_RANDOM_SEED")) != null) {
            nonNegativeMatrixFactorAlgoType.setNMFSRANDOMSEED(BigInteger.valueOf(number.longValue()));
            this._allSetting.put("NMFS_RANDOM_SEED", number.longValue());
        }
    }

    private void applyModifiedPropertiesSVD() {
        Object object;
        ModelType modelType = this.getModelType();
        SVDModelType sVDModelType = (SVDModelType)modelType;
        SVDAlgoType sVDAlgoType = sVDModelType.getSVDAlgo();
        if (this._modifiedSettings.containsKey("FEAT_NUM_FEATURES")) {
            object = (Number)this._modifiedSettings.get("FEAT_NUM_FEATURES");
            if (object != null) {
                sVDAlgoType.setFEATNUMFEATURES(Integer.valueOf(((Number)object).intValue()));
                this._allSetting.put("FEAT_NUM_FEATURES", ((Number)object).intValue());
            } else {
                sVDAlgoType.setFEATNUMFEATURES(null);
                this._allSetting.put("FEAT_NUM_FEATURES", null);
            }
        }
        if (this._modifiedSettings.containsKey("ODMS_APPROXIMATE_COMPUTATION")) {
            object = (String)this._modifiedSettings.get("ODMS_APPROXIMATE_COMPUTATION");
            if (object != null && !((String)object).isEmpty()) {
                sVDAlgoType.setODMSAPPROXIMATECOMPUTATION((String)object);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", object);
            } else {
                sVDAlgoType.setODMSAPPROXIMATECOMPUTATION(null);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", null);
            }
        }
        if (this._modifiedSettings.containsKey("SVDS_U_MATRIX_OUTPUT")) {
            object = (String)this._modifiedSettings.get("SVDS_U_MATRIX_OUTPUT");
            sVDAlgoType.setSVDSUMATRIXOUTPUT((String)object);
            this._allSetting.put("SVDS_U_MATRIX_OUTPUT", object);
        }
        sVDAlgoType.setSVDSSCORINGMODE("SVDS_SCORING_SVD");
        this._allSetting.put("SVDS_SCORING_SVD", "SVDS_SCORING_SVD");
    }

    private void applyModifiedPropertiesPCA() {
        Object object;
        ModelType modelType = this.getModelType();
        PCAModelType pCAModelType = (PCAModelType)modelType;
        PCAAlgoType pCAAlgoType = pCAModelType.getPCAAlgo();
        if (this._modifiedSettings.containsKey("FEAT_NUM_FEATURES")) {
            object = (Number)this._modifiedSettings.get("FEAT_NUM_FEATURES");
            if (object != null) {
                pCAAlgoType.setFEATNUMFEATURES(Integer.valueOf(((Number)object).intValue()));
                this._allSetting.put("FEAT_NUM_FEATURES", ((Number)object).intValue());
            } else {
                pCAAlgoType.setFEATNUMFEATURES(null);
                this._allSetting.put("FEAT_NUM_FEATURES", null);
            }
        }
        if (this._modifiedSettings.containsKey("ODMS_APPROXIMATE_COMPUTATION")) {
            object = (String)this._modifiedSettings.get("ODMS_APPROXIMATE_COMPUTATION");
            if (object != null && !((String)object).isEmpty()) {
                pCAAlgoType.setODMSAPPROXIMATECOMPUTATION((String)object);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", object);
            } else {
                pCAAlgoType.setODMSAPPROXIMATECOMPUTATION(null);
                this._allSetting.put("ODMS_APPROXIMATE_COMPUTATION", null);
            }
        }
        if (this._modifiedSettings.containsKey("SVDS_U_MATRIX_OUTPUT")) {
            object = (String)this._modifiedSettings.get("SVDS_U_MATRIX_OUTPUT");
            pCAAlgoType.setSVDSUMATRIXOUTPUT((String)object);
            this._allSetting.put("SVDS_U_MATRIX_OUTPUT", object);
        }
        pCAAlgoType.setSVDSSCORINGMODE("SVDS_SCORING_PCA");
        this._allSetting.put("SVDS_SCORING_PCA", "SVDS_SCORING_PCA");
    }

    private HashMap<String, Object> getAllModelSettings() {
        HashMap<String, Object> hashMap = null;
        ModelType modelType = this.getModelType();
        if (modelType != null) {
            if (modelType instanceof ClassificationModelType) {
                hashMap = this.getClassificationModelSettings();
            } else if (modelType instanceof RegressionModelType) {
                hashMap = this.getRegressionModelSettings();
            } else if (modelType instanceof ClusteringModelType) {
                hashMap = this.getClusteringModelSettings();
            } else if (modelType instanceof AprioriModelType) {
                hashMap = this.getAssociationModelSettings();
            } else if (modelType instanceof AnomalyDetectionModelType) {
                hashMap = this.getAnomalyDetectionModelSettings();
            } else if (modelType instanceof NonNegativeMatrixFactorModelType || modelType instanceof SVDModelType || modelType instanceof PCAModelType) {
                hashMap = this.getFeatureExtractionModelSettings();
            }
        }
        return hashMap;
    }

    private HashMap<String, Object> getClusteringModelSettings() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ModelType modelType = this.getModelType();
        ClusteringModelType clusteringModelType = (ClusteringModelType)modelType;
        if (clusteringModelType instanceof KMeansModelType) {
            KMeansAlgoType kMeansAlgoType = ((KMeansModelType)clusteringModelType).getKMeansAlgo();
            hashMap.put("CLUS_NUM_CLUSTERS", kMeansAlgoType.getCLUSNUMCLUSTERS());
            hashMap.put("KMNS_BLOCK_GROWTH", kMeansAlgoType.getKMNSBLOCKGROWTH());
            hashMap.put("KMNS_CONV_TOLERANCE", kMeansAlgoType.getKMNSCONVTOLERANCE());
            hashMap.put("KMNS_DISTANCE", kMeansAlgoType.getKMNSDISTANCE());
            hashMap.put("KMNS_ITERATIONS", kMeansAlgoType.getKMNSITERATIONS());
            hashMap.put("KMNS_MIN_PCT_ATTR_SUPPORT", kMeansAlgoType.getKMNSMINPCTATTRSUPPORT());
            hashMap.put("KMNS_NUM_BINS", kMeansAlgoType.getKMNSNUMBINS());
            hashMap.put("KMNS_SPLIT_CRITERION", kMeansAlgoType.getKMNSSPLITCRITERION());
        } else if (clusteringModelType instanceof OClusterModelType) {
            OClusterAlgoType oClusterAlgoType = ((OClusterModelType)clusteringModelType).getOClusterAlgo();
            hashMap.put("CLUS_NUM_CLUSTERS", oClusterAlgoType.getCLUSNUMCLUSTERS());
            hashMap.put("OCLT_MAX_BUFFER", oClusterAlgoType.getOCLTMAXBUFFER());
            hashMap.put("OCLT_SENSITIVITY", oClusterAlgoType.getOCLTSENSITIVITY());
        } else if (clusteringModelType instanceof ExpectationMaximizationModelType) {
            ExpectationMaximizationAlgoType expectationMaximizationAlgoType = ((ExpectationMaximizationModelType)clusteringModelType).getExpectationMaximizationAlgo();
            hashMap.put("CLUS_NUM_CLUSTERS", expectationMaximizationAlgoType.getCLUSNUMCLUSTERS());
            hashMap.put("EMCS_CLUSTER_COMPONENTS", expectationMaximizationAlgoType.getEMCSCLUSTERCOMPONENTS());
            hashMap.put("EMCS_CLUSTER_THRESH", expectationMaximizationAlgoType.getEMCSCLUSTERTHRESH());
            hashMap.put("EMCS_LINKAGE_FUNCTION", expectationMaximizationAlgoType.getEMCSLINKAGEFUNCTION());
            hashMap.put("ODMS_APPROXIMATE_COMPUTATION", expectationMaximizationAlgoType.getODMSAPPROXIMATECOMPUTATION());
            hashMap.put("EMCS_NUM_COMPONENTS", expectationMaximizationAlgoType.getEMCSNUMCOMPONENTS());
            hashMap.put("EMCS_NUM_ITERATIONS", expectationMaximizationAlgoType.getEMCSNUMITERATIONS());
            hashMap.put("EMCS_LOGLIKE_IMPROVEMENT", expectationMaximizationAlgoType.getEMCSLOGLIKEIMPROVEMENT());
            hashMap.put("EMCS_CONVERGENCE_CRITERION", expectationMaximizationAlgoType.getEMCSCONVERGENCECRITERION());
            hashMap.put("EMCS_NUM_DISTRIBUTION", expectationMaximizationAlgoType.getEMCSNUMDISTRIBUTION());
            hashMap.put("EMCS_CLUSTER_STATISTICS", expectationMaximizationAlgoType.getEMCSCLUSTERSTATISTICS());
            hashMap.put("EMCS_MIN_PCT_ATTR_SUPPORT", expectationMaximizationAlgoType.getEMCSMINPCTATTRSUPPORT());
            hashMap.put("EMCS_MAX_NUM_ATTR_2D", expectationMaximizationAlgoType.getEMCSMAXNUMATTR2D());
            hashMap.put("EMCS_NUM_PROJECTIONS", expectationMaximizationAlgoType.getEMCSNUMPROJECTIONS());
            hashMap.put("EMCS_NUM_QUANTILE_BINS", expectationMaximizationAlgoType.getEMCSNUMQUANTILEBINS());
            hashMap.put("EMCS_NUM_TOPN_BINS", expectationMaximizationAlgoType.getEMCSNUMTOPNBINS());
            hashMap.put("EMCS_NUM_EQUIWIDTH_BINS", expectationMaximizationAlgoType.getEMCSNUMEQUIWIDTHBINS());
            hashMap.put("EMCS_ATTRIBUTE_FILTER", expectationMaximizationAlgoType.getEMCSATTRIBUTEFILTER());
        }
        return hashMap;
    }

    private HashMap<String, Object> getAssociationModelSettings() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ModelType modelType = this.getModelType();
        AprioriModelType aprioriModelType = (AprioriModelType)modelType;
        AprioriAlgoType aprioriAlgoType = aprioriModelType.getAprioriAlgo();
        hashMap.put("ASSO_MAX_RULE_LENGTH", aprioriAlgoType.getASSOMAXRULELENGTH());
        hashMap.put("ASSO_MIN_CONFIDENCE", aprioriAlgoType.getASSOMINCONFIDENCE() * 100.0);
        hashMap.put("ASSO_MIN_SUPPORT", aprioriAlgoType.getASSOMINSUPPORT() * 100.0);
        return hashMap;
    }

    private HashMap<String, Object> getRegressionModelSettings() {
        RGeneralizedLinearAlgoType rGeneralizedLinearAlgoType;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ModelType modelType = this.getModelType();
        RegressionModelType regressionModelType = (RegressionModelType)modelType;
        if (regressionModelType instanceof RSupportVectorMachineModelType) {
            RSupportVectorMachineAlgoType rSupportVectorMachineAlgoType = ((RSupportVectorMachineModelType)regressionModelType).getRSupportVectorMachineAlgo();
            hashMap.put("SVMS_ACTIVE_LEARNING", rSupportVectorMachineAlgoType.getSVMSACTIVELEARNING());
            hashMap.put("SVMS_COMPLEXITY_FACTOR", rSupportVectorMachineAlgoType.getSVMSCOMPLEXITYFACTOR());
            hashMap.put("SVMS_CONV_TOLERANCE", rSupportVectorMachineAlgoType.getSVMSCONVTOLERANCE());
            hashMap.put("SVMS_KERNEL_FUNCTION", rSupportVectorMachineAlgoType.getSVMSKERNELFUNCTION());
            hashMap.put("SVMS_KERNEL_CACHE_SIZE", rSupportVectorMachineAlgoType.getSVMSKERNELCACHESIZE());
            hashMap.put("SVMS_STD_DEV", rSupportVectorMachineAlgoType.getSVMSSTDDEV());
            hashMap.put("SVMS_EPSILON", rSupportVectorMachineAlgoType.getSVMSEPSILON());
        } else if (regressionModelType instanceof RGeneralizedLinearModelType && (rGeneralizedLinearAlgoType = ((RGeneralizedLinearModelType)regressionModelType).getRGeneralizedLinearModelAlgo()) != null) {
            double d;
            if (rGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME() != null) {
                hashMap.put("GLMS_DIAGNOSTICS_TABLE_NAME", rGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME());
            }
            if ((d = rGeneralizedLinearAlgoType.getGLMSCONFLEVEL()) < 0.0 || d > 1.0) {
                d = 0.95;
            }
            hashMap.put("GLMS_CONF_LEVEL", d);
            hashMap.put("GLMS_REFERENCE_CLASS_NAME", null != rGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME() ? rGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME() : SYSTEM_DETERMINED);
            hashMap.put("GLMS_RIDGE_REGRESSION", null != rGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION() ? rGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION() : null);
            if (rGeneralizedLinearAlgoType.getGLMSRIDGEVALUE() != null) {
                hashMap.put("GLMS_RIDGE_VALUE", rGeneralizedLinearAlgoType.getGLMSRIDGEVALUE());
            }
            hashMap.put("GLMS_VIF_FOR_RIDGE", null != rGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE() ? rGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE() : "GLMS_VIF_RIDGE_DISABLE");
            hashMap.put("ODMS_MISSING_VALUE_TREATMENT", rGeneralizedLinearAlgoType.getODMSMISSINGVALUETREATMENT() != null ? rGeneralizedLinearAlgoType.getODMSMISSINGVALUETREATMENT() : "ODMS_MISSING_VALUE_MEAN_MODE");
            hashMap.put("ODMS_ROW_WEIGHT_COLUMN_NAME", rGeneralizedLinearAlgoType.getODMSROWWEIGHTCOLUMNNAME() != null ? rGeneralizedLinearAlgoType.getODMSROWWEIGHTCOLUMNNAME() : null);
            hashMap.put("GLMS_FTR_SEL_CRIT", null != rGeneralizedLinearAlgoType.getGLMSFTRSELCRIT() ? rGeneralizedLinearAlgoType.getGLMSFTRSELCRIT() : null);
            hashMap.put("GLMS_MAX_FEATURES", null != rGeneralizedLinearAlgoType.getGLMSMAXFEATURES() ? rGeneralizedLinearAlgoType.getGLMSMAXFEATURES() : null);
            hashMap.put("GLMS_SELECT_BLOCK", null != rGeneralizedLinearAlgoType.getGLMSSELECTBLOCK() ? rGeneralizedLinearAlgoType.getGLMSSELECTBLOCK() : null);
            hashMap.put("ODMS_APPROXIMATE_COMPUTATION", null != rGeneralizedLinearAlgoType.getODMSAPPROXIMATECOMPUTATION() ? rGeneralizedLinearAlgoType.getODMSAPPROXIMATECOMPUTATION() : null);
            hashMap.put("GLMS_PRUNE_MODEL", null != rGeneralizedLinearAlgoType.getGLMSPRUNEMODEL() ? rGeneralizedLinearAlgoType.getGLMSPRUNEMODEL() : null);
            hashMap.put("GLMS_FTR_ACCEPTANCE", null != rGeneralizedLinearAlgoType.getGLMSFTRACCEPTANCE() ? rGeneralizedLinearAlgoType.getGLMSFTRACCEPTANCE() : null);
            hashMap.put("GLMS_FTR_SELECTION", null != rGeneralizedLinearAlgoType.getGLMSFTRSELECTION() ? rGeneralizedLinearAlgoType.getGLMSFTRSELECTION() : null);
            hashMap.put("GLMS_FTR_GENERATION", null != rGeneralizedLinearAlgoType.getGLMSFTRGENERATION() ? rGeneralizedLinearAlgoType.getGLMSFTRGENERATION() : null);
            hashMap.put("GLMS_FTR_GEN_METHOD", null != rGeneralizedLinearAlgoType.getGLMSFTRGENMETHOD() ? rGeneralizedLinearAlgoType.getGLMSFTRGENMETHOD() : null);
            hashMap.put("GLMS_FTR_IDENTIFICATION", null != rGeneralizedLinearAlgoType.getGLMSFTRIDENTIFICATION() ? rGeneralizedLinearAlgoType.getGLMSFTRIDENTIFICATION() : null);
        }
        return hashMap;
    }

    private HashMap<String, Object> getClassificationModelSettings() {
        CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType;
        PerformanceType.Custom custom;
        PerformanceType.Natural natural;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ModelType modelType = this.getModelType();
        ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
        PerformanceType performanceType = classificationModelType.getPerformance();
        PerformanceType.Balanced balanced = performanceType.getBalanced();
        if (balanced != null) {
            hashMap.put("BUILD_SETTING_PERFORM_OPTION", "BUILD_SETTING_PERFORM_OP_AVG");
        }
        if ((natural = performanceType.getNatural()) != null) {
            hashMap.put("BUILD_SETTING_PERFORM_OPTION", "BUILD_SETTING_PERFORM_OP_OVRL");
        }
        if ((custom = performanceType.getCustom()) != null) {
            hashMap.put("BUILD_SETTING_PERFORM_OPTION", "BUILD_SETTING_PERFORM_OP_CUST");
        }
        if (classificationModelType instanceof NaiveBayesModelType) {
            NaiveBayesAlgoType naiveBayesAlgoType = ((NaiveBayesModelType)classificationModelType).getNaiveBayesAlgo();
            hashMap.put("NABS_PAIRWISE_THRESHOLD", naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD());
            this.setBackupValue("NABS_PAIRWISE_THRESHOLD", naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD());
            hashMap.put("NABS_SINGLETON_THRESHOLD", naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD());
            this.setBackupValue("NABS_SINGLETON_THRESHOLD", naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD());
        } else if (classificationModelType instanceof CSupportVectorMachineModelType) {
            CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = ((CSupportVectorMachineModelType)classificationModelType).getCSupportVectorMachineAlgo();
            hashMap.put("SVMS_ACTIVE_LEARNING", cSupportVectorMachineAlgoType.getSVMSACTIVELEARNING());
            hashMap.put("SVMS_COMPLEXITY_FACTOR", cSupportVectorMachineAlgoType.getSVMSCOMPLEXITYFACTOR());
            hashMap.put("SVMS_CONV_TOLERANCE", cSupportVectorMachineAlgoType.getSVMSCONVTOLERANCE());
            hashMap.put("SVMS_KERNEL_FUNCTION", cSupportVectorMachineAlgoType.getSVMSKERNELFUNCTION());
            hashMap.put("SVMS_KERNEL_CACHE_SIZE", cSupportVectorMachineAlgoType.getSVMSKERNELCACHESIZE());
            hashMap.put("SVMS_STD_DEV", cSupportVectorMachineAlgoType.getSVMSSTDDEV());
        } else if (classificationModelType instanceof DecisionTreeModelType) {
            DecisionTreeAlgoType decisionTreeAlgoType = ((DecisionTreeModelType)classificationModelType).getDecisionTreeAlgo();
            if (decisionTreeAlgoType != null) {
                hashMap.put("TREE_IMPURITY_METRIC", null != decisionTreeAlgoType.getTREEIMPURITYMETRIC() ? decisionTreeAlgoType.getTREEIMPURITYMETRIC() : ServerConstants.DTSettings.TREE_IMPURITY.TREE_IMPURITY_GINI);
                int n = decisionTreeAlgoType.getTREETERMMAXDEPTH();
                if (n < 2 || n > 20) {
                    n = 7;
                }
                hashMap.put("TREE_TERM_MAX_DEPTH", n);
                double d = decisionTreeAlgoType.getTREETERMMINPCTNODE();
                if (d < 0.0 || d > 10.0) {
                    d = 0.05;
                }
                hashMap.put("TREE_TERM_MINPCT_NODE", d);
                double d2 = decisionTreeAlgoType.getTREETERMMINPCTSPLIT();
                if (d2 < 0.0 || d2 > 20.0) {
                    d2 = 0.1;
                }
                hashMap.put("TREE_TERM_MINPCT_SPLIT", d2);
                hashMap.put("TREE_TERM_MINREC_NODE", null != decisionTreeAlgoType.getTREETERMMINRECNODE() ? decisionTreeAlgoType.getTREETERMMINRECNODE() : Integer.valueOf(10));
                hashMap.put("TREE_TERM_MINREC_SPLIT", null != decisionTreeAlgoType.getTREETERMMINRECSPLIT() ? decisionTreeAlgoType.getTREETERMMINRECSPLIT() : Integer.valueOf(20));
            }
        } else if (classificationModelType instanceof CGeneralizedLinearModelType && (cGeneralizedLinearAlgoType = ((CGeneralizedLinearModelType)classificationModelType).getCGeneralizedLinearAlgo()) != null) {
            double d;
            if (cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME() != null) {
                hashMap.put("GLMS_DIAGNOSTICS_TABLE_NAME", cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME());
            }
            if ((d = cGeneralizedLinearAlgoType.getGLMSCONFLEVEL()) < 0.0 || d > 1.0) {
                d = 0.95;
            }
            hashMap.put("GLMS_CONF_LEVEL", d);
            hashMap.put("GLMS_REFERENCE_CLASS_NAME", null != cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME() ? cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME() : SYSTEM_DETERMINED);
            hashMap.put("GLMS_RIDGE_REGRESSION", null != cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION() ? cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION() : null);
            hashMap.put("GLMS_RIDGE_VALUE", null != cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE() ? cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE() : null);
            hashMap.put("GLMS_VIF_FOR_RIDGE", null != cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE() ? cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE() : null);
            hashMap.put("ODMS_MISSING_VALUE_TREATMENT", cGeneralizedLinearAlgoType.getODMSMISSINGVALUETREATMENT() != null ? cGeneralizedLinearAlgoType.getODMSMISSINGVALUETREATMENT() : "ODMS_MISSING_VALUE_MEAN_MODE");
            hashMap.put("ODMS_ROW_WEIGHT_COLUMN_NAME", cGeneralizedLinearAlgoType.getODMSROWWEIGHTCOLUMNNAME() != null ? cGeneralizedLinearAlgoType.getODMSROWWEIGHTCOLUMNNAME() : null);
            hashMap.put("GLMS_FTR_SEL_CRIT", null != cGeneralizedLinearAlgoType.getGLMSFTRSELCRIT() ? cGeneralizedLinearAlgoType.getGLMSFTRSELCRIT() : null);
            hashMap.put("GLMS_MAX_FEATURES", null != cGeneralizedLinearAlgoType.getGLMSMAXFEATURES() ? cGeneralizedLinearAlgoType.getGLMSMAXFEATURES() : null);
            hashMap.put("GLMS_SELECT_BLOCK", null != cGeneralizedLinearAlgoType.getGLMSSELECTBLOCK() ? cGeneralizedLinearAlgoType.getGLMSSELECTBLOCK() : null);
            hashMap.put("ODMS_APPROXIMATE_COMPUTATION", null != cGeneralizedLinearAlgoType.getODMSAPPROXIMATECOMPUTATION() ? cGeneralizedLinearAlgoType.getODMSAPPROXIMATECOMPUTATION() : null);
            hashMap.put("GLMS_PRUNE_MODEL", null != cGeneralizedLinearAlgoType.getGLMSPRUNEMODEL() ? cGeneralizedLinearAlgoType.getGLMSPRUNEMODEL() : null);
            hashMap.put("GLMS_FTR_ACCEPTANCE", null != cGeneralizedLinearAlgoType.getGLMSFTRACCEPTANCE() ? cGeneralizedLinearAlgoType.getGLMSFTRACCEPTANCE() : null);
            hashMap.put("GLMS_FTR_SELECTION", null != cGeneralizedLinearAlgoType.getGLMSFTRSELECTION() ? cGeneralizedLinearAlgoType.getGLMSFTRSELECTION() : null);
            hashMap.put("GLMS_FTR_GENERATION", null != cGeneralizedLinearAlgoType.getGLMSFTRGENERATION() ? cGeneralizedLinearAlgoType.getGLMSFTRGENERATION() : null);
            hashMap.put("GLMS_FTR_GEN_METHOD", null != cGeneralizedLinearAlgoType.getGLMSFTRGENMETHOD() ? cGeneralizedLinearAlgoType.getGLMSFTRGENMETHOD() : null);
            hashMap.put("GLMS_FTR_IDENTIFICATION", null != cGeneralizedLinearAlgoType.getGLMSFTRIDENTIFICATION() ? cGeneralizedLinearAlgoType.getGLMSFTRIDENTIFICATION() : null);
        }
        return hashMap;
    }

    private HashMap<String, Object> getAnomalyDetectionModelSettings() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ModelType modelType = this.getModelType();
        AnomalyDetectionModelType anomalyDetectionModelType = (AnomalyDetectionModelType)modelType;
        AnomalyDetectionAlgoType anomalyDetectionAlgoType = anomalyDetectionModelType.getAnomalyDetectionAlgo();
        hashMap.put("SVMS_ACTIVE_LEARNING", anomalyDetectionAlgoType.getSVMSACTIVELEARNING());
        hashMap.put("SVMS_COMPLEXITY_FACTOR", anomalyDetectionAlgoType.getSVMSCOMPLEXITYFACTOR());
        hashMap.put("SVMS_CONV_TOLERANCE", anomalyDetectionAlgoType.getSVMSCONVTOLERANCE());
        hashMap.put("SVMS_KERNEL_FUNCTION", anomalyDetectionAlgoType.getSVMSKERNELFUNCTION());
        hashMap.put("SVMS_KERNEL_CACHE_SIZE", anomalyDetectionAlgoType.getSVMSKERNELCACHESIZE());
        hashMap.put("SVMS_STD_DEV", anomalyDetectionAlgoType.getSVMSSTDDEV());
        hashMap.put("SVMS_OUTLIER_RATE", anomalyDetectionAlgoType.getSVMSOUTLIERRATE());
        return hashMap;
    }

    private HashMap<String, Object> getFeatureExtractionModelSettings() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ModelType modelType = this.getModelType();
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            NonNegativeMatrixFactorAlgoType nonNegativeMatrixFactorAlgoType = ((NonNegativeMatrixFactorModelType)modelType).getNonNegativeMatrixFactorAlgo();
            hashMap.put("FEAT_NUM_FEATURES", nonNegativeMatrixFactorAlgoType.getFEATNUMFEATURES());
            hashMap.put("NMFS_CONV_TOLERANCE", nonNegativeMatrixFactorAlgoType.getNMFSCONVTOLERANCE());
            hashMap.put("NMFS_NUM_ITERATIONS", nonNegativeMatrixFactorAlgoType.getNMFSNUMITERATIONS());
            hashMap.put("NMFS_RANDOM_SEED", nonNegativeMatrixFactorAlgoType.getNMFSRANDOMSEED());
        } else if (modelType instanceof SVDModelType) {
            SVDAlgoType sVDAlgoType = ((SVDModelType)modelType).getSVDAlgo();
            hashMap.put("FEAT_NUM_FEATURES", sVDAlgoType.getFEATNUMFEATURES());
            hashMap.put("ODMS_APPROXIMATE_COMPUTATION", sVDAlgoType.getODMSAPPROXIMATECOMPUTATION());
            hashMap.put("SVDS_U_MATRIX_OUTPUT", sVDAlgoType.getSVDSUMATRIXOUTPUT());
            hashMap.put("SVDS_SCORING_MODE", sVDAlgoType.getSVDSSCORINGMODE());
        } else if (modelType instanceof PCAModelType) {
            PCAAlgoType pCAAlgoType = ((PCAModelType)modelType).getPCAAlgo();
            hashMap.put("FEAT_NUM_FEATURES", pCAAlgoType.getFEATNUMFEATURES());
            hashMap.put("ODMS_APPROXIMATE_COMPUTATION", pCAAlgoType.getODMSAPPROXIMATECOMPUTATION());
            hashMap.put("SVDS_U_MATRIX_OUTPUT", pCAAlgoType.getSVDSUMATRIXOUTPUT());
            hashMap.put("SVDS_SCORING_MODE", pCAAlgoType.getSVDSSCORINGMODE());
        }
        return hashMap;
    }

    public void load() throws Exception {
        if (this._modelType == null) {
            return;
        }
        try {
            this._allSetting = this.getAllModelSettings();
            if (ServerConstants.Algorithm.isNB(this.getAlgorithm())) {
                this.loadPriorsInfo();
            }
            this.getOriginalPerformanceOption();
            this._curClassRefValue = this.getModelSettingStringValue("GLMS_REFERENCE_CLASS_NAME");
            if (this._curClassRefValue == null || this._curClassRefValue.isEmpty()) {
                this._curClassRefValue = SYSTEM_DETERMINED;
            } else {
                this.getGlmClassRefValues();
            }
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            this._odmModel = new Model(this._modelType.getName());
            this._odmModel.load(connectionFolder);
        }
        catch (Exception exception) {
            this._allSetting = null;
            throw exception;
        }
    }

    public boolean isGlmClassRefValuesLoaded() {
        return this._glmClassRefValues != null;
    }

    public boolean isModelBuilt() {
        ModelType modelType = this.getModelType();
        return modelType.getStatus() == ModelStatusType.COMPLETE;
    }

    public List<String> getGlmClassRefValues() {
        if (this._glmClassRefValues != null) {
            return this._glmClassRefValues;
        }
        if (this.isDataSourcePresent() && this.isTargetSelected()) {
            this._glmClassRefValues = this.getDistinctTargetValues();
        }
        return this._glmClassRefValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDistinctTargetValues() {
        String string = this.getStackedSQL();
        AttributeType attributeType = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute();
        if (attributeType == null) {
            return new ArrayList<String>(0);
        }
        String string2 = attributeType.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct \"" + string2 + "\" from " + string + " where \"" + string2 + "\" is not null");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(1);
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public boolean isODmModelBuilt() {
        assert (this._odmModel != null);
        ModelGeneralDescription modelGeneralDescription = this._odmModel.getModelGeneralDescription();
        return modelGeneralDescription.getCreationDate() != null;
    }

    public String getModelSettingStringValue(String string) {
        Object object = null;
        if (this._allSetting != null && (object = this._allSetting.get(string)) != null) {
            return object.toString();
        }
        return "";
    }

    public BigDecimal getModelSettingNumValue(String string) {
        Object object;
        BigDecimal bigDecimal = null;
        if (this._allSetting != null && (object = this._allSetting.get(string)) != null) {
            return new BigDecimal(object.toString());
        }
        return bigDecimal;
    }

    public ArrayList<String> getIgnoredSettings() {
        return this._ignoredSettings;
    }

    public static boolean isPriorsEqual(PriorsInfo priorsInfo, PriorsInfo priorsInfo2) {
        if (priorsInfo == null && priorsInfo2 == null) {
            return true;
        }
        if (priorsInfo == null && priorsInfo2 != null) {
            return false;
        }
        return priorsInfo.equals(priorsInfo2);
    }

    public boolean loadPriorsInfo() {
        boolean bl = false;
        this._priorsOriginalInfo = this.loadPriors();
        this._priorsResultInfo = new PriorsInfo(this._priorsOriginalInfo);
        return !bl ? null != this._priorsOriginalInfo.getOptionName() : false;
    }

    private PriorsInfo loadPriors() {
        ModelType modelType;
        NaiveBayesModelType naiveBayesModelType;
        PriorType priorType;
        PriorsInfo priorsInfo = null;
        if (this._modelType == null) {
            return priorsInfo;
        }
        if (this._modelType instanceof NaiveBayesModelType && (priorType = (naiveBayesModelType = (NaiveBayesModelType)(modelType = this.getModelType())).getPrior()) != null) {
            priorsInfo = new PriorsInfo("Y");
            List list = priorType.getItem();
            if (list != null && list.size() > 0) {
                for (PriorType.Item item : list) {
                    String string = item.getTargetValue();
                    double d = item.getProb();
                    priorsInfo.put(string, BigDecimal.valueOf(d));
                }
            }
        }
        if (priorsInfo == null) {
            return PriorsInfo._NO_PRIOR;
        }
        return priorsInfo;
    }

    public void createCustomPriorsInfo() {
        String string = this.getStackedSQL();
        this._priorsResultInfo = this.createDefaultPriors(this.getContext(), string);
    }

    public CostBenefitsInfo createDefaultCostBenefit() {
        String string = this.getStackedSQL();
        return this.createDefaultCostBenefit(this.getContext(), string);
    }

    public CostMatrixInfo createDefaultCostMatrix() {
        String string = this.getStackedSQL();
        return this.createDefaultCostMatrix(this.getContext(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostMatrixInfo createDefaultCostMatrix(Context context, String string) {
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TRUE");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("select distinct \"" + string2 + "\" from " + string + " where \"" + string2 + "\" is not null");
        Vector<String> vector = new Vector<String>();
        stringBuffer.append(stringBuffer2);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(1);
                vector.add(string3);
            }
        }
        if (costMatrixInfo == null) {
            return null;
        }
        if (vector.isEmpty()) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                costMatrixInfo.put(vector.get(i), vector.get(j), j != i ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L));
            }
        }
        return costMatrixInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostBenefitsInfo createDefaultCostBenefit(Context context, String string) {
        CostBenefitsInfo costBenefitsInfo = new CostBenefitsInfo("BUILD_SETTING_COST_BENEFITS_OPTION");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("select distinct \"" + string2 + "\" from " + string + " where \"" + string2 + "\" is not null");
        Vector<String> vector = new Vector<String>();
        stringBuffer.append(stringBuffer2);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(1);
                vector.add(string3);
            }
        }
        if (costBenefitsInfo == null) {
            return null;
        }
        if (vector.isEmpty()) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            costBenefitsInfo.put((String)vector.get(i), BigDecimal.valueOf(0L));
        }
        return costBenefitsInfo;
    }

    public boolean hasPriors() {
        return null != this._priorsResultInfo && null != this._priorsResultInfo.getValues();
    }

    public void clearPriors() {
        if (null != this._priorsResultInfo) {
            this._priorsResultInfo.clearPriors();
        }
        this._priorsResultInfo.setNoPriorsOption();
    }

    public PriorsInfo getResultPriorsInfo() {
        return this._priorsResultInfo;
    }

    public PriorsInfo getOriginalPriorsInfo() {
        return this._priorsOriginalInfo;
    }

    public void setResultPriorsInfo(PriorsInfo priorsInfo) {
        this._priorsResultInfo = new PriorsInfo(priorsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PriorsInfo createDefaultPriors(Context context, String string) {
        PriorsInfo priorsInfo = new PriorsInfo("Y");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        String string4 = "select \"" + string3 + "\" as VALUE, COUNT(*) as VALUE_COUNT \n" + " from " + string + " group by \"" + string3 + "\" having \"" + string3 + "\" is not null";
        String string5 = "SELECT COUNT(*) AS total FROM " + string + " WHERE \"" + string3 + "\" IS NOT NULL";
        String string6 = "select  COUNT(*) as ROWCOUNT from " + string;
        String string7 = "select  e.VALUE,  ROUND((e.value_count / total), 4) as current_distribution from \n(" + string4 + ") e, " + "\n(" + string5 + ") f, " + "\n(" + string6 + ") g ";
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string7);
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        double d2 = 0.0;
        String string8 = null;
        try {
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                String string9 = sQLHelper.rs.getString(1);
                double d3 = sQLHelper.rs.getDouble(2);
                priorsInfo.put(string9, new BigDecimal(String.valueOf(d3)));
                if (d == null) {
                    d = d3;
                } else if (d3 > d) {
                    d = d3;
                    string8 = string9;
                }
                d2 += d3;
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            priorsInfo = null;
        }
        finally {
            sQLHelper.close();
        }
        double d4 = 1.0 - d2;
        if (d4 > 0.0 || d4 < 0.0) {
            double d5 = d + d4;
            priorsInfo.put(string8, new BigDecimal(String.valueOf(d5)));
        }
        return priorsInfo;
    }

    public String getOriginalPerformanceOption() {
        if (this._pOriginalPerfInfo != null) {
            return this._pOriginalPerfInfo.getPerformanceOption();
        }
        if (this._pOriginalPerfInfo != null) {
            return this._pOriginalPerfInfo.getPerformanceOption();
        }
        this._pOriginalPerfInfo = this.getPerformanceOption();
        if (this._pOriginalPerfInfo != null) {
            this._pResultPerfInfo = new PerformanceInfo(this._pOriginalPerfInfo);
        }
        return this._pOriginalPerfInfo != null ? this._pOriginalPerfInfo.getPerformanceOption() : null;
    }

    private PerformanceInfo getPerformanceOption() {
        PerformanceInfo performanceInfo = null;
        if (this._modelType == null) {
            return performanceInfo;
        }
        if (this._modelType instanceof ClassificationModelType) {
            ModelType modelType = this.getModelType();
            ClassificationModelType classificationModelType = (ClassificationModelType)modelType;
            PerformanceType performanceType = classificationModelType.getPerformance();
            PerformanceType.Custom custom = null;
            if (performanceType != null) {
                if (null != performanceType.getBalanced()) {
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_AVG");
                } else if (null != performanceType.getNatural()) {
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_OVRL");
                } else if (null != performanceType.getCustom()) {
                    custom = performanceType.getCustom();
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
                    WeightsType weightsType = custom.getWeights();
                    List list = weightsType.getItem();
                    if (list != null && list.size() > 0) {
                        for (WeightsType.Item item : list) {
                            String string = item.getTargetValue();
                            double d = item.getWeight();
                            performanceInfo.put(string, BigDecimal.valueOf(d));
                        }
                    }
                } else {
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_AVG");
                }
            }
        }
        return performanceInfo;
    }

    public PerformanceInfo getResultPerformanceInfo() {
        return this._pResultPerfInfo;
    }

    public PerformanceInfo getOriginalPerformanceInfo() {
        return this._pOriginalPerfInfo;
    }

    public boolean hasWeights() {
        return null != this._pResultPerfInfo && null != this._pResultPerfInfo.getValues();
    }

    public void setResultPerformanceInfo(PerformanceInfo performanceInfo) {
        this._pResultPerfInfo = new PerformanceInfo(performanceInfo);
    }

    public void setBalancedPerformanceInfo() {
        this.setPerformanceOption(this._pResultPerfInfo, true);
    }

    public void setNaturalPerformanceInfo() {
        this.setPerformanceOption(this._pResultPerfInfo, false);
    }

    private void setPerformanceOption(PerformanceInfo performanceInfo, boolean bl) {
        performanceInfo.setPerformanceOption(bl ? "BUILD_SETTING_PERFORM_OP_AVG" : "BUILD_SETTING_PERFORM_OP_OVRL");
    }

    public void setPerformanceInfo(boolean bl) {
        this._pResultPerfInfo.setPerformanceOption(bl ? "BUILD_SETTING_PERFORM_OP_AVG" : "BUILD_SETTING_PERFORM_OP_OVRL");
    }

    public void setCustomPerformanceInfo() {
        this._pResultPerfInfo.setPerformanceOption("BUILD_SETTING_PERFORM_OP_CUST");
    }

    public boolean isCaseIdSelected() {
        List list = ((SuperviseBuildNodeType)this._nodeType).getCaseAttributes().getAttribute();
        return list != null && !list.isEmpty();
    }

    public String createCustomPerformanceInfo(boolean bl) {
        String string = null;
        if (!(this._nodeType instanceof SuperviseBuildNodeType)) {
            return string;
        }
        String string2 = StringUtils.addDoubleQuotes(((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName());
        if (bl) {
            this.createBalanceWeights(string2);
        } else {
            this.createNaturalWeights(string2);
        }
        if (this._pResultPerfInfo.getValues() == null) {
            string = _NO_DATA;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerformanceInfo createNaturalWeights(Context context, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        String string4 = "select  " + string + " as VALUE, " + "COUNT(*) as VALUE_COUNT " + "from " + string2 + " group by " + string + " " + "having " + string + " is not null ";
        String string5 = "select  COUNT(*) as total from " + string2 + " where " + string + " is not null";
        String string6 = "select  e.VALUE,  ROUND((e.value_count / total), 4) as target_distribution from \n(" + string4 + ") e, " + "\n(" + string5 + ") f ";
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(string6);
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuffer.toString());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            int n = sQLHelper.rs.getMetaData().getColumnType(1);
            if (2 == n) {
                while (sQLHelper.rs.next()) {
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(1);
                    BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(2);
                    performanceInfo.put(bigDecimal, bigDecimal2);
                }
            } else {
                while (sQLHelper.rs.next()) {
                    String string7 = sQLHelper.rs.getString(1);
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(2);
                    performanceInfo.put(string7, bigDecimal);
                }
            }
        }
        performanceInfo.setCustomGeneratedNatural();
        return performanceInfo;
    }

    private void createBalanceWeights(String string) {
        String string2 = this.getStackedSQL();
        this._pResultPerfInfo = this.createBalanceWeights(this.getContext(), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceInfo createBalanceWeights(Context context, String string, String string2) {
        if (this._modelType == null) {
            return null;
        }
        String string3 = MetaDataHelper.getAlgorithmType(this._modelType);
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = null;
        if (ServerConstants.Algorithm.isDT(string3)) {
            if (string4 != null) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("select " + string + ", 1 / (count(*) / (select count(*) from " + string2 + " where " + string + " is not null)) " + " from " + string2 + " group by " + string + " having " + string + " is not null");
        } else if (ServerConstants.Algorithm.isSVM(string3) || ServerConstants.Algorithm.isGLM(string3)) {
            if (string4 != null) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("select " + string + ", 1/count(*) / (select sum(1/count(*)) from " + string2 + " group by " + string + " having " + string + " is not null) " + " from " + string2 + " group by " + string + " having " + string + " is not null");
        } else if (ServerConstants.Algorithm.isNB(string3)) {
            if (string4 != null) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("select distinct " + string + ", 1 / (select count(distinct  " + string + " ) from " + string2 + " where " + string + " is not null) " + " from " + string2 + " where " + string + " is not null");
        }
        if (stringBuffer == null) {
            return null;
        }
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            int n = sQLHelper.rs.getMetaData().getColumnType(1);
            if (2 == n) {
                while (sQLHelper.rs.next()) {
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(1);
                    BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(2);
                    performanceInfo.put(bigDecimal, bigDecimal2);
                }
            } else {
                while (sQLHelper.rs.next()) {
                    String string5 = sQLHelper.rs.getString(1);
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(2);
                    performanceInfo.put(string5, bigDecimal);
                }
            }
        }
        performanceInfo.setCustomGeneratedBalanced();
        return performanceInfo;
    }

    private void createNaturalWeights(String string) {
        String string2 = this.getStackedSQL();
        this._pResultPerfInfo = this.createNaturalWeights(this.getContext(), string, string2);
    }

    public void setSelectedTargetValue(Object object) {
        this._selectedTargetValue = object;
    }

    public Object getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public void setFalsePositive(boolean bl) {
        this._falsePositive = bl;
    }

    public boolean isFalsePositive() {
        return this._falsePositive;
    }

    public Context getContext() {
        return this._context;
    }

    public void validate() throws ValidationException {
        String string = this.getValidationError();
        if (string != null) {
            throw new ValidationException(string);
        }
    }

    public Object getUserObject() {
        return this._modifiedSettings;
    }

    private static class ModifiedObject {
        private Object _content;
        private boolean _modified = true;

        ModifiedObject(Object object) {
            this._content = object;
        }

        Object getContent() {
            return this._content;
        }

        void clearModifiedFlag() {
            this._modified = false;
        }

        boolean isDirty() {
            return this._modified;
        }
    }

    public static enum OPTION {
        PROPERTIES,
        COST_MATRIX,
        COST_BENEFIT;

    }
}

