/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyPredictionDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyTopNPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardModel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardPage;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ApplySettingsPage
extends ApplyWizardPage
implements DataminerGUIPanel {
    private ApplyWizardModel _wizModel;
    private SpecificTableModel _models;
    private boolean _isDatabaseVersion12_2andUp = false;
    private DataMinerTablePanel dataMinerTablePanel;
    private JCheckBox jMostLikelyBoundsCheckBox;
    private JCheckBox jMostLikelyCheckBox;
    private JTextField jMostLikelyConfidenceField;
    private JLabel jMostLikelyConfidenceLabel;
    private JButton jMostLikelyDetailsButton;
    private JCheckBox jMostLikelyDetailsCheckBox;
    private JLabel jMostLikelyDetailsLabel;
    private JCheckBox jMostLikelyDistanceCheckBox;
    private JPanel jMostLikelyParamsPanel;
    private JCheckBox jSpecificBoundsCheckBox;
    private JCheckBox jSpecificCheckBox;
    private JTextField jSpecificConfidenceField;
    private JLabel jSpecificConfidenceLabel;
    private JButton jSpecificDetailsButton;
    private JCheckBox jSpecificDetailsCheckBox;
    private JLabel jSpecificDetailsLabel;
    private JCheckBox jSpecificDistanceCheckBox;
    private JPanel jSpecificParamsPanel;
    private JCheckBox jTopNCheckBox;
    private JButton jTopNDetailsButton;
    private JLabel jTopNDetailsLabel;
    private JPanel jTopNParamsPanel;
    private JCheckBox jchkPartitionName;

    public ApplySettingsPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initUI() {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        this._wizModel = this.getModel(this.getTraversableContext());
        ApplyNode applyNode = (ApplyNode)this._wizModel.getParent().getData();
        try {
            object3 = ConnectionFolder.getConnectionFolder(applyNode.getContext()).getDbVersion();
            this._isDatabaseVersion12_2andUp = ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, object3, true);
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OPTION_NONE_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
        }
        object3 = this._wizModel.getMostLikelyParam();
        this.jMostLikelyCheckBox.setSelected(object3 != null);
        this.jchkPartitionName.setVisible(false);
        if (this._isDatabaseVersion12_2andUp && ((ApplyNode.PartitionResult)(object2 = ApplyNode.isPartitionedModel((BuildNodeType)this._wizModel.getSelectedModelNode().getData(), this._wizModel.getSelectedModels().get(0).getName()))).isModelFound() && ((ApplyNode.PartitionResult)object2).isModelPartitioned()) {
            this.jchkPartitionName.setVisible(true);
        }
        object2 = this._wizModel.getMostLikelyDetailsParam();
        if (applyNode.is12gDB()) {
            this.jMostLikelyDetailsCheckBox.setVisible(true);
            this.jMostLikelyDetailsLabel.setVisible(true);
            this.jMostLikelyDetailsButton.setVisible(true);
            this.jMostLikelyDetailsLabel.setText(object2.toString());
            this.jMostLikelyDetailsButton.setEnabled(this.jMostLikelyDetailsCheckBox.isSelected());
        } else {
            this.jMostLikelyDetailsLabel.setVisible(false);
            this.jMostLikelyDetailsButton.setVisible(false);
            this.jMostLikelyDetailsCheckBox.setVisible(object2 != null);
        }
        this.jMostLikelyDetailsCheckBox.setSelected(false);
        ApplyNode.Parameters parameters = this._wizModel.getMostLikelyBoundsParam();
        if (parameters == null) {
            this.jMostLikelyBoundsCheckBox.setVisible(false);
            this.jMostLikelyConfidenceLabel.setVisible(false);
            this.jMostLikelyConfidenceField.setVisible(false);
        } else {
            this.jMostLikelyBoundsCheckBox.setSelected(false);
            this.jMostLikelyBoundsCheckBox.setVisible(true);
            this.jMostLikelyConfidenceLabel.setVisible(true);
            this.jMostLikelyConfidenceField.setVisible(true);
            this.jMostLikelyConfidenceField.setEnabled(this.jMostLikelyBoundsCheckBox.isSelected());
            object = ((ApplyNode.DefaultPredictionBounds)parameters).getConfidence();
            ((NumberTextField)this.jMostLikelyConfidenceField).setSigned(false);
            ((NumberTextField)this.jMostLikelyConfidenceField).setDataType(Double.class);
            ((NumberTextField)this.jMostLikelyConfidenceField).setNumber((Number)((Double)object * 100.0));
        }
        object = null;
        if (applyNode.is12gDB()) {
            object = this._wizModel.getMostLikelyDistanceParam();
            if (object == null) {
                this.jMostLikelyDistanceCheckBox.setVisible(false);
            } else {
                this.jMostLikelyDistanceCheckBox.setVisible(true);
            }
            this.jMostLikelyDistanceCheckBox.setSelected(false);
        } else {
            this.jMostLikelyDistanceCheckBox.setVisible(false);
        }
        this.jMostLikelyParamsPanel.setVisible(object2 != null || parameters != null || object != null);
        this.jMostLikelyCheckBox.setVisible(object3 != null);
        ApplyNode.Parameters parameters2 = this._wizModel.getTopNParam();
        if (parameters2 == null) {
            this.jTopNDetailsLabel.setVisible(false);
            this.jTopNDetailsButton.setVisible(false);
        } else {
            this.jTopNCheckBox.setSelected(false);
            this.jTopNDetailsButton.setEnabled(this.jTopNCheckBox.isSelected());
            this.jTopNDetailsLabel.setText(parameters2.toString());
        }
        this.jTopNCheckBox.setVisible(parameters2 != null);
        this.jTopNParamsPanel.setVisible(parameters2 != null);
        ApplyNode.Parameters parameters3 = this._wizModel.getSpecificParam();
        if (parameters3 != null) {
            this._models = new SpecificTableModel(this._wizModel);
            if (parameters3 instanceof ApplyNode.PredictionProbability) {
                this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("PAGE_OUTPUT_TARGET_COL"), 0, true);
            } else if (parameters3 instanceof ApplyNode.ClusterProbability) {
                this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("PAGE_OUTPUT_CLUSTER_COL"), 0, true);
            } else if (parameters3 instanceof ApplyNode.FeatureValue) {
                this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("PAGE_OUTPUT_FEATURE_COL"), 0, true);
            }
            serializable = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
            ((TableColumn)serializable).setMaxWidth(15);
            ((TableColumn)serializable).setResizable(false);
            this.dataMinerTablePanel.getTable().getColumnModel().getColumn(1).setPreferredWidth(100);
            this.dataMinerTablePanel.getTable().setSortColumn(1, true);
            this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ApplySettingsPage.this.handleModelSelectionChanged();
                }
            });
            ApplyNode.Parameters parameters4 = this._wizModel.getSpecificDetailsParam();
            if (applyNode.is12gDB()) {
                this.jSpecificDetailsCheckBox.setVisible(true);
                this.jSpecificDetailsLabel.setVisible(true);
                this.jSpecificDetailsButton.setVisible(true);
                this.jSpecificDetailsLabel.setText(parameters4.toString());
                this.jSpecificDetailsButton.setEnabled(this.jMostLikelyDetailsCheckBox.isSelected());
            } else {
                this.jSpecificDetailsLabel.setVisible(false);
                this.jSpecificDetailsButton.setVisible(false);
                this.jSpecificDetailsCheckBox.setVisible(parameters4 != null);
            }
            this.jSpecificDetailsCheckBox.setSelected(false);
            parameters = this._wizModel.getSpecificBoundsParam();
            if (parameters == null) {
                this.jSpecificBoundsCheckBox.setVisible(false);
                this.jSpecificConfidenceLabel.setVisible(false);
                this.jSpecificConfidenceField.setVisible(false);
            } else {
                this.jSpecificBoundsCheckBox.setVisible(true);
                this.jSpecificConfidenceLabel.setVisible(true);
                this.jSpecificConfidenceField.setVisible(true);
                this.jSpecificBoundsCheckBox.setSelected(false);
                this.jSpecificConfidenceField.setEnabled(this.jSpecificBoundsCheckBox.isSelected());
                Double d = ((ApplyNode.DefaultPredictionBounds)parameters).getConfidence();
                ((NumberTextField)this.jSpecificConfidenceField).setSigned(false);
                ((NumberTextField)this.jSpecificConfidenceField).setDataType(Double.class);
                ((NumberTextField)this.jSpecificConfidenceField).setNumber((Number)(d * 100.0));
            }
            object = null;
            if (applyNode.is12gDB()) {
                object = this._wizModel.getSpecificDistanceParam();
                if (object == null) {
                    this.jSpecificDistanceCheckBox.setVisible(false);
                } else {
                    this.jSpecificDistanceCheckBox.setVisible(true);
                }
                this.jSpecificDistanceCheckBox.setSelected(false);
            } else {
                this.jSpecificDistanceCheckBox.setVisible(false);
            }
        }
        this.jSpecificCheckBox.setVisible(parameters3 != null);
        this.jSpecificParamsPanel.setVisible(parameters3 != null);
        serializable = new HashMap<String, JComponent>();
        if (!applyNode.is12gDB()) {
            ((HashMap)serializable).put((String)DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_DETAILS_OLD"), (JComponent)this.jMostLikelyDetailsCheckBox);
        }
        UIResourceHelper.setComponentText(serializable);
    }

    private void handleModelSelectionChanged() {
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_OPTION"), this.jMostLikelyCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_DETAILS"), this.jMostLikelyDetailsCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS"), this.jMostLikelyBoundsCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS_CONFIDENCE"), this.jMostLikelyConfidenceLabel);
        this.jMostLikelyConfidenceField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS_CONFIDENCE_TIP"));
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_TOPN_OPTION"), this.jTopNCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_SPEC_OPTION"), this.jSpecificCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_SPEC_DETAILS"), this.jSpecificDetailsCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_SPEC_BOUNDS"), this.jSpecificBoundsCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_SPEC_BOUNDS_CONFIDENCE"), this.jSpecificConfidenceLabel);
        this.jSpecificConfidenceField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_SPEC_BOUNDS_CONFIDENCE_TIP"));
        UIResourceHelper.setComponentText(hashMap);
    }

    private void initComponents() {
        this.jMostLikelyCheckBox = new JCheckBox();
        this.jMostLikelyParamsPanel = new JPanel();
        this.jMostLikelyDetailsCheckBox = new JCheckBox();
        this.jMostLikelyDetailsLabel = new JLabel();
        this.jMostLikelyDetailsButton = new JButton();
        this.jMostLikelyBoundsCheckBox = new JCheckBox();
        this.jMostLikelyConfidenceLabel = new JLabel();
        this.jMostLikelyConfidenceField = new NumberTextField();
        this.jMostLikelyDistanceCheckBox = new JCheckBox();
        this.jTopNCheckBox = new JCheckBox();
        this.jTopNParamsPanel = new JPanel();
        this.jTopNDetailsLabel = new JLabel();
        this.jTopNDetailsButton = new JButton();
        this.jSpecificCheckBox = new JCheckBox();
        this.jSpecificParamsPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jSpecificDetailsCheckBox = new JCheckBox();
        this.jSpecificDetailsLabel = new JLabel();
        this.jSpecificDetailsButton = new JButton();
        this.jSpecificBoundsCheckBox = new JCheckBox();
        this.jSpecificConfidenceLabel = new JLabel();
        this.jSpecificConfidenceField = new NumberTextField();
        this.jSpecificDistanceCheckBox = new JCheckBox();
        this.jchkPartitionName = new JCheckBox();
        this.jMostLikelyCheckBox.setText("Most Likely");
        this.jMostLikelyCheckBox.setName("jMostLikelyCheckBox");
        this.jMostLikelyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jMostLikelyCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jMostLikelyParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jMostLikelyParamsPanel.setName("jMostLikelyParamsPanel");
        this.jMostLikelyDetailsCheckBox.setText("Prediction Details");
        this.jMostLikelyDetailsCheckBox.setName("jMostLikelyDetailsCheckBox");
        this.jMostLikelyDetailsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jMostLikelyDetailsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jMostLikelyDetailsLabel.setLabelFor(this.jMostLikelyDetailsButton);
        this.jMostLikelyDetailsLabel.setText("Sort: Absolute, Length: 3");
        this.jMostLikelyDetailsLabel.setName("jMostLikelyDetailsLabel");
        this.jMostLikelyDetailsButton.setText("Edit");
        this.jMostLikelyDetailsButton.setName("jMostLikelyDetailsButton");
        this.jMostLikelyDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jMostLikelyDetailsButtonActionPerformed(actionEvent);
            }
        });
        this.jMostLikelyBoundsCheckBox.setText("Prediction Bounds (for GLM only)");
        this.jMostLikelyBoundsCheckBox.setName("jMostLikelyBoundsCheckBox");
        this.jMostLikelyBoundsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jMostLikelyBoundsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jMostLikelyConfidenceLabel.setLabelFor(this.jMostLikelyConfidenceField);
        this.jMostLikelyConfidenceLabel.setText("Confidence (%):");
        this.jMostLikelyConfidenceLabel.setName("jMostLikelyConfidenceLabel");
        this.jMostLikelyConfidenceField.setName("jMostLikelyConfidenceField");
        this.jMostLikelyConfidenceField.setPreferredSize(new Dimension(50, 20));
        this.jMostLikelyDistanceCheckBox.setText("Cluster Distance");
        this.jMostLikelyDistanceCheckBox.setName("jMostLikelyDistanceCheckBox");
        this.jMostLikelyDistanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jMostLikelyDistanceCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jMostLikelyParamsPanel);
        this.jMostLikelyParamsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jMostLikelyConfidenceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMostLikelyConfidenceField, -2, 76, -2).addGap(0, 324, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMostLikelyDetailsCheckBox).addGap(0, 315, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jMostLikelyDetailsLabel, -1, 401, Short.MAX_VALUE))).addGap(22, 22, 22).addComponent(this.jMostLikelyDetailsButton)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMostLikelyBoundsCheckBox).addComponent(this.jMostLikelyDistanceCheckBox)).addGap(0, 314, Short.MAX_VALUE))).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMostLikelyDetailsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMostLikelyDetailsLabel).addComponent(this.jMostLikelyDetailsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMostLikelyBoundsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMostLikelyConfidenceLabel).addComponent(this.jMostLikelyConfidenceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jMostLikelyDistanceCheckBox)));
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTopNParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jTopNParamsPanel.setName("jTopNParamsPanel");
        this.jTopNDetailsLabel.setLabelFor(this.jTopNDetailsButton);
        this.jTopNDetailsLabel.setText("TopN: 5, CutOff: 12");
        this.jTopNDetailsLabel.setName("jTopNDetailsLabel");
        this.jTopNDetailsButton.setText("Edit");
        this.jTopNDetailsButton.setName("jTopNDetailsButton");
        this.jTopNDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jTopNDetailsButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jTopNParamsPanel);
        this.jTopNParamsPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTopNDetailsLabel, -1, 398, Short.MAX_VALUE).addGap(42, 42, 42).addComponent(this.jTopNDetailsButton).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTopNDetailsLabel).addComponent(this.jTopNDetailsButton)));
        this.jSpecificCheckBox.setText("Specific");
        this.jSpecificCheckBox.setName("jSpecificCheckBox");
        this.jSpecificCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jSpecificCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSpecificParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jSpecificParamsPanel.setName("jSpecificParamsPanel");
        this.dataMinerTablePanel.setName("dataMinerTablePanel");
        this.jSpecificDetailsCheckBox.setText("Predictional Details");
        this.jSpecificDetailsCheckBox.setName("jSpecificDetailsCheckBox");
        this.jSpecificDetailsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jSpecificDetailsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSpecificDetailsLabel.setLabelFor(this.jSpecificDetailsButton);
        this.jSpecificDetailsLabel.setText("Sort: Absolute, Length: 3");
        this.jSpecificDetailsLabel.setName("jSpecificDetailsLabel");
        this.jSpecificDetailsButton.setText("Edit");
        this.jSpecificDetailsButton.setName("jSpecificDetailsButton");
        this.jSpecificDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jSpecificDetailsButtonActionPerformed(actionEvent);
            }
        });
        this.jSpecificBoundsCheckBox.setText("Prediction Bounds (for GLM only)");
        this.jSpecificBoundsCheckBox.setName("jSpecificBoundsCheckBox");
        this.jSpecificBoundsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jSpecificBoundsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSpecificConfidenceLabel.setLabelFor(this.jSpecificConfidenceField);
        this.jSpecificConfidenceLabel.setText("Confidence (%):");
        this.jSpecificConfidenceLabel.setName("jSpecificConfidenceLabel");
        this.jSpecificConfidenceField.setName("jSpecificConfidenceField");
        this.jSpecificConfidenceField.setPreferredSize(new Dimension(50, 20));
        this.jSpecificDistanceCheckBox.setText("Cluster Distance");
        this.jSpecificDistanceCheckBox.setName("jSpecificDistanceCheckBox");
        this.jSpecificDistanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jSpecificDistanceCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.jSpecificParamsPanel);
        this.jSpecificParamsPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jSpecificDetailsCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jSpecificDetailsLabel, -1, -1, Short.MAX_VALUE))).addGap(18, 18, 18).addComponent(this.jSpecificDetailsButton)).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpecificDistanceCheckBox).addGroup(groupLayout3.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jSpecificConfidenceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpecificConfidenceField, -2, 76, -2)).addComponent(this.jSpecificBoundsCheckBox)).addGap(0, 282, Short.MAX_VALUE))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.dataMinerTablePanel, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSpecificDetailsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpecificDetailsLabel).addComponent(this.jSpecificDetailsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpecificBoundsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpecificConfidenceLabel).addComponent(this.jSpecificConfidenceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpecificDistanceCheckBox)));
        this.jchkPartitionName.setText("Partition Name");
        this.jchkPartitionName.setName("jchkPartitionName");
        GroupLayout groupLayout4 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTopNParamsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jMostLikelyParamsPanel, -1, -1, Short.MAX_VALUE))).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jSpecificParamsPanel, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jSpecificCheckBox).addGap(0, 471, Short.MAX_VALUE))).addContainerGap()).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMostLikelyCheckBox).addComponent(this.jTopNCheckBox).addComponent(this.jchkPartitionName)).addGap(0, 0, Short.MAX_VALUE)))));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jMostLikelyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMostLikelyParamsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTopNCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTopNParamsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpecificCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpecificParamsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jchkPartitionName).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jMostLikelyCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jMostLikelyCheckBox.isSelected();
        if (!bl) {
            this.jMostLikelyDetailsCheckBox.setSelected(bl);
            this.jMostLikelyBoundsCheckBox.setSelected(bl);
            this.jMostLikelyDistanceCheckBox.setSelected(bl);
        }
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jTopNCheckBox.isSelected();
        this.jTopNDetailsButton.setEnabled(bl);
    }

    private void jSpecificCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jSpecificCheckBox.isSelected();
        if (!bl) {
            this.jSpecificDetailsCheckBox.setSelected(bl);
            this.jSpecificBoundsCheckBox.setSelected(bl);
            this.jSpecificDistanceCheckBox.setSelected(bl);
        }
    }

    private void jMostLikelyDetailsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jMostLikelyDetailsCheckBox.isSelected();
        if (bl) {
            this.jMostLikelyCheckBox.setSelected(bl);
        }
        this.jMostLikelyDetailsButton.setEnabled(bl);
    }

    private void jMostLikelyBoundsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jMostLikelyBoundsCheckBox.isSelected();
        if (bl) {
            this.jMostLikelyCheckBox.setSelected(bl);
        }
        this.jMostLikelyConfidenceField.setEnabled(bl);
    }

    private void jSpecificBoundsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jSpecificBoundsCheckBox.isSelected();
        if (bl) {
            this.jSpecificCheckBox.setSelected(bl);
        }
        this.jSpecificConfidenceField.setEnabled(bl);
    }

    private void jMostLikelyDetailsButtonActionPerformed(ActionEvent actionEvent) {
        ApplyNode.DefaultPredictionDetails defaultPredictionDetails = (ApplyNode.DefaultPredictionDetails)this._wizModel.getMostLikelyDetailsParam();
        ApplyPredictionDetailsPanel applyPredictionDetailsPanel = new ApplyPredictionDetailsPanel(this._wizModel.getContext(), defaultPredictionDetails);
        if (applyPredictionDetailsPanel.showAsDialog((Component)((Object)this))) {
            this.jMostLikelyDetailsLabel.setText(defaultPredictionDetails.toString());
        }
    }

    private void jTopNDetailsButtonActionPerformed(ActionEvent actionEvent) {
        ApplyNode.DefaultPredictionSet defaultPredictionSet = (ApplyNode.DefaultPredictionSet)this._wizModel.getTopNParam();
        ApplyTopNPanel applyTopNPanel = new ApplyTopNPanel(this._wizModel.getContext(), this, defaultPredictionSet);
        if (applyTopNPanel.showAsDialog((Component)((Object)this))) {
            this.jTopNDetailsLabel.setText(defaultPredictionSet.toString());
        }
    }

    private void jSpecificDetailsButtonActionPerformed(ActionEvent actionEvent) {
        ApplyNode.DefaultPredictionDetails defaultPredictionDetails = (ApplyNode.DefaultPredictionDetails)this._wizModel.getSpecificDetailsParam();
        ApplyPredictionDetailsPanel applyPredictionDetailsPanel = new ApplyPredictionDetailsPanel(this._wizModel.getContext(), defaultPredictionDetails);
        if (applyPredictionDetailsPanel.showAsDialog((Component)((Object)this))) {
            this.jSpecificDetailsLabel.setText(defaultPredictionDetails.toString());
        }
    }

    private void jMostLikelyDistanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jMostLikelyDistanceCheckBox.isSelected();
        if (bl) {
            this.jMostLikelyCheckBox.setSelected(bl);
        }
    }

    private void jSpecificDetailsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jSpecificDetailsCheckBox.isSelected();
        if (bl) {
            this.jSpecificCheckBox.setSelected(bl);
        }
        this.jSpecificDetailsButton.setEnabled(bl);
    }

    private void jSpecificDistanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jSpecificDistanceCheckBox.isSelected();
        if (bl) {
            this.jSpecificCheckBox.setSelected(bl);
        }
    }

    @Override
    public String getPageDirtyKey() {
        return "outputDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        ApplyNode.Parameters parameters;
        List<Integer> list;
        ApplyWizardModel applyWizardModel = this.getModel(traversableContext);
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        if (!(this.jMostLikelyCheckBox.isSelected() || this.jTopNCheckBox.isSelected() || this.jSpecificCheckBox.isSelected() || this.jchkPartitionName.isSelected())) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OPTION_NONE_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (this._isDatabaseVersion12_2andUp) {
            applyWizardModel.setPartitionNameSelected(this.jchkPartitionName.isSelected());
        }
        if (!this.jMostLikelyCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyParam(null);
        }
        if (!this.jMostLikelyDetailsCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyDetailsParam(null);
        }
        if (!this.jMostLikelyBoundsCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyBoundsParam(null);
        } else {
            list = (Double)((NumberTextField)this.jMostLikelyConfidenceField).getNumber();
            parameters = (ApplyNode.DefaultPredictionBounds)applyWizardModel.getMostLikelyBoundsParam();
            ((ApplyNode.DefaultPredictionBounds)parameters).setConfidence((Double)((Object)list) / 100.0);
            try {
                ((ApplyNode.DefaultPredictionBounds)parameters).validate();
            }
            catch (ValidationException validationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
        }
        if (!this.jMostLikelyDistanceCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyDistanceParam(null);
        }
        if (!this.jTopNCheckBox.isSelected()) {
            applyWizardModel.setTopNParam(null);
        }
        if (this.jSpecificCheckBox.isSelected()) {
            list = this._models.getSelecteds();
            if (list.size() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OPTION_SPECIFIC_NO_VALUES_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this._models.isDirty()) {
                parameters = applyWizardModel.getSpecificParam();
                Vector<Object> vector = null;
                if (parameters instanceof ApplyNode.PredictionProbability) {
                    vector = ((ApplyNode.PredictionProbability)parameters).getTargetValues();
                } else if (parameters instanceof ApplyNode.ClusterProbability) {
                    vector = ((ApplyNode.ClusterProbability)parameters).getClusterIds();
                } else if (parameters instanceof ApplyNode.FeatureValue) {
                    vector = ((ApplyNode.FeatureValue)parameters).getFeatureIds();
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(vector.get((Integer)list.get(i)));
                }
                applyWizardModel.setSpecificValues(arrayList);
            }
        } else {
            applyWizardModel.setSpecificParam(null);
        }
        if (!this.jSpecificDetailsCheckBox.isSelected()) {
            applyWizardModel.setSpecificDetailsParam(null);
        }
        if (!this.jSpecificBoundsCheckBox.isSelected()) {
            applyWizardModel.setSpecificBoundsParam(null);
        } else {
            list = (Double)((NumberTextField)this.jSpecificConfidenceField).getNumber();
            parameters = (ApplyNode.DefaultPredictionBounds)applyWizardModel.getSpecificBoundsParam();
            ((ApplyNode.DefaultPredictionBounds)parameters).setConfidence((Double)((Object)list) / 100.0);
            try {
                ((ApplyNode.DefaultPredictionBounds)parameters).validate();
            }
            catch (ValidationException validationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
        }
        if (!this.jSpecificDistanceCheckBox.isSelected()) {
            applyWizardModel.setSpecificDistanceParam(null);
        }
        return this.validateAndWriteToState(applyWizardModel);
    }

    public boolean validateAndWriteToState(ApplyWizardModel applyWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread();
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        return bl;
    }

    public ApplyWizardModel getWizModel() {
        return this._wizModel;
    }

    private static class SpecificTableModel
    extends GenericBaseTableModel {
        public static String[] _targetColumnNames = new String[]{"", DialogsLrb.get("PAGE_OUTPUT_TARGET_COL")};
        public static String[] _clusterColumnNames = new String[]{"", DialogsLrb.get("PAGE_OUTPUT_CLUSTER_COL")};
        public static String[] _featureColumnNames = new String[]{"", DialogsLrb.get("PAGE_OUTPUT_FEATURE_COL")};
        public static final int SELECT_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int COLUMN_COUNT = 2;
        private List<Boolean> _selecteds = new ArrayList<Boolean>();
        private ApplyNode.Parameters _specificParam;
        private boolean dirty = false;

        public SpecificTableModel(ApplyWizardModel applyWizardModel) {
            this._specificParam = applyWizardModel.getSpecificParam();
            if (this._specificParam instanceof ApplyNode.PredictionProbability) {
                this.setColumnIdentifiers(_targetColumnNames);
            } else if (this._specificParam instanceof ApplyNode.ClusterProbability) {
                this.setColumnIdentifiers(_clusterColumnNames);
            } else if (this._specificParam instanceof ApplyNode.FeatureValue) {
                this.setColumnIdentifiers(_featureColumnNames);
            }
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
            if (this.getRowCount() > 0) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    this._selecteds.add(Boolean.FALSE);
                }
            }
        }

        public int getRowCount() {
            Vector<Object> vector = null;
            if (this._specificParam instanceof ApplyNode.PredictionProbability) {
                vector = ((ApplyNode.PredictionProbability)this._specificParam).getTargetValues();
            } else if (this._specificParam instanceof ApplyNode.ClusterProbability) {
                vector = ((ApplyNode.ClusterProbability)this._specificParam).getClusterIds();
            } else if (this._specificParam instanceof ApplyNode.FeatureValue) {
                vector = ((ApplyNode.FeatureValue)this._specificParam).getFeatureIds();
            }
            return vector != null ? vector.size() : 0;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            Object object = this.getValueAt(0, 1);
            return object.getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Boolean bl;
                if (!this.dirty && !(bl = this._selecteds.get(n)).equals(object)) {
                    this.dirty = true;
                }
                this._selecteds.set(n, (Boolean)object);
            }
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            Vector<Object> vector = null;
            if (this._specificParam instanceof ApplyNode.PredictionProbability) {
                vector = ((ApplyNode.PredictionProbability)this._specificParam).getTargetValues();
            } else if (this._specificParam instanceof ApplyNode.ClusterProbability) {
                vector = ((ApplyNode.ClusterProbability)this._specificParam).getClusterIds();
            } else if (this._specificParam instanceof ApplyNode.FeatureValue) {
                vector = ((ApplyNode.FeatureValue)this._specificParam).getFeatureIds();
            }
            Object object = null;
            switch (n2) {
                case 0: {
                    object = this._selecteds.get(n);
                    break;
                }
                case 1: {
                    object = vector.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public List<Integer> getSelecteds() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this._selecteds.size(); ++i) {
                if (!Boolean.TRUE.equals(this._selecteds.get(i))) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    private static class ValidateWriteThread
    extends ProgressRunnable {
        boolean _validated = true;

        private ValidateWriteThread() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }
    }
}

