/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.bali.inspector.UpdateType;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyDataPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyModelsPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyPreferencesPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.docking.DockableView;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorWindowImpl;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Version;

public class ApplyEditorPanel
extends DialogDisplayer<ApplyNode> {
    private PropertyModel _model;
    private ApplyNode _node;
    private ApplyModelsPanel _modelPanel;
    private ApplyDataPanel _dataPanel;
    private String _outputOrder;
    private static Preferences _p = Preferences.getPreferences();
    private ApplyPreferencesPanel.ApplyPreferenceSettings prefs = ApplyPreferencesPanel.ApplyPreferenceSettings.getInstance((PropertyStorage)_p);
    private boolean _isDatabaseVersion12_2andUp = false;
    private JCheckBox jOrderPartitionsCheck;
    private JComboBox<String> jOutputOrderComboBox;
    private JLabel jOutputOrderLabel;
    private JTabbedPane jTabbedPane;
    private static String APPLY_MODEL_TAB = DialogsLrb.get("APPLY_MODEL_TAB");
    private static String APPLY_DATA_TAB = DialogsLrb.get("APPLY_DATA_TAB");

    public ApplyEditorPanel(Context context, ApplyNode applyNode, PropertyModel propertyModel) {
        super(context, applyNode);
        assert (context != null) : "Context must not be null.";
        assert (applyNode != null) : "Apply node must not be null.";
        this._context = context;
        this._model = propertyModel;
        this._node = applyNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this._modelPanel = new ApplyModelsPanel(this._context, this._node, this._model, this);
        this.jTabbedPane.add(APPLY_MODEL_TAB, this._modelPanel);
        this._dataPanel = new ApplyDataPanel(this._context, this._node, this._model);
        this.jTabbedPane.add(APPLY_DATA_TAB, this._dataPanel);
        this.jOutputOrderComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA"), DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_APPLY")}));
        this._outputOrder = ((ApplyNodeType)this._node.getData()).getColumnOutputOrder();
        if (this._outputOrder.equals("SupplementalColumns")) {
            this.jOutputOrderComboBox.setSelectedItem(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA"));
        } else {
            this.jOutputOrderComboBox.setSelectedItem(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_APPLY"));
        }
        this.jOrderPartitionsCheck.setVisible(false);
        try {
            Version version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
            this._isDatabaseVersion12_2andUp = ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, version, true);
            if (this._isDatabaseVersion12_2andUp) {
                this.jOrderPartitionsCheck.setVisible(true);
                String string = ((ApplyNodeType)this._node.getData()).getOrderPartitions();
                if (string != null && string.equals("Yes")) {
                    this.jOrderPartitionsCheck.setSelected(true);
                } else {
                    this.jOrderPartitionsCheck.setSelected(false);
                }
                this.jOrderPartitionsCheck.setToolTipText(DialogsLrb.get("APPLY_NODE_EDIT_ORDER_PARTITIONS"));
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("APPLY_NODE_EDIT_ERROR_MESG"), null);
        }
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jOutputOrderLabel, this.jOutputOrderComboBox, (String)DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING"));
        this.jOutputOrderLabel.getAccessibleContext().setAccessibleName("PREF_OUTPUT_ORDER_SETTING");
        this.jOutputOrderLabel.getAccessibleContext().setAccessibleDescription("PREF_OUTPUT_ORDER_SETTING_ADA");
        ResourceUtils.resButton((AbstractButton)this.jOrderPartitionsCheck, (String)DialogsLrb.get("PREF_OUTPUT_PARTITIONS_ORDER_SETTING"));
        this.jOrderPartitionsCheck.getAccessibleContext().setAccessibleName("PREF_OUTPUT_PARTITIONS_ORDER_SETTING");
        this.jOrderPartitionsCheck.getAccessibleContext().setAccessibleDescription("PREF_OUTPUT_PARTITIONS_ORDER_SETTING_ADA");
    }

    public ApplyDataPanel getDataPanel() {
        return this._dataPanel;
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jOutputOrderLabel = new JLabel();
        this.jOutputOrderComboBox = new JComboBox();
        this.jOrderPartitionsCheck = new JCheckBox();
        this.setPreferredSize(new Dimension(950, 400));
        this.jTabbedPane.setName("jTabbedPane");
        this.jOutputOrderLabel.setLabelFor(this.jOutputOrderComboBox);
        this.jOutputOrderLabel.setText("Column Output Order:");
        this.jOutputOrderLabel.setName("jOutputOrderLabel");
        this.jOutputOrderComboBox.setName("jOutputOrderComboBox");
        this.jOrderPartitionsCheck.setText("Order Partitions");
        this.jOrderPartitionsCheck.setName("");
        this.jOrderPartitionsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyEditorPanel.this.jOrderPartitionsCheckActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 930, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jOutputOrderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOutputOrderComboBox, -2, 173, -2).addGap(18, 18, 18).addComponent(this.jOrderPartitionsCheck).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputOrderLabel).addComponent(this.jOutputOrderComboBox, -2, -1, -2).addComponent(this.jOrderPartitionsCheck)).addContainerGap()));
    }

    private void jOrderPartitionsCheckActionPerformed(ActionEvent actionEvent) {
        ApplyNodeType applyNodeType = (ApplyNodeType)this._node.getData();
        if (this.jOrderPartitionsCheck.isSelected()) {
            applyNodeType.setOrderPartitions("Yes");
        } else {
            applyNodeType.setOrderPartitions("No");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        boolean bl = true;
        String string = (String)this.jOutputOrderComboBox.getSelectedItem();
        string = string.equals(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA")) ? "SupplementalColumns" : "OutputColumns";
        if (this._modelPanel.isDirty() || this._dataPanel.isDirty() || !this._outputOrder.equals(string)) {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("APPLY_NODE_EDIT_TRANSACTION_NAME"));
            try {
                boolean bl2 = false;
                ArrayList<Property> arrayList = new ArrayList<Property>();
                if (!this._outputOrder.equals(string)) {
                    arrayList.add(new Property("applyColumnOutputOrder", null, string, null, null));
                    bl2 = true;
                }
                if (this._modelPanel.isDirty() && this._model == null) {
                    arrayList.add(new Property("applyScoreOutputColumns", null, this._modelPanel.getApplyOutputColumns(), null, null));
                    bl2 = true;
                }
                if (this._dataPanel.isDirty() && this._model == null) {
                    arrayList.add(new Property("applySupplementalColumns", null, this._dataPanel.getSupplementalAttributes(), null, null));
                    bl2 = true;
                }
                if (bl2) {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((ApplyNode)this.getData()).getUndoFilter();
                    odmrSDMUndoFilter.prepareUndoPropertyList(this._node, this.getContext(), arrayList);
                    this._node.validate(true);
                    for (Object e : InspectorManager.getInspectorManager().getViews()) {
                        DockableView dockableView;
                        if (!(e instanceof DockableView) || !(dockableView = (DockableView)e).isVisible() || !(dockableView instanceof InspectorWindowImpl) || dockableView.getGUI() == null) continue;
                        PropertyModelUpdateEvent propertyModelUpdateEvent = new PropertyModelUpdateEvent();
                        propertyModelUpdateEvent.updateType(UpdateType.UPDATE_VALUES_ONLY);
                        InspectorWindowImpl inspectorWindowImpl = (InspectorWindowImpl)dockableView;
                        inspectorWindowImpl.updatePropertyInspector(propertyModelUpdateEvent);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("APPLY_NODE_EDIT_ERROR_MESG"), null);
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                if (CommandProcessor.getInstance().isTransactionActive()) {
                    CommandProcessor.getInstance().endTrans();
                }
            }
        }
        return bl;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "apply_editor";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(950, 600));
    }
}

