/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AbstractAggregationWizardPage;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardModel;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class AggregationWizardOutputNamesPage
extends AbstractAggregationWizardPage
implements DataminerGUIPanel {
    private String[] _columnNames = new String[]{AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SOURCE_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_OUTPUT_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_FUNCTION_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SUB_GROUP_BY_COLUMN")};
    private static final int COLUMN_COUNT = 4;
    private static final int SOURCE = 0;
    private static final int OUTPUT = 1;
    private static final int FUNCTION = 2;
    private static final int SUB_GROUP_BY = 3;
    AggregationWizardModel _wizModel;
    private JScrollPane _jDescriptionScrollPane;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public AggregationWizardOutputNamesPage() {
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this._jDescriptionScrollPane = new JScrollPane();
        this._jDescriptionScrollPane.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jDescriptionScrollPane, -1, 380, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 380, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jDescriptionScrollPane, -2, 28, -2).addContainerGap(261, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(52, 52, 52).addComponent((Component)this.jAttributesComponent, -1, 237, Short.MAX_VALUE).addContainerGap())));
    }

    @Override
    public String getPageDirtyKey() {
        return "outputDirty";
    }

    @Override
    protected String getValidationMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_OUT_NAMES_PAGE_VALIDATION_MESSAGE");
    }

    @Override
    protected String getValidationTitle() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_OUT_NAMES_PAGE_VALIDATE_TITLE");
    }

    @Override
    protected String getValidationFailedMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_OUT_NAMES_PAGE_VALIDATION_FAILED");
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        if (aggregationWizardModel.getNewAggregationElements().isEmpty()) {
            MessageDialog.error((Component)((Object)this), (Object)AggregateDialogsLrb.get("AGGREGATE_WIZ_NO_AGGREGATE_ELEMENTS"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        return true;
    }

    @Override
    public void initRes() {
        this.jAttributesComponent.setLabel(new JLabel(AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_GRID_TITLE")));
        this._jDescription.setText(AggregateDialogsLrb.get("AGGREGATE_WIZ_OUT_NAMES_PAGE_DESCRIPTION"));
        this._jDescriptionScrollPane.getViewport().add((Component)this._jDescription);
    }

    @Override
    public void initUI() {
        this._jAttributesTable.setTooltipEnable(true);
        this._wizModel = this.getModel(this.getTraversableContext());
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(this._wizModel.getNewAggregationElements());
        this.setupItemsTable(generalAttributesTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this._jAttributesTable.setFillsViewportHeight(true);
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(aggregationWizardModel.getContext());
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(dBObjectNameEditor);
    }

    private class GeneralAttributesTableModel
    extends GenericBaseTableModel {
        private List<AggregationElementType> _srcData;

        GeneralAttributesTableModel(List<AggregationElementType> list) {
            this._srcData = new ArrayList<AggregationElementType>(list.size());
            this._srcData.addAll(list);
            this.setRowCount(this._srcData.size());
            this.setColumnIdentifiers(AggregationWizardOutputNamesPage.this._columnNames);
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Vector<AggregationElementType> getDataVector() {
            return new Vector<AggregationElementType>(this._srcData);
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            AggregationElementType aggregationElementType;
            String string;
            if (object == null || object.toString().trim().isEmpty()) {
                MessageDialog.error((Component)((Object)AggregationWizardOutputNamesPage.this), (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
                return;
            }
            String string2 = "";
            if (object != null) {
                string2 = ((String)object).trim();
            }
            if ((string = (aggregationElementType = this._srcData.get(n)).getOutput().getName()) != null && StringUtils.isDoubleQuotedString(string2)) {
                string = StringUtils.addDoubleQuotes(string);
            }
            if (string != null && string.compareTo(string2) == 0) {
                return;
            }
            boolean bl = true;
            for (AggregationElementType aggregationElementType2 : this._srcData) {
                if (!aggregationElementType2.getOutput().getName().equals(object.toString())) continue;
                bl = false;
                break;
            }
            if (!bl) {
                MessageDialog.error((Component)((Object)AggregationWizardOutputNamesPage.this), (Object)AggregateDialogsLrb.get("AGGREGATE_WIZ_OUTPUT_NAME_DUPLICATE"), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_OUT_NAMES_PAGE_VALIDATE_TITLE"), null);
                return;
            }
            if (string2.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string2)) {
                    string2 = string2.toUpperCase();
                }
                if (!AttributeNameValidator.validateAttributeName(string2, null, AggregationWizardOutputNamesPage.this._wizModel.getContext(), true)) {
                    return;
                }
            }
            string2 = StringUtils.trimDoubleQuotes(string2);
            aggregationElementType.getOutput().setName(string2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AggregationElementType aggregationElementType = this._srcData.get(n);
            String string = null;
            if (n2 == 0) {
                GroupingElementType groupingElementType = aggregationElementType.getSource();
                if (null == groupingElementType.getExpression()) {
                    List list = groupingElementType.getAttributes().getAttribute();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (AttributeType attributeType : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(attributeType.getName());
                    }
                    string = stringBuilder.toString();
                } else {
                    string = groupingElementType.getExpression();
                }
            } else if (n2 == 1) {
                AttributeType attributeType = aggregationElementType.getOutput();
                string = attributeType.getName();
            } else if (n2 == 2) {
                string = aggregationElementType.getAggregationFunction();
            } else if (n2 == 3) {
                GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
                if (null == groupingElementType.getExpression()) {
                    if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
                        List list = groupingElementType.getAttributes().getAttribute();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (AttributeType attributeType : list) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(attributeType.getName());
                        }
                        string = stringBuilder.toString();
                    }
                } else {
                    string = groupingElementType.getExpression();
                }
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }
    }
}

