/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ProfitTabState {
    private static final Logger theLogger = Logger.getLogger(ProfitTabState.class.getName());
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<String> _targetValues;
    private String _selectedTargetValue;
    private String _selectedTestResult;
    private HashMap<String, Map<String, List<ProfitData>>> _profitdata;
    private int _selectedQuantileValue;
    private int _selectedBudgetQuantileValue;
    private double _customThresholdValue;
    private ProfitTableModel _profitTableModel;
    private DefaultGraphDataModel _profitGraphModel;
    private int _thresholdSeries;
    private double _minCumProfit;
    private double _maxCumProfit;
    private double _startup_cost;
    private double _inc_revenue;
    private double _inc_cost;
    private double _population;
    private double _budget;
    private int _maxQuantileCnt;

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public int getRESULT_NAME() {
        return this._profitTableModel.getRESULT_NAME();
    }

    public int getTUNE() {
        return ((ProfitTuneTableModel)this._profitTableModel).getTUNE();
    }

    public int getPROFIT() {
        return this._profitTableModel.getPROFIT();
    }

    public int getROI() {
        return this._profitTableModel.getROI();
    }

    public int getPERCENTAGE_RECORDS_CUMULATIVE() {
        return this._profitTableModel.getPERCENTAGE_RECORDS_CUMULATIVE();
    }

    public int getTARGET_DENSITY_CUMULATIVE() {
        return this._profitTableModel.getTARGET_DENSITY_CUMULATIVE();
    }

    public int getMAX_PROFIT() {
        return this._profitTableModel.getMAX_PROFIT();
    }

    public int getMAX_PROFIT_POPULATION() {
        return this._profitTableModel.getMAX_PROFIT_POPULATION();
    }

    public int getALGORITHM() {
        return this._profitTableModel.getALGORITHM();
    }

    public int getBUILD_ROWS() {
        return this._profitTableModel.getBUILD_ROWS();
    }

    public int getTEST_ROWS() {
        return this._profitTableModel.getTEST_ROWS();
    }

    public int getCREATION_DATE() {
        return this._profitTableModel.getCREATION_DATE();
    }

    public ProfitTabState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._profitdata = new HashMap();
        this._selectedQuantileValue = 20;
        this._selectedBudgetQuantileValue = 0;
        this._selectedTestResult = null;
        this._profitTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
        this._profitGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
        this._startup_cost = 1.0;
        this._inc_revenue = 1.0;
        this._inc_cost = 1.0;
        this._population = 100.0;
        this._budget = 1.0;
    }

    public void load(boolean bl) throws SQLException {
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        try {
            for (TestResult testResult : this._testResults) {
                Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
                for (String string : vector) {
                    if (this._targetValues.contains(string)) continue;
                    this._targetValues.add(string);
                }
            }
            Object object = ((ClassTestResult)this._testResults.get(0)).getLeastTargetValue(bl, this._parentTestViewerState.getSelectedPartitionName());
            if (object == null || !this._targetValues.contains(object)) {
                object = this._targetValues.get(0);
            }
            this.setSelectedTargetValue((String)object);
            this.loadProfitData();
            this.loadProfitGraph();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    public void refreshProfitData() throws SQLException {
        try {
            this.loadProfitData();
            this.loadProfitGraph();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    private void loadProfitData() throws SQLException {
        String string = this.getSelectedTargetValue();
        TreeMap<String, List<ProfitData>> treeMap = new TreeMap<String, List<ProfitData>>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            int n;
            for (TestResult testResult : this._testResults) {
                Object object;
                List<ProfitData> list;
                String string2 = ((ClassTestResult)testResult).geLiftResultTable(string);
                if (string2 == null) continue;
                String string3 = testResult.toString();
                Map<String, List<ProfitData>> map = this._profitdata.get(string);
                if (map == null) {
                    map = new HashMap<String, List<ProfitData>>();
                    this._profitdata.put(string, map);
                }
                if ((list = map.get(string3)) == null) {
                    list = new ArrayList<ProfitData>();
                    object = "SELECT * FROM " + string2 + " ORDER BY QUANTILE_NUMBER";
                    sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    n = 0;
                    ProfitData profitData = null;
                    while (sQLHelper.rs.next()) {
                        double d;
                        n = sQLHelper.rs.getInt("QUANTILE_NUMBER");
                        try {
                            d = sQLHelper.rs.getDouble("PROBABILITY_THRESHOLD");
                        }
                        catch (SQLException sQLException) {
                            d = sQLHelper.rs.getDouble("COST_THRESHOLD");
                        }
                        double d2 = sQLHelper.rs.getDouble("PERCENTAGE_RECORDS_CUMULATIVE");
                        double d3 = sQLHelper.rs.getDouble("TARGET_DENSITY_CUMULATIVE");
                        double d4 = sQLHelper.rs.getDouble("TARGETS_CUMULATIVE");
                        double d5 = sQLHelper.rs.getDouble("NON_TARGETS_CUMULATIVE");
                        profitData = new ProfitData(n, d, d2, d3, d4, d5, testResult.getMiningAlgorithm(), testResult.getCreationTime());
                        list.add(profitData);
                    }
                    sQLHelper.close();
                    while (n < 100) {
                        ProfitData profitData2 = new ProfitData(++n, profitData._threshold, profitData._percentRecordsCum / 100.0, profitData._targetDensityCum, profitData._targetCum, profitData._nonTargetCum, profitData._algorithm, profitData._creation_date);
                        list.add(profitData2);
                    }
                    profitData = new ProfitData(0, 0.0, 0.0, 0.0, 0.0, 0.0, null, null);
                    list.add(0, profitData);
                    map.put(string3, list);
                }
                object = map.get(string3);
                treeMap.put(string3, (List<ProfitData>)object);
            }
            TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
            this._profitTableModel = tuneState == null ? new ProfitTableModel(treeMap, false) : new ProfitTuneTableModel(tuneState, treeMap, false);
            double d = (this.getBudget() - this.getStartup_cost()) * 100.0 / (this.getPopulation() * this.getInc_cost());
            d = Math.min(100.0, Math.max(1.0, d));
            this.setSelectedBudgetQuantileValue((int)d);
            if (this.getSelectedQuantileValue() == 0) {
                int n2;
                double d6 = 0.0;
                double d7 = 0.0;
                n = 0;
                for (n2 = 0; n2 < treeMap.size(); ++n2) {
                    d6 = (Double)this._profitTableModel.getValueAt(n2, this.getMAX_PROFIT());
                    if (!(d7 < d6)) continue;
                    d7 = d6;
                    n = n2;
                }
                this.setSelectedTestResult((String)this._profitTableModel.getValueAt(n, this.getRESULT_NAME()));
                n2 = (Integer)this._profitTableModel.getValueAt(n, this.getMAX_PROFIT_POPULATION());
                this.setSelectedQuantileValue(n2);
            }
        }
    }

    private void loadProfitGraph() {
        double d;
        Map<String, List<ProfitData>> map = this._profitdata.get(this.getSelectedTargetValue());
        this._profitGraphModel.clear();
        this._maxQuantileCnt = 0;
        this._maxCumProfit = -1.0 * this.getStartup_cost();
        this._minCumProfit = -1.0 * this.getStartup_cost();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        for (TestResult testResult : this._testResults) {
            String string = testResult.toString();
            List<ProfitData> list = map.get(string);
            if (list == null) continue;
            int n2 = list.size();
            if (this._maxQuantileCnt < n2) {
                this._maxQuantileCnt = n2;
            }
            ++n;
        }
        Object[][] objectArray = new Object[this._maxQuantileCnt * 2][n + 2];
        Object[] objectArray2 = new Object[n + 2];
        Object[] objectArray3 = new Object[n + 2];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getSelectedQuantileValue();
        for (TestResult testResult : this._testResults) {
            String string = testResult.toString();
            List<ProfitData> list = map.get(string);
            if (list == null) continue;
            n4 = 0;
            for (int i = 0; i < list.size(); ++i) {
                objectArray[n4++][n3] = (double)i;
                this.setSelectedQuantileValue(i);
                Double d2 = (Double)this._profitTableModel.getValueAt(n3, this.getPROFIT());
                objectArray[n4++][n3] = d2;
                if (d2 > this._maxCumProfit) {
                    this._maxCumProfit = d2;
                }
                if (!(d2 < this._minCumProfit)) continue;
                this._minCumProfit = d2;
            }
            string = (String)this._profitTableModel.getValueAt(n3, this.getRESULT_NAME());
            objectArray2[n3] = "Profit: " + string;
            objectArray3[n3] = 0;
            ++n3;
            Color color = this._parentTestViewerState.getTestResultGraphColor(string);
            arrayList.add(color);
        }
        this.setSelectedQuantileValue(n5);
        n4 = 0;
        double d3 = this.getSelectedQuantileValue();
        double d4 = this.getSelectedQuantileValue();
        double d5 = this._minCumProfit;
        double d6 = this._maxCumProfit;
        objectArray[n4++][n3] = d3;
        objectArray[n4++][n3] = d5;
        objectArray[n4++][n3] = d4;
        objectArray[n4++][n3] = d6;
        objectArray2[n3] = TestViewerLrb.get("PROFIT_GRAPH_DATA_THRESHOLD");
        objectArray3[n3] = 0;
        this._thresholdSeries = n3++;
        n4 = 0;
        d3 = d = (double)this.getSelectedBudgetQuantileValue();
        d4 = d;
        d5 = this._minCumProfit;
        d6 = this._maxCumProfit;
        objectArray[n4++][n3] = d3;
        objectArray[n4++][n3] = d5;
        objectArray[n4++][n3] = d4;
        objectArray[n4][n3] = d6;
        objectArray2[n3] = TestViewerLrb.get("PROFIT_GRAPH_DATA_BUDGET");
        objectArray3[n3] = 0;
        this._profitGraphModel.addRowLabels(objectArray2);
        this._profitGraphModel.addRowMarkerShapes(objectArray3);
        this._profitGraphModel.addGraphData(objectArray);
        this._profitGraphModel.setLegendVisible(true);
        this._profitGraphModel.setLegendSeriesStart(n);
        this._profitGraphModel.setLegendSeriesCount(2);
        Object[] objectArray4 = new Object[this._maxQuantileCnt * 2];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray4[i] = "";
        }
        this._profitGraphModel.addColumnLabels(objectArray4);
        arrayList.add(SharedTestEditorState.PROFIT_POPULATION_LINE);
        arrayList.add(SharedTestEditorState.PROFIT_BUDGET_LINE);
        this._profitGraphModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
        this._profitGraphModel.setX1(TestViewerLrb.get("X_POPULATION"), this._maxQuantileCnt - 1);
        this._profitGraphModel.setY1(TestViewerLrb.get("Y_PROFIT"), this._minCumProfit, this._maxCumProfit);
    }

    public void refreshCustomThresholdData() {
        Object[][] objectArray = this._profitGraphModel.getGraphData();
        this._profitGraphModel.clearGraphData();
        int n = 0;
        double d = this.getSelectedQuantileValue();
        double d2 = this.getSelectedQuantileValue();
        double d3 = this._minCumProfit;
        double d4 = this._maxCumProfit;
        objectArray[n++][this._thresholdSeries] = d;
        objectArray[n++][this._thresholdSeries] = d3;
        objectArray[n++][this._thresholdSeries] = d2;
        objectArray[n][this._thresholdSeries] = d4;
        this._profitGraphModel.addGraphData(objectArray);
    }

    public void setSelectedTargetValue(String string) {
        this._selectedTargetValue = string;
    }

    public String getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public Map<String, List<ProfitData>> getProfitData() {
        return this._profitdata.get(this.getSelectedTargetValue());
    }

    public ProfitTableModel getLoadingProfitTableModel() {
        return new ProfitTableModel();
    }

    public ProfitTableModel getProfitTableModel() {
        return this._profitTableModel;
    }

    public Vector<String> getTargetValues() {
        return this._targetValues;
    }

    public DefaultGraphDataModel getProfitGraphModel() {
        return this._profitGraphModel;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setSelectedQuantileValue(int n) {
        this._selectedQuantileValue = n;
    }

    public int getSelectedQuantileValue() {
        return this._selectedQuantileValue;
    }

    public void setCustomThresholdValue(double d) {
        this._customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this._customThresholdValue;
    }

    public void setStartup_cost(double d) {
        this._startup_cost = d;
    }

    public double getStartup_cost() {
        return this._startup_cost;
    }

    public void setInc_revenue(double d) {
        this._inc_revenue = d;
    }

    public double getInc_revenue() {
        return this._inc_revenue;
    }

    public void setInc_cost(double d) {
        this._inc_cost = d;
    }

    public double getInc_cost() {
        return this._inc_cost;
    }

    public void setPopulation(double d) {
        this._population = d;
    }

    public double getPopulation() {
        return this._population;
    }

    public void setBudget(double d) {
        this._budget = d;
    }

    public double getBudget() {
        return this._budget;
    }

    public void setSelectedBudgetQuantileValue(int n) {
        this._selectedBudgetQuantileValue = n;
    }

    public int getSelectedBudgetQuantileValue() {
        return this._selectedBudgetQuantileValue;
    }

    public int getMaxQuantileCnt() {
        return this._maxQuantileCnt;
    }

    public class ProfitTuneTableModel
    extends ProfitTableModel {
        private int _start;
        private int RESULT_NAME;
        private int TUNE;
        private int PROFIT;
        private int ROI;
        private int PERCENTAGE_RECORDS_CUMULATIVE;
        private int TARGET_DENSITY_CUMULATIVE;
        private int MAX_PROFIT;
        private int MAX_PROFIT_POPULATION;
        private int ALGORITHM;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;

        @Override
        protected int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        protected int getTUNE() {
            return this.TUNE;
        }

        @Override
        protected int getPROFIT() {
            return this.PROFIT;
        }

        @Override
        protected int getROI() {
            return this.ROI;
        }

        @Override
        protected int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        @Override
        protected int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        @Override
        protected int getMAX_PROFIT() {
            return this.MAX_PROFIT;
        }

        @Override
        protected int getMAX_PROFIT_POPULATION() {
            return this.MAX_PROFIT_POPULATION;
        }

        @Override
        protected int getALGORITHM() {
            return this.ALGORITHM;
        }

        @Override
        protected int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        @Override
        protected int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        @Override
        protected int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        public ProfitTuneTableModel(TuneState tuneState, Map<String, List<ProfitData>> map, boolean bl) {
            super(map, bl);
            this._start = 0;
            this.RESULT_NAME = this._start++;
            this.TUNE = this._start++;
            this.PROFIT = this._start++;
            this.ROI = this._start++;
            this.PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
            this.TARGET_DENSITY_CUMULATIVE = this._start++;
            this.MAX_PROFIT = this._start++;
            this.MAX_PROFIT_POPULATION = this._start++;
            this.ALGORITHM = this._start++;
            this.BUILD_ROWS = -1;
            this.TEST_ROWS = -1;
            this.CREATION_DATE = -1;
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._colNames = new Vector();
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("RESULT_NAME")));
            this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT_POPULATION")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ALGORITHM")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("CREATION_DATE")));
            if (bl) {
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this.CREATION_DATE = this._start++;
            }
            this.setColumnIdentifiers(this._colNames);
            this.setColumnCount(this._colNames.size());
            this._tuneState = tuneState;
        }

        @Override
        public String getColumnName(int n) {
            return (String)this._colNames.get(n);
        }

        @Override
        protected void updateColumnIndices(boolean bl) {
        }

        @Override
        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == this.getRESULT_NAME()) {
                return super.getValueAt(n, this.getRESULT_NAME());
            }
            if (n2 == this.getPROFIT()) {
                return super.getValueAt(n, this.getPROFIT());
            }
            if (n2 == this.getROI()) {
                return super.getValueAt(n, this.getROI());
            }
            if (n2 == this.getPERCENTAGE_RECORDS_CUMULATIVE()) {
                return super.getValueAt(n, this.getPERCENTAGE_RECORDS_CUMULATIVE());
            }
            if (n2 == this.getTARGET_DENSITY_CUMULATIVE()) {
                return super.getValueAt(n, this.getTARGET_DENSITY_CUMULATIVE());
            }
            if (n2 == this.getMAX_PROFIT()) {
                return super.getValueAt(n, this.getMAX_PROFIT());
            }
            if (n2 == this.getMAX_PROFIT_POPULATION()) {
                return super.getValueAt(n, this.getMAX_PROFIT_POPULATION());
            }
            if (n2 == this.getALGORITHM()) {
                return super.getValueAt(n, this.getALGORITHM());
            }
            if (n2 == this.getCREATION_DATE()) {
                return super.getValueAt(n, this.getCREATION_DATE());
            }
            if (n2 == this.TUNE) {
                if (this._profitData != null) {
                    Object[] objectArray = this._profitData.keySet().toArray();
                    String string = (String)objectArray[n];
                    if (this._tuneState.isTuningNone(string)) {
                        return this.TUNE_NONE;
                    }
                    if (this._tuneState.isTuningBenefit(string)) {
                        return this.TUNE_BENEFIT;
                    }
                    if (this._tuneState.isTuningCost(string)) {
                        return this.TUNE_COST;
                    }
                    if (this._tuneState.isTuningCustomROC(string)) {
                        return this.TUNE_ROC;
                    }
                    if (this._tuneState.isTuningCustomLift(string)) {
                        return this.TUNE_LIFT;
                    }
                    if (this._tuneState.isTuningCustomProfit(string)) {
                        return this.TUNE_PROFIT;
                    }
                }
            } else {
                if (n2 == this.getBUILD_ROWS()) {
                    return "TODO";
                }
                if (n2 == this.getTEST_ROWS()) {
                    return "TODO";
                }
            }
            return null;
        }
    }

    public class ProfitTableModel
    extends GenericBaseTableModel {
        private int _start = 0;
        private int RESULT_NAME = this._start++;
        private int PROFIT = this._start++;
        private int ROI = this._start++;
        private int PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
        private int TARGET_DENSITY_CUMULATIVE = this._start++;
        private int MAX_PROFIT = this._start++;
        private int MAX_PROFIT_POPULATION = this._start++;
        private int ALGORITHM = this._start++;
        private int BUILD_ROWS = -1;
        private int TEST_ROWS = -1;
        private int CREATION_DATE = -1;
        protected Vector<String> _colNames;
        protected Map<String, List<ProfitData>> _profitData = null;
        protected Map<String, ProfitDetail> _maxprofit = null;
        private final String LOADING = TestViewerLrb.get("LOADING");

        protected int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        protected int getPROFIT() {
            return this.PROFIT;
        }

        protected int getROI() {
            return this.ROI;
        }

        protected int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        protected int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        protected int getMAX_PROFIT() {
            return this.MAX_PROFIT;
        }

        protected int getMAX_PROFIT_POPULATION() {
            return this.MAX_PROFIT_POPULATION;
        }

        protected int getALGORITHM() {
            return this.ALGORITHM;
        }

        protected int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        protected int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        protected int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        public ProfitTableModel() {
            this(null, false);
        }

        protected void createColumns(boolean bl) {
            if (bl) {
                this._colNames = new Vector();
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("RESULT_NAME")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT_POPULATION")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ALGORITHM")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("BUILD_ROWS")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TEST_ROWS")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("CREATION_DATE")));
            } else {
                this._colNames = new Vector();
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("RESULT_NAME")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT_POPULATION")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ALGORITHM")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("CREATION_DATE")));
            }
        }

        protected void updateColumnIndices(boolean bl) {
            if (bl) {
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this.CREATION_DATE = this._start++;
            }
        }

        public ProfitTableModel(Map<String, List<ProfitData>> map, boolean bl) {
            this.createColumns(bl);
            this.updateColumnIndices(bl);
            this.setColumnIdentifiers(this._colNames);
            this._profitData = map;
            if (this._profitData != null) {
                this._maxprofit = new HashMap<String, ProfitDetail>();
                this.findMaxProfit();
                this.setRowCount(this._profitData.size());
            } else {
                this.setRowCount(1);
            }
            this.setColumnCount(this._colNames.size());
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public void findMaxProfit() {
            Object[] objectArray = this._profitData.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                double d = Double.NEGATIVE_INFINITY;
                int n = 1;
                List<ProfitData> list = this._profitData.get(objectArray[i]);
                int n2 = list.size();
                double d2 = list.get((int)(n2 - 1))._targetCum + list.get((int)(n2 - 1))._nonTargetCum;
                for (int j = 1; j < n2; ++j) {
                    double d3 = list.get((int)j)._targetCum;
                    double d4 = list.get((int)j)._nonTargetCum;
                    double d5 = -1.0 * ProfitTabState.this.getStartup_cost() + (ProfitTabState.this.getInc_revenue() * d3 - ProfitTabState.this.getInc_cost() * (d3 + d4)) * ProfitTabState.this.getPopulation() / d2;
                    if (!(d < d5)) continue;
                    d = d5;
                    n = list.get((int)j)._quantile;
                }
                this._maxprofit.put((String)objectArray[i], new ProfitDetail(d, n));
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this._profitData == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._profitData.keySet().toArray();
            List<ProfitData> list = this._profitData.get(objectArray[n]);
            String string = (String)objectArray[n];
            int n3 = ProfitTabState.this._selectedQuantileValue;
            int n4 = list.size();
            double d = list.get((int)(n4 - 1))._targetCum + list.get((int)(n4 - 1))._nonTargetCum;
            double d2 = list.get((int)n3)._targetCum;
            double d3 = list.get((int)n3)._nonTargetCum;
            if (n2 == this.getRESULT_NAME()) {
                return string;
            }
            if (n2 == this.getPROFIT()) {
                double d4 = ProfitTabState.this.getInc_revenue() * d2;
                double d5 = ProfitTabState.this.getInc_cost() * (d2 + d3);
                double d6 = -1.0 * ProfitTabState.this.getStartup_cost() + (d4 - d5) * ProfitTabState.this.getPopulation() / d;
                return d6;
            }
            if (n2 == this.getROI()) {
                double d7 = ProfitTabState.this.getInc_revenue() * d2;
                double d8 = ProfitTabState.this.getInc_cost() * (d2 + d3);
                double d9 = (d7 - d8) / d8 * 100.0;
                return d9;
            }
            if (n2 == this.getPERCENTAGE_RECORDS_CUMULATIVE()) {
                return list.get((int)n3)._percentRecordsCum;
            }
            if (n2 == this.getTARGET_DENSITY_CUMULATIVE()) {
                return list.get((int)n3)._targetDensityCum;
            }
            if (n2 == this.getMAX_PROFIT()) {
                return this._maxprofit.get((Object)string)._maxProfit;
            }
            if (n2 == this.getMAX_PROFIT_POPULATION()) {
                return this._maxprofit.get((Object)string)._maxProfitQuantile;
            }
            if (n2 == this.getALGORITHM()) {
                return list.get((int)n3)._algorithm;
            }
            if (n2 == this.getCREATION_DATE()) {
                return list.get((int)n3)._creation_date;
            }
            if (n2 == this.getBUILD_ROWS()) {
                return "TODO";
            }
            if (n2 == this.getTEST_ROWS()) {
                return "TODO";
            }
            return "Undefined";
        }

        private class ProfitDetail {
            double _maxProfit;
            int _maxProfitQuantile;

            public ProfitDetail(double d, int n) {
                this._maxProfit = d;
                this._maxProfitQuantile = n;
            }
        }
    }

    public static class ProfitData
    implements Element {
        public Integer _quantile;
        public Double _threshold;
        public Double _targetCum;
        public Double _nonTargetCum;
        public Double _percentRecordsCum;
        public Double _targetDensityCum;
        public String _algorithm;
        public Date _creation_date;
        private String _label;

        public ProfitData(Integer n, Double d, Double d2, Double d3, Double d4, Double d5, String string, Date date) {
            this._quantile = n;
            this._threshold = d;
            this._percentRecordsCum = d2 * 100.0;
            this._targetDensityCum = d3;
            this._targetCum = d4;
            this._nonTargetCum = d5;
            this._algorithm = string;
            this._creation_date = date;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

