/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.partitions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.partition.PartitionDetailsPanel;
import oracle.dmt.dataminer.partition.RulesPartitionFilterSortingPanel;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.partitions.ModelPartitionsEditor;
import oracle.dmt.dataminer.tviewer.partitions.ModelPartitionsState;
import oracle.dmt.dataminer.tviewer.partitions.Sorting;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ColorIcon;

public class ModelPartitionsPanel
extends DataMinerViewGUI
implements Reloadable {
    private BlockingComponent overLayPanel;
    private boolean avoidRefresh = false;
    private final ModelPartitionsState state;
    private final ModelPartitionsState.LoadPartitionsConfig config;
    private ModelPartitionsTableModel tableModel;
    private JPanel jContainer;
    private ButtonGroup jSortGroup;
    private RulesPartitionFilterSortingPanel rulesPartitionFilterSortingPanel1;
    private DataMinerTablePanel tablePanel;
    private final JButton pinBtn = new JButton();
    private final JButton parDetailsBtn = new JButton();
    private final JButton modelDetailsBtn = new JButton();
    private final JButton resultSelBtn = new JButton();

    public ModelPartitionsPanel(ModelPartitionsEditor modelPartitionsEditor) {
        super(modelPartitionsEditor, modelPartitionsEditor.getContext());
        this.state = new ModelPartitionsState((SharedTestEditorState)modelPartitionsEditor.getCachedLegendState(), this.getContext());
        this.config = new ModelPartitionsState.LoadPartitionsConfig();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSortGroup = new ButtonGroup();
        this.jContainer = new JPanel();
        this.rulesPartitionFilterSortingPanel1 = new RulesPartitionFilterSortingPanel(this.getContext(), this.state.getModels(), true, this.state.isClassification());
        this.tablePanel = new DataMinerTablePanel();
        this.jContainer.setLayout(new BoxLayout(this.jContainer, 1));
        this.jContainer.add(this.rulesPartitionFilterSortingPanel1);
        this.jContainer.add(this.tablePanel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jContainer, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jContainer, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.pinBtn.setIcon(OracleIcons.getIcon((String)"pin.png"));
        this.parDetailsBtn.setIcon(OracleIcons.getIcon((String)"settings.png"));
        this.modelDetailsBtn.setIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this.resultSelBtn.setIcon(OracleIcons.getIcon((String)"compare.png"));
        this.pinBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_PIN"));
        this.parDetailsBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_DETAILS"));
        this.modelDetailsBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_MODEL_DETAILS"));
        this.resultSelBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_MODEL_SELECTOR"));
    }

    @Override
    public void initUI() {
        this.pinBtn.setEnabled(false);
        this.parDetailsBtn.setEnabled(false);
        this.modelDetailsBtn.setEnabled(false);
        this.parDetailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelPartitionsPanel.this.tablePanel.getTable().getSelectedRowInModel();
                if (n != -1) {
                    ModelPartitionsState.PartitionTestResult partitionTestResult = (ModelPartitionsState.PartitionTestResult)ModelPartitionsPanel.this.tableModel.getSrcData().get(n);
                    PartitionDetailsPanel partitionDetailsPanel = new PartitionDetailsPanel(partitionTestResult.partitionInfo);
                    partitionDetailsPanel.showAsTooltipDialog(ModelPartitionsPanel.this.parDetailsBtn);
                }
            }
        });
        this.pinBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelPartitionsPanel.this.tablePanel.getTable().getSelectedRowInModel();
                if (n != -1) {
                    ModelPartitionsState.PartitionTestResult partitionTestResult = (ModelPartitionsState.PartitionTestResult)ModelPartitionsPanel.this.tableModel.getSrcData().get(n);
                    AbstractHiddenNode abstractHiddenNode = ModelPartitionsPanel.this.state.getParentState().getTestCompareNode();
                    if (abstractHiddenNode == null) {
                        abstractHiddenNode = ModelPartitionsPanel.this.state.getParentState().getTestResultNode();
                    }
                    TestViewerPartitionToolbar.pinPartition(abstractHiddenNode, partitionTestResult.partitionInfo);
                    ModelPartitionsPanel.this.avoidRefresh = true;
                }
            }
        });
        this.modelDetailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelPartitionsPanel.this.tablePanel.getTable().getSelectedRowInModel();
                if (n != -1) {
                    ModelPartitionsState.PartitionTestResult partitionTestResult = (ModelPartitionsState.PartitionTestResult)ModelPartitionsPanel.this.tableModel.getSrcData().get(n);
                    WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(ModelPartitionsPanel.this.getContext());
                    String string = ModelPartitionsPanel.this.state.getDiagramNodeName();
                    BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string, partitionTestResult.modelName);
                    ModelViewerPartitionToolbar.setSelectedPartitionForModel(baseTreeNode.getLongLabel(), partitionTestResult.partitionInfo);
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                }
            }
        });
        this.resultSelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(ModelPartitionsPanel.this.state.getParentState());
                if (testResultsSelectorPanel.showAsDialog(ModelPartitionsPanel.this)) {
                    List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
                    ModelPartitionsPanel.this.state.getParentState().setTestResults(list);
                    String[] stringArray = new String[list.size()];
                    int n = 0;
                    for (TestResult testResult : list) {
                        stringArray[n++] = testResult.getModelName();
                    }
                    ModelPartitionsPanel.this.state.setModels(stringArray);
                    ModelPartitionsPanel.this.reload();
                }
            }
        });
        this.rulesPartitionFilterSortingPanel1.getQueryButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPartitionsPanel.this.reload();
            }
        });
        if (this.state.getParentState().getTestCompareNode() != null) {
            this.tablePanel.addControlBarComponents(this.pinBtn, this.parDetailsBtn, this.modelDetailsBtn, this.resultSelBtn);
        } else {
            this.tablePanel.addControlBarComponents(this.pinBtn, this.parDetailsBtn, this.modelDetailsBtn);
        }
        this.tablePanel.getTable().setNoEntryInstructionText(TableMessages.LOADING.getMessage());
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().getSelectionModel().setSelectionMode(0);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (listSelectionEvent.getFirstIndex() >= 0) {
                    ModelPartitionsPanel.this.pinBtn.setEnabled(true);
                    ModelPartitionsPanel.this.parDetailsBtn.setEnabled(true);
                    ModelPartitionsPanel.this.modelDetailsBtn.setEnabled(true);
                } else {
                    ModelPartitionsPanel.this.pinBtn.setEnabled(false);
                    ModelPartitionsPanel.this.parDetailsBtn.setEnabled(false);
                    ModelPartitionsPanel.this.modelDetailsBtn.setEnabled(false);
                }
            }
        });
        this.reload();
    }

    public void setupTable() {
        Object object;
        List<ModelPartitionsState.PartitionTestResult> list = this.state.getTestResultsData();
        if (list.isEmpty()) {
            this.tablePanel.getTable().setNoEntryInstructionText(TableMessages.NO_RESULTS.getMessage());
            return;
        }
        if (this.tableModel == null) {
            object = new ArrayList();
            if (this.state.isClassification()) {
                object.addAll(Arrays.asList(ModelPartitionsTableModel.BASE_COLUMNS_CLASSIFICATION));
            } else {
                object.addAll(Arrays.asList(ModelPartitionsTableModel.BASE_COLUMNS_REGRESSION));
            }
            object.addAll(this.state.getTestResultsColumns());
            this.tableModel = new ModelPartitionsTableModel(object.toArray(new String[object.size()]), list, this.state.isClassification());
            this.tablePanel.setup((TableModel)((Object)this.tableModel), TestViewerLrb.get("PARTITION_TEST_RESULT_TABLE_TITLE"), -1);
            DataMinerTable dataMinerTable = this.tablePanel.getTable();
            TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
            if (this.state.isClassification()) {
                this.setupTableClassification(tableColumnModel);
            } else {
                this.setupTableRegression(tableColumnModel);
            }
        } else {
            this.tableModel.setSrcData(list);
        }
        object = this.tablePanel.getTable();
        if (this.config.getSortColumn() != null) {
            int n = object.getColumnModel().getColumnIndex(this.config.getSortColumn());
            object.setSortColumn(n, this.config.getSortOrder().equals((Object)Sorting.ASC));
        }
    }

    private void setupTableClassification(TableColumnModel tableColumnModel) {
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(100L, true, DecimalFormat.getInstance());
        this.setupTableCommon(tableColumnModel, histogramBarRenderer);
        TableColumn tableColumn = tableColumnModel.getColumn(4);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(5);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(12);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(10);
        tableColumn.setCellRenderer(new DateCellRenderer2());
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n - 11];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 11 + i;
        }
        this.tablePanel.getTable().setHiddenColumns(nArray);
    }

    private void setupTableRegression(TableColumnModel tableColumnModel) {
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(100L, true, DecimalFormat.getInstance());
        this.setupTableCommon(tableColumnModel, histogramBarRenderer);
        TableColumn tableColumn = tableColumnModel.getColumn(13);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(11);
        tableColumn.setCellRenderer(new DateCellRenderer2());
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n - 12];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 12 + i;
        }
        this.tablePanel.getTable().setHiddenColumns(nArray);
    }

    private void setupTableCommon(TableColumnModel tableColumnModel, HistogramBarRenderer histogramBarRenderer) {
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Color color = ModelPartitionsPanel.this.state.getParentState().getTestResultGraphColor(object.toString());
                return new ColorIcon(color);
            }
        }));
        tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellRenderer(new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object.equals(TestViewerPartitionToolbar.getPingedPartitionForNode((AbstractHiddenNode)ModelPartitionsPanel.this.getContext().getNode()))) {
                    return OracleIcons.getIcon((String)"pin.png");
                }
                return null;
            }
        }));
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    @Override
    public void reload() {
        if (this.avoidRefresh) {
            this.avoidRefresh = false;
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        } else {
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    public static class ModelPartitionsTableModel
    extends ODMrTableModel<ModelPartitionsState.PartitionTestResult> {
        private static final int COMMON_MODEL_NAME = 0;
        private static final int COMMON_PARTITION_ID = 1;
        private static final int COMMON_PARTITION_NAME = 2;
        private static final int COMMON_PREDICTIVE_CONFIDENCE = 3;
        private static final int CLASS_OVERALL_ACCURACY = 4;
        private static final int CLASS_AVERAGE_ACCURACY = 5;
        private static final int CLASS_BUILD_ROWS = 6;
        private static final int CLASS_TEST_ROWS = 7;
        private static final int CLASS_COST = 8;
        private static final int CLASS_ALGORITHM_TYPE = 9;
        private static final int CLASS_CREATION_DATE = 10;
        private static final int CLASS_BUILD_ROWS_PERCENT = 11;
        private static final int CLASS_TEST_ROWS_PERCENT = 12;
        private static final int CLASS_LAST_VISIBLE_COL = 11;
        private static final int CLASS_LAST_COL_INDEX = 13;
        private static final int REG_MEAN_ABSOLUTE_ERROR = 4;
        private static final int REG_ROOT_MEAN_SQRT_ERROR = 5;
        private static final int REG_MEAN_PREDICTED_VALUE = 6;
        private static final int REG_MEAN_ACTUAL_VALUE = 7;
        private static final int REG_BUILD_ROWS = 8;
        private static final int REG_TEST_ROWS = 9;
        private static final int REG_ALGORITHM_TYPE = 10;
        private static final int REG_CREATION_DATE = 11;
        private static final int REG_BUILD_ROWS_PERCENT = 12;
        private static final int REG_TEST_ROWS_PERCENT = 13;
        private static final int REG_LAST_VISIBLE_COL = 12;
        private static final int REG_LAST_COL_INDEX = 14;
        private static final String[] BASE_COLUMNS_CLASSIFICATION = new String[]{CommonLrb.get("COMMON_MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("COST"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("PARTITION_TEST_RESULT_BUILD_ROWS_PERCENT"), TestViewerLrb.get("PARTITION_TEST_RESULT_TEST_ROWS_PERCENT")};
        private static final String[] BASE_COLUMNS_REGRESSION = new String[]{CommonLrb.get("COMMON_MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("PARTITION_TEST_RESULT_BUILD_ROWS_PERCENT"), TestViewerLrb.get("PARTITION_TEST_RESULT_TEST_ROWS_PERCENT")};
        private boolean isClassification = false;

        public ModelPartitionsTableModel(String[] stringArray, List<ModelPartitionsState.PartitionTestResult> list, boolean bl) {
            super(stringArray, list);
            this.isClassification = bl;
        }

        public Object getValueAt(int n, int n2) {
            return this.isClassification ? this.getValueForClassification(n, n2) : this.getValueForRegression(n, n2);
        }

        private Object getValueForClassification(int n, int n2) {
            ModelPartitionsState.PartitionTestResult partitionTestResult = (ModelPartitionsState.PartitionTestResult)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    return partitionTestResult.modelName;
                }
                case 1: {
                    return partitionTestResult.partitionInfo.getPartitionID();
                }
                case 2: {
                    return partitionTestResult.partitionInfo.getPartitionName();
                }
                case 3: {
                    return partitionTestResult.predictiveConfidence;
                }
                case 4: {
                    return partitionTestResult.classOverallAccuracy;
                }
                case 5: {
                    return partitionTestResult.classAverageAccuracy;
                }
                case 6: {
                    return partitionTestResult.buildRows;
                }
                case 7: {
                    return partitionTestResult.testRows;
                }
                case 8: {
                    return partitionTestResult.classCost;
                }
                case 9: {
                    return partitionTestResult.algorithmType;
                }
                case 10: {
                    return partitionTestResult.creationDate;
                }
                case 11: {
                    return partitionTestResult.buildRowsPercent;
                }
                case 12: {
                    return partitionTestResult.testRowsPercent;
                }
            }
            return partitionTestResult.partitionInfo.getColumns().get(n2 - 13).getValue();
        }

        private Object getValueForRegression(int n, int n2) {
            ModelPartitionsState.PartitionTestResult partitionTestResult = (ModelPartitionsState.PartitionTestResult)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    return partitionTestResult.modelName;
                }
                case 1: {
                    return partitionTestResult.partitionInfo.getPartitionID();
                }
                case 2: {
                    return partitionTestResult.partitionInfo.getPartitionName();
                }
                case 3: {
                    return partitionTestResult.predictiveConfidence;
                }
                case 4: {
                    return partitionTestResult.regMeanAbsoluteError;
                }
                case 5: {
                    return partitionTestResult.regRootMeanSquareError;
                }
                case 6: {
                    return partitionTestResult.regMeanPredictedValue;
                }
                case 7: {
                    return partitionTestResult.regMeanActualValue;
                }
                case 8: {
                    return partitionTestResult.buildRows;
                }
                case 9: {
                    return partitionTestResult.testRows;
                }
                case 10: {
                    return partitionTestResult.algorithmType;
                }
                case 11: {
                    return partitionTestResult.creationDate;
                }
                case 12: {
                    return partitionTestResult.buildRowsPercent;
                }
                case 13: {
                    return partitionTestResult.testRowsPercent;
                }
            }
            return partitionTestResult.partitionInfo.getColumns().get(n2 - 14).getValue();
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(ModelPartitionsPanel.this, ModelPartitionsPanel.this.tablePanel.getTable(), ModelPartitionsPanel.this.overLayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            ModelPartitionsPanel.this.config.setFetchSize(ModelPartitionsPanel.this.rulesPartitionFilterSortingPanel1.getFetchSize()).setFilter(ModelPartitionsPanel.this.rulesPartitionFilterSortingPanel1.getFilterRules(), ModelPartitionsPanel.this.rulesPartitionFilterSortingPanel1.matchAll()).setSorting(ModelPartitionsPanel.this.rulesPartitionFilterSortingPanel1.getSortColumn(), ModelPartitionsPanel.this.rulesPartitionFilterSortingPanel1.getSortOrder());
            ModelPartitionsPanel.this.state.load(ModelPartitionsPanel.this.config);
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ModelPartitionsPanel.this.setupTable();
        }
    }
}

