/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Activity;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public class SharedTestEditorState {
    private static final Logger theLogger = Logger.getLogger(SharedTestEditorState.class.getName());
    private List<TestResult> _allTestResults = null;
    private List<TestResult> _testResults = null;
    private String _selectTestResult = null;
    private List<Color> _testResultGraphColors = null;
    private HashMap<String, Color> _allTestResultGraphColors;
    private List<CPerformanceTabState.PerformanceMetric> _performanceMetrics = null;
    private Context _context = null;
    private Activity _parentActivity;
    private long _lastUpdateTime = 0L;
    private TestResultNode testResultNode;
    private TestCompareNode testCompareNode;
    public static final Color LIFT_IDEAL_LINE = Color.GREEN;
    public static final Color LIFT_RANDOM_LINE = Color.RED;
    public static final Color LIFT_QUANTILE_LINE = Color.BLUE;
    public static final Color PROFIT_BUDGET_LINE = Color.GREEN;
    public static final Color PROFIT_POPULATION_LINE = Color.BLUE;
    public static final String global_results = "partition_name is null";
    public static final String partition_clause = "<partition_clause>";
    public static final String partition_var = "partition_name = ?";
    public static final String performance_table = "<performanceTable>";
    private String selectedPartition;
    private boolean generatePartitions = false;
    private static final List<Color> RESERVED_COLORS = Arrays.asList(Color.GREEN, Color.RED, Color.BLUE);

    public void setSelectedPartition(String string) {
        this.selectedPartition = string;
    }

    public String getSelectedPartitionName() {
        return this.selectedPartition;
    }

    public boolean isEnabledPartitioning() {
        return this.generatePartitions;
    }

    public static String setPartitionClause(String string, String string2) {
        String string3 = null;
        string3 = string2 == null ? StringUtils.getReplacedString(string, partition_clause, global_results) : StringUtils.getReplacedString(string, partition_clause, partition_var);
        return string3;
    }

    public SharedTestEditorState(Node node) {
        boolean bl;
        Object object;
        Object object2;
        TreeMap<String, TestResult> treeMap;
        AbstractHiddenNode abstractHiddenNode;
        String string = null;
        if (node instanceof TestResultNode) {
            abstractHiddenNode = (TestResultNode)node;
            this.testResultNode = abstractHiddenNode;
            treeMap = (TestResult)abstractHiddenNode.getRepositoryData();
            assert (treeMap != null) : "model cannot be null";
            this._testResults = new ArrayList<TestResult>();
            this._testResults.add((TestResult)((Object)treeMap));
            this._context = abstractHiddenNode.getContext();
            string = ((TestResultNode)abstractHiddenNode).getParentClassificationNodeId();
        } else if (node instanceof TestCompareNode) {
            abstractHiddenNode = (TestCompareNode)node;
            this.testCompareNode = abstractHiddenNode;
            assert (((TestCompareNode)abstractHiddenNode).getTestResults() != null) : "models cannot be null";
            this._testResults = ((TestCompareNode)abstractHiddenNode).getTestResults();
            this._context = abstractHiddenNode.getContext();
            string = ((TestCompareNode)abstractHiddenNode).getParentNodeId();
        } else assert (false) : "Node is not of type TestResultNode or TestCompareNode";
        boolean bl2 = false;
        try {
            treeMap = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
            bl2 = ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, (Version)treeMap, true);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2 && (treeMap = WorkflowNode.findParentWorkflowNode(this.getContext())) != null && string != null) {
            TestNodeType testNodeType;
            List list;
            Object object3;
            object2 = ((WorkflowNode)((Object)treeMap)).getWorkflowModel();
            AbstractNode object5 = (AbstractNode)((WorkflowModel)((Object)object2)).findNodeByMetadataId(string);
            if (object5 instanceof ClassificationBuildNode) {
                object3 = (ClassificationBuildNode)object5;
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)((AbstractNode)object3).getData();
                object = classificationBuildNodeType.getPartitionExpressions();
                if (object != null && !(list = object.getPartitionExpression()).isEmpty()) {
                    this.generatePartitions = true;
                }
            } else if (object5 instanceof RegressionBuildNode) {
                object3 = (RegressionBuildNode)object5;
                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)((AbstractNode)object3).getData();
                object = regressionBuildNodeType.getPartitionExpressions();
                if (object != null && !(list = object.getPartitionExpression()).isEmpty()) {
                    this.generatePartitions = true;
                }
            } else if (object5 instanceof TestNode && (object = (testNodeType = (TestNodeType)((AbstractNode)(object3 = (TestNode)object5)).getData()).getTestModels()) != null) {
                this.generatePartitions = object.isGeneratePartitions();
            }
        }
        treeMap = new TreeMap<String, TestResult>();
        for (TestResult bl22 : this._testResults) {
            treeMap.put(bl22.toString(), bl22);
        }
        this._testResults = new ArrayList(treeMap.values());
        object2 = null;
        try {
            object2 = ConnectionFolder.getUserAccountName(this._context);
            object2 = StringUtils.isDoubleQuotedString((String)object2) ? StringUtils.trimDoubleQuotes((String)object2) : ((String)object2).toUpperCase();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        boolean bl3 = false;
        for (TestResult testResult : this._testResults) {
            object = testResult.getModelSchema();
            if (object == null || ((String)object).compareTo((String)object2) == 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (TestResult testResult : this._testResults) {
                testResult.setShowSchema(true);
            }
        }
        this._allTestResults = new ArrayList<TestResult>();
        this._allTestResults.addAll(this._testResults);
        this.assignColors();
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public void updateTime() {
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public List<TestResult> getTestResults() {
        return this._testResults;
    }

    public Activity getParentActivity() {
        return this._parentActivity;
    }

    public List<Color> getTestResultGraphColors() {
        return this._testResultGraphColors;
    }

    public Color getTestResultGraphColor(String string) {
        return this._allTestResultGraphColors.get(string);
    }

    public Context getContext() {
        return this._context;
    }

    public void setTestResults(List<TestResult> list) {
        this._testResults = list;
        this._testResultGraphColors.clear();
        for (TestResult testResult : this._testResults) {
            Color color = this._allTestResultGraphColors.get(testResult.toString());
            this._testResultGraphColors.add(color);
        }
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setPerformanceMetrics(List<CPerformanceTabState.PerformanceMetric> list) {
        this._performanceMetrics = list;
    }

    public List<CPerformanceTabState.PerformanceMetric> getPerformanceMetrics() {
        return this._performanceMetrics;
    }

    private void assignColors() {
        Graph graph = new Graph();
        Object[] objectArray = new Object[]{"TempRowLable1", "TempRowLable2"};
        Object[] objectArray2 = new Object[this._testResults.size() + RESERVED_COLORS.size()];
        Object[][] objectArray3 = new Object[2][this._testResults.size() + RESERVED_COLORS.size()];
        int n = 0;
        for (int i = 0; i < RESERVED_COLORS.size(); ++i) {
            objectArray2[n] = "Color-" + n;
            objectArray3[0][n] = 0.5;
            objectArray3[1][n] = 1.0;
            ++n;
        }
        for (TestResult iterator : this._allTestResults) {
            objectArray2[n] = iterator.getName();
            objectArray3[0][n] = 0.5;
            objectArray3[1][n] = 1.0;
            ++n;
        }
        graph.setGridData(objectArray, objectArray2, objectArray3);
        Series series = graph.getSeries();
        n = 0;
        for (Color color : RESERVED_COLORS) {
            try {
                series.setColor(color, n++);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        this._allTestResultGraphColors = new HashMap();
        this._testResultGraphColors = new ArrayList<Color>();
        for (TestResult testResult : this._allTestResults) {
            try {
                Color color = series.getColor(n++);
                this._allTestResultGraphColors.put(testResult.toString(), color);
                this._testResultGraphColors.add(color);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public List<TestResult> getAllTestResults() {
        return this._allTestResults;
    }

    public void setSelectTestResult(String string) {
        this._selectTestResult = string;
    }

    public String getSelectTestResult() {
        return this._selectTestResult;
    }

    public TestResultNode getTestResultNode() {
        return this.testResultNode;
    }

    public TestCompareNode getTestCompareNode() {
        return this.testCompareNode;
    }
}

