/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.teditor.structure.StructureViewState;
import oracle.dmt.dataminer.teditor.structure.StructureViewTableModel;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class StructureViewPanel
extends DataMinerViewGUI {
    private boolean _loadFromNode = true;
    private boolean _loadFromSQLExpression = false;
    private TableVO _selectedTable = null;
    private String SYN_SELECTED_TABLE = "syn_selected_table";
    private String _connectionName;
    private String _schemaName;
    private String _tableName;
    private String _sqlExpression;
    private boolean _completedHiddenColumnsDefinition = false;
    private BlockingComponent overLayPanel = null;
    private DataSourceWizardModel wizModel;
    private StructureViewState _state;
    private StructureViewTableModel tableModel;
    private DataMinerTablePanel structurePanel;

    public StructureViewPanel(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context, DataSourceWizardModel dataSourceWizardModel, boolean bl) {
        super(null, context);
        this.wizModel = dataSourceWizardModel;
        this._loadFromNode = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context, String string) {
        super(null, context);
        this._loadFromNode = false;
        this._loadFromSQLExpression = true;
        this._sqlExpression = string;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.structurePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.structurePanel, -1, 478, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.structurePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.structurePanel.setTitle(StructureLrb.get("TABLE_STRUCTURE_EDITOR_GRID_TITLE"));
    }

    @Override
    public void initUI() {
        this._state = this._context != null ? (this._loadFromSQLExpression ? new StructureViewState(this._context, this._sqlExpression) : new StructureViewState(this._context, this._loadFromNode)) : new StructureViewState(this._connectionName, this._schemaName, this._tableName);
        this.setLoading(true);
        this.initializeControls();
        this.setupTable();
        if (this._loadFromNode || this._loadFromSQLExpression) {
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public void reload() {
        this.initUI();
    }

    public StructureViewState getState() {
        return this._state;
    }

    private void setTableStatus(TableStatus tableStatus) {
        this.tableModel.clear();
        switch (tableStatus) {
            case LOADING: {
                this.structurePanel.getTable().setNoEntryInstructionText(TableMessages.LOADING.getMessage());
                break;
            }
            case NO_SELECTION: {
                this.structurePanel.getTable().setNoEntryInstructionText(StructureLrb.get("TABLE_STRUCTURE_EDITOR_SELECTION_REQUIRED"));
                break;
            }
            case QUERY_NOT_AVAILABLE: {
                this.structurePanel.getTable().setNoEntryInstructionText(DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE"));
                break;
            }
            case ERROR: {
                this.structurePanel.getTable().setNoEntryInstructionText(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILED_TO_LOAD_TABLE_STRUCTURE"));
            }
        }
    }

    public void loadTable(TableVO tableVO) {
        this.setLoading(true);
        this.enableControls(true);
        this.setSelectedTable(tableVO);
        LoadUISync loadUISync = new LoadUISync(tableVO != null ? tableVO.getSynonymSchema() : "", tableVO != null ? tableVO.getSynonymName() : "");
        loadUISync.execute();
    }

    public void loadTable(String string) {
        this.setLoading(true);
        this.enableControls(true);
        this.setSelectedSQLExpression(string);
        LoadUISync loadUISync = new LoadUISync(string);
        loadUISync.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableVO getSelectedTable() {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            return this._selectedTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTable(TableVO tableVO) {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            this._selectedTable = tableVO;
            if (tableVO == null) {
                this.setTableStatus(TableStatus.NO_SELECTION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedSQLExpression(String string) {
        String string2 = this.SYN_SELECTED_TABLE;
        synchronized (string2) {
            this._sqlExpression = string;
        }
    }

    public void close() {
    }

    private void initializeControls() {
        this.enableControls(false);
    }

    public HelpInfo getHelpInfo() {
        String string = "data_structure_viewer_help";
        return new HelpInfo(string);
    }

    private void setColumnWidths(TableColumnModel tableColumnModel) {
        tableColumnModel.getColumn(0).setPreferredWidth(295);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        tableColumnModel.getColumn(3).setPreferredWidth(80);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
    }

    private void setupTable() {
        this.tableModel = new StructureViewTableModel((List<ColumnDataRow>)new ArrayList<ColumnDataRow>(0));
        this.structurePanel.setup((TableModel)((Object)this.tableModel), null, new String[]{StructureViewTableModel.COLUMN_NAMES[0], StructureViewTableModel.COLUMN_NAMES[1], StructureViewTableModel.COLUMN_NAMES[2]}, 0);
        this.structurePanel.getTable().setSortColumn(0, true);
        TableColumnModel tableColumnModel = this.structurePanel.getTable().getColumnModel();
        this.setColumnWidths(tableColumnModel);
        if (!this._completedHiddenColumnsDefinition) {
            this.structurePanel.getTable().setHiddenColumns(new int[]{4, 5});
            this._completedHiddenColumnsDefinition = true;
        }
        this.setTableStatus(TableStatus.NO_SELECTION);
    }

    private void enableControls(boolean bl) {
        this.structurePanel.getSearchField().setEnabled(bl);
    }

    private static enum TableStatus {
        LOADING,
        NO_SELECTION,
        ERROR,
        QUERY_NOT_AVAILABLE;

    }

    private class LoadUI
    extends SwingWorker<List<ColumnDataRow>, Void> {
        private LoadUI() {
            StructureViewPanel.this.setTableStatus(TableStatus.LOADING);
            StructureViewPanel.this.tableModel.clear();
        }

        @Override
        protected List<ColumnDataRow> doInBackground() throws Exception {
            return StructureViewPanel.this._state.load();
        }

        @Override
        protected void done() {
            try {
                StructureViewPanel.this.setLoaded(true);
                StructureViewPanel.this.tableModel.setSrcData((List)this.get());
                StructureViewPanel.this.structurePanel.trySearch();
                StructureViewPanel.this.enableControls(true);
            }
            catch (InterruptedException | ExecutionException exception) {
                StructureViewPanel.this.setTableStatus(TableStatus.ERROR);
                DataMinerEditor.handleEditorException(StructureViewPanel.this.getEditor().getContext(), exception, StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"));
            }
            finally {
                StructureViewPanel.this.setLoading(false);
                if (StructureViewPanel.this.overLayPanel != null) {
                    StructureViewPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private class LoadUISync
    extends SwingWorker<List<ColumnDataRow>, Void> {
        static final String _syncObject = "SyncObject";
        String _schema = null;
        String _table = null;
        String _sqlExpression = null;
        boolean _abandon = false;

        public LoadUISync(String string, String string2) {
            this._schema = string;
            this._table = string2;
            if (StructureViewPanel.this._selectedTable != null) {
                StructureViewPanel.this.setTableStatus(TableStatus.LOADING);
            }
        }

        public LoadUISync(String string) {
            this._sqlExpression = string;
            if (this._sqlExpression != null) {
                StructureViewPanel.this.setTableStatus(TableStatus.LOADING);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<ColumnDataRow> doInBackground() throws Exception {
            List<ColumnDataRow> list = null;
            try {
                String string = _syncObject;
                synchronized (_syncObject) {
                    if (this._sqlExpression != null) {
                        StructureViewPanel.this._state.setSqlExpression(this._sqlExpression);
                        list = StructureViewPanel.this._state.load();
                        this._abandon = false;
                    } else {
                        TableVO tableVO = StructureViewPanel.this.getSelectedTable();
                        if (tableVO == null) {
                            this._abandon = true;
                        } else if (tableVO.getSynonymSchema().equals(this._schema) && tableVO.getSynonymName().equals(this._table)) {
                            StructureViewPanel.this._state.setTableName(this._schema, this._table);
                            list = StructureViewPanel.this._state.load();
                            tableVO = StructureViewPanel.this.getSelectedTable();
                            if (tableVO == null) {
                                this._abandon = true;
                            } else if (!tableVO.getSynonymSchema().equals(this._schema) || !tableVO.getSynonymName().equals(this._table)) {
                                this._abandon = true;
                            }
                        } else {
                            this._abandon = true;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                this._abandon = true;
                throw exception;
            }
            {
                return list;
            }
        }

        @Override
        protected void done() {
            super.done();
            try {
                List list = (List)this.get();
                if (this._abandon) {
                    return;
                }
                if (list.size() > 0) {
                    TableVO tableVO;
                    if (!(this._sqlExpression != null || (tableVO = StructureViewPanel.this.getSelectedTable()).getSynonymSchema().equals(this._schema) && tableVO.getSynonymName().equals(this._table))) {
                        return;
                    }
                    StructureViewPanel.this.tableModel.setSrcData(list);
                    StructureViewPanel.this.structurePanel.trySearch();
                    if (StructureViewPanel.this._state != null) {
                        StructureViewPanel.this.wizModel.setJsonColumns(StructureViewPanel.this._state.getJsonColumns());
                    }
                    StructureViewPanel.this.enableControls(true);
                    StructureViewPanel.this.setLoaded(true);
                } else if ("".equals(this._table)) {
                    StructureViewPanel.this.setTableStatus(TableStatus.NO_SELECTION);
                } else {
                    StructureViewPanel.this.setTableStatus(TableStatus.QUERY_NOT_AVAILABLE);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                StructureViewPanel.this.setTableStatus(TableStatus.ERROR);
                DataMinerEditor.handleEditorException(StructureViewPanel.this.getEditor().getContext(), exception, StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"));
            }
            finally {
                if (StructureViewPanel.this.overLayPanel != null) {
                    StructureViewPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

