/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.graph.BinningWorker;
import oracle.dmt.dataminer.teditor.graph.GraphLoader;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphPreferences;
import oracle.dmt.dataminer.teditor.graph.GraphQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;

class HistogramQueryBuilder
extends GraphQueryBuilder {
    protected String binIdsClause = "";
    protected String binLabelsClause = "";
    protected String xBinComma = "";
    protected String binIdAttr = "";
    protected String orderBy = "";
    protected String gcomma;
    protected String nullsClause;

    public static GraphQueryBuilder getQueryGraphBuilder(Context context, String string, GraphSettingsType graphSettingsType) throws Exception {
        return GraphQueryBuilder.getQueryGraphBuilder(HistogramQueryBuilder.class, context, string, graphSettingsType, GraphPreferences.getInstance());
    }

    @Override
    public String buildGraphQuery() throws Exception {
        String string;
        this.init("COUNT", GraphLrb.get("COUNT"));
        this.query = "WITH BINNING_INTERVALS AS (  SELECT    <grouping_clause><gcomma>     <bin_id_clause><xbincomma>    <bin_label_clause>  FROM <table> <nulls> ), <binned_data><allBinsClause> select * from <source>   <orderby>";
        if (GraphUtils.isCategoricalType(this.xattribute.getDataType()) && this.isGroupByEnabled) {
            string = "  count_calc as (    select count (<gattr>) as \"COUNT\", <gattr>, <xattr> from binning_intervals group by <gattr>, <xattr>),  total_calc as (    select sum(\"COUNT\") TOTAL, <xattr> from count_calc GROUP BY <xattr>),  binned_data as (    select total_calc.total, count_calc.\"COUNT\", count_calc.<xattr>, <gattr>    from count_calc, total_calc     where count_calc.<xattr> = total_calc.<xattr>    order by total desc, <xattr>, <gattr> desc  )";
        } else {
            string = "BINNED_DATA AS (  SELECT      COUNT(<xattr>) as <yattr>,      <binidattr><xbincomma> <xattr><gcomma> <gattr>  FROM BINNING_INTERVALS   GROUP BY <binidattr><xbincomma> <xattr><gcomma> <gattr>)";
            if (GraphUtils.isCategoricalType(this.xattribute.getDataType()) && !this.isGroupByEnabled) {
                this.orderBy = "order by <yattr> desc";
            }
        }
        this.query = StringUtils.getReplacedString(this.query, "<binned_data>", string);
        this.query = StringUtils.getReplacedString(this.query, "<orderby>", this.orderBy);
        this.query = StringUtils.getReplacedString(this.query, "<binidattr>", this.binIdAttr);
        this.query = StringUtils.getReplacedString(this.query, "<xbincomma>", this.xBinComma);
        this.query = StringUtils.getReplacedString(this.query, "<grouping_clause>", this.groupingClause);
        this.query = StringUtils.getReplacedString(this.query, "<bin_id_clause>", this.binIdsClause);
        this.query = StringUtils.getReplacedString(this.query, "<bin_label_clause>", this.binLabelsClause);
        this.query = StringUtils.getReplacedString(this.query, "<nulls>", this.nullsClause);
        this.query = StringUtils.getReplacedString(this.query, "<table>", this.fqCacheTableName);
        this.query = StringUtils.getReplacedString(this.query, "<yattr>", this.yAttributeName);
        this.query = StringUtils.getReplacedString(this.query, "<xattr>", this.qXAttributeName);
        this.query = StringUtils.getReplacedString(this.query, "<allBinsClause>", this.allBinsClause);
        this.query = StringUtils.getReplacedString(this.query, "<gattr>", this.qGAttributeName);
        this.query = StringUtils.getReplacedString(this.query, "<gcomma>", this.gcomma);
        this.query = StringUtils.getReplacedString(this.query, "<emptyGBinClause>", this.emptyGBinClause);
        this.query = StringUtils.getReplacedString(this.query, "<source>", this.allBinsClause.length() != 0 ? "ALL_BINS" : "BINNED_DATA");
        if (this.isGroupByEnabled) {
            this.columnTitles.add(this.gAttributeName);
            this.columnTitles.add(this.xattribute.getName());
        } else {
            this.columnTitles.add(this.xattribute.getName());
            this.columnTitles.add(GraphLrb.get("GRAPH_DATA_SERIES"));
        }
        this.columnTitles.add(GraphLrb.get("GRAPH_DATA_HIST_COUNT"));
        return this.query;
    }

    protected void init(String string, String string2) throws Exception {
        Object object;
        Object object3;
        List<NameValuePair> list;
        this.yAttributeName = string;
        this.yAxisLabel = string2;
        Map<String, List<NameValuePair>> map = BinningWorker.getDefaultBins(this.context, this.binningAttributes, this.attributeBinningSettings);
        if (this.gAttributeName != null && this.gAttributeName.length() != 0) {
            if (!this.gbinningSettings.getBinningKind().equals((Object)BinningType.NONE) && !map.containsKey(this.gAttributeName)) {
                throw new GraphLoader.NoDataFoundException(GraphLrb.get("LOADER_NO_BINS_FOUND_GRP"));
            }
            list = map.get(this.gAttributeName);
            if (this.gbinningSettings.getBinningKind() == BinningType.EQUAL_WIDTH) {
                object3 = this.getNumBinClauses(list, string, this.gattribute, "0", false, this.showGroupByNulls);
                Pair<String, String> object22 = ((GraphLoader.BinClausesInfo)object3).getBinClauses();
                this.emptyGBinClause = ((GraphLoader.BinClausesInfo)object3).getEmptyBinsClause();
                this.groupingClause = (String)object22.getSecond();
            } else if (this.gbinningSettings.getBinningKind() == BinningType.TOP_N) {
                if (this.gcatBinValues.isEmpty()) {
                    for (NameValuePair nameValuePair : list) {
                        object = StringUtils.escapeSingleQuotesForSQL((String)nameValuePair.getValue());
                        this.gcatBinValues.add(object);
                    }
                }
                this.groupingClause = this.getCatBinCaseClause(this.gattribute, this.gbinningSettings);
            } else if (this.gbinningSettings.getBinningKind() == BinningType.NONE) {
                this.groupingClause = this.gAttributeName;
            }
            if (!map.containsKey(this.xattribute.getName())) {
                throw new GraphLoader.NoDataFoundException(GraphLrb.get("LOADER_NO_BINS_FOUND"));
            }
        }
        list = map.get(this.xattribute.getName());
        if (this.xBinningSettings.getBinningKind().equals((Object)BinningType.EQUAL_WIDTH)) {
            object3 = null;
            if (this.isGroupByEnabled) {
                object3 = this.gcatBinValues == null || this.gcatBinValues.isEmpty() ? "0" : (String)this.gcatBinValues.get(0);
            }
            GraphLoader.BinClausesInfo binClausesInfo = this.getNumBinClauses(list, string, this.xattribute, (String)object3, true, this.showXNulls);
            object = binClausesInfo.getBinClauses();
            this.binIdsClause = (String)object.getFirst();
            this.binLabelsClause = (String)object.getSecond();
            this.allBinsClause = binClausesInfo.getEmptyBinsClause();
            this.xBinComma = ", ";
            this.binIdAttr = "BIN_IDS";
            this.orderBy = "ORDER BY " + this.binIdAttr;
        } else if (this.xBinningSettings.getBinningKind().equals((Object)BinningType.TOP_N)) {
            if (this.catBinValues.isEmpty()) {
                for (NameValuePair nameValuePair : list) {
                    object = StringUtils.escapeSingleQuotesForSQL((String)nameValuePair.getValue());
                    this.catBinValues.add(object);
                }
            }
            this.binLabelsClause = this.getCatBinCaseClause(this.xattribute, this.xBinningSettings);
        } else if (this.xBinningSettings.getBinningKind().equals((Object)BinningType.NONE)) {
            this.binLabelsClause = this.xattribute.getName();
        }
        this.gcomma = this.isGroupByEnabled ? " , " : "";
        this.nullsClause = !this.showXNulls ? " where <xattr> is not null " : "";
    }
}

