/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingWorker;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.teditor.sql.SQLEditorLrb;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.Components;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class ODMrXMLOutputPanel
extends JPanel {
    private SearchField _jFilterCtl = new SearchField();
    private Component _findPane;
    private BasicEditorPane _xmlEditor = EditorFactory.createIdeEditorPane();
    private String _xmlString = null;
    private boolean _isDirty = false;
    private int _nextOffset = -1;
    public static final Color CARET_COLOR = Color.black;
    public static final Color SELECTION_TEXT_COLOR = Color.white;
    public static final Color SELECTION_COLOR = Color.blue;
    private ComponentWithTitlebar<JComponent> ColumnComponentWithTitlebar;

    public ODMrXMLOutputPanel(String string) {
        this.initComponents();
        this._xmlString = string;
        this._xmlEditor = new BasicEditorPane();
        this._xmlEditor.setCaretColor(CARET_COLOR);
        this._xmlEditor.setSelectedTextColor(SELECTION_TEXT_COLOR);
        this._xmlEditor.setSelectionColor(SELECTION_COLOR);
        BasicDocument basicDocument = new BasicDocument();
        basicDocument.setLanguageSupport("foo.xml");
        this._xmlEditor.setDocument((Document)basicDocument);
        this._xmlEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        final FindHighlightPlugin findHighlightPlugin = new FindHighlightPlugin();
        this._xmlEditor.installPlugin((EditorPlugin)findHighlightPlugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this._xmlEditor);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setScrollMode(1);
        this.ColumnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this.ColumnComponentWithTitlebar.setControlBar(controlBar);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(SQLEditorLrb.get("SQL_VIEWER_FIND"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                if (ODMrXMLOutputPanel.this._nextOffset != -1) {
                    if (direction == SearchEvent.Direction.FORWARD) {
                        ODMrXMLOutputPanel.this._nextOffset = ODMrXMLOutputPanel.this._nextOffset + string.length();
                    }
                }
                ODMrXMLOutputPanel.this._nextOffset = findHighlightPlugin.findText(string, ODMrXMLOutputPanel.this._nextOffset == -1 ? 0 : ODMrXMLOutputPanel.this._nextOffset, direction == SearchEvent.Direction.FORWARD, false, true, false, true);
                Components.setCaretPositionCenter((JTextComponent)ODMrXMLOutputPanel.this._xmlEditor, (int)ODMrXMLOutputPanel.this._nextOffset);
                Components.moveCaretPositionCenter((JTextComponent)ODMrXMLOutputPanel.this._xmlEditor, (int)(ODMrXMLOutputPanel.this._nextOffset + string.length()));
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        LoadXMLString loadXMLString = new LoadXMLString(this._xmlString);
        loadXMLString.execute();
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 180);
        Dimension dimension3 = this.derive(dimension, 100);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    public void reset(String string) {
        this._xmlEditor.setEditable(true);
        this._xmlEditor.setText(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        this._xmlEditor.setEditable(false);
        this._xmlString = string;
        this._isDirty = true;
    }

    public void refresh() {
        if (this._isDirty) {
            LoadXMLString loadXMLString = new LoadXMLString(this._xmlString);
            loadXMLString.execute();
        } else {
            this._xmlEditor.updateUI();
        }
    }

    private void initComponents() {
        this.ColumnComponentWithTitlebar = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.ColumnComponentWithTitlebar, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.ColumnComponentWithTitlebar, -1, 300, Short.MAX_VALUE));
    }

    private class LoadXMLString
    extends SwingWorker {
        private Exception _ex = null;
        private boolean _success = false;
        private String _xmlString = null;

        public LoadXMLString(String string) {
            this._xmlString = string;
        }

        protected Object doInBackground() throws Exception {
            try {
                this._xmlString = ODMrDataTypesUtil.prettyPrintWithDOM3LS(this._xmlString);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._xmlString;
        }

        @Override
        protected void done() {
            super.done();
            try {
                ODMrXMLOutputPanel.this._xmlEditor.setEditable(true);
                ODMrXMLOutputPanel.this._xmlEditor.setText(this._xmlString);
                ODMrXMLOutputPanel.this._xmlEditor.setEditable(false);
                ODMrXMLOutputPanel.this._isDirty = false;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
            }
        }
    }
}

