/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.SystemColor;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.jdbc.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class ODMrDefaultCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOGGER = Logger.getLogger(ODMrDefaultCellRenderer.class.getName());

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        TableModel tableModel = jTable.getModel();
        ODMrResultSetTableModel oDMrResultSetTableModel = null;
        int n3 = 0;
        if (tableModel instanceof ODMrResultSetTableModel) {
            oDMrResultSetTableModel = (ODMrResultSetTableModel)tableModel;
            n3 = oDMrResultSetTableModel.getType(n2);
        }
        switch (n3) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                jLabel.setHorizontalAlignment(4);
                break;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                jLabel.setAlignmentX(0.0f);
                break;
            }
            default: {
                jLabel.setAlignmentX(0.0f);
            }
        }
        Connection connection = null;
        if (oDMrResultSetTableModel != null) {
            connection = oDMrResultSetTableModel.getConnection();
        }
        String string = null;
        try {
            if (null != connection) {
                string = ODMrDataTypesUtil.stringValue(object, connection);
            } else if (string != null) {
                string = object.toString();
            }
            this.setText(string == null ? "" : string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        if (bl) {
            jLabel.setBackground(SystemColor.textHighlight);
        } else {
            jLabel.setBackground(SystemColor.text);
        }
        return jLabel;
    }

    private static String stringValue(Object object, Connection connection) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        Object object2 = null;
        if (object instanceof Clob) {
            try {
                object2 = object;
                stringBuilder = new StringBuilder(Translate.translate("(CLOB) "));
                stringBuilder.append(((Clob)object).getSubString(1L, 10));
                if ((int)((Clob)object).length() > 10) {
                    stringBuilder.append("...");
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
        } else if (object instanceof Blob) {
            object2 = object;
            stringBuilder = new StringBuilder(Translate.translate("(BLOB)"));
        } else if (object instanceof RAW) {
            object2 = object;
            stringBuilder = new StringBuilder(Translate.translate("(RAW)"));
        } else if (object instanceof BFILE) {
            object2 = object;
            stringBuilder = new StringBuilder(Translate.translate("(BFILE)"));
        } else if (object instanceof TIMESTAMPTZ || object instanceof TIMESTAMPLTZ || object instanceof TIMESTAMP || object instanceof DATE || object instanceof NUMBER || object instanceof BigDecimal) {
            stringBuilder = new StringBuilder((String)NLSUtils.getValue(connection, object));
        } else if (object instanceof Date) {
            try {
                stringBuilder = new StringBuilder(NLSUtils.formatDate(new DATE((Date)object)));
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (object instanceof OPAQUE) {
            try {
                stringBuilder = new StringBuilder(((OPAQUE)object).getSQLTypeName().trim());
                if ("SYS.XMLTYPE".equals(stringBuilder.toString())) {
                    stringBuilder = new StringBuilder(XMLType.createXML((OPAQUE)((OPAQUE)object)).getStringVal());
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof STRUCT) {
            try {
                stringBuilder = new StringBuilder(((STRUCT)object).getSQLTypeName().trim());
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof Array) {
            try {
                Array array = (Array)object;
                stringBuilder = new StringBuilder(array.getBaseTypeName());
                stringBuilder.append("(");
                Object[] objectArray = (Object[])array.getArray();
                boolean bl = true;
                for (Object object3 : objectArray) {
                    stringBuilder.append(bl ? "" : ",");
                    stringBuilder.append(ODMrDefaultCellRenderer.stringValue(object3, connection));
                    bl = false;
                }
                stringBuilder.append(")");
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else if (object instanceof ResultSet) {
            stringBuilder = new StringBuilder(Translate.translate("(ResultSet)"));
        } else if (object instanceof List) {
            stringBuilder = new StringBuilder("{");
            List list = (List)object;
            int n = 0;
            List list2 = (List)list.get(0);
            for (Object e : list) {
                if (n > 0) {
                    stringBuilder.append("<");
                    int n2 = 0;
                    for (Object e2 : (List)e) {
                        stringBuilder.append(list2.get(n2));
                        stringBuilder.append("=");
                        stringBuilder.append(ODMrDefaultCellRenderer.stringValue(e2, connection));
                        stringBuilder.append(",");
                        ++n2;
                    }
                    stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                    stringBuilder.append(">,");
                }
                ++n;
            }
            stringBuilder.append("}");
        } else if (object instanceof Datum && !(object instanceof INTERVALDS)) {
            try {
                stringBuilder = new StringBuilder(((Datum)object).stringValue());
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        } else {
            stringBuilder = new StringBuilder(object.toString());
        }
        return stringBuilder.toString();
    }

    private static class Translate {
        private Translate() {
        }

        private static String translate(String string) {
            return string;
        }
    }

    private static class NLSUtils {
        private static final DateFormat SDF = SimpleDateFormat.getDateTimeInstance(1, 1, Locale.getDefault());

        private NLSUtils() {
        }

        public static Object getValue(Connection connection, Object object) {
            if (object == null) {
                return object;
            }
            String string = "";
            try {
                string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMP && connection != null ? NLSUtils.formatTIMESTAMP((TIMESTAMP)object) : (object instanceof TIMESTAMPTZ && connection != null ? NLSUtils.formatTIMESTAMPTZ((TIMESTAMPTZ)object) : (object instanceof TIMESTAMPLTZ && connection != null ? NLSUtils.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object) : (object instanceof DATE && connection != null ? NLSUtils.formatDate((DATE)object) : (object instanceof Date && connection != null ? NLSUtils.formatDate(new DATE((Date)object)) : (object instanceof NUMBER && connection != null ? NLSUtils.formatNUMBER(connection, (NUMBER)object) : (object instanceof BigDecimal && connection != null ? NLSUtils.formatBigDecimal(connection, (BigDecimal)object) : (object instanceof INTERVALDS && connection != null ? object.toString() : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))))))))));
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return string;
        }

        public static String formatBigDecimal(Connection connection, BigDecimal bigDecimal) {
            String string = null;
            string = bigDecimal.toPlainString();
            if (string.indexOf(46) != -1 && connection instanceof OracleConnection) {
                char c = '.';
                string = bigDecimal.toPlainString();
                if (c != '.') {
                    string = string.replace('.', c);
                }
            }
            return string;
        }

        public static String formatNUMBER(Connection connection, NUMBER nUMBER) {
            String string = null;
            string = nUMBER.stringValue();
            if (string.indexOf(46) != -1) {
                char c = '.';
                try {
                    BigDecimal bigDecimal = nUMBER.bigDecimalValue();
                    string = bigDecimal.toPlainString();
                    if (c != '.') {
                        string = string.replace('.', c);
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            return string;
        }

        public static String formatDate(DATE dATE) {
            return SDF.format(dATE.dateValue());
        }

        private static String formatTIMESTAMP(TIMESTAMP tIMESTAMP) {
            String string = "";
            try {
                string = SDF.format(tIMESTAMP.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
            String string = "";
            try {
                string = SDF.format(tIMESTAMPTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
            String string = "";
            try {
                string = SDF.format(tIMESTAMPLTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }
    }
}

