/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmItemset;
import oracle.dmt.dataminer.server.model.Item;
import oracle.dmt.dataminer.server.model.RuleContentOption;

public class ItemSet {
    private Integer itemsets_id;
    private Vector<Item> items;
    private Double support;
    private Integer number_of_items;
    private static final String COMMA = ", ";
    private static final String BROWSER_NEXT_LINE = "<BR>";

    public ItemSet() {
        this.itemsets_id = 0;
        this.items = new Vector();
        this.support = 0.0;
        this.number_of_items = 0;
    }

    public ItemSet(Integer n, Vector<Item> vector, Double d, Integer n2) {
        this.itemsets_id = n;
        this.items = vector;
        this.support = d;
        this.number_of_items = n2;
    }

    public ItemSet(Integer n, Item item, Double d, Integer n2) {
        this.itemsets_id = n;
        this.items = new Vector();
        this.items.add(item);
        this.support = d;
        this.number_of_items = n2;
    }

    public ItemSet(DmItemset dmItemset) throws Exception {
        this.itemsets_id = dmItemset.getItemsetId();
        this.items = Item.createItemsFromDmItems(dmItemset.getItems());
        this.support = dmItemset.getSupport().doubleValue();
        this.number_of_items = dmItemset.getNumberOfItems().intValue();
    }

    public Integer getItemsets_id() {
        return this.itemsets_id;
    }

    public Vector<Item> getItems() {
        return this.items;
    }

    public Double getSupport() {
        return this.support;
    }

    public Integer getNumber_of_items() {
        return this.number_of_items;
    }

    public String getItemSetString() {
        return this.getItemSetString(RuleContentOption.NAME_SUBNAME_VALUE, false);
    }

    public String getItemSetString(RuleContentOption ruleContentOption, Boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Item> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            stringBuffer.append(item.getItemDetail(ruleContentOption));
            if (!iterator.hasNext()) continue;
            if (bl.booleanValue()) {
                stringBuffer.append(", <BR>");
                continue;
            }
            stringBuffer.append(COMMA);
        }
        return stringBuffer.toString();
    }

    public String getItemSetStringOld() {
        String string = " = ";
        String string2 = COMMA;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Item> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            stringBuffer.append(item.getFullAttributeName() + string + item.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

