/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmItem;
import oracle.dmt.dataminer.generated.server.DmItems;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.utils.NumericFormat;

public class Item {
    private String _attribute_name;
    private String _attribute_subname;
    private Double _attribute_num_value;
    private String _attribute_str_value;

    public Item() {
        this._attribute_name = "";
        this._attribute_subname = "";
        this._attribute_num_value = 0.0;
        this._attribute_str_value = "";
    }

    public Item(String string, String string2, Double d, String string3) {
        this._attribute_name = string;
        this._attribute_subname = string2;
        this._attribute_num_value = d;
        this._attribute_str_value = string3;
    }

    public Item(DmItem dmItem) throws SQLException {
        this._attribute_name = dmItem.getAttributeName();
        this._attribute_subname = dmItem.getAttributeSubname() != null ? dmItem.getAttributeSubname() : null;
        this._attribute_num_value = dmItem.getAttributeNumValue() != null ? Double.valueOf(dmItem.getAttributeNumValue().doubleValue()) : null;
        this._attribute_str_value = dmItem.getAttributeStrValue() != null ? dmItem.getAttributeStrValue() : null;
    }

    public static Vector<Item> createItemsFromDmItems(DmItems dmItems) throws Exception {
        Vector<Item> vector = new Vector<Item>();
        for (int i = 0; i < dmItems.length(); ++i) {
            DmItem dmItem = dmItems.getElement(i);
            Item item = new Item(dmItem);
            vector.add(item);
        }
        return vector;
    }

    public void setAttribute_name(String string) {
        this._attribute_name = string;
    }

    public String getAttribute_name() {
        return this._attribute_name;
    }

    public void setAttribute_subname(String string) {
        this._attribute_subname = string;
    }

    public String getAttribute_subname() {
        return this._attribute_subname;
    }

    public void setAttribute_num_value(Double d) {
        this._attribute_num_value = d;
    }

    public Double getAttribute_num_value() {
        return this._attribute_num_value;
    }

    public void setAttribute_str_value(String string) {
        this._attribute_str_value = string;
    }

    public String getAttribute_str_value() {
        return this._attribute_str_value;
    }

    public String getFullAttributeName() {
        if (this._attribute_subname != null && this._attribute_subname.trim().length() != 0) {
            return this._attribute_name + "." + this._attribute_subname;
        }
        return this._attribute_name;
    }

    public String getFullAttributeName(NameContent nameContent) {
        String string = "";
        switch (nameContent) {
            case NC_NAME_ONLY: {
                string = this._attribute_name;
                break;
            }
            case NC_NAME_SUBNAME_ONLY: {
                string = this._attribute_name;
                if (this._attribute_subname == null || this._attribute_subname.trim().length() == 0) break;
                string = this._attribute_name + "." + this._attribute_subname;
                break;
            }
            case NC_SUBNAME_ONLY: {
                if (this._attribute_subname == null) break;
                string = this._attribute_subname;
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public String getValue() {
        if (this._attribute_num_value != null) {
            return NumericFormat.format(this._attribute_num_value, true, 8) + "";
        }
        return this._attribute_str_value;
    }

    public String getItemDetail(RuleContentOption ruleContentOption) {
        String string = "";
        switch (ruleContentOption) {
            case NAME_SUBNAME_VALUE: {
                string = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY) + " = " + this.getValue();
                break;
            }
            case NAME_SUBNAME: {
                string = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY);
                break;
            }
            case SUBNAME: {
                string = this.getFullAttributeName(NameContent.NC_SUBNAME_ONLY);
                break;
            }
            case SUBNAME_VALUE: {
                string = this.getFullAttributeName(NameContent.NC_SUBNAME_ONLY) + " = " + this.getValue();
                break;
            }
        }
        return string;
    }

    public static enum NameContent {
        NC_NAME_ONLY,
        NC_NAME_SUBNAME_ONLY,
        NC_SUBNAME_ONLY;

    }
}

