/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.RowColumnValue;
import oracle.dmt.dataminer.repository.AttributeUsage;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;

public class Model
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(oracle.dmt.dataminer.server.model.Model.class.getName());
    private String _function;
    private String _algorithm;
    private Timestamp _creationTime;
    private Timestamp _modelCreationTime;
    private Timestamp _lastUpdateTime;
    private Timestamp _lastRunTime;
    private Timestamp _runDuration;
    private String _state;
    private String _stateDescription;
    private boolean _archiveEnabled;
    private String _target;
    private List<AttributeUsage> _dataUsage = new ArrayList<AttributeUsage>();
    private static String STR_SETTING_VALUE_QRY = "SELECT STR_SETTING_VALUE FROM ODMR_USER_ATN_SETTINGS WHERE SETTING_NAME = ? AND AT_NODE_ID = ?";
    private static String COSTS_MATRIX_QRY = "SELECT TYPE, ACTUAL_TARGET_STR_VAL, PREDICTED_TARGET_STR_VAL, ACTUAL_TARGET_NUM_VAL, PREDICTED_TARGET_NUM_VAL, COST FROM ODMR_USER_ATN_COST_MATRICES  WHERE AT_NODE_ID = ?";
    public static final String AT_NODE_TABLE = "ODMR_USER_AT_NODE";
    public static final String NODE_ID = "AT_NODE_ID";
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String ACTIVITY_ID = "AT_ID";
    public static final String TYPE = "NODE_TYPE";
    public static final String FUNCTION = "MINING_FUNCTION";
    public static final String ALGORITHM = "MINING_ALGORITHM";
    public static final String MODEL_NAME = "MODEL_NAME";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String LAST_UPDATED_TIME = "LAST_UPDATED_TIME";
    public static final String LAST_RUN_TIME = "LAST_RUN_TIME";
    public static final String LAST_RUN_DURATION = "LAST_RUN_DURATION";
    public static final String STATE = "STATE";
    public static final String STATE_DESCRIPTION = "STATE_DESCRIPTION";
    public static final String ARCHIVE_ON = "ARCHIVE_ON";
    public static final String COMMENTS = "COMMENTS";
    public static final String ODM_ALL_MINING_MODELS = "USER_MINING_MODELS";
    public static final String ODM_OWNER = "OWNER";
    public static final String ODM_MODEL_NAME = "MODEL_NAME";
    public static final String ODM_CREATION_DATE = "CREATION_DATE";
    public static final int _ROUNDING_PRECISION = 4;

    public Model(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    @Override
    public void load(ConnectionManager connectionManager) {
        if (this.isLoaded()) {
            return;
        }
        this.loadAttributeUsage(connectionManager);
        this.setLoaded(true);
    }

    @Override
    public void unload() throws Exception {
        this._dataUsage.clear();
        this.setLoaded(false);
    }

    @Override
    public void refresh(ConnectionManager connectionManager) {
    }

    public static Map<String, String> getAllModelNames(ConnectionManager connectionManager) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer("select MODEL_NAME from USER_MINING_MODELS order by MODEL_NAME");
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuffer.toString());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string = sQLHelper.rs.getString("MODEL_NAME");
                hashMap.put(string, string);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    private void loadAttributeUsage(ConnectionManager connectionManager) {
    }

    public List<AttributeUsage> getDataUsage() {
        return this._dataUsage;
    }

    public void setFunction(String string) {
        this._function = string;
    }

    public String getFunction() {
        return this._function;
    }

    public void setAlgorithm(String string) {
        this._algorithm = string;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setCreationTime(Timestamp timestamp) {
        this._creationTime = timestamp;
    }

    public Timestamp getCreationTime() {
        return this._creationTime;
    }

    public void setLastUpdateTime(Timestamp timestamp) {
        this._lastUpdateTime = timestamp;
    }

    public Timestamp getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setLastRunTime(Timestamp timestamp) {
        this._lastRunTime = timestamp;
    }

    public Timestamp getLastRunTime() {
        return this._lastRunTime;
    }

    public void setRunDuration(Timestamp timestamp) {
        this._runDuration = timestamp;
    }

    public Timestamp getRunDuration() {
        return this._runDuration;
    }

    public void setState(String string) {
        this._state = string;
    }

    public String getState() {
        return this._state;
    }

    public void setStateDescription(String string) {
        this._stateDescription = string;
    }

    public String getStateDescription() {
        return this._stateDescription;
    }

    public void setArchiveEnabled(boolean bl) {
        this._archiveEnabled = bl;
    }

    public boolean isArchiveEnabled() {
        return this._archiveEnabled;
    }

    public void setModelCreationTime(Timestamp timestamp) {
        this._modelCreationTime = timestamp;
    }

    public Timestamp getModelCreationTime() {
        return this._modelCreationTime;
    }

    public void setTarget(String string) {
        this._target = string;
    }

    public String getTarget() {
        return this._target;
    }

    public static CostMatrixInfo getROCCostBenefit(Vector<RowColumnValue> vector) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TUNED");
        for (int i = 0; i < vector.size(); ++i) {
            RowColumnValue rowColumnValue = vector.elementAt(i);
            Object object = rowColumnValue._row;
            Object object2 = rowColumnValue._col;
            costMatrixInfo.put(object, object2, rowColumnValue._value);
        }
        return costMatrixInfo;
    }
}

