/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.ValueCellEditor;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.ghost.GhostPointingPalette;

public class ValueSelectorPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(ValueSelectorPanel.class.getName());
    private Context context;
    private String columnName;
    private String models;
    private ValueCellEditor editor;
    private DefaultListModel<String> listModel;
    private DefaultListModel<String> messageModel;
    private ButtonGroup buttonGroup;
    private JButton jCancelBtn;
    private JRadioButton jContainsRadio;
    private JButton jOkBtn;
    private JScrollPane jScrollPane1;
    private JButton jSearchBtn;
    private JRadioButton jStartsWithRadio;
    private JLabel jValueLabel;
    private JTextField jValueTxt;
    private JList<String> jValuesList;

    public ValueSelectorPanel(Context context, String string, String string2, ValueCellEditor valueCellEditor) {
        this.context = context;
        this.columnName = string;
        this.models = string2;
        this.editor = valueCellEditor;
        this.listModel = new DefaultListModel();
        this.messageModel = new DefaultListModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jValueLabel = new JLabel();
        this.jValueTxt = new JTextField();
        this.jSearchBtn = new JButton();
        this.jStartsWithRadio = new JRadioButton();
        this.jContainsRadio = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jValuesList = new JList();
        this.jOkBtn = new JButton();
        this.jCancelBtn = new JButton();
        this.jValueLabel.setText("Value:");
        this.jSearchBtn.setText("Find");
        this.buttonGroup.add(this.jStartsWithRadio);
        this.jStartsWithRadio.setSelected(true);
        this.jStartsWithRadio.setText("Starts With");
        this.buttonGroup.add(this.jContainsRadio);
        this.jContainsRadio.setText("Contains");
        this.jValuesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jValuesList);
        this.jOkBtn.setText("OK");
        this.jOkBtn.setPreferredSize(new Dimension(65, 25));
        this.jCancelBtn.setText("Cancel");
        this.jCancelBtn.setPreferredSize(new Dimension(65, 25));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jStartsWithRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jContainsRadio).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCancelBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOkBtn, -2, 65, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jValueTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSearchBtn, -2, 65, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jValueLabel).addComponent(this.jValueTxt, -2, -1, -2).addComponent(this.jSearchBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStartsWithRadio).addComponent(this.jContainsRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCancelBtn, -2, -1, -2).addComponent(this.jOkBtn, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jValueLabel, (Component)this.jValueTxt, (String)PartitionsLrb.get("VALUE_SELECTOR_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jStartsWithRadio, (String)PartitionsLrb.get("VALUE_SELECTOR_STARTS"));
        ResourceUtils.resButton((AbstractButton)this.jContainsRadio, (String)PartitionsLrb.get("VALUE_SELECTOR_CONTAINS"));
        ResourceUtils.resButton((AbstractButton)this.jSearchBtn, (String)CommonLrb.get("COMMON_FIND"));
    }

    @Override
    public void initUI() {
        this.jOkBtn.setEnabled(false);
        this.jOkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ValueSelectorPanel.this.jValuesList.getSelectedIndex();
                String string = (String)ValueSelectorPanel.this.jValuesList.getModel().getElementAt(n);
                ValueSelectorPanel.this.editor.setText(string);
                GhostPointingPalette ghostPointingPalette = (GhostPointingPalette)SwingUtilities.getAncestorOfClass(GhostPointingPalette.class, ValueSelectorPanel.this);
                ghostPointingPalette.hidePanel();
            }
        });
        this.jCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValueSelectorPanel.this.editor.cancelCellEditing();
                GhostPointingPalette ghostPointingPalette = (GhostPointingPalette)SwingUtilities.getAncestorOfClass(GhostPointingPalette.class, ValueSelectorPanel.this);
                ghostPointingPalette.hidePanel();
            }
        });
        this.jValuesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (listSelectionEvent.getFirstIndex() >= 0 && ValueSelectorPanel.this.jValuesList.getModel() == ValueSelectorPanel.this.listModel) {
                    ValueSelectorPanel.this.jOkBtn.setEnabled(true);
                }
            }
        });
        SearchActionListener searchActionListener = new SearchActionListener();
        this.jValueTxt.addActionListener(searchActionListener);
        this.jSearchBtn.addActionListener(searchActionListener);
        String string = this.editor.getCellEditorValue().toString();
        this.jValueTxt.setText(string);
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchWorker searchWorker = new SearchWorker();
            searchWorker.execute();
        }
    }

    private class SearchWorker
    extends ODMrSwingWorker<Void, Void> {
        private static final String QUERY = "SELECT column_value FROM\n  (SELECT DISTINCT(column_value)\n   FROM all_mining_model_partitions\n   WHERE model_name IN ({MODEL})\n   AND column_name = ? \n   AND UPPER(column_value) LIKE ? \n   ORDER BY column_value)\nWHERE ROWNUM <= 15";

        private SearchWorker() {
            super(ValueSelectorPanel.this);
            ValueSelectorPanel.this.messageModel.clear();
            ValueSelectorPanel.this.messageModel.addElement(CommonLrb.get("COMMON_LOADING"));
            ValueSelectorPanel.this.jValuesList.setModel(ValueSelectorPanel.this.messageModel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            String string = StringUtils.getReplacedString(QUERY, "{MODEL}", ValueSelectorPanel.this.models);
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(ValueSelectorPanel.this.context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.pstmt.setString(1, ValueSelectorPanel.this.columnName);
                sQLHelper.pstmt.setString(2, this.getSQLFilter());
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                ValueSelectorPanel.this.listModel.clear();
                while (sQLHelper.rs.next()) {
                    ValueSelectorPanel.this.listModel.addElement(sQLHelper.rs.getString(1));
                }
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            if (ValueSelectorPanel.this.listModel.isEmpty()) {
                ValueSelectorPanel.this.messageModel.clear();
                ValueSelectorPanel.this.messageModel.addElement(PartitionsLrb.get("VALUE_SELECTOR_NO_MATCH"));
                ValueSelectorPanel.this.jValuesList.setModel(ValueSelectorPanel.this.messageModel);
            } else {
                ValueSelectorPanel.this.jValuesList.setModel(ValueSelectorPanel.this.listModel);
            }
        }

        @Override
        protected void onFailure(Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            ValueSelectorPanel.this.messageModel.clear();
            ValueSelectorPanel.this.messageModel.addElement(PartitionsLrb.get("VALUE_SELECTOR_NO_MATCH"));
            ValueSelectorPanel.this.jValuesList.setModel(ValueSelectorPanel.this.messageModel);
        }

        private String getSQLFilter() {
            StringBuilder stringBuilder = new StringBuilder();
            if (ValueSelectorPanel.this.jContainsRadio.isSelected()) {
                stringBuilder.append("%");
            }
            stringBuilder.append(ValueSelectorPanel.this.jValueTxt.getText().toUpperCase());
            stringBuilder.append("%");
            return stringBuilder.toString();
        }
    }
}

