/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.Rule;
import oracle.dmt.dataminer.partition.RulesPartitionFilterSortingPanel;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;

public class ModelPartitionChooserPanel
extends DialogDisplayer<AbstractNode> {
    private PartitionsTableModel model;
    private PartitionVO selectedPartition;
    private String[] models;
    private boolean multiModel;
    private DataMinerTablePanel partitionsTablePanel;
    private RulesPartitionFilterSortingPanel rulesPartitionFilterSortingPanel1;

    public ModelPartitionChooserPanel(Context context, String[] stringArray) {
        super(context, null);
        this.models = Arrays.copyOf(stringArray, stringArray.length);
        this.multiModel = stringArray.length > 1;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.rulesPartitionFilterSortingPanel1 = new RulesPartitionFilterSortingPanel(this.getContext(), this.models);
        this.partitionsTablePanel = new DataMinerTablePanel();
        this.setPreferredSize(new Dimension(630, 400));
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.rulesPartitionFilterSortingPanel1);
        this.add(this.partitionsTablePanel);
    }

    @Override
    public void initRes() {
        this.partitionsTablePanel.getTable().setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
    }

    @Override
    public void initUI() {
        this.rulesPartitionFilterSortingPanel1.getQueryButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadModelPartitions loadModelPartitions = new LoadModelPartitions();
                loadModelPartitions.execute();
            }
        });
        this.partitionsTablePanel.getTable().setColumnSelectorAvailable(true);
        this.partitionsTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getFirstIndex() != -1) {
                    ModelPartitionChooserPanel.this.getDialogInstance().setOKButtonEnabled(true);
                }
            }
        });
        LoadModelPartitions loadModelPartitions = new LoadModelPartitions();
        loadModelPartitions.execute();
    }

    @Override
    protected String getDialogTitle() {
        return PartitionsLrb.get("FILTER_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setPreferredSize(new Dimension(800, 700));
        jEWTDialog.setOKButtonEnabled(false);
    }

    @Override
    public boolean doWork() {
        DataMinerTable dataMinerTable = this.partitionsTablePanel.getTable();
        this.selectedPartition = (PartitionVO)this.model.getSrcData().get(dataMinerTable.getSelectedRowInModel());
        return true;
    }

    public PartitionVO getSelectedPartition() {
        return this.selectedPartition;
    }

    private static class PartitionsTableModel
    extends ODMrTableModel<PartitionVO> {
        private final boolean multiModel;

        private PartitionsTableModel(String[] stringArray, List<PartitionVO> list, boolean bl) {
            super(stringArray, list);
            this.multiModel = bl;
        }

        public Object getValueAt(int n, int n2) {
            PartitionVO partitionVO = (PartitionVO)this.srcData.get(n);
            return this.multiModel ? this.getMultiModelValue(partitionVO, n2) : this.getSingleModelValue(partitionVO, n2);
        }

        private Object getMultiModelValue(PartitionVO partitionVO, int n) {
            switch (n) {
                case 0: {
                    return partitionVO.getPartitionName();
                }
            }
            return partitionVO.getColumns().get(n - 1).getValue();
        }

        private Object getSingleModelValue(PartitionVO partitionVO, int n) {
            switch (n) {
                case 0: {
                    return partitionVO.getPartitionID();
                }
                case 1: {
                    return partitionVO.getPartitionName();
                }
            }
            return partitionVO.getColumns().get(n - 2).getValue();
        }
    }

    private class LoadModelPartitions
    extends ODMrSwingWorker<Object[], Void> {
        private static final String COL_PARTITION_ID = "partition_name";
        private static final String COL_POSITION = "position";
        private static final String COL_ATTRIBUTE_NAME = "attribute_name";
        private static final String COL_DATA_TYPE = "data_type";
        private static final String COL_COLUMN_VALUE = "column_value";
        private static final String RULE_SQL = "SELECT DISTINCT partition_name\n    FROM PartitionsTable\n    WHERE model_name IN ({MODEL})\n    {FILTER}";
        private static final String QUERY_BASE = "WITH \nPartitionsTable AS \n  (SELECT mp.owner, mp.model_name, mp.partition_name, mp.position, ma.attribute_name,           ma.data_type, mp.column_value\n   FROM all_mining_model_partitions mp\n   INNER JOIN all_mining_model_attributes ma \n    ON  mp.owner       = ma.owner\n    AND mp.model_name  = ma.model_name\n    AND mp.column_name = ma.attribute_name), \nPartNameTable AS\n (SELECT * FROM\n   ({QUERY})\n WHERE ROWNUM <= ?)\nSELECT DISTINCT owner, p.partition_name, position, attribute_name, data_type, \n       NVL(column_value, '(null)') AS column_value \nFROM PartitionsTable p INNER JOIN PartNameTable t ON p.partition_name = t.partition_name  \nWHERE model_name IN ({MODEL})\nORDER BY partition_name, position";
        private static final String QUERY_COUNT = "SELECT COUNT(DISTINCT partition_name) FROM all_mining_model_partitions WHERE model_name IN ({MODEL})";
        private String modelsQuery;

        private LoadModelPartitions() {
            super(ModelPartitionChooserPanel.this, ModelPartitionChooserPanel.this.partitionsTablePanel.getTable());
            ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getQueryButton().setEnabled(false);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : ModelPartitionChooserPanel.this.models) {
                stringBuilder.append("'");
                stringBuilder.append(string);
                stringBuilder.append("',");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            this.modelsQuery = stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object[] doInBackground() throws Exception {
            Object[] objectArray = new Object[3];
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try (SQLHelper sQLHelper = new SQLHelper();){
                Object object;
                sQLHelper.conn = ConnectionFolder.getConnection(ModelPartitionChooserPanel.this.getContext());
                String string = StringUtils.getReplacedString(QUERY_COUNT, "{MODEL}", this.modelsQuery);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                ResultSet resultSet = sQLHelper.pstmt.executeQuery();
                if (resultSet.next()) {
                    objectArray[0] = object = Integer.valueOf(resultSet.getInt(1));
                }
                sQLHelper.close();
                object = this.getSQLFilter();
                sQLHelper.conn = ConnectionFolder.getConnection(ModelPartitionChooserPanel.this.getContext());
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                int n = 1;
                block9: for (Rule rule : ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getFilterRules()) {
                    sQLHelper.pstmt.setString(n++, rule.getPartitionKey().getColumnName());
                    String string2 = rule.getValue().toUpperCase(Locale.getDefault());
                    switch (rule.getOperator()) {
                        case GREATER_THAN: 
                        case LESS_THAN: {
                            sQLHelper.pstmt.setDouble(n++, Double.valueOf(rule.getValue()));
                            continue block9;
                        }
                        case CONTAINS: 
                        case NOT_CONTAINS: {
                            sQLHelper.pstmt.setString(n++, "%" + string2 + "%");
                            continue block9;
                        }
                        case STARTS: 
                        case NOT_START: {
                            sQLHelper.pstmt.setString(n++, string2 + "%");
                            continue block9;
                        }
                        case ENDS: 
                        case NOT_END: {
                            sQLHelper.pstmt.setString(n++, "%" + string2);
                            continue block9;
                        }
                    }
                    sQLHelper.pstmt.setString(n++, string2);
                }
                sQLHelper.pstmt.setInt(n, ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getFetchSize());
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                ArrayList arrayList2 = new ArrayList();
                if (!ModelPartitionChooserPanel.this.multiModel) {
                    arrayList2.add(PartitionsLrb.get("PARTITIONS_TABLE_COL_ID"));
                }
                arrayList2.add(PartitionsLrb.get("PARTITIONS_TABLE_COL_NAME"));
                boolean bl = true;
                boolean bl2 = true;
                String string3 = null;
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<PartitionColumn> arrayList3 = new ArrayList<PartitionColumn>();
                while (sQLHelper.rs.next()) {
                    Object object2;
                    int n2 = sQLHelper.rs.getInt(COL_POSITION);
                    if (n2 == 1 && !bl2) {
                        if (bl) {
                            for (PartitionColumn partitionColumn : arrayList3) {
                                arrayList2.add(partitionColumn.getColumnName());
                            }
                            bl = false;
                        }
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                        object2 = new PartitionVO(string3, stringBuilder.toString(), arrayList3);
                        arrayList.add(object2);
                        stringBuilder = new StringBuilder();
                        arrayList3 = new ArrayList();
                    }
                    string3 = sQLHelper.rs.getString(COL_PARTITION_ID);
                    object2 = sQLHelper.rs.getString(COL_ATTRIBUTE_NAME);
                    String object32 = sQLHelper.rs.getString(COL_DATA_TYPE);
                    String string2 = sQLHelper.rs.getString(COL_COLUMN_VALUE);
                    PartitionColumn partitionColumn = new PartitionColumn((String)object2, object32, string2);
                    arrayList3.add(partitionColumn);
                    stringBuilder.append(string2);
                    stringBuilder.append("_");
                    bl2 = false;
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                PartitionVO partitionVO = new PartitionVO(string3, stringBuilder.toString(), arrayList3);
                arrayList.add(partitionVO);
                objectArray[1] = arrayList2;
                objectArray[2] = arrayList;
            }
            return objectArray;
        }

        @Override
        protected void onSuccess(Object[] objectArray) throws Exception {
            Integer n = (Integer)objectArray[0];
            List list = (List)objectArray[1];
            List list2 = (List)objectArray[2];
            String string = MessageFormat.format(PartitionsLrb.get("PARTITIONS_TABLE_TITLE"), list2.size(), n);
            if (ModelPartitionChooserPanel.this.model == null) {
                ModelPartitionChooserPanel.this.partitionsTablePanel.getTable().setFixedColumns(ModelPartitionChooserPanel.this.multiModel ? 1 : 2, 150, 150);
                ModelPartitionChooserPanel.this.model = new PartitionsTableModel(list.toArray(new String[list.size()]), list2, ModelPartitionChooserPanel.this.multiModel);
                ModelPartitionChooserPanel.this.partitionsTablePanel.setup((TableModel)((Object)ModelPartitionChooserPanel.this.model), string, 0, true);
            } else {
                ModelPartitionChooserPanel.this.partitionsTablePanel.setTitle(string);
                if (list2.size() > 0) {
                    ModelPartitionChooserPanel.this.model.setSrcData(list2);
                } else {
                    this.setTableMessage(TableMessages.NO_RESULTS);
                }
            }
        }

        @Override
        protected void onFinally() {
            ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getQueryButton().setEnabled(true);
        }

        private String getSQLFilter() {
            String string;
            List<Rule> list = ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getFilterRules();
            if (list.isEmpty()) {
                string = StringUtils.getReplacedString(RULE_SQL, "{FILTER}", "ORDER BY partition_name");
            } else {
                boolean bl = ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.matchAll();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    Rule rule = list.get(i);
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("AND attribute_name = ? ");
                    if (rule.getOperator().isStringOperator()) {
                        stringBuilder2.append("AND UPPER(column_value) ");
                    } else {
                        stringBuilder2.append("AND TO_NUMBER(column_value) ");
                    }
                    Rule.addOperatorSQL(stringBuilder2, rule.getOperator());
                    if (i < list.size() - 1) {
                        if (bl) {
                            stringBuilder2.append("\n     INTERSECT\n    ");
                        } else {
                            stringBuilder2.append("\n     UNION\n    ");
                        }
                    }
                    if (i == list.size() - 1) {
                        stringBuilder2.append("\n   ORDER BY partition_name");
                    }
                    stringBuilder.append(StringUtils.getReplacedString(RULE_SQL, "{FILTER}", stringBuilder2.toString()));
                }
                string = stringBuilder.toString();
            }
            String string2 = StringUtils.getReplacedString(QUERY_BASE, "{QUERY}", string);
            string2 = StringUtils.getReplacedString(string2, "{MODEL}", this.modelsQuery);
            return string2;
        }
    }
}

