/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.Vector;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class SettingsViewerTextAttrsTableModel
extends GenericBaseTableModel {
    private Vector<MiningAttributeInfo> _data = new Vector();
    private static final int COLUMN_COUNT = 3;
    public static final int ATTRIBUTE_NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int MINING_TYPE = 2;
    private String[] _columnNames = new String[]{SettingsLrb.get("ATTRIBUTE_NAME_SHORT"), SettingsLrb.get("DATA_TYPE"), SettingsLrb.get("MINING_TYPE")};

    public SettingsViewerTextAttrsTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(3);
    }

    public SettingsViewerTextAttrsTableModel(Vector<MiningAttributeInfo> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(3);
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        MiningAttributeInfo miningAttributeInfo = this._data.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = miningAttributeInfo.getAttributeName();
                break;
            }
            case 1: {
                string = miningAttributeInfo.getDataType();
                break;
            }
            case 2: {
                string = ServerConstants.MiningType.toHuman(miningAttributeInfo.getAttributeType());
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }

    public void addRow(MiningAttributeInfo miningAttributeInfo) {
        this._data.add(miningAttributeInfo);
    }

    public Vector<MiningAttributeInfo> getDataVector() {
        return this._data;
    }
}

