/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.filter.FilterEvent;
import oracle.dmt.dataminer.filter.FilterListener;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.mviewer.coefficients.RegrCoefficientFilterPanel;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class RegrCoefViewer
extends JPanel
implements GeneralCoeffViewer {
    CoefViewerState _state;
    Context _context;
    CoefViewerMainPanel _mainPanel;
    public static final String COEFFICIENT_VIEWER_ID = "COEFFICIENT_VIEWER_ID";
    private static final int GLM_FROZEN_COLUMNS = 2;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private static String _LOADING_SVM = CoefficientsLrb.get("COEFFICIENT_LOADING");
    private static String _LOADING_GLM = CoefficientsLrb.get("STATISTICS_LOADING");
    private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private NumberFormat _labelPercentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private HistogramBarRenderer _barRenderer;
    private boolean _loadedFilterSetting = false;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public RegrCoefViewer(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        this._mainPanel = coefViewerMainPanel;
        this._context = context;
        this._state = coefViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 504, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, -1, Short.MAX_VALUE));
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = "";
        if (this._state.isSVM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        } else if (this._state.isGLM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        }
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this._state.isSVM() || this._state.isGLM()) {
            n3 = 0;
        }
        Integer n4 = n2 + n3;
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    @Override
    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(coefficientFilterSetting);
        this.prepareReload();
    }

    public void setFilterState(FilterEvent filterEvent) {
    }

    public CoefficientFilterSetting getFilterState() {
        return this._state.getFilterSetting();
    }

    @Override
    public CoefficientFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    @Override
    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this._state.setCachedFilterSetting(coefficientFilterSetting);
    }

    @Override
    public void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
    }

    void prepareForNewQuery() {
        this._state.clearRows();
        if (this._state.isSVM()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(_LOADING_SVM);
            this._state.addRow(coefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        } else if (this._state.isGLM()) {
            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(_LOADING_GLM);
            this._state.addRow(gLMCoefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        }
        this.enableControls(false);
    }

    private void initializeControls() {
        this.setupLoadingTable();
        this.enableControls(false);
    }

    private void setupSVMTable(CoefViewerTableModel coefViewerTableModel) {
        this.dataMinerTablePanel.setup((TableModel)((Object)coefViewerTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelNumericalFormat);
        this.dataMinerTablePanel.getTable().getColumnModel().getColumn(2).setCellRenderer(this._barRenderer);
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RegrCoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupGLMTable(GLMCoefViewerTableModel gLMCoefViewerTableModel) {
        this.dataMinerTablePanel.getTable().setFixedColumns(2, 175, 175);
        gLMCoefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.setup((TableModel)((Object)gLMCoefViewerTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        tableColumnModel.getColumn(2).setPreferredWidth(130);
        tableColumnModel.getColumn(3).setPreferredWidth(150);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelNumericalFormat);
        tableColumnModel.getColumn(2).setCellRenderer(this._barRenderer);
        if (this._state.isCovarianceIndicator()) {
            tableColumnModel.getColumn(7).setPreferredWidth(130);
            tableColumnModel.getColumn(6).setPreferredWidth(100);
            tableColumnModel.getColumn(4).setPreferredWidth(130);
            tableColumnModel.getColumn(5).setPreferredWidth(100);
            tableColumnModel.getColumn(8).setPreferredWidth(130);
            tableColumnModel.getColumn(7).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(6).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(4).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(5).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(8).setCellRenderer(new NumberCellRenderer());
        }
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RegrCoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private void setupLoadingTable() {
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)new LoadingTableModel()));
    }

    class LoadingTableModel
    extends GenericBaseTableModel {
        public final int NAME = 0;
        public final int COLUMN_COUNT = 1;
        private String[] columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME")};

        LoadingTableModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(1);
            this.setColumnCount(this.columnNames.length);
        }

        public Object getValueAt(int n, int n2) {
            if (RegrCoefViewer.this._state.isSVM()) {
                return _LOADING_SVM;
            }
            if (RegrCoefViewer.this._state.isGLM()) {
                return _LOADING_GLM;
            }
            return "unknown details";
        }
    }

    class CoefficientFilterListener
    implements FilterListener {
        CoefficientFilterListener() {
        }

        @Override
        public void applyEvent(FilterEvent filterEvent) {
            RegrCoefViewer.this.setFilterState(filterEvent);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                RegrCoefficientFilterPanel regrCoefficientFilterPanel = (RegrCoefficientFilterPanel)RegrCoefViewer.this._mainPanel.getViewerFilterPanel();
                if (this._reload) {
                    if (RegrCoefViewer.this._mainPanel.isModelParitioned()) {
                        RegrCoefViewer.this._state.reloadCoefficients(regrCoefficientFilterPanel.getSelectedParitionId());
                    } else {
                        RegrCoefViewer.this._state.reloadCoefficients("");
                    }
                } else if (RegrCoefViewer.this._mainPanel.isModelParitioned()) {
                    RegrCoefViewer.this._state.load(regrCoefficientFilterPanel.getPartitionVO());
                } else {
                    RegrCoefViewer.this._state.load(new PartitionVO("", ""));
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return RegrCoefViewer.this._state;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if (RegrCoefViewer.this._state.isSVM()) {
                        RegrCoefViewer.this.setupSVMTable((CoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                    } else if (RegrCoefViewer.this._state.isGLM()) {
                        RegrCoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                    }
                    RegrCoefViewer.this.dataMinerTablePanel.trySearch();
                    RegrCoefViewer.this.loadRowsOutOfTotalLabel(RegrCoefViewer.this._state.getTableModel().getRowCount(), RegrCoefViewer.this._state.getTotalDetailCount());
                    RegrCoefViewer.this.enableControls(true);
                    RegrCoefViewer.this._labelNumericalFormat.setMaximumFractionDigits(RegrCoefViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    RegrCoefViewer.this._labelPercentageFormat.setMaximumFractionDigits(RegrCoefViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    if (RegrCoefViewer.this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                        RegrCoefViewer.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{0});
                    }
                    RegrCoefViewer.this.setLoaded(true);
                } else if (RegrCoefViewer.this._state.getTableModel() != null) {
                    RegrCoefViewer.this._state.clearRows();
                    if (RegrCoefViewer.this._state.isSVM()) {
                        CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("COEFFICIENT_FAILURE"));
                        RegrCoefViewer.this._state.addRow(coefficientRowData);
                        RegrCoefViewer.this.setupSVMTable((CoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                    } else if (RegrCoefViewer.this._state.isGLM()) {
                        GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(CoefficientsLrb.get("STATISTICS_FAILURE"));
                        RegrCoefViewer.this._state.addRow(gLMCoefficientRowData);
                        RegrCoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                    } else if (RegrCoefViewer.this._state.isNB()) {
                        CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("PROBABILITIES_FAILURE"));
                        RegrCoefViewer.this._state.addRow(coefficientRowData);
                    }
                }
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(RegrCoefViewer.this._mainPanel.getEditor().getContext(), this._ex, CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"));
                }
                RegrCoefViewer.this.setLoading(false);
                if (RegrCoefViewer.this.overLayPanel != null) {
                    RegrCoefViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

