/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterCompareTableModel
extends GenericBaseTableModel {
    private static final Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    public static final String[] COL_NAMES = new String[]{CompareClustersLrb.get("DETAIL_TABLE_COLUMN_NAME"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_RANK"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_DIVERGENCE"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_DISTRIBUTION"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_CENTROID"), CompareClustersLrb.get("DETAIL_TABLE_COLUMN_CENTROID")};
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_RANK = 1;
    public static final int _COLUMN_DIVERGENCE = 2;
    public static final int _COLUMN_DISTRIBUTION = 3;
    public static final int _COLUMN_CENTROID1 = 4;
    public static final int _COLUMN_CENTROID2 = 5;
    private String cluster1;
    private String cluster2;
    private Vector<CompareClustersModelRow> _data = new Vector();
    private Hashtable<String, CompareClustersModelRow> _attributeNameToRowMap = new Hashtable();

    public ClusterCompareTableModel(Vector<CompareClustersModelRow> vector, String string, String string2) {
        this.cluster1 = string;
        this.cluster2 = string2;
        Object[] objectArray = Arrays.copyOf(COL_NAMES, COL_NAMES.length);
        objectArray[4] = this.cluster1 != null ? objectArray[4] + "(" + this.cluster1 + ")" : "";
        objectArray[5] = this.cluster2 != null ? (String)objectArray[5] + "(" + this.cluster2 + ")" : "";
        this.setColumnIdentifiers(objectArray);
        this.setDataVector(vector);
        this.setColumnCount(objectArray.length);
    }

    public ClusterCompareTableModel(List<CompareClustersModelRow> list, String string, String string2) {
        if (list.size() <= 0) {
            return;
        }
        this.cluster1 = string;
        this.cluster2 = string2;
        Object[] objectArray = Arrays.copyOf(COL_NAMES, COL_NAMES.length);
        objectArray[4] = this.cluster1 != null ? objectArray[4] + "(" + string + ")" : "";
        objectArray[5] = this.cluster2 != null ? (String)objectArray[5] + "(" + string2 + ")" : "";
        this.setColumnIdentifiers(objectArray);
        this.setDataList(list);
        this.setColumnCount(objectArray.length);
    }

    public ClusterCompareTableModel() {
        this.setColumnIdentifiers(COL_NAMES);
        CompareClustersModelRow compareClustersModelRow = new CompareClustersModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
        this.addDataItem(compareClustersModelRow);
        this.setRowCount(this.getDataSize());
        this.setColumnCount(COL_NAMES.length);
    }

    private void addDataItem(CompareClustersModelRow compareClustersModelRow) {
        this._data.add(compareClustersModelRow);
    }

    public void clear() {
        for (CompareClustersModelRow compareClustersModelRow : this._data) {
            compareClustersModelRow.setGraphDataModel(null);
            compareClustersModelRow.setFirstClusterHistogram(null);
            compareClustersModelRow.setSecondClusterHistogram(null);
        }
        this._data.clear();
        this._attributeNameToRowMap.clear();
    }

    private int getDataSize() {
        return this._data.size();
    }

    public CompareClustersModelRow getClusterDetailRow(String string) {
        return this._attributeNameToRowMap.get(string);
    }

    public void setDataVector(Vector<CompareClustersModelRow> vector) {
        this._data = vector;
        this.setRowCount(this._data.size());
        this._attributeNameToRowMap.clear();
        for (CompareClustersModelRow compareClustersModelRow : vector) {
            this._attributeNameToRowMap.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
        }
    }

    public void setDataList(List<CompareClustersModelRow> list) {
        this._data.addAll(list);
        this.setRowCount(this._data.size());
        this._attributeNameToRowMap.clear();
        for (CompareClustersModelRow compareClustersModelRow : list) {
            this._attributeNameToRowMap.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CompareClustersModelRow compareClustersModelRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = compareClustersModelRow.getFullAttributeName();
                break;
            }
            case 1: {
                object = compareClustersModelRow.getRank();
                break;
            }
            case 2: {
                object = compareClustersModelRow.getDivergence();
                break;
            }
            case 4: {
                object = this.getCentroid(compareClustersModelRow.getCentroid1());
                break;
            }
            case 5: {
                object = this.getCentroid(compareClustersModelRow.getCentroid2());
                break;
            }
            case 3: {
                object = compareClustersModelRow.getGraphDataModel();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    private String getCentroid(String string) {
        String string2 = string;
        try {
            NumberFormat numberFormat = NumberFormat.getInstance();
            Number number = numberFormat.parse(string);
            string2 = NumericFormat.format(number.doubleValue(), true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "";
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public Vector<CompareClustersModelRow> getDataVector() {
        return this._data;
    }
}

