/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.SQLException;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.clustering.ClusterFilterPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewer;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.mviewer.clustering.StateChangeListener;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractDiagramModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.BlockingComponent;

public class SingleClusterMainPanel
extends DataMinerViewGUI
implements StateChangeListener {
    SingleClusterViewer _clusterViewerPanel;
    ClusterFilterPanel _singleClusterViewerFilterPanel;
    SingleClusterViewerState _state;
    private BlockingComponent overLayPanel = null;
    private boolean modelPartitioned = false;
    private PartitionVO pvo = new PartitionVO("", "");

    public PartitionVO getPartitionVO() {
        return this.pvo;
    }

    public boolean isModelParitioned() {
        return this.modelPartitioned;
    }

    public ClusterFilterPanel getSingleClusterViewerFilterPanel() {
        return this._singleClusterViewerFilterPanel;
    }

    public SingleClusterMainPanel(Editor editor, Context context) throws SQLException {
        super(editor, context);
        Node node = context.getNode();
        ModelNode modelNode = (ModelNode)node;
        if (!modelNode.isModelExists().booleanValue()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this._state = new SingleClusterViewerState(this._context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        Node node = this.getContext().getNode();
        AbstractDiagramModelNode abstractDiagramModelNode = (AbstractDiagramModelNode)node;
        String string = abstractDiagramModelNode.getOdmModel().getUserName();
        String string2 = abstractDiagramModelNode.getOdmModel().getModelName();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        this.modelPartitioned = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string, string2, this.pvo);
        this._singleClusterViewerFilterPanel = new ClusterFilterPanel(this, this.getContext(), this._state);
        this._clusterViewerPanel = new SingleClusterViewer(this.getEditor(), this, this.getContext(), this._state);
        this.add((Component)this._singleClusterViewerFilterPanel, "North");
        this.add((Component)this._clusterViewerPanel, "Center");
        this._state.addStateChangeListener(this);
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
        if (this._clusterViewerPanel != null) {
            this._clusterViewerPanel.setBlockingComponent(blockingComponent);
        }
    }

    @Override
    public void stateChanged() {
        this._singleClusterViewerFilterPanel.executeAppy();
    }

    protected void updateLoaded(boolean bl) {
        this.setLoaded(bl);
    }

    protected void updateLoading(boolean bl) {
        this._singleClusterViewerFilterPanel.setLoading(bl);
        this.setLoading(bl);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
    }

    public void setFilterState(ClusteringFilterSetting clusteringFilterSetting, boolean bl) {
        this._clusterViewerPanel.setFilterState(clusteringFilterSetting, bl);
    }

    public void setFilterPanelInitialState(ClusteringFilterSetting clusteringFilterSetting) {
        this._singleClusterViewerFilterPanel.setupUI(clusteringFilterSetting);
    }

    public HelpInfo getHelpInfo() {
        return this._clusterViewerPanel.getHelpInfo();
    }

    public void reload() {
        this._clusterViewerPanel.prepareReload(true);
    }

    void prepareReload(boolean bl) {
        this._clusterViewerPanel.prepareReload(bl);
    }

    void updateClusterIDs() {
        this._singleClusterViewerFilterPanel.setupClusterCombo();
    }
}

