/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesDetailViewer;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesFilterPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewer;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.ARRulesFilterSetting;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.BlockingComponent;

public class ARRulesMainPanel
extends DataMinerViewGUI {
    ARRulesViewer _rulesViewerPanel;
    ARRulesDetailViewer _rulesDetailViewerPanel;
    ARRulesFilterPanel _rulesViewerFilterPanel;
    private BlockingComponent overLayPanel = null;
    private boolean modelPartitioned = false;
    private PartitionVO pvo = new PartitionVO("", "");

    public PartitionVO getPartitionVO() {
        return this.pvo;
    }

    public boolean isModelParitioned() {
        return this.modelPartitioned;
    }

    public ARRulesFilterPanel getCoefCompareFilterPanel() {
        return this._rulesViewerFilterPanel;
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
        this._rulesViewerPanel.setBlockingComponent(blockingComponent);
        this._rulesViewerFilterPanel.setBlockingComponent(blockingComponent);
    }

    public ARRulesMainPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        Node node = context.getNode();
        ModelNode modelNode = (ModelNode)node;
        if (!modelNode.isModelExists().booleanValue()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        AbstractModelNode abstractModelNode = (AbstractModelNode)node;
        String string = abstractModelNode.getOdmModel().getUserName();
        String string2 = abstractModelNode.getOdmModel().getModelName();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        this.modelPartitioned = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string, string2, this.pvo);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initComponents() throws Exception {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.setLayout(borderLayout);
        this._rulesViewerFilterPanel = new ARRulesFilterPanel(this, this.getContext());
        this._rulesDetailViewerPanel = new ARRulesDetailViewer();
        this._rulesViewerPanel = new ARRulesViewer(this, this.getContext(), this._rulesDetailViewerPanel);
        JSplitPane jSplitPane = new JSplitPane(0, this._rulesViewerPanel, this._rulesDetailViewerPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.add((Component)this._rulesViewerFilterPanel, "First");
        this.add((Component)jSplitPane, "Center");
    }

    protected void updateLoaded(boolean bl) {
        this.setLoaded(bl);
    }

    protected void updateLoading(boolean bl) {
        this.setLoading(bl);
        this._rulesViewerFilterPanel.setLoading(bl);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
    }

    public void reload() {
        this._rulesViewerPanel.prepareReload();
    }

    public ARRulesViewerState getARRulesViewerState() {
        return this._rulesViewerPanel.getState();
    }

    public void setFilterState(ARRulesFilterSetting aRRulesFilterSetting) {
        this._rulesViewerPanel.setFilterState(aRRulesFilterSetting);
    }

    public void setFilterPanelInitialState(ARRulesFilterSetting aRRulesFilterSetting) {
        this._rulesViewerFilterPanel.setupUI(aRRulesFilterSetting);
    }

    public Object getCachedFilterState() {
        return this._rulesViewerPanel.getCachedFilterState();
    }

    public void setCachedFilterState(ARRulesFilterSetting aRRulesFilterSetting) {
        this._rulesViewerPanel.setCachedFilterState(aRRulesFilterSetting);
    }

    public HelpInfo getHelpInfo() {
        return this._rulesViewerPanel.getHelpInfo();
    }
}

