/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemTableModel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.ItemSetFilterSetting;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.JLabelListCellRenderer;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class ARItemFilterEditor
extends DialogDisplayer<AbstractNode> {
    private Context _context;
    private ItemSetFilterSetting _filterSetting;
    private AssociationRules _model;
    private GenericTable _table;
    private ARRulesViewerState _arViewerState;
    private ARItemTableModel.NAME_DISPLAY _nameDisplay;
    private boolean _displayValueColumn = true;
    private boolean _hideResultTypeCombo = false;
    private ARItemTableModel _filterItemTableModel;
    private boolean _filterExpanded = false;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private String _partitionId;
    private static final String RESULT_TYPE_NAME = ARRulesLrb.get("RESULT_TYPE_NAME");
    private static final String RESULT_TYPE_NAME_SUBNAME = ARRulesLrb.get("RESULT_TYPE_NAME_SUBNAME");
    private static final String RESULT_TYPE_NAME_SUBNAME_VALUE = ARRulesLrb.get("RESULT_TYPE_NAME_SUBNAME_VALUE");
    private static final String SORT_BY_ATTRIBUTE = ARRulesLrb.get("ADD_ITEMS_SORT_BY_ATTRIBUTE");
    private static final String SORT_BY_SUPPORT = ARRulesLrb.get("ADD_ITEMS_SORT_BY_SUPPORT");
    private static final String SORT_BY_VALUE = ARRulesLrb.get("ADD_ITEMS_SORT_BY_VALUE");
    private static final String ORDER_BY_DESCENDING = ARRulesLrb.get("DESCENDING");
    private static final String ORDER_BY_ASCENDING = ARRulesLrb.get("ASCENDING");
    private static final String[] SORT_ORDER_COMBO_VALUES = new String[]{ORDER_BY_DESCENDING, ORDER_BY_ASCENDING};
    private JComboBox _jAddOptionCombo;
    private JLabel _jAddOptionLbl;
    private JButton _jExpandButton;
    private JLabel _jFetchSizeLabel;
    private JSpinner _jFetchSizeValue;
    private JLabel _jItemNameFilterLbl;
    private JTextField _jItemNameFilterValue;
    private JScrollPane _jPageDescPanel;
    private JButton _jQueryItemsButton;
    private JComboBox _jResultTypeCombo;
    private JLabel _jResultTypeLbl;
    private JLabel _jSortByLabel1;
    private JComboBox _jSortCombo1;
    private JComboBox _jSortOrderCombo1;
    private DataMinerTablePanel tablePanel;

    public ARItemFilterEditor(Context context, ARItemTableModel aRItemTableModel, GenericTable genericTable, ARRulesViewerState aRRulesViewerState, String string) {
        this._partitionId = string;
        this._filterItemTableModel = aRItemTableModel;
        this._context = context;
        this._filterSetting = new ItemSetFilterSetting();
        this._model = aRRulesViewerState.getModel();
        this._table = genericTable;
        this._arViewerState = aRRulesViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jPageDescPanel = new JScrollPane();
        this._jItemNameFilterLbl = new JLabel();
        this._jItemNameFilterValue = new JTextField();
        this._jQueryItemsButton = new JButton();
        this._jResultTypeLbl = new JLabel();
        this._jResultTypeCombo = new JComboBox();
        this._jAddOptionLbl = new JLabel();
        this._jAddOptionCombo = new JComboBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSizeValue = new JSpinner();
        this._jSortByLabel1 = new JLabel();
        this._jSortCombo1 = new JComboBox();
        this._jSortOrderCombo1 = new JComboBox();
        this._jExpandButton = new JButton();
        this.tablePanel = new DataMinerTablePanel();
        this._jPageDescPanel.setBorder(null);
        this._jItemNameFilterLbl.setText("Name Filter:");
        this._jQueryItemsButton.setText("Search");
        this._jResultTypeLbl.setText("Result Type:");
        this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Name", "Name, Subname", "Name, Subname, Value"}));
        this._jAddOptionLbl.setText("Add Items As:");
        this._jAddOptionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Both", "Association", "Condition"}));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jSortByLabel1.setText("Sort by:");
        this._jExpandButton.setText("More");
        this._jExpandButton.setHorizontalAlignment(11);
        this._jExpandButton.setMaximumSize(new Dimension(63, 23));
        this._jExpandButton.setMinimumSize(new Dimension(63, 23));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPageDescPanel, -1, 731, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jQueryItemsButton)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this._jAddOptionLbl, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jAddOptionCombo, -2, 153, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSizeValue, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 510, Short.MAX_VALUE).addComponent(this._jExpandButton, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jSortByLabel1, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSortCombo1, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSortOrderCombo1, -2, 124, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jItemNameFilterLbl, -1, 93, Short.MAX_VALUE).addComponent(this._jResultTypeLbl, -1, 93, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jResultTypeCombo, -2, 138, -2).addComponent(this._jItemNameFilterValue, -2, 138, -2)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this._jFetchSizeLabel, this._jItemNameFilterLbl, this._jResultTypeLbl, this._jSortByLabel1);
        groupLayout.linkSize(0, this._jFetchSizeValue, this._jItemNameFilterValue, this._jResultTypeCombo, this._jSortCombo1);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPageDescPanel, -2, 37, -2).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSortByLabel1).addComponent(this._jSortCombo1, -2, -1, -2).addComponent(this._jSortOrderCombo1, -2, -1, -2))).addComponent(this._jQueryItemsButton)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeValue, -2, -1, -2).addComponent(this._jFetchSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jItemNameFilterValue, -2, -1, -2).addComponent(this._jItemNameFilterLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jResultTypeLbl).addComponent(this._jResultTypeCombo, -2, -1, -2))).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jExpandButton, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 253, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jAddOptionCombo, -2, -1, -2).addComponent(this._jAddOptionLbl)).addContainerGap()));
    }

    @Override
    public void initRes() {
        this._jPageDescPanel.setViewportView((Component)new JMultiLineLabel(ARRulesLrb.get("ADD_ITEM_DIALOG_DESC")));
        this._jPageDescPanel.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_DIALOG_DESC"));
        ResourceUtils.resButton((AbstractButton)this._jQueryItemsButton, (String)ARRulesLrb.get("ADD_ITEM_QUERY"));
        this._jQueryItemsButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_QUERY"));
        this._jQueryItemsButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_QUERY_ADA"));
        this._jQueryItemsButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
        this._jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
        this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
        this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
        this._jExpandButton.setHorizontalTextPosition(10);
        ResourceUtils.resLabel((JLabel)this._jItemNameFilterLbl, (Component)this._jItemNameFilterValue, (String)ARRulesLrb.get("ADD_ITEM_NAME_FILTER"));
        this._jItemNameFilterLbl.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_NAME_FILTER"));
        this._jItemNameFilterLbl.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_NAME_FILTER_ADA"));
        this._jItemNameFilterLbl.setLabelFor(this._jItemNameFilterValue);
        this._jItemNameFilterValue.setToolTipText(ARRulesLrb.get("ADD_ITEM_NAME_FILTER_ADA"));
        ResourceUtils.resLabel((JLabel)this._jResultTypeLbl, (Component)this._jResultTypeCombo, (String)ARRulesLrb.get("ADD_ITEM_RESULT_TYPE"));
        this._jResultTypeLbl.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_RESULT_TYPE"));
        this._jResultTypeLbl.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_RESULT_TYPE_ADA"));
        this._jResultTypeLbl.setLabelFor(this._jResultTypeCombo);
        this._jResultTypeCombo.setToolTipText(ARRulesLrb.get("ADD_ITEM_RESULT_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSizeValue, (String)ARRulesLrb.get("ADD_ITEM_FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_FETCH_SIZE_ADA"));
        this._jFetchSizeValue.setToolTipText(ARRulesLrb.get("ADD_ITEM_FETCH_SIZE_ADA") + "\n" + ARRulesLrb.get("ADD_ITEM_FETCH_SIZE_RANGE"));
        this._jFetchSizeValue.setModel(new SpinnerNumberModel(this._modelViewerPrefenceSettings.getFetchSizeARModel(), 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resLabel((JLabel)this._jAddOptionLbl, (Component)this._jAddOptionCombo, (String)ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE"));
        this._jAddOptionLbl.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE"));
        this._jAddOptionLbl.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE_ADA"));
        JLabel jLabel = new JLabel(ARRulesLrb.get("ADD_ITEM_INCLUDE_BOTH"), OracleIcons.getIcon((String)"update.png"), 10);
        JLabel jLabel2 = new JLabel(ARRulesLrb.get("ADD_ITEM_INCLUDE_ASSOCIATION"), OracleIcons.getIcon((String)"from_ref.png"), 10);
        JLabel jLabel3 = new JLabel(ARRulesLrb.get("ADD_ITEM_INCLUDE_CONDITION"), OracleIcons.getIcon((String)"forwardDirection.png"), 10);
        Object[] objectArray = new JLabel[]{jLabel, jLabel3, jLabel2};
        this._jAddOptionCombo.setModel(new DefaultListComboBoxModel(objectArray));
        this._jAddOptionCombo.setSelectedItem(jLabel2);
        this._jAddOptionCombo.setToolTipText(ARRulesLrb.get("ADD_ITEM_INCLUDE_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jSortByLabel1, (Component)this._jSortCombo1, (String)ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortCombo1.setToolTipText(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ORDER"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ORDER_ADA"));
        this._jSortOrderCombo1.setModel(new DefaultComboBoxModel<String>(SORT_ORDER_COMBO_VALUES));
        this._jSortOrderCombo1.setSelectedItem(ORDER_BY_ASCENDING);
        this._jSortOrderCombo1.setToolTipText(ARRulesLrb.get("ORDER_ADA"));
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    private void setLoading(boolean bl) {
        if (bl) {
            this.showTableMessage(TableMessages.LOADING);
        }
        this._jQueryItemsButton.setEnabled(!bl);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this._jQueryItemsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemFilterEditor.this._jQueryItemsButton_actionPerformed(actionEvent);
            }
        });
        this._jExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARItemFilterEditor.this._jExpandButton_actionPerformed(actionEvent);
            }
        });
        JLabelListCellRenderer jLabelListCellRenderer = new JLabelListCellRenderer();
        this._jAddOptionCombo.setRenderer(jLabelListCellRenderer);
        this.loadStateBasedOnModelContent();
        this.showExtraFilterControls(false);
        this.loadTable(this._partitionId);
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ARRulesLrb.get("ITEMS_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n);
        String string3 = "Loading...";
        if (n2 != null) {
            string3 = NumericFormat.format(n2);
        }
        String string4 = MessageFormat.format(string, string2, string3);
        this.tablePanel.setTitle(string4);
    }

    private void loadStateBasedOnModelContent() {
        this._nameDisplay = this._arViewerState.isOnlyOneColumnNameInModelItems() && !this._arViewerState.isNoSubNameColumnsInModelItems() ? ARItemTableModel.NAME_DISPLAY.SUB_NAME_ONLY : (this._arViewerState.isNoSubNameColumnsInModelItems() ? ARItemTableModel.NAME_DISPLAY.NAME_ONLY : ARItemTableModel.NAME_DISPLAY.NAME_SUBNAME);
        this._displayValueColumn = !this._arViewerState.isOnlyOneConstantValueInModelItems();
        this.setupCombos();
    }

    private void setupCombos() {
        if (this._nameDisplay == ARItemTableModel.NAME_DISPLAY.SUB_NAME_ONLY) {
            if (this._displayValueColumn) {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            } else {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            }
        } else if (this._nameDisplay == ARItemTableModel.NAME_DISPLAY.NAME_ONLY) {
            if (this._displayValueColumn) {
                String[] stringArray = new String[]{RESULT_TYPE_NAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            } else {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = true;
            }
        } else if (this._nameDisplay == ARItemTableModel.NAME_DISPLAY.NAME_SUBNAME) {
            if (this._displayValueColumn) {
                String[] stringArray = new String[]{RESULT_TYPE_NAME, RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = false;
            } else {
                String[] stringArray = new String[]{RESULT_TYPE_NAME_SUBNAME, RESULT_TYPE_NAME_SUBNAME_VALUE};
                this._jResultTypeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
                this._jResultTypeCombo.setSelectedItem(RESULT_TYPE_NAME_SUBNAME_VALUE);
                this._hideResultTypeCombo = false;
            }
        }
        String[] stringArray = this._displayValueColumn ? new String[]{SORT_BY_ATTRIBUTE, SORT_BY_SUPPORT, SORT_BY_VALUE} : new String[]{SORT_BY_ATTRIBUTE, SORT_BY_SUPPORT};
        this._jSortCombo1.setModel(new DefaultComboBoxModel<String>(stringArray));
        this._jSortCombo1.setSelectedItem(SORT_BY_ATTRIBUTE);
    }

    private void setSortState(int n, boolean bl, String string, String string2) {
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        sortSpec.setUseIt(bl);
        if (SORT_BY_ATTRIBUTE.equals(string)) {
            sortSpec.setAttributeName("FULL_NAME");
        } else if (SORT_BY_SUPPORT.equals(string)) {
            sortSpec.setAttributeName("SUPPORT");
        } else if (SORT_BY_VALUE.equals(string)) {
            sortSpec.setAttributeName("ATTRIBUTE_VALUE");
        } else {
            throw new IllegalArgumentException("Unrecognized sort value selection: " + string);
        }
        if (ORDER_BY_DESCENDING.equals(string2)) {
            sortSpec.setSortDirection(SortSpec.SortDirection.DESCENDING);
        } else if (ORDER_BY_ASCENDING.equals(string2)) {
            sortSpec.setSortDirection(SortSpec.SortDirection.ASCENDING);
        } else {
            throw new IllegalArgumentException("Unrecognized sort order selection: " + string2);
        }
    }

    private void showExtraFilterControls(boolean bl) {
        if (this._hideResultTypeCombo) {
            this._jResultTypeCombo.setVisible(false);
            this._jResultTypeLbl.setVisible(false);
        } else {
            this._jResultTypeCombo.setVisible(bl);
            this._jResultTypeLbl.setVisible(bl);
        }
        this._jItemNameFilterLbl.setVisible(bl);
        this._jItemNameFilterValue.setVisible(bl);
    }

    private void _jExpandButton_actionPerformed(ActionEvent actionEvent) {
        if (this._filterExpanded) {
            this._filterExpanded = false;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
            this._jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        } else {
            this._filterExpanded = true;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("HIDE"));
            this._jExpandButton.setIcon(DataMinerIcons.get(Icons.COLLAPSE));
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("HIDE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("HIDE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        }
    }

    private void loadTable(String string) {
        this.setLoading(true);
        QueryItems queryItems = new QueryItems(string);
        queryItems.execute();
    }

    private void setupTable(ARItemTableModel aRItemTableModel) {
        this.tablePanel.setup((TableModel)((Object)aRItemTableModel), null, 0);
        aRItemTableModel.setNameDisplay(this._nameDisplay);
        if (aRItemTableModel.isIncludeSupportColumn()) {
            this.tablePanel.getTable().getColumnModel().getColumn(2).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.PERCENTAGE));
        }
        this.loadRowsOutOfTotalLabel(this.tablePanel.getTable().getRowCount(), this._arViewerState.getTotalNumberOfSingleOccuringItems());
        if (this._displayValueColumn) {
            this.tablePanel.getTable().setHiddenColumns(new int[]{2});
        } else {
            this.tablePanel.getTable().setHiddenColumns(new int[]{1, 2});
        }
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void _jQueryItemsButton_actionPerformed(ActionEvent actionEvent) {
        this.loadRowsOutOfTotalLabel(0, this._arViewerState.getTotalNumberOfSingleOccuringItems());
        this.loadTable(this._partitionId);
    }

    private void clearTable() {
        TableModel tableModel = this.tablePanel.getTable().getModel();
        if (tableModel instanceof ARItemTableModel) {
            ((ARItemTableModel)((Object)tableModel)).clearRows();
        }
    }

    private void showTableMessage(TableMessages tableMessages) {
        String string;
        switch (tableMessages) {
            case ERROR: {
                string = ARRulesLrb.get("ADD_ITEMS_FAILURE");
                break;
            }
            case LOADING: {
                string = tableMessages.getMessage();
                break;
            }
            case NO_RESULTS: {
                string = ARRulesLrb.get("ADD_ITEMS_NO_RESULTS");
                break;
            }
            default: {
                string = "";
            }
        }
        this.clearTable();
        this.tablePanel.getTable().setNoEntryInstructionText(string);
    }

    @Override
    public boolean doWork() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            MessageDialog.error((Component)this.getParentWindow(), (Object)ARRulesLrb.get("ADD_ITEM_QUERY_VALIDATION_MESSAGE"), (String)ARRulesLrb.get("ADD_ITEM_QUERY_VALIDATION_TITLE"), null);
            return false;
        }
        String string = ((JLabel)this._jAddOptionCombo.getSelectedItem()).getText();
        int n = this.translateFilterAction(string);
        ARItemTableModel aRItemTableModel = (ARItemTableModel)((Object)this.tablePanel.getTable().getModel());
        aRItemTableModel.setFilterActionForAll(n);
        this._filterItemTableModel.addSelection(aRItemTableModel, nArray);
        if (this._table.getRowCount() > 0) {
            this._table.reSort();
            this._table.getSelectionModel().clearSelection();
            this._table.scrollToSelection();
        }
        return true;
    }

    private int translateFilterAction(String string) {
        int n = -1;
        if (ARRulesLrb.get("ADD_ITEM_INCLUDE_BOTH").equals(string)) {
            n = 0;
        } else if (ARRulesLrb.get("ADD_ITEM_INCLUDE_CONDITION").equals(string)) {
            n = 1;
        } else if (ARRulesLrb.get("ADD_ITEM_INCLUDE_ASSOCIATION").equals(string)) {
            n = 2;
        } else assert (false) : "Unknown filter action";
        return n;
    }

    @Override
    protected String getDialogTitle() {
        return ARRulesLrb.get("ADD_ITEM_FILTER_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "add_item_filters";
    }

    private class QueryItems
    extends SwingWorker<Boolean, Void> {
        private ARItemTableModel _tableModel;
        private String _partitionId;

        private QueryItems(String string) {
            this._partitionId = string;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            ARItemFilterEditor.this._filterSetting.setFetchSize(ARItemFilterEditor.this.getNumber(ARItemFilterEditor.this._jFetchSizeValue).intValue());
            ARItemFilterEditor.this._filterSetting.setNameFilter(ARItemFilterEditor.this._jItemNameFilterValue.getText());
            ARItemFilterEditor.this._filterSetting.setUseNumberOfItems(true);
            ARItemFilterEditor.this._filterSetting.setNumberOfItems(1);
            ARItemFilterEditor.this._filterSetting.setUseTopN(false);
            ARItemFilterEditor.this._filterSetting.setTopNBySupport(ARItemFilterEditor.this.getNumber(ARItemFilterEditor.this._jFetchSizeValue).intValue());
            String string = (String)ARItemFilterEditor.this._jResultTypeCombo.getSelectedItem();
            if (RESULT_TYPE_NAME.equals(string)) {
                ARItemFilterEditor.this._filterSetting.setResultType(1);
            } else if (RESULT_TYPE_NAME_SUBNAME.equals(string)) {
                ARItemFilterEditor.this._filterSetting.setResultType(2);
            } else if (RESULT_TYPE_NAME_SUBNAME_VALUE.equals(string)) {
                ARItemFilterEditor.this._filterSetting.setResultType(3);
            } else {
                throw new IllegalArgumentException("Invalid Result Type");
            }
            ARItemFilterEditor.this.setSortState(0, true, (String)ARItemFilterEditor.this._jSortCombo1.getSelectedItem(), (String)ARItemFilterEditor.this._jSortOrderCombo1.getSelectedItem());
            this._tableModel = new ARItemTableModel(ARItemFilterEditor.this._context, ARItemFilterEditor.this._model, ARItemFilterEditor.this._filterSetting, (ARItemTableModel)((Object)ARItemFilterEditor.this._table.getModel()), ((ARItemTableModel)((Object)ARItemFilterEditor.this._table.getModel())).isIncludeSupportColumn());
            this._tableModel.load(this._partitionId);
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            ARItemFilterEditor.this.setLoading(false);
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    if (this._tableModel.getRowCount() != 0) {
                        ARItemFilterEditor.this.setupTable(this._tableModel);
                    } else {
                        ARItemFilterEditor.this.showTableMessage(TableMessages.NO_RESULTS);
                    }
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                ARItemFilterEditor.this.showTableMessage(TableMessages.ERROR);
                Throwable throwable = exception instanceof InterruptedException ? exception : exception.getCause();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_TITLE"), (String)ARRulesLrb.get("ADD_ITEM_QUERY_FAILURE_MESSAGE"), null);
            }
        }
    }
}

