/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class ExpressionBuilderDialog {
    protected JEWTDialog _dlg;
    protected String wizName = "Expression Builder";
    private AbstractExpressionBuilderContext m_ebc = null;
    private ExpressionBuilderMainPanel m_dialogPanel = null;
    private Context m_context = null;
    private boolean m_enable = true;

    public ExpressionBuilderDialog() {
    }

    public ExpressionBuilderDialog(boolean bl) {
        this.m_enable = bl;
    }

    protected JEWTDialog buildDialog(Context context) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        this.m_dialogPanel = new ExpressionBuilderMainPanel(context, this.m_ebc, this);
        this.m_dialogPanel.enableOutputName(this.m_enable);
        jEWTDialog.setContent((Component)this.m_dialogPanel);
        jEWTDialog.setTitle(DialogsLrb.get("EXPBLDR_TITLE"));
        return jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, AbstractExpressionBuilderContext abstractExpressionBuilderContext) {
        this.m_context = context;
        this.m_ebc = abstractExpressionBuilderContext;
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context);
            jEWTDialog.setResizable(true);
            final ExpressionBuilderMainPanel expressionBuilderMainPanel = (ExpressionBuilderMainPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !expressionBuilderMainPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    public String getExpression() {
        return this.m_dialogPanel.getExpression();
    }

    public String getAttributeName() {
        return this.m_dialogPanel.getAttributeName();
    }

    public String getExpressionDataType() {
        return this.m_dialogPanel.getExpressionDataType();
    }
}

