/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.table.GenericBaseTableModel;

public abstract class ODMrTableModel<E>
extends GenericBaseTableModel {
    protected List<E> srcData;

    public ODMrTableModel(List<E> list) {
        this(new String[0], list);
    }

    public ODMrTableModel(String[] stringArray) {
        this(stringArray, new ArrayList());
    }

    public ODMrTableModel(String[] stringArray, List<E> arrayList) {
        assert (stringArray != null) : "Can not pass null columns in to the constructor";
        this.srcData = arrayList == null ? new ArrayList() : arrayList;
        this.setColumnIdentifiers(stringArray);
    }

    public int getRowCount() {
        return this.srcData == null ? 0 : this.srcData.size();
    }

    public Class getColumnClass(int n) {
        Object object = null;
        for (int i = 0; i < this.getRowCount() && (object = this.getValueAt(i, n)) == null; ++i) {
        }
        if (object != null) {
            return object.getClass();
        }
        return String.class;
    }

    public List<E> getSrcData() {
        return this.srcData;
    }

    public void setSrcData(List<E> list) {
        this.srcData = list;
        this.fireTableDataChanged();
    }

    public void addRows(List<E> list) {
        this.srcData.addAll(list);
        this.fireTableDataChanged();
    }

    public void addRow(E e) {
        this.srcData.add(e);
        this.fireTableDataChanged();
    }

    public void removeRows(List<E> list) {
        this.srcData.removeAll(list);
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        this.srcData.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void clear() {
        if (this.srcData != null) {
            this.srcData.clear();
            this.fireTableDataChanged();
        }
    }

    public Vector<E> getDataVector() {
        return new Vector<E>(this.srcData);
    }

    public void fireTableDataChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ODMrTableModel.super.fireTableDataChanged();
                }
            });
        }
    }

    public String getStringValueAt(int n, int n2) {
        String string = null;
        Object object = this.getValueAt(n, n2);
        if (object != null) {
            string = object.toString();
        }
        return string;
    }
}

