/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.EventObject;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dmt.dataminer.controls.BaseTreeTable;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONStructureGroupByTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructureTreeTable;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.javatools.ui.checktree.TriStateNode;

public class JSONStructureGroupByTreeTable
extends JSONStructureTreeTable {
    public JSONStructureGroupByTreeTable() {
        super(new JSONStructureGroupByTreeTableModel());
        this.initialize();
        this.enableCheckBoxes();
    }

    @Override
    protected void setCheckboxCellRenderer() {
        this.getTree().setCellRenderer(new CheckboxCellRendererGroupBy());
    }

    @Override
    protected void setCheckboxCellEditor() {
        this.getTree().setCellEditor(new CheckboxCellEditorGroupBy());
    }

    protected void initialize() {
        if (closedIcon == null) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getTree().getCellRenderer();
            closedIcon = defaultTreeCellRenderer.getDefaultClosedIcon();
            openIcon = defaultTreeCellRenderer.getDefaultOpenIcon();
            textSelectionColor = defaultTreeCellRenderer.getTextSelectionColor();
            textNonSelectionColor = defaultTreeCellRenderer.getTextNonSelectionColor();
        }
    }

    private boolean isPrimitiveType(Object object) {
        boolean bl = false;
        if (object instanceof JSONElement) {
            JSONElement jSONElement = (JSONElement)((Object)object);
            String string = jSONElement.getDataType();
            if (DatabaseMetadataUtils.isPrimitiveJSONType(string)) {
                bl = true;
            } else if (DatabaseMetadataUtils.isDataTypeSupported(string)) {
                bl = true;
            } else if (string.isEmpty()) {
                bl = false;
            }
        }
        return bl;
    }

    protected class CheckboxCellRendererGroupBy
    extends BaseTreeTable.CheckboxCellRendererHideShowCheckBox {
        protected CheckboxCellRendererGroupBy() {
        }

        @Override
        protected boolean isCheckBoxVisible(Object object) {
            return !JSONStructureGroupByTreeTable.this.isPrimitiveType(object);
        }
    }

    protected class CheckboxCellEditorGroupBy
    extends BaseTreeTable.CheckboxCellEditor {
        protected CheckboxCellEditorGroupBy() {
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            TreePath treePath = JSONStructureGroupByTreeTable.this.getTree().getSelectionPath();
            if (treePath == null) {
                return false;
            }
            TriStateNode triStateNode = (TriStateNode)treePath.getLastPathComponent();
            return JSONStructureGroupByTreeTable.this.isPrimitiveType(triStateNode);
        }
    }
}

